/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.other;

import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.net.URL;

@MirrorMetadata(directoryName="kev", mavenPropertyName="cisaKevDownload")
public class CisaKevDownload
extends Download {
    public CisaKevDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CisaKevDownload.class);
    }

    @Override
    protected void performDownload() {
        URL kevURL = this.getRemoteResourceLocationUrl(ResourceLocationKEV.CISA_KEV, new Object[0]);
        File kevFile = new File(this.downloadIntoDirectory, "cisa-kev.json");
        this.downloader.fetchResponseBodyFromUrlToFile(kevURL, kevFile);
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationKEV.valueOf(location), url);
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        return false;
    }

    public static enum ResourceLocationKEV implements ResourceLocation
    {
        CISA_KEV("https://www.cisa.gov/sites/default/files/feeds/known_exploited_vulnerabilities.json");

        private final String defaultValue;

        private ResourceLocationKEV(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

