/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.download.other;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.Retry;
import com.metaeffekt.mirror.download.Download;
import com.metaeffekt.mirror.download.ResourceLocation;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.json.JSONArray;

@MirrorMetadata(directoryName="eol", mavenPropertyName="eolDownload")
public class EolDownload
extends Download {
    public EolDownload(File baseMirrorDirectory) {
        super(baseMirrorDirectory, EolDownload.class);
    }

    @Override
    protected void performDownload() {
        URL allProductsUrl = this.getRemoteResourceLocationUrl(ResourceLocationEOL.EOL_ALL_PRODUCTS, new Object[0]);
        JSONArray allProducts = new JSONArray(String.join((CharSequence)"", this.downloader.fetchResponseBodyFromUrlAsList(allProductsUrl)));
        for (int i = 0; i < allProducts.length(); ++i) {
            String product = allProducts.getString(i);
            URL productUrl = this.getRemoteResourceLocationUrl(ResourceLocationEOL.EOL_PRODUCT_VERSIONS, product);
            JSONArray productVersions = new Retry<JSONArray>(() -> new JSONArray(String.join((CharSequence)"", this.downloader.fetchResponseBodyFromUrlAsList(productUrl)))).retryCount(3).withDelay(1000).onFailure(e -> {
                throw new RuntimeException("Failed to fetch EOL product versions.", (Throwable)e);
            }).run();
            try {
                FileUtils.write((File)new File(this.downloadIntoDirectory, product + ".json"), (CharSequence)productVersions.toString(), (Charset)StandardCharsets.UTF_8);
                continue;
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to write EOL product info to directory.", e2);
            }
        }
    }

    @Override
    protected boolean additionalIsDownloadRequired() {
        return false;
    }

    @Override
    public void setRemoteResourceLocation(String location, String url) {
        super.setRemoteResourceLocation(ResourceLocationEOL.valueOf(location), url);
    }

    public static enum ResourceLocationEOL implements ResourceLocation
    {
        EOL_PRODUCT_VERSIONS("https://endoflife.date/api/%s.json"),
        EOL_ALL_PRODUCTS("https://endoflife.date/api/all.json");

        private final String defaultValue;

        private ResourceLocationEOL(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public String getDefault() {
            return this.defaultValue;
        }
    }
}

