/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.advisor;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.advisory.CertEuAdvisorEntry;
import com.metaeffekt.mirror.download.advisor.CertEuDownload;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="certeu-advisors", mavenPropertyName="certEuAdvisorIndex")
public class CertEuAdvisorIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(CertEuAdvisorIndex.class);

    public CertEuAdvisorIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CertEuAdvisorIndex.class, Collections.singletonList(CertEuDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"CertEuAdvisorEntry#fromDownloadJson"})
    protected Map<String, Document> createIndexDocuments() {
        HashMap<String, Document> documents = new HashMap<String, Document>();
        List<File> files = super.getAllFilesInSubDirectories(new File(this.requiredDownloads[0], "publications"));
        LOG.info("Found [{}] CERT-EU advisory files", (Object)files.size());
        for (File file : files) {
            try {
                List contents = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                JSONObject jsonContent = new JSONObject(String.join((CharSequence)"", contents));
                CertEuAdvisorEntry parsedEntry = CertEuAdvisorEntry.fromDownloadJson(jsonContent);
                documents.put(parsedEntry.getId(), parsedEntry.toDocument());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read file contents during indexing ", e);
            }
        }
        return documents;
    }
}

