/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.nvd;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.download.nvd.CpeDictionaryDownload;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import us.springett.parsers.cpe.Cpe;

@Deprecated
@MirrorMetadata(directoryName="cpe-dict", mavenPropertyName="cpeDictionaryIndex", deprecated=true)
public class CpeDictionaryIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(CpeDictionaryIndex.class);

    public CpeDictionaryIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, CpeDictionaryIndex.class, Collections.singletonList(CpeDictionaryDownload.class), Collections.emptyList());
    }

    @Override
    protected Map<String, org.apache.lucene.document.Document> createIndexDocuments() {
        HashMap<String, org.apache.lucene.document.Document> documents = new HashMap<String, org.apache.lucene.document.Document>();
        File downloadsDirectory = this.requiredDownloads[0];
        File cpeDictionary = new File(downloadsDirectory, "cpe-dict.xml");
        if (!cpeDictionary.isFile()) {
            throw new RuntimeException("Could not find cpe-dict.xml in " + downloadsDirectory.getAbsolutePath());
        }
        File cpeMatch = new File(downloadsDirectory, "cpe-match.json");
        if (!cpeMatch.isFile()) {
            throw new RuntimeException("Could not find cpe-match.json in " + downloadsDirectory.getAbsolutePath());
        }
        this.parseCpeMatch(cpeMatch, documents);
        super.writeIndexDocuments(documents);
        this.parseCpeDict(cpeDictionary, documents);
        return documents;
    }

    private void parseCpeMatch(File cpeMatch, Map<String, org.apache.lucene.document.Document> documents) {
        JSONObject json;
        String jsonContents;
        LOG.info("Parsing CPE match in {}", (Object)cpeMatch.getAbsolutePath());
        try {
            jsonContents = FileUtils.readFileToString((File)cpeMatch, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read file contents during indexing: " + cpeMatch.getAbsolutePath(), e);
        }
        try {
            json = new JSONObject(jsonContents);
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to parse JSON document during indexing: " + cpeMatch.getAbsolutePath(), e);
        }
        JSONArray matchesCpeList = json.getJSONArray("matches");
        int loggingStepSize = matchesCpeList.length() / 4;
        for (int i = 0; i < matchesCpeList.length(); ++i) {
            String cpe;
            JSONObject match = matchesCpeList.getJSONObject(i);
            JSONArray cpeNames = match.optJSONArray("cpe_name");
            if (cpeNames != null && cpeNames.length() > 0) {
                for (int j = 0; j < cpeNames.length(); ++j) {
                    JSONObject cpeNameObject = cpeNames.getJSONObject(j);
                    String cpe2 = cpeNameObject.getString("cpe23Uri");
                    this.appendSingleCpeFromCpeMatchToIndexableDocuments(cpe2, documents);
                }
            }
            if (StringUtils.hasText(cpe = match.optString("cpe23Uri"))) {
                this.appendSingleCpeFromCpeMatchToIndexableDocuments(cpe, documents);
            }
            if (i % loggingStepSize != 0) continue;
            LOG.info("Created documents for [{} / {}] CPE entries", (Object)i, (Object)matchesCpeList.length());
        }
    }

    private void appendSingleCpeFromCpeMatchToIndexableDocuments(String cpeString, Map<String, org.apache.lucene.document.Document> documents) {
        Optional<Cpe> optionalCpe = CommonEnumerationUtil.parseCpe(cpeString);
        if (!optionalCpe.isPresent()) {
            return;
        }
        Cpe cpe = optionalCpe.get();
        org.apache.lucene.document.Document doc = CpeDictionaryIndex.createDocumentFromCpe(cpe);
        doc.add((IndexableField)new TextField("nvdId", UUID.nameUUIDFromBytes(cpe.toCpe23FS().getBytes()).toString(), Field.Store.YES));
        doc.add((IndexableField)new TextField("deprecated", "false", Field.Store.YES));
        doc.add((IndexableField)new TextField("title", "", Field.Store.YES));
        doc.add((IndexableField)new TextField("references", "[]", Field.Store.YES));
        String cpe23FS = cpe.toCpe23FS();
        if (!documents.containsKey(cpe23FS)) {
            documents.put(cpe23FS, doc);
        }
    }

    private void parseCpeDict(File cpeDict, Map<String, org.apache.lucene.document.Document> documents) {
        Document xmlDocument;
        LOG.info("Parsing CPE dictionary in {}", (Object)cpeDict.getAbsolutePath());
        try {
            String xmlContents = FileUtils.readFileToString((File)cpeDict, (Charset)StandardCharsets.UTF_8);
            xmlDocument = this.parseXmlDocument(xmlContents);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read file contents during indexing: " + cpeDict.getAbsolutePath(), e);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to parse XML document during indexing: " + cpeDict.getAbsolutePath(), e);
        }
        NodeList cpeItems = xmlDocument.getElementsByTagName("cpe-item");
        int loggingStepSize = cpeItems.getLength() / 4;
        for (int i = 0; i < cpeItems.getLength(); ++i) {
            Element cpeItem = (Element)cpeItems.item(i);
            String cpe22 = cpeItem.getAttribute("name");
            Optional<Cpe> optionalCpe = CommonEnumerationUtil.parseCpe(cpe22);
            if (!optionalCpe.isPresent()) {
                return;
            }
            Cpe cpe = optionalCpe.get();
            org.apache.lucene.document.Document doc = CpeDictionaryIndex.createDocumentFromCpe(cpe);
            String title = cpeItem.getElementsByTagName("title").item(0).getTextContent();
            ArrayList<Reference> references = new ArrayList<Reference>();
            NodeList referencesNode = cpeItem.getElementsByTagName("references");
            if (referencesNode.getLength() > 0) {
                NodeList referenceNodes = ((Element)referencesNode.item(0)).getElementsByTagName("reference");
                for (int j = 0; j < referenceNodes.getLength(); ++j) {
                    Element referenceNode = (Element)referenceNodes.item(j);
                    String href = referenceNode.getAttribute("href");
                    String text = referenceNode.getTextContent();
                    references.add(Reference.fromTitleAndUrl(text, href));
                }
            }
            String nvdId = cpeItem.getElementsByTagName("meta:item-metadata").item(0).getAttributes().getNamedItem("nvd-id").getTextContent();
            String modificationDate = cpeItem.getElementsByTagName("meta:item-metadata").item(0).getAttributes().getNamedItem("modification-date").getTextContent();
            if (cpeItem.getElementsByTagName("meta:item-metadata").item(0).getAttributes().getNamedItem("deprecated-by-nvd-id") != null) {
                String deprecatedByNvdId = cpeItem.getElementsByTagName("meta:item-metadata").item(0).getAttributes().getNamedItem("deprecated-by-nvd-id").getTextContent();
                doc.add((IndexableField)new TextField("deprecatedByNvdId", deprecatedByNvdId, Field.Store.YES));
                doc.add((IndexableField)new TextField("deprecated", "true", Field.Store.YES));
            } else {
                doc.add((IndexableField)new TextField("deprecated", "false", Field.Store.YES));
            }
            if (StringUtils.hasText(title)) {
                doc.add((IndexableField)new TextField("title", new JSONArray().put((Object)new JSONObject().put("title", (Object)title).put("lang", (Object)"en")).toString(), Field.Store.YES));
            }
            doc.add((IndexableField)new TextField("references", references.stream().map(Reference::toJson).collect(CustomCollectors.toJsonArray()).toString(), Field.Store.YES));
            doc.add((IndexableField)new TextField("nvdId", nvdId, Field.Store.YES));
            Date parsedUpdateDate = TimeUtils.tryParse(modificationDate);
            if (parsedUpdateDate != null) {
                doc.add((IndexableField)new TextField("updateDate", String.valueOf(parsedUpdateDate.getTime()), Field.Store.YES));
            }
            documents.put(cpe.toCpe23FS(), doc);
            if (i % loggingStepSize != 0) continue;
            LOG.info("Created documents for [{} / {}] CPE entries", (Object)i, (Object)cpeItems.getLength());
        }
    }

    private static org.apache.lucene.document.Document createDocumentFromCpe(Cpe cpe) {
        org.apache.lucene.document.Document doc = new org.apache.lucene.document.Document();
        doc.add((IndexableField)new TextField("part", cpe.getPart().getAbbreviation(), Field.Store.YES));
        doc.add((IndexableField)new TextField("vendor", cpe.getVendor(), Field.Store.YES));
        doc.add((IndexableField)new TextField("product", cpe.getProduct(), Field.Store.YES));
        doc.add((IndexableField)new TextField("version", cpe.getVersion(), Field.Store.YES));
        doc.add((IndexableField)new TextField("update", cpe.getUpdate(), Field.Store.YES));
        doc.add((IndexableField)new TextField("edition", cpe.getEdition(), Field.Store.YES));
        doc.add((IndexableField)new TextField("language", cpe.getLanguage(), Field.Store.YES));
        doc.add((IndexableField)new TextField("sw_edition", cpe.getSwEdition(), Field.Store.YES));
        doc.add((IndexableField)new TextField("target_sw", cpe.getTargetSw(), Field.Store.YES));
        doc.add((IndexableField)new TextField("target_hw", cpe.getTargetHw(), Field.Store.YES));
        doc.add((IndexableField)new TextField("other", cpe.getOther(), Field.Store.YES));
        doc.add((IndexableField)new TextField("cpe23Uri", cpe.toCpe23FS(), Field.Store.YES));
        return doc;
    }
}

