/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.nvd;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.download.nvd.NvdDownload;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@MirrorMetadata(directoryName="nvd-cve", mavenPropertyName="nvdLegacyVulnerabilityIndex", deprecated=true)
public class NvdVulnerabilityIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(NvdVulnerabilityIndex.class);
    private static final String DATA_VERSION = "4.0";

    public NvdVulnerabilityIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdVulnerabilityIndex.class, Collections.singletonList(NvdDownload.class), Collections.emptyList());
    }

    @Override
    protected Map<String, Document> createIndexDocuments() {
        ConcurrentHashMap<String, Document> documents = new ConcurrentHashMap<String, Document>();
        File[] files = this.requiredDownloads[0].listFiles(f -> f.isFile() && f.getName().startsWith("nvd-") && f.getName().endsWith(".json"));
        if (files == null) {
            throw new RuntimeException("Unable to list files in " + this.requiredDownloads[0]);
        }
        for (File file : files) {
            this.executor.submit(() -> documents.putAll(this.processFile(file)));
        }
        this.executor.setSize(6);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for indexing to complete.", e);
        }
        return documents;
    }

    private Map<String, Document> processFile(File file) {
        JSONObject json;
        HashMap<String, Document> documents = new HashMap<String, Document>();
        LOG.info("Processing file {}", (Object)file.getAbsolutePath());
        try {
            json = new JSONObject(String.join((CharSequence)"", FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read yearly NVD document from " + file.getAbsolutePath(), e);
        }
        if (!json.optString("CVE_data_version", "UNSET").equals(DATA_VERSION)) {
            LOG.warn("Data version might not be compatible with indexing process: expected [{}] but was [{}] on {}", new Object[]{DATA_VERSION, json.optString("CVE_data_version", "UNSET"), file.getAbsolutePath()});
        }
        JSONArray cveItems = json.getJSONArray("CVE_Items");
        for (int i = 0; i < cveItems.length(); ++i) {
            JSONObject cveItem = cveItems.getJSONObject(i);
            Vulnerability vulnerability = Vulnerability.fromNvdMirrorCveItem1P0(cveItem);
            Document document = vulnerability.toDocument();
            documents.put(vulnerability.getId(), document);
        }
        return documents;
    }
}

