/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.other;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.eol.EolLifecycle;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.download.other.EolDownload;
import com.metaeffekt.mirror.index.Index;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="eol", mavenPropertyName="eolIndex")
public class EolIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(EolIndex.class);

    public EolIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, EolIndex.class, Collections.singletonList(EolDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"EolLifecycle#fromJson", "EolCycle#fromJson"})
    protected Map<String, Document> createIndexDocuments() {
        ConcurrentHashMap<String, Document> documents = new ConcurrentHashMap<String, Document>();
        Collection<File> files = super.getAllFilesRecursively(this.requiredDownloads[0]);
        LOG.info("Found [{}] files in repository", (Object)files.size());
        for (File file : files) {
            if (!file.getName().endsWith(".json")) continue;
            String product = file.getName().replace(".json", "");
            try {
                String contents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                JSONArray parsedContents = new JSONArray(contents);
                EolLifecycle productInfo = EolLifecycle.fromJson(product, parsedContents);
                for (Document document : productInfo.toDocuments()) {
                    String uldid = product + "-" + document.get("cycle");
                    if (documents.containsKey(uldid)) {
                        if (!documents.containsKey(uldid = uldid + "-" + document.get("link"))) continue;
                        LOG.warn("Duplicate entry found, skipping: {}", (Object)document);
                        continue;
                    }
                    documents.put(uldid, document);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + file.getAbsolutePath(), e);
            }
        }
        if (!files.isEmpty()) {
            LOG.info("Average of [{}] cycles per product", (Object)(documents.size() / files.size()));
        }
        return documents;
    }
}

