/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.index.other;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.mirror.contents.kev.KevData;
import com.metaeffekt.mirror.download.documentation.DocRelevantMethods;
import com.metaeffekt.mirror.download.documentation.MirrorMetadata;
import com.metaeffekt.mirror.download.other.CisaKevDownload;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.index.other.EolIndex;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MirrorMetadata(directoryName="kev", mavenPropertyName="kevIndex")
public class KevIndex
extends Index {
    private static final Logger LOG = LoggerFactory.getLogger(EolIndex.class);

    public KevIndex(File baseMirrorDirectory) {
        super(baseMirrorDirectory, KevIndex.class, Collections.singletonList(CisaKevDownload.class), Collections.emptyList());
    }

    @Override
    @DocRelevantMethods(value={"KevData#fromCisaKev"})
    protected Map<String, Document> createIndexDocuments() {
        ConcurrentHashMap<String, Document> documents = new ConcurrentHashMap<String, Document>();
        Collection<File> files = super.getAllFilesRecursively(this.requiredDownloads[0]);
        for (File file : files) {
            if (!file.getName().endsWith(".json")) continue;
            LOG.info("Processing file: {}", (Object)file.getName());
            try {
                String contents = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                JSONObject parsedContents = new JSONObject(contents);
                JSONArray kevEntries = parsedContents.getJSONArray("vulnerabilities");
                List<Document> kevEntriesDocs = this.fromJson(kevEntries);
                for (Document document : kevEntriesDocs) {
                    String uldid = document.get("vulnerability");
                    if (documents.containsKey(uldid)) {
                        LOG.warn("Duplicate entry found, skipping: {}", (Object)document);
                        continue;
                    }
                    documents.put(uldid, document);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read file: " + file.getAbsolutePath(), e);
            }
        }
        return documents;
    }

    private List<Document> fromJson(JSONArray jsonArray) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            KevData data = KevData.fromCisaKev(jsonArray.getJSONObject(i));
            documents.add(data.toDocument());
        }
        return documents;
    }
}

