/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;

public abstract class AdvisorIndexQuery<T extends AdvisoryEntry>
extends IndexQuery {
    private List<T> cachedAllAdvisories;

    public AdvisorIndexQuery(File baseMirrorDirectory, Class<? extends Index> index) {
        super(baseMirrorDirectory, index);
    }

    public AdvisorIndexQuery(Index index) {
        super(index);
    }

    public T findById(String id) {
        return (T)((AdvisoryEntry)this.index.findDocuments(new IndexSearch().fieldEquals("id", id)).stream().findFirst().map(this::createAdvisoryEntry).orElse(null));
    }

    public List<T> findByReferencedId(String referencedId) {
        return this.index.findDocuments(new IndexSearch().fieldContains("referencedIds", referencedId)).stream().map(this::createAdvisoryEntry).filter(entry -> entry.getReferencedVulnerabilities().values().stream().anyMatch(e -> e.contains(referencedId)) || entry.getReferencedSecurityAdvisories().values().stream().anyMatch(e -> e.contains(referencedId)) || entry.getReferencedOtherIds().values().stream().anyMatch(e -> e.contains(referencedId))).collect(Collectors.toList());
    }

    public List<T> findByAnyTextFieldContains(String value) {
        return this.index.findDocuments(new IndexSearch().fieldContains("summary", value).fieldContains("description", value).fieldContains("threat", value).fieldContains("recommendations", value).fieldContains("workarounds", value).fieldContains("references", value).fieldContains("keywords", value).joinOperator("OR")).stream().map(this::createAdvisoryEntry).collect(Collectors.toList());
    }

    public List<T> findCreatedOrUpdatedInRange(long start, long end) {
        return this.findAll().stream().filter(entry -> entry.hasBeenUpdatedSince(start) && entry.hasBeenUpdatedBefore(end)).collect(Collectors.toList());
    }

    public List<T> findAll() {
        if (this.cachedAllAdvisories == null) {
            this.cachedAllAdvisories = this.index.findAllDocuments().stream().map(this::createAdvisoryEntry).collect(Collectors.toList());
        }
        return new ArrayList<T>(this.cachedAllAdvisories);
    }

    public void findAndProcessAll(Consumer<T> consumer) {
        this.index.findAndProcessAllDocuments(document -> consumer.accept(this.createAdvisoryEntry((Document)document)));
    }

    public void findAndProcessAllCancelable(Function<T, Boolean> consumer) {
        this.index.findAndProcessAllDocumentsCancelable(document -> (Boolean)consumer.apply(this.createAdvisoryEntry((Document)document)));
    }

    protected abstract T createAdvisoryEntry(Document var1);
}

