/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.contents.epss.EpssData;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.other.EpssIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.Optional;

public class EpssIndexQuery
extends IndexQuery {
    public EpssIndexQuery(EpssIndex index) {
        super(index);
    }

    public EpssIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, EpssIndex.class);
    }

    public Optional<EpssData> getEpssData(Vulnerability vulnerability) {
        return this.findEpssData(vulnerability);
    }

    public Optional<EpssData> findEpssData(Vulnerability vulnerability) {
        return this.index.findDocuments(new IndexSearch().fieldEquals("vulnerability", vulnerability.getId())).stream().findFirst().map(EpssData::fromDocument);
    }

    public Optional<EpssData> findEpssData(String vulnerabilityId) {
        return this.index.findDocuments(new IndexSearch().fieldEquals("vulnerability", vulnerabilityId)).stream().findFirst().map(EpssData::fromDocument);
    }
}

