/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.advisor.MsrcProductIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class MsrcProductIndexQuery
extends IndexQuery {
    public MsrcProductIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, MsrcProductIndex.class);
    }

    public MsrcProductIndexQuery(MsrcProductIndex index) {
        super(index);
    }

    public MsrcProduct findProductByIdOrName(String idOrName) {
        MsrcProduct product = this.findProductById(idOrName);
        if (product != null) {
            return product;
        }
        return this.findProductByName(idOrName);
    }

    public MsrcProduct findProductById(String id) {
        return this.index.findDocuments(new IndexSearch().fieldEquals("id", id)).stream().findFirst().map(MsrcProduct::fromDocument).orElse(null);
    }

    public MsrcProduct findProductByName(String name) {
        return this.index.findDocuments(new IndexSearch().fieldEquals("name", name)).stream().findFirst().map(MsrcProduct::fromDocument).orElse(null);
    }

    public List<MsrcProduct> findProductsByName(String name) {
        return this.index.findDocuments(new IndexSearch().fieldEquals("name", name)).stream().map(MsrcProduct::fromDocument).collect(Collectors.toList());
    }

    public List<MsrcProduct> findProductByNameFuzzyIfNoExactMatch(String name) {
        MsrcProduct product = this.findProductByName(name);
        if (product != null) {
            return Collections.singletonList(product);
        }
        return this.index.findDocuments(new IndexSearch().fieldContains("name", name)).stream().map(MsrcProduct::fromDocument).collect(Collectors.toList());
    }

    public List<MsrcProduct> findAll() {
        return this.index.findAllDocuments().stream().map(MsrcProduct::fromDocument).collect(Collectors.toList());
    }
}

