/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.nvd.NvdCpeApiVendorProductIndex;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdCpeApiVendorProductIndexQuery
extends IndexQuery {
    private static final Logger LOG = LoggerFactory.getLogger(NvdCpeApiVendorProductIndexQuery.class);
    private final Map<String, Set<String>> vendorProductsMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> productVendorsMap = new HashMap<String, Set<String>>();

    public NvdCpeApiVendorProductIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdCpeApiVendorProductIndex.class);
    }

    public NvdCpeApiVendorProductIndexQuery(NvdCpeApiVendorProductIndex index) {
        super(index);
    }

    public boolean vendorExists(String vendor) {
        return !this.index.findDocuments(new IndexSearch().fieldEquals("vendor", vendor).fieldEquals("type", "vp")).isEmpty();
    }

    public boolean productExists(String product) {
        return !this.index.findDocuments(new IndexSearch().fieldEquals("product", product).fieldEquals("type", "pv")).isEmpty();
    }

    public Set<String> findVendorsFuzzy(String vendor) {
        return this.index.findDocuments(new IndexSearch().fieldContains("vendor", vendor).fieldEquals("type", "vp")).stream().map(d -> d.get("vendor")).collect(Collectors.toSet());
    }

    public Set<String> findProductsFuzzy(String product) {
        return this.index.findDocuments(new IndexSearch().fieldContains("product", product).fieldEquals("type", "pv")).stream().map(d -> d.get("product")).collect(Collectors.toSet());
    }

    public Set<String> findVendorsForProduct(String product) {
        return this.getProductVendorsMap().getOrDefault(product, Collections.emptySet());
    }

    public Set<String> findProductsForVendor(String vendor) {
        return this.getVendorProductsMap().getOrDefault(vendor, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getVendorProductsMap() {
        Map<String, Set<String>> map = this.vendorProductsMap;
        synchronized (map) {
            if (this.vendorProductsMap.isEmpty()) {
                LOG.debug("Building Vendor Products map for the first time");
                this.index.findAndProcessAllDocuments(document -> {
                    if (document.get("type").equals("vp")) {
                        this.vendorProductsMap.computeIfAbsent(document.get("vendor"), k -> new HashSet()).addAll(Arrays.asList(document.get("product").split(", ")));
                    }
                });
            }
        }
        return this.vendorProductsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set<String>> getProductVendorsMap() {
        Map<String, Set<String>> map = this.productVendorsMap;
        synchronized (map) {
            if (this.productVendorsMap.isEmpty()) {
                LOG.debug("Building Product Vendors map for the first time");
                this.index.findAndProcessAllDocuments(document -> {
                    if (document.get("type").equals("pv")) {
                        this.productVendorsMap.computeIfAbsent(document.get("product"), k -> new HashSet()).addAll(Arrays.asList(document.get("vendor").split(", ")));
                    }
                });
            }
        }
        return this.productVendorsMap;
    }

    public Map<String, Integer> findVendorTerms() {
        return this.findTopTermsInternal(this.getVendorProductsMap());
    }

    public Map<String, Integer> findProductTerms() {
        return this.findTopTermsInternal(this.getProductVendorsMap());
    }

    public LinkedHashMap<String, Integer> findTopVpTerms(TermsLimiter ... termsLimiter) {
        Map<String, Integer> vendorCount = this.findVendorTerms();
        Map<String, Integer> productCount = this.findProductTerms();
        HashMap<String, Integer> vpCount = new HashMap<String, Integer>();
        vpCount.putAll(vendorCount);
        productCount.forEach((product, count) -> vpCount.merge((String)product, (Integer)count, Integer::sum));
        return TermsLimiter.limitMap(vpCount, termsLimiter);
    }

    public LinkedHashMap<String, Integer> findTopVpTerms(List<TermsLimiter> termsLimiters) {
        return this.findTopVpTerms(termsLimiters.toArray(new TermsLimiter[0]));
    }

    private Map<String, Integer> findTopTermsInternal(Map<String, Set<String>> data) {
        List dataBySize = data.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Set)((Map.Entry)e).getValue()).size()).reversed()).collect(Collectors.toList());
        HashMap<String, Integer> keywordCount = new HashMap<String, Integer>();
        for (Map.Entry entry : dataBySize) {
            keywordCount.put((String)entry.getKey(), ((Set)entry.getValue()).size());
        }
        return keywordCount;
    }

    public static class MaxTermsLimiter
    implements TermsLimiter {
        private final int maxTerms;

        @Override
        public LinkedHashMap<String, Integer> limitMap(Map<String, Integer> map) {
            return map.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)((Map.Entry)e).getValue()).reversed()).limit(this.maxTerms).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        @Override
        public JSONObject toJson() {
            return this.toBaseJson().put("maxTerms", this.maxTerms);
        }

        public static MaxTermsLimiter fromJson(JSONObject input) {
            return new MaxTermsLimiter(input.getInt("maxTerms"));
        }

        public MaxTermsLimiter(int maxTerms) {
            this.maxTerms = maxTerms;
        }

        public int getMaxTerms() {
            return this.maxTerms;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MaxTermsLimiter)) {
                return false;
            }
            MaxTermsLimiter other = (MaxTermsLimiter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMaxTerms() == other.getMaxTerms();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MaxTermsLimiter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxTerms();
            return result;
        }

        public String toString() {
            return "NvdCpeApiVendorProductIndexQuery.MaxTermsLimiter(maxTerms=" + this.getMaxTerms() + ")";
        }
    }

    public static class MinTermsLimiter
    implements TermsLimiter {
        private final int minTerms;

        @Override
        public LinkedHashMap<String, Integer> limitMap(Map<String, Integer> map) {
            return map.entrySet().stream().filter(e -> (Integer)e.getValue() >= this.minTerms).sorted(Comparator.comparingInt(e -> (Integer)((Map.Entry)e).getValue()).reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        @Override
        public JSONObject toJson() {
            return this.toBaseJson().put("minTerms", this.minTerms);
        }

        public static MinTermsLimiter fromJson(JSONObject input) {
            return new MinTermsLimiter(input.getInt("minTerms"));
        }

        public MinTermsLimiter(int minTerms) {
            this.minTerms = minTerms;
        }

        public int getMinTerms() {
            return this.minTerms;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MinTermsLimiter)) {
                return false;
            }
            MinTermsLimiter other = (MinTermsLimiter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getMinTerms() == other.getMinTerms();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MinTermsLimiter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinTerms();
            return result;
        }

        public String toString() {
            return "NvdCpeApiVendorProductIndexQuery.MinTermsLimiter(minTerms=" + this.getMinTerms() + ")";
        }
    }

    public static class TopNTermsLimiter
    implements TermsLimiter {
        private final int topN;

        @Override
        public LinkedHashMap<String, Integer> limitMap(Map<String, Integer> map) {
            return map.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)((Map.Entry)e).getValue()).reversed()).limit(this.topN).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        @Override
        public JSONObject toJson() {
            return this.toBaseJson().put("topN", this.topN);
        }

        public static TopNTermsLimiter fromJson(JSONObject input) {
            return new TopNTermsLimiter(input.getInt("topN"));
        }

        public TopNTermsLimiter(int topN) {
            this.topN = topN;
        }

        public int getTopN() {
            return this.topN;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopNTermsLimiter)) {
                return false;
            }
            TopNTermsLimiter other = (TopNTermsLimiter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getTopN() == other.getTopN();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TopNTermsLimiter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTopN();
            return result;
        }

        public String toString() {
            return "NvdCpeApiVendorProductIndexQuery.TopNTermsLimiter(topN=" + this.getTopN() + ")";
        }
    }

    public static class TopPTermsLimiter
    implements TermsLimiter {
        private final double topP;

        @Override
        public LinkedHashMap<String, Integer> limitMap(Map<String, Integer> map) {
            int topN = (int)Math.ceil((double)map.size() * this.topP);
            return map.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)((Map.Entry)e).getValue()).reversed()).limit(topN).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }

        @Override
        public JSONObject toJson() {
            return this.toBaseJson().put("topP", this.topP);
        }

        public static TopPTermsLimiter fromJson(JSONObject input) {
            return new TopPTermsLimiter(input.getDouble("topP"));
        }

        public TopPTermsLimiter(double topP) {
            this.topP = topP;
        }

        public double getTopP() {
            return this.topP;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopPTermsLimiter)) {
                return false;
            }
            TopPTermsLimiter other = (TopPTermsLimiter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Double.compare(this.getTopP(), other.getTopP()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof TopPTermsLimiter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $topP = Double.doubleToLongBits(this.getTopP());
            result = result * 59 + (int)($topP >>> 32 ^ $topP);
            return result;
        }

        public String toString() {
            return "NvdCpeApiVendorProductIndexQuery.TopPTermsLimiter(topP=" + this.getTopP() + ")";
        }
    }

    public static interface TermsLimiter {
        public LinkedHashMap<String, Integer> limitMap(Map<String, Integer> var1);

        public JSONObject toJson();

        default public JSONObject toBaseJson() {
            return new JSONObject().put("type", (Object)this.getClass().getSimpleName());
        }

        public static LinkedHashMap<String, Integer> limitMap(Map<String, Integer> map, TermsLimiter ... limiter) {
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>(map);
            for (TermsLimiter l : limiter) {
                result = l.limitMap(result);
            }
            return result;
        }

        public static List<TermsLimiter> fromJson(JSONArray inputArray) {
            ArrayList<TermsLimiter> result = new ArrayList<TermsLimiter>();
            block12: for (int i = 0; i < inputArray.length(); ++i) {
                String type;
                JSONObject input = inputArray.getJSONObject(i);
                switch (type = input.getString("type")) {
                    case "TopPTermsLimiter": {
                        result.add(TopPTermsLimiter.fromJson(input));
                        continue block12;
                    }
                    case "TopNTermsLimiter": {
                        result.add(TopNTermsLimiter.fromJson(input));
                        continue block12;
                    }
                    case "MinTermsLimiter": {
                        result.add(MinTermsLimiter.fromJson(input));
                        continue block12;
                    }
                    case "MaxTermsLimiter": {
                        result.add(MaxTermsLimiter.fromJson(input));
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown terms limiter type: " + type);
                    }
                }
            }
            return result;
        }
    }
}

