/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.artifact.analysis.utils.LruLinkedHashMap;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.index.nvd.NvdCveApiIndex;
import com.metaeffekt.mirror.query.VulnerabilityIndexQuery;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class NvdCveIndexQuery
extends VulnerabilityIndexQuery {
    private static final Logger log = LoggerFactory.getLogger(NvdCveIndexQuery.class);
    private final Map<String, Vulnerability> vulnerabilityByNameCache = new LruLinkedHashMap<String, Vulnerability>(1000);
    private final Map<String, List<Vulnerability>> documentByVendorProductCache = new LruLinkedHashMap<String, List<Vulnerability>>(1000);

    public NvdCveIndexQuery(File baseMirrorDirectory) {
        super(baseMirrorDirectory, NvdCveApiIndex.class);
    }

    @Override
    public VulnerabilityTypeIdentifier<?> getVulnerabilityType() {
        return VulnerabilityTypeStore.CVE;
    }

    private Optional<Vulnerability> findVulnerabilityByNameInternal(String name) {
        return super.getIndex().findDocuments(new IndexSearch().fieldEquals("name", name)).stream().map(this::fromDocument).findFirst();
    }

    @Override
    public List<Vulnerability> findAll() {
        return super.getIndex().findAllDocuments().stream().map(this::fromDocument).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Vulnerability> findVulnerabilityByName(String name) {
        Map<String, Vulnerability> map = this.vulnerabilityByNameCache;
        synchronized (map) {
            if (this.vulnerabilityByNameCache.containsKey(name)) {
                return Optional.of(this.vulnerabilityByNameCache.get(name));
            }
        }
        return this.findVulnerabilityByNameInternal(name).map(v -> {
            Map<String, Vulnerability> map = this.vulnerabilityByNameCache;
            synchronized (map) {
                this.vulnerabilityByNameCache.put(name, (Vulnerability)v);
            }
            return v;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Vulnerability> findVulnerabilitiesByFlatAffectedConfiguration(Cpe cpe) {
        String key = cpe.getVendor() + ":" + cpe.getProduct();
        Map<String, List<Vulnerability>> map = this.documentByVendorProductCache;
        synchronized (map) {
            if (this.documentByVendorProductCache.containsKey(key)) {
                return this.documentByVendorProductCache.get(key).stream().filter(v -> v.cpeFlatMatchesVulnerableSoftware(cpe)).sorted(Vulnerability.COMPARE_BY_NAME).collect(Collectors.toList());
            }
        }
        List<Vulnerability> vulnerabilityDocuments = this.searchIndexForCpe(cpe);
        Map<String, List<Vulnerability>> map2 = this.documentByVendorProductCache;
        synchronized (map2) {
            this.documentByVendorProductCache.put(key, vulnerabilityDocuments);
        }
        return vulnerabilityDocuments.stream().distinct().filter(v -> v.cpeFlatMatchesVulnerableSoftware(cpe)).sorted(Vulnerability.COMPARE_BY_NAME).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Vulnerability, VulnerableSoftwareVersionRangeCpe> findVulnerabilitiesByFlatAffectedConfigurationRetainSource(Cpe cpe) {
        List vulnerabilities;
        String key = cpe.getVendor() + ":" + cpe.getProduct();
        Map<String, List<Vulnerability>> map = this.documentByVendorProductCache;
        synchronized (map) {
            vulnerabilities = this.documentByVendorProductCache.getOrDefault(key, null);
        }
        if (vulnerabilities != null) {
            return vulnerabilities.stream().map(v -> Pair.of((Object)v, (Object)v.getCpeFlatMatchedVulnerableSoftware(cpe))).filter(p -> p.getRight() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        }
        List<Vulnerability> vulnerabilityDocuments = this.searchIndexForCpe(cpe);
        Map<String, List<Vulnerability>> map2 = this.documentByVendorProductCache;
        synchronized (map2) {
            this.documentByVendorProductCache.put(key, vulnerabilityDocuments);
        }
        return vulnerabilityDocuments.stream().distinct().map(v -> Pair.of((Object)v, (Object)v.getCpeFlatMatchedVulnerableSoftware(cpe))).filter(p -> p.getRight() != null).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private List<Vulnerability> searchIndexForCpe(Cpe cpe) {
        boolean vendorAsterisk = "*".equals(cpe.getVendor());
        boolean productAsterisk = "*".equals(cpe.getProduct());
        if (vendorAsterisk && productAsterisk) {
            log.warn("Wildcard search for both vendor and product is not supported. Returning empty list.");
            return Collections.emptyList();
        }
        String queryString = vendorAsterisk ? "*\\:" + QueryParserUtil.escape((String)cpe.getProduct()) : (productAsterisk ? QueryParserUtil.escape((String)cpe.getVendor()) + "\\:*" : cpe.getVendor() + ":" + cpe.getProduct());
        if (vendorAsterisk || productAsterisk) {
            log.warn("It is recommended to avoid using only the vendor OR product information when querying vulnerability databases for the CPE [{}]. This broad approach can inadvertently match vulnerabilities that were not intended to be included, leading to inaccurate results. Even if the current data appears to correct as of now, there is no guarantee that the NVD will not introduce new CPE entries with different vendor/product combinations that could still match the original query unintentionally. To ensure precise and reliable vulnerability matching, it is recommended to provide more specific CPE identifiers that include both the vendor and product information whenever possible.", (Object)cpe);
            return super.getIndex().findDocuments(new IndexSearch().fieldContainsUnquoted("vulnerable_software_vp", queryString)).stream().map(this::findInCacheOrCreateVulnerabilityFromDocument).distinct().collect(Collectors.toList());
        }
        return super.getIndex().findDocuments(new IndexSearch().fieldContains("vulnerable_software_vp", queryString)).stream().map(this::findInCacheOrCreateVulnerabilityFromDocument).distinct().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vulnerability findInCacheOrCreateVulnerabilityFromDocument(Document document) {
        String name = document.get("name");
        Map<String, Vulnerability> map = this.vulnerabilityByNameCache;
        synchronized (map) {
            Vulnerability vulnerability = this.vulnerabilityByNameCache.get(name);
            if (vulnerability != null) {
                return vulnerability;
            }
            Vulnerability parsedVulnerability = Vulnerability.fromDocument(document);
            this.vulnerabilityByNameCache.put(name, parsedVulnerability);
            return parsedVulnerability;
        }
    }
}

