/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.mirror.query;

import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import com.metaeffekt.mirror.index.Index;
import com.metaeffekt.mirror.index.IndexSearch;
import com.metaeffekt.mirror.query.IndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public abstract class VulnerabilityIndexQuery
extends IndexQuery {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilityIndexQuery.class);

    protected VulnerabilityIndexQuery(File baseMirrorDirectory, Class<? extends Index> requiredIndex) {
        super(baseMirrorDirectory, requiredIndex);
    }

    protected VulnerabilityIndexQuery(Index index) {
        super(index);
    }

    public abstract List<Vulnerability> findAll();

    public abstract Optional<Vulnerability> findVulnerabilityByName(String var1);

    public abstract List<Vulnerability> findVulnerabilitiesByFlatAffectedConfiguration(Cpe var1);

    public abstract Map<Vulnerability, VulnerableSoftwareVersionRangeCpe> findVulnerabilitiesByFlatAffectedConfigurationRetainSource(Cpe var1);

    public abstract VulnerabilityTypeIdentifier<?> getVulnerabilityType();

    public List<Vulnerability> findCreatedOrUpdatedInRange(long start, long end) {
        ArrayList<Vulnerability> updatedOrCreated = new ArrayList<Vulnerability>();
        HashSet<String> knownVulnerabilityNames = new HashSet<String>();
        List createDateVulnerabilities = super.getIndex().findDocuments(new IndexSearch().fieldNumericBetween("createDate", start, end)).stream().map(this::fromDocument).collect(Collectors.toList());
        List updateDateVulnerabilities = super.getIndex().findDocuments(new IndexSearch().fieldNumericBetween("updateDate", start, end)).stream().map(this::fromDocument).collect(Collectors.toList());
        for (Vulnerability vulnerability : createDateVulnerabilities) {
            if (!knownVulnerabilityNames.add(vulnerability.getId())) continue;
            updatedOrCreated.add(vulnerability);
        }
        for (Vulnerability vulnerability : updateDateVulnerabilities) {
            if (!knownVulnerabilityNames.add(vulnerability.getId())) continue;
            updatedOrCreated.add(vulnerability);
        }
        return updatedOrCreated;
    }

    public Vulnerability fromDocument(Document document) {
        Vulnerability vulnerability = Vulnerability.fromDocument(document);
        vulnerability.setSourceIdentifier(this.getVulnerabilityType());
        return vulnerability;
    }
}

