/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom;

import com.metaeffekt.artifact.analysis.bom.spdx.LicenseStringConverter;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.terms.model.LicenseTextEntry;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.metaeffekt.common.notice.model.ComponentDefinition;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.common.notice.model.UnassignedInformation;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseProcessor {
    private static final Logger log = LoggerFactory.getLogger(LicenseProcessor.class);

    public static Map<String, String> getReferencedLicenseText(Collection<TermsMetaData> referencedLicenses, LicenseTextProvider licenseTextProvider, NormalizationMetaData normalizationMetaData) {
        if (referencedLicenses.isEmpty()) {
            return null;
        }
        HashMap<String, String> identifierToLicenseText = new HashMap<String, String>();
        Set<String> referencedCanonicalNames = referencedLicenses.stream().map(TermsMetaData::getCanonicalName).collect(Collectors.toSet());
        LicenseStringConverter licenseStringConverter = new LicenseStringConverter(normalizationMetaData, null);
        Map<Object, Object> licenseTextEntryByName = licenseTextProvider != null ? licenseTextProvider.resolve(referencedCanonicalNames) : Collections.emptyMap();
        for (Map.Entry licenseNameToTextEntry : licenseTextEntryByName.entrySet()) {
            String canonicalName = (String)licenseNameToTextEntry.getKey();
            TermsMetaData tmd = normalizationMetaData.findTermsMetaData(canonicalName);
            if (tmd == null && (tmd = normalizationMetaData.findUsingCanonicalNameInHistory(canonicalName)) == null) continue;
            String identifier = licenseStringConverter.getLicenseRefForTmd(tmd);
            identifierToLicenseText.put(identifier, ((LicenseTextEntry)licenseNameToTextEntry.getValue()).getLicenseText());
        }
        referencedCanonicalNames.removeAll(licenseTextEntryByName.keySet());
        for (String canonicalName : referencedCanonicalNames) {
            TermsMetaData tmd = normalizationMetaData.findTermsMetaData(canonicalName);
            if (tmd == null && (tmd = normalizationMetaData.findUsingCanonicalNameInHistory(canonicalName)) == null) continue;
            String identifier = licenseStringConverter.getLicenseRefForTmd(tmd);
            identifierToLicenseText.put(identifier, null);
        }
        return identifierToLicenseText;
    }

    public static List<String> aggregateEffectiveLicenses(NoticeParameters noticeParameters) {
        HashSet<String> aggregated = new HashSet<String>();
        if (noticeParameters.getComponent() != null) {
            aggregated.addAll(LicenseProcessor.aggregateEffectiveLicenses(noticeParameters.getComponent()));
        }
        if (noticeParameters.getSubcomponents() != null) {
            for (ComponentDefinition componentDefinition : noticeParameters.getSubcomponents()) {
                aggregated.addAll(LicenseProcessor.aggregateEffectiveLicenses(componentDefinition));
            }
        }
        return aggregated.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    private static Collection<String> aggregateEffectiveLicenses(ComponentDefinition component) {
        if (component != null) {
            if (component.getEffectiveLicenses() == null || component.getEffectiveLicenses().isEmpty()) {
                List associatedLicenses = component.getAssociatedLicenses();
                return InventoryUtils.tokenizeLicense((String)InventoryUtils.deriveEffectiveLicenses(associatedLicenses), (boolean)true, (boolean)false);
            }
            return component.getEffectiveLicenses();
        }
        return Collections.emptyList();
    }

    public static NoticeParameters readNoticeParameters(AbstractModelBase modelBase) {
        String noticeParametersString = modelBase.get("Notice Parameter");
        if (StringUtils.isBlank((CharSequence)noticeParametersString)) {
            noticeParametersString = modelBase.get("Inherited Notice Parameter");
        }
        if (StringUtils.isBlank((CharSequence)noticeParametersString)) {
            noticeParametersString = modelBase.get("Derived Notice Parameter");
        }
        if (StringUtils.isNotBlank((CharSequence)noticeParametersString)) {
            try {
                return NoticeParameters.readYaml((String)noticeParametersString);
            }
            catch (RuntimeException e) {
                log.warn("Unable to parse notice parameter:\n[{}]", (Object)noticeParametersString);
            }
        }
        String associatedLicenses = null;
        List<String> copyrights = null;
        if (modelBase instanceof Artifact) {
            associatedLicenses = LicenseProcessor.deriveAssociatedLicenses((Artifact)modelBase);
            copyrights = LicenseProcessor.extractCopyrights((Artifact)modelBase);
        }
        if (StringUtils.isNotEmpty(associatedLicenses)) {
            ComponentDefinition componentDefinition = new ComponentDefinition();
            componentDefinition.setAssociatedLicenses(InventoryUtils.tokenizeLicense((String)associatedLicenses, (boolean)true, (boolean)true));
            NoticeParameters noticeParameters = new NoticeParameters();
            noticeParameters.setComponent(componentDefinition);
            UnassignedInformation unassignedInformation = new UnassignedInformation();
            unassignedInformation.setCopyrights(copyrights);
            noticeParameters.setUnassignedInformation(unassignedInformation);
            return noticeParameters;
        }
        if (copyrights != null && !copyrights.isEmpty()) {
            NoticeParameters noticeParameters = new NoticeParameters();
            UnassignedInformation unassignedInformation = new UnassignedInformation();
            unassignedInformation.setCopyrights(copyrights);
            noticeParameters.setUnassignedInformation(unassignedInformation);
            return noticeParameters;
        }
        return null;
    }

    private static String deriveAssociatedLicenses(Artifact artifact) {
        String associatedLicenses = artifact.getLicense();
        if (StringUtils.isEmpty((CharSequence)associatedLicenses)) {
            associatedLicenses = artifact.get("Binary Artifact - Derived Licenses");
        }
        if (StringUtils.isEmpty((CharSequence)associatedLicenses)) {
            associatedLicenses = artifact.get("Derived Licenses");
        }
        if (StringUtils.isEmpty((CharSequence)associatedLicenses)) {
            associatedLicenses = artifact.get("Source Artifact - Derived Licenses");
        }
        if (StringUtils.isEmpty((CharSequence)associatedLicenses)) {
            associatedLicenses = artifact.get("Source Archive - Derived Licenses");
        }
        if (StringUtils.isEmpty((CharSequence)associatedLicenses)) {
            associatedLicenses = artifact.get("Descriptor - Derived Licenses");
        }
        if (StringUtils.isEmpty((CharSequence)associatedLicenses)) {
            associatedLicenses = artifact.get("Specified Package License (mapped)");
        }
        return associatedLicenses;
    }

    private static List<String> extractCopyrights(Artifact artifact) {
        String copyrights = artifact.get("Extracted Copyrights (ScanCode)");
        if (StringUtils.isEmpty((CharSequence)copyrights)) {
            copyrights = artifact.get("Binary Artifact - Extracted Copyrights (ScanCode)");
        }
        if (StringUtils.isEmpty((CharSequence)copyrights)) {
            copyrights = artifact.get("Source Artifact - Extracted Copyrights (ScanCode)");
        }
        if (StringUtils.isEmpty((CharSequence)copyrights)) {
            copyrights = artifact.get("Source Archive - Extracted Copyrights (ScanCode)");
        }
        if (StringUtils.isEmpty((CharSequence)copyrights)) {
            copyrights = artifact.get("Descriptor - Extracted Copyrights (ScanCode)");
        }
        if (!StringUtils.isEmpty((CharSequence)copyrights)) {
            return InventoryUtils.filterCopyrightsAndAuthorsList(copyrights);
        }
        return Collections.emptyList();
    }
}

