/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.cyclonedx;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.metaeffekt.artifact.analysis.bom.LicenseProcessor;
import com.metaeffekt.artifact.analysis.bom.PatternHelper;
import com.metaeffekt.artifact.analysis.bom.cyclonedx.AbstractAttributeMapper;
import com.metaeffekt.artifact.analysis.bom.parameters.ExportParameters;
import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import com.metaeffekt.artifact.analysis.bom.spdx.LicenseStringConverter;
import com.metaeffekt.artifact.terms.model.LicenseTextProvider;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.license.Expression;
import org.cyclonedx.util.LicenseResolver;
import org.metaeffekt.common.notice.model.NoticeParameters;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycloneDxComponentMapper
extends AbstractAttributeMapper {
    private static final Logger log = LoggerFactory.getLogger(CycloneDxComponentMapper.class);
    public DocumentSpec documentSpec;
    public Inventory inventory;
    public LicenseStringConverter licenseStringConverter;
    public LicenseTextProvider licenseTextProvider;
    public NormalizationMetaData normalizationMetaData;
    public Set<TermsMetaData> referencedLicenses = new HashSet<TermsMetaData>();
    private ExportParameters exportParameters;
    private Map<String, String> customLicenseMappings;
    private int currentId;

    public CycloneDxComponentMapper(DocumentSpec documentSpec, Inventory inventory, LicenseStringConverter licenseStringConverter, NormalizationMetaData normalizationMetaData, LicenseTextProvider licenseTextProvider, List<Pattern> includedAttributePatterns, List<Pattern> excludedAttributePatterns, ExportParameters exportParameters) {
        super(includedAttributePatterns, excludedAttributePatterns);
        this.exportParameters = exportParameters;
        this.documentSpec = documentSpec;
        this.inventory = inventory;
        this.licenseStringConverter = licenseStringConverter;
        this.licenseTextProvider = licenseTextProvider;
        this.normalizationMetaData = normalizationMetaData;
        File licenseMappingsFile = exportParameters.getCustomLicenseMappings();
        if (licenseMappingsFile == null || licenseMappingsFile.length() == 0L) {
            this.customLicenseMappings = null;
        } else {
            this.parseLicenseMappings(licenseMappingsFile);
        }
    }

    private void parseLicenseMappings(File licenseMappingsFile) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            this.customLicenseMappings = (Map)objectMapper.readValue(licenseMappingsFile, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read custom license mappings file: " + licenseMappingsFile, e);
        }
    }

    public Component map(AbstractModelBase modelBase) {
        Component component = new Component();
        HashSet<String> writtenAttributes = new HashSet<String>();
        this.mapBaseComponent(component, modelBase, writtenAttributes);
        this.mapChecksums(component, modelBase, writtenAttributes);
        this.mapProjects(component, modelBase);
        this.mapFileTypeInformation(component, modelBase, writtenAttributes);
        this.mapIncludesExcludes(component, modelBase, writtenAttributes);
        this.mapType(component, modelBase, writtenAttributes);
        if (modelBase instanceof Artifact) {
            this.mapLicenses(component, (Artifact)modelBase);
        }
        if (this.exportParameters.isIncludeTechnicalProperties()) {
            this.mapTechnicalProperties(component, modelBase);
        }
        return component;
    }

    private void mapBaseComponent(Component component, AbstractModelBase modelBase, Set<String> writtenAttributes) {
        component.setBomRef(this.getNextId());
        this.setFieldOrFallbackFromPurl(Component::setName, component, modelBase, Arrays.asList("Id", "Asset Id"), purl -> null, writtenAttributes);
        this.setFieldOrFallbackFromPurl(Component::setPublisher, component, modelBase, Collections.singletonList("URL"), purl -> null, writtenAttributes);
        this.setFieldOrFallbackFromPurl(Component::setVersion, component, modelBase, Collections.singletonList("Version"), PackageURL::getVersion, writtenAttributes);
        this.setFieldOrFallbackFromPurl(Component::setGroup, component, modelBase, Collections.singletonList("Group Id"), PackageURL::getNamespace, writtenAttributes);
        this.setFieldOrFallbackFromPurl(Component::setPurl, component, modelBase, Collections.singletonList("PURL"), purl -> null, writtenAttributes);
    }

    private void mapChecksums(Component component, AbstractModelBase modelBase, Set<String> writtenAttributes) {
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get("Hash (SHA-1)"))) {
            component.addHash(new Hash(Hash.Algorithm.SHA1, modelBase.get("Hash (SHA-1)")));
            writtenAttributes.add("Hash (SHA-1)");
        }
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get("Hash (SHA-256)"))) {
            component.addHash(new Hash(Hash.Algorithm.SHA_256, modelBase.get("Hash (SHA-256)")));
            writtenAttributes.add("Hash (SHA-256)");
        }
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get("Checksum"))) {
            component.addHash(new Hash(Hash.Algorithm.MD5, modelBase.get("Checksum")));
            writtenAttributes.add("Checksum");
        }
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get("Hash (SHA-512)"))) {
            component.addHash(new Hash(Hash.Algorithm.SHA_512, modelBase.get("Hash (SHA-512)")));
            writtenAttributes.add("Hash (SHA-512)");
        }
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get("Digest")) && modelBase.get("Digest").startsWith("sha256")) {
            component.addHash(new Hash(Hash.Algorithm.SHA_256, modelBase.get("Digest").substring(7)));
            writtenAttributes.add("Digest");
        }
    }

    private void mapProjects(Component component, AbstractModelBase modelBase) {
        if (StringUtils.isNotEmpty((CharSequence)modelBase.get("Projects"))) {
            Property property = new Property();
            property.setName("Projects");
            property.setValue(modelBase.get("Projects"));
            component.addProperty(property);
        }
    }

    private void mapType(Component component, AbstractModelBase modelBase, Set<String> writtenAttributes) {
        String modelBaseType = modelBase.get("Type");
        if (StringUtils.isBlank((CharSequence)modelBaseType) && this.exportParameters.isDeriveAttributesFromPurl()) {
            try {
                modelBaseType = new PackageURL(modelBase.get("PURL")).getType();
            }
            catch (MalformedPackageURLException e2) {
                log.warn("Cannot derive type from purl for: [{}]", (Object)modelBase);
            }
        }
        if (modelBaseType == null) {
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(this.getClass().getResource("/sbom/typeMap.json"));
            Iterator iterator = jsonNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ArrayList valuesList = new ArrayList();
                if (((JsonNode)entry.getValue()).isArray()) {
                    ((JsonNode)entry.getValue()).forEach(e -> valuesList.add(e.asText()));
                }
                if (valuesList.contains(modelBaseType)) {
                    component.setType(Component.Type.valueOf((String)((String)entry.getKey())));
                }
                writtenAttributes.add("Type");
            }
        }
        catch (IOException e3) {
            throw new RuntimeException(e3);
        }
    }

    private void mapFileTypeInformation(Component component, AbstractModelBase modelBase, Set<String> writtenAttributes) {
        String archive = modelBase.get("Archive");
        String structured = modelBase.get("Structured");
        String executable = modelBase.get("Executable");
        if (StringUtils.isNotBlank((CharSequence)archive)) {
            Property archiveProperty = new Property();
            archiveProperty.setName("Archive");
            archiveProperty.setValue(archive);
            component.addProperty(archiveProperty);
            writtenAttributes.add("Archive");
            if (StringUtils.isNotBlank((CharSequence)structured)) {
                Property structuredProperty = new Property();
                structuredProperty.setName("Structured");
                structuredProperty.setValue(structured);
                component.addProperty(structuredProperty);
                writtenAttributes.add("Structured");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)executable)) {
            Property executableProperty = new Property();
            executableProperty.setName("Executable");
            executableProperty.setValue(executable);
            component.addProperty(executableProperty);
            writtenAttributes.add("Executable");
        }
    }

    private void mapIncludesExcludes(Component component, AbstractModelBase modelBase, Set<String> writtenAttributes) {
        Set attributes = modelBase.getAttributes();
        for (String attribute : attributes) {
            boolean excluded = PatternHelper.isExcluded(attribute, this.getIncludedAttributePatterns(), this.getExcludedAttributePatterns());
            if (excluded || writtenAttributes.contains(attribute)) continue;
            Property property = new Property();
            property.setName(attribute);
            property.setValue(modelBase.get(attribute));
            component.addProperty(property);
        }
        String idKey = modelBase instanceof AssetMetaData ? AssetMetaData.Attribute.ASSET_ID.getKey() : Artifact.Attribute.ID.getKey();
        String id = modelBase.get(idKey);
        if (id != null) {
            Property idProperty = new Property();
            idProperty.setName("com.metaeffekt.component.id");
            idProperty.setValue(id);
            component.addProperty(idProperty);
        }
    }

    private void mapTechnicalProperties(Component component, AbstractModelBase modelBase) {
        String type;
        Property property = new Property();
        property.setName("com.metaeffekt.component.class");
        if (modelBase instanceof Artifact) {
            property.setValue("artifact");
        } else if (modelBase instanceof AssetMetaData) {
            property.setValue("asset");
        } else {
            log.error("{} is not an Artifact or Asset. That should not be possible.", (Object)modelBase.toString());
        }
        component.addProperty(property);
        String version = modelBase.get("Version");
        if (version != null) {
            Property versionProperty = new Property();
            versionProperty.setName("com.metaeffekt.component.version");
            versionProperty.setValue(version);
            component.addProperty(versionProperty);
        }
        if ((type = modelBase.get("Type")) != null) {
            Property componentType = new Property();
            componentType.setName("com.metaeffekt.component.type");
            componentType.setValue(type);
            component.addProperty(componentType);
        }
    }

    private void mapLicenses(Component component, Artifact artifact) {
        NoticeParameters noticeParameters = LicenseProcessor.readNoticeParameters((AbstractModelBase)artifact);
        if (noticeParameters == null) {
            return;
        }
        List<String> effectiveLicenses = LicenseProcessor.aggregateEffectiveLicenses(noticeParameters);
        List associatedLicenses = noticeParameters.aggregateAssociatedLicenses();
        if (effectiveLicenses.isEmpty() || effectiveLicenses.stream().anyMatch(StringUtils::isBlank) || associatedLicenses.isEmpty() || associatedLicenses.stream().anyMatch(StringUtils::isBlank)) {
            return;
        }
        List<LicenseStringConverter.ToSpdxResult> concludedLicenseResults = effectiveLicenses.stream().map((? super T s) -> this.licenseStringConverter.licenseStringToSpdxExpression((String)s)).collect(Collectors.toList());
        List<LicenseStringConverter.ToSpdxResult> declaredLicenseResults = associatedLicenses.stream().map((? super T s) -> this.licenseStringConverter.licenseStringToSpdxExpression((String)s)).collect(Collectors.toList());
        if (!this.exportParameters.isUseLicenseExpressions()) {
            if (!concludedLicenseResults.isEmpty()) {
                this.addSingleLicenses(concludedLicenseResults, this.exportParameters.isIncludeLicenseTexts(), "concluded", component);
            }
            if (!declaredLicenseResults.isEmpty()) {
                this.addSingleLicenses(declaredLicenseResults, this.exportParameters.isIncludeLicenseTexts(), "declared", component);
            }
        } else if (!concludedLicenseResults.isEmpty()) {
            this.addLicenseExpression(concludedLicenseResults, component, "concluded");
        } else if (!declaredLicenseResults.isEmpty()) {
            this.addLicenseExpression(declaredLicenseResults, component, "declared");
        }
    }

    private void addSingleLicenses(List<LicenseStringConverter.ToSpdxResult> results, boolean includeLicenseTexts, String acknowledgement, Component component) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (LicenseStringConverter.ToSpdxResult result : results) {
            if (StringUtils.isBlank((CharSequence)result.getExpression())) {
                return;
            }
            String expression = result.getExpression();
            for (String licenseValue : result.getReferencedMissingTmd()) {
                if (this.exportParameters.getCustomLicenseMappings() == null || !this.customLicenseMappings.containsKey(licenseValue)) continue;
                expression = this.customLicenseMappings.get(licenseValue);
            }
            LicenseChoice licenseChoiceResolved = LicenseResolver.resolve((String)expression, (LicenseResolver.LicenseTextSettings)new LicenseResolver.LicenseTextSettings(includeLicenseTexts, LicenseResolver.LicenseEncoding.NONE));
            if (licenseChoiceResolved != null) {
                licenseChoiceResolved.getLicenses().forEach(e -> {
                    e.setAcknowledgement(acknowledgement);
                    licenseChoice.addLicense(e);
                });
                continue;
            }
            Map<String, String> licenseToText = LicenseProcessor.getReferencedLicenseText(result.getReferencedLicenses(), this.licenseTextProvider, this.normalizationMetaData);
            License license = new License();
            if (includeLicenseTexts && licenseToText != null) {
                AttachmentText attachmentText = new AttachmentText();
                attachmentText.setText(licenseToText.get(expression));
                license.setLicenseText(attachmentText);
            }
            license.setName(expression);
            license.setAcknowledgement(acknowledgement);
            licenseChoice.addLicense(license);
        }
        component.setLicenses(licenseChoice);
    }

    private void addLicenseExpression(List<LicenseStringConverter.ToSpdxResult> results, Component component, String acknowledgement) {
        StringJoiner joiner = new StringJoiner(" AND ", "(", ")");
        for (LicenseStringConverter.ToSpdxResult converterResult : results) {
            if (!StringUtils.isNotBlank((CharSequence)converterResult.getExpression())) continue;
            String expression = converterResult.getExpression();
            for (String licenseValue : converterResult.getReferencedMissingTmd()) {
                if (this.customLicenseMappings == null || !this.customLicenseMappings.containsKey(licenseValue)) continue;
                expression = this.customLicenseMappings.get(licenseValue);
            }
            LicenseChoice hasLicenseResolved = LicenseResolver.resolve((String)expression);
            if (hasLicenseResolved == null) {
                this.referencedLicenses.addAll(converterResult.getReferencedLicenses());
            }
            if (expression.startsWith("(") && expression.endsWith(")")) {
                joiner.add(expression);
                continue;
            }
            joiner.add("(" + expression + ")");
        }
        LicenseChoice licenseChoice = new LicenseChoice();
        Expression expression = new Expression(joiner.toString());
        expression.setAcknowledgement(acknowledgement);
        licenseChoice.setExpression(expression);
        component.setLicenses(licenseChoice);
    }

    private void setFieldOrFallbackFromPurl(BiConsumer<Component, String> setter, Component component, AbstractModelBase modelBase, List<String> keys, Function<PackageURL, String> purlExtractor, Set<String> writtenAttributes) {
        boolean found = this.setIfNotBlank(setter, component, modelBase, keys, writtenAttributes);
        if (!found && this.exportParameters.isDeriveAttributesFromPurl()) {
            try {
                String purlValue = purlExtractor.apply(new PackageURL(modelBase.get("PURL")));
                if (StringUtils.isNotBlank((CharSequence)purlValue)) {
                    setter.accept(component, purlValue);
                }
            }
            catch (MalformedPackageURLException e) {
                log.debug("Cant extract info from invalid purl in: [{}]", (Object)modelBase);
            }
        }
    }

    private boolean setIfNotBlank(BiConsumer<Component, String> setter, Component component, AbstractModelBase modelBase, List<String> keys, Set<String> writtenAttributes) {
        for (String key : keys) {
            String value = modelBase.get(key);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                setter.accept(component, value);
                return true;
            }
            writtenAttributes.add(key);
        }
        return false;
    }

    private String getNextId() {
        ++this.currentId;
        return this.documentSpec.getOrganizationUrl() + "Component-" + this.currentId;
    }

    public DocumentSpec getDocumentSpec() {
        return this.documentSpec;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public LicenseStringConverter getLicenseStringConverter() {
        return this.licenseStringConverter;
    }

    public LicenseTextProvider getLicenseTextProvider() {
        return this.licenseTextProvider;
    }

    public NormalizationMetaData getNormalizationMetaData() {
        return this.normalizationMetaData;
    }

    public Set<TermsMetaData> getReferencedLicenses() {
        return this.referencedLicenses;
    }

    public ExportParameters getExportParameters() {
        return this.exportParameters;
    }

    public Map<String, String> getCustomLicenseMappings() {
        return this.customLicenseMappings;
    }

    public int getCurrentId() {
        return this.currentId;
    }

    public void setDocumentSpec(DocumentSpec documentSpec) {
        this.documentSpec = documentSpec;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public void setLicenseStringConverter(LicenseStringConverter licenseStringConverter) {
        this.licenseStringConverter = licenseStringConverter;
    }

    public void setLicenseTextProvider(LicenseTextProvider licenseTextProvider) {
        this.licenseTextProvider = licenseTextProvider;
    }

    public void setNormalizationMetaData(NormalizationMetaData normalizationMetaData) {
        this.normalizationMetaData = normalizationMetaData;
    }

    public void setReferencedLicenses(Set<TermsMetaData> referencedLicenses) {
        this.referencedLicenses = referencedLicenses;
    }

    public void setExportParameters(ExportParameters exportParameters) {
        this.exportParameters = exportParameters;
    }

    public void setCustomLicenseMappings(Map<String, String> customLicenseMappings) {
        this.customLicenseMappings = customLicenseMappings;
    }

    public void setCurrentId(int currentId) {
        this.currentId = currentId;
    }
}

