/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx;

import com.metaeffekt.artifact.analysis.bom.BomConstants;

public class DocumentSpec {
    private String documentName;
    private String description;
    private String documentId;
    private String organization;
    private String organizationUrl;
    private String person;
    private String tool = "{metaeffekt} Kontinuum Exporter";
    private String comment;
    private String spdxLicenseListVersion;
    private BomConstants.Format format = BomConstants.Format.JSON;
    private int documentVersion = 1;

    public DocumentSpec(String documentName, String documentId, String organization, String organizationUrl) {
        if (documentId == null) {
            throw new IllegalArgumentException("The document URI in the document spec cannot be null.");
        }
        if (organizationUrl == null) {
            throw new IllegalArgumentException("The organization URL in the document spec cannot be null.");
        }
        this.documentName = documentName;
        this.documentId = documentId;
        this.organization = organization;
        this.organizationUrl = organizationUrl;
    }

    public DocumentSpec withDescription(String description) {
        this.description = description;
        return this;
    }

    public DocumentSpec withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public DocumentSpec withSpdxLicenseListVersion(String spdxLicenseListVersion) {
        this.spdxLicenseListVersion = spdxLicenseListVersion;
        return this;
    }

    public DocumentSpec byPerson(String person) {
        this.person = person;
        return this;
    }

    public DocumentSpec usingTool(String tool) {
        this.tool = tool;
        return this;
    }

    public DocumentSpec usingFormat(BomConstants.Format format) {
        this.format = format;
        return this;
    }

    public DocumentSpec setDocumentVersion(int documentVersion) {
        this.documentVersion = documentVersion;
        return this;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public String getPerson() {
        return this.person;
    }

    public String getTool() {
        return this.tool;
    }

    public String getComment() {
        return this.comment;
    }

    public String getSpdxLicenseListVersion() {
        return this.spdxLicenseListVersion;
    }

    public BomConstants.Format getFormat() {
        return this.format;
    }

    public int getDocumentVersion() {
        return this.documentVersion;
    }
}

