/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx;

import com.metaeffekt.artifact.analysis.bom.spdx.LicenseStringUtils;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.model.license.ListedLicenses;

public class LicenseStringConverter {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseStringConverter.class);
    public static final int MAX_RECURSION_DEPTH = 64;
    private static final Pattern ENDS_WITH_WITH_PATTERN = Pattern.compile("WITH *$");
    private static final Pattern SPDX_OR_PATTERN = Pattern.compile(" OR ", 2);
    private static final Pattern SPDX_AND_PATTERN = Pattern.compile(" AND ", 2);
    private final NormalizationMetaData normalizationMetaData;
    private final Map<String, String> spdxToLicenseStringAssessments;
    private final List<String> alreadyScannedLicenses = new ArrayList<String>();

    public LicenseStringConverter(NormalizationMetaData normalizationMetaData, Map<String, String> spdxToLicenseStringAssessments) {
        Objects.requireNonNull(normalizationMetaData, "This class requires non-null NormalizationMetaData.");
        this.normalizationMetaData = normalizationMetaData;
        this.spdxToLicenseStringAssessments = spdxToLicenseStringAssessments == null ? new HashMap<String, String>() : new HashMap<String, String>(spdxToLicenseStringAssessments);
    }

    protected String findSpdxAssessment(String expression) {
        if (expression != null) {
            return this.spdxToLicenseStringAssessments.get(expression);
        }
        return null;
    }

    protected TermsMetaData findTmdForCanonicalName(String inputName) {
        TermsMetaData resolvedMeta = this.normalizationMetaData.findTermsMetaData(inputName);
        if (resolvedMeta == null) {
            resolvedMeta = this.normalizationMetaData.findUsingCanonicalNameInHistory(inputName);
        }
        return resolvedMeta;
    }

    protected String deriveSpdxRepresentation(String inputName, Set<TermsMetaData> referencedLicenses, Set<String> referencedWithoutTmd) {
        TermsMetaData resolvedMeta = this.findTmdForCanonicalName(inputName);
        if (resolvedMeta == null) {
            if (!this.alreadyScannedLicenses.contains(inputName)) {
                LOG.warn("No terms metadata found for [{}].", (Object)inputName);
                this.alreadyScannedLicenses.add(inputName);
            }
            referencedWithoutTmd.add(inputName);
            String tmd = LicenseStringUtils.createUnknownLicenseRef(inputName);
            LOG.debug("Created ref [{}] using raw name [{}].", (Object)tmd, (Object)inputName);
            return tmd;
        }
        return this.deriveLicenseExpressionFromTmd(resolvedMeta, referencedLicenses, referencedWithoutTmd);
    }

    public ToSpdxResult licenseStringToSpdxExpression(String metaLicensesString) {
        if (metaLicensesString == null) {
            return new ToSpdxResult(null, Collections.emptySet(), Collections.emptySet());
        }
        if (StringUtils.isBlank((CharSequence)metaLicensesString)) {
            return new ToSpdxResult("", Collections.emptySet(), Collections.emptySet());
        }
        StringJoiner andJoiner = new StringJoiner(" AND ");
        String[] andSplit = metaLicensesString.split(",");
        HashSet<TermsMetaData> referencedLicenses = new HashSet<TermsMetaData>();
        HashSet<String> referencedWithoutTmd = new HashSet<String>();
        for (String foundLicense : andSplit) {
            foundLicense = foundLicense.trim();
            String[] licenseFound = (foundLicense = this.transformLicense(foundLicense)).trim().split(" \\+ ");
            StringJoiner orJoiner = licenseFound.length > 1 && andSplit.length > 1 ? new StringJoiner(" OR ", "(", ")") : new StringJoiner(" OR ");
            for (String licenseName : licenseFound) {
                if (StringUtils.isBlank((CharSequence)(licenseName = licenseName.trim()))) {
                    throw new IllegalStateException("Invalid license string '" + metaLicensesString + "' could not be parsed.");
                }
                if (licenseName.length() < 3) {
                    LOG.info("Suspicious input name [{}]. Bad license string [{}] in input inventory?", (Object)licenseName, (Object)metaLicensesString);
                }
                String spdxRepresentation = this.deriveSpdxRepresentation(licenseName, referencedLicenses, referencedWithoutTmd);
                if (ListedLicenses.getListedLicenses().isSpdxListedExceptionId(spdxRepresentation)) {
                    TermsMetaData tmdToRef = this.findTmdForCanonicalName(licenseName);
                    referencedLicenses.add(tmdToRef);
                    spdxRepresentation = this.getLicenseRefForTmd(tmdToRef);
                }
                orJoiner.add(spdxRepresentation);
            }
            if (orJoiner.length() == 0) {
                throw new RuntimeException("Sanity check failed: Invalid empty orJoiner output for non-empty input.");
            }
            andJoiner.add(orJoiner.toString());
        }
        return new ToSpdxResult(andJoiner.toString(), referencedLicenses, referencedWithoutTmd);
    }

    private String transformLicense(String foundLicense) {
        TermsMetaData termsMetaData = this.normalizationMetaData.findUsingCanonicalNameInHistory(foundLicense);
        if (termsMetaData != null) {
            return termsMetaData.getCanonicalName();
        }
        return foundLicense;
    }

    private Pair<String, List<String>> recurseBrackets(String spdxExpressionSnippet, Artifact artifact) {
        if (spdxExpressionSnippet.contains("()")) {
            LOG.warn("Spdx license expression contains '()' (empty brackets). This may lead to problems.");
        }
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder placeholderSnippet = new StringBuilder();
        int added = 0;
        for (Map.Entry bracketPositions : LicenseStringUtils.findTopBrackets(spdxExpressionSnippet).entrySet()) {
            int contentBegin = (Integer)bracketPositions.getKey();
            int contentEnd = (Integer)bracketPositions.getValue();
            String sub = spdxExpressionSnippet.substring(contentBegin + 1, contentEnd);
            String convertedContent = this.spdxExpressionToLicenseString(sub, artifact);
            placeholderSnippet.append(spdxExpressionSnippet, added, contentBegin).append("()");
            added = contentEnd + 1;
            values.add(convertedContent);
        }
        placeholderSnippet.append(spdxExpressionSnippet, added, spdxExpressionSnippet.length());
        return Pair.of((Object)placeholderSnippet.toString(), values);
    }

    public String spdxExpressionToLicenseString(String spdxExpression) {
        return this.spdxExpressionToLicenseString(spdxExpression, null);
    }

    public String spdxExpressionToLicenseString(String spdxExpression, Artifact artifact) {
        if (spdxExpression == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)spdxExpression)) {
            return "";
        }
        String lookupAssessment = this.findSpdxAssessment(spdxExpression = spdxExpression.trim());
        if (lookupAssessment != null) {
            return lookupAssessment;
        }
        Pair<String, List<String>> recursionResult = this.recurseBrackets(spdxExpression, artifact);
        String expressionWithPlaceholders = (String)recursionResult.getLeft();
        List values = (List)recursionResult.getRight();
        String[] orParts = SPDX_OR_PATTERN.split(expressionWithPlaceholders);
        StringJoiner orJoiner = new StringJoiner(" + ");
        for (String orPart : orParts) {
            String[] andParts = SPDX_AND_PATTERN.split(orPart);
            if (orParts.length > 1 && andParts.length > 1) {
                throw new RuntimeException("Logic incompatibility due to differing operator precedence: '" + orPart + "' in Expression '" + spdxExpression + "' would require bracketing. Please provide a manual assessment for this exact expression.");
            }
            StringJoiner andJoiner = new StringJoiner(", ");
            for (String spdxPart : andParts) {
                String trimmed = spdxPart.trim();
                if (trimmed.equals("()")) {
                    String toInsert = (String)values.remove(0);
                    if (LicenseStringUtils.containsTopAnd(toInsert) && andParts.length == 1 && orParts.length != 1) {
                        throw new RuntimeException("Cannot ignore brackets around '" + toInsert + "' inserted into '" + trimmed.replaceFirst(Pattern.quote("()"), "(INSERT_GOES_HERE)") + "'. Logic may be incompatble between spdx and license strings.");
                    }
                    andJoiner.add(trimmed.replace("()", toInsert));
                    continue;
                }
                if (trimmed.startsWith("LicenseRef-ae-")) {
                    String unwrappedLicenseRef = LicenseStringUtils.unwrapLicenseRef(trimmed);
                    TermsMetaData foundMeta = this.normalizationMetaData.findByShortName(unwrappedLicenseRef);
                    if (foundMeta == null) {
                        LOG.warn("Unknown license short name [{}].", (Object)unwrappedLicenseRef);
                        LicenseStringConverter.addError(artifact, "No tmd '" + unwrappedLicenseRef + "'");
                    }
                    andJoiner.add(unwrappedLicenseRef);
                    continue;
                }
                TermsMetaData foundMeta = this.normalizationMetaData.findTermsMetaData(trimmed);
                if (foundMeta == null) {
                    String mapped = this.spdxToLicenseStringAssessments.get(trimmed);
                    if (mapped == null) {
                        mapped = "SpdxLicense-(" + trimmed + ")";
                        LOG.warn("Can't find spdx expression '" + trimmed + "' in tmd. Writing '" + mapped + "'.");
                        LicenseStringConverter.addError(artifact, "No data for spdxId '" + trimmed + "'");
                    }
                    andJoiner.add(mapped);
                    continue;
                }
                andJoiner.add(foundMeta.getCanonicalName());
            }
            orJoiner.add(andJoiner.toString());
        }
        return orJoiner.toString();
    }

    protected static void addError(Artifact artifact, String errorString) {
        if (artifact != null) {
            artifact.append("Errors", errorString, ", ");
        }
    }

    public static String getRepresentativeName(TermsMetaData tmd) {
        String name = tmd.getShortName();
        if (StringUtils.isBlank((CharSequence)name)) {
            LOG.warn("Could not create meta representation for tmd [{}]. Indicates a processing error or invalid tmd.", (Object)tmd.getCanonicalName());
        }
        return name;
    }

    protected String parseProtoExpressionBottomLevel(String protoExpression, String canonicalName, Set<TermsMetaData> referencedLicenses, Set<String> referencedWithoutTmd, int recursionDepth) {
        String nameForPlaceholderBracket = protoExpression.startsWith("[") && protoExpression.endsWith("]") ? protoExpression.substring(1, protoExpression.length() - 1) : protoExpression;
        TermsMetaData resolvedTmdForPlaceholder = this.normalizationMetaData.findTermsMetaData(nameForPlaceholderBracket);
        if (resolvedTmdForPlaceholder == null && (resolvedTmdForPlaceholder = this.normalizationMetaData.findUsingCanonicalNameInHistory(nameForPlaceholderBracket)) != null) {
            LOG.info("Deprecated canonicalName [{}] still used in expression of tmd [{}].", (Object)nameForPlaceholderBracket, (Object)canonicalName);
        }
        if (resolvedTmdForPlaceholder == null) {
            LOG.warn("No terms metadata found for [{}] referenced in spdxExpression of tmd [{}].", (Object)nameForPlaceholderBracket, (Object)canonicalName);
            referencedWithoutTmd.add(nameForPlaceholderBracket);
            return null;
        }
        return this.deriveLicenseExpressionFromTmd(resolvedTmdForPlaceholder, referencedLicenses, referencedWithoutTmd, recursionDepth + 1);
    }

    public String parseProtoExpression(String protoExpression, String canonicalName, Set<TermsMetaData> referencedLicenses, Set<String> referencedWithoutTmd, int recursionDepth) {
        if (protoExpression == null) {
            return null;
        }
        if (recursionDepth > 64) {
            throw new RuntimeException("Recursion depth exceeded while parsing expression [{}] in [{}].");
        }
        NavigableMap<Integer, Integer> topBrackets = LicenseStringUtils.findTopBrackets(protoExpression, '[', ']');
        if (topBrackets.size() <= 1) {
            return this.parseProtoExpressionBottomLevel(protoExpression, canonicalName, referencedLicenses, referencedWithoutTmd, recursionDepth + 1);
        }
        StringBuilder outputExpression = new StringBuilder();
        int lastEnd = 0;
        Iterator iterator = topBrackets.keySet().iterator();
        while (iterator.hasNext()) {
            int start = (Integer)iterator.next();
            outputExpression.append(protoExpression, lastEnd, start);
            int end = (Integer)topBrackets.get(start);
            String topBracketContent = protoExpression.substring(start + 1, end);
            boolean isAfterWith = ENDS_WITH_WITH_PATTERN.matcher(outputExpression.toString()).find();
            String parsedSubstring = this.parseProtoExpression(topBracketContent, canonicalName, referencedLicenses, referencedWithoutTmd, recursionDepth + 1);
            if (parsedSubstring == null) {
                return null;
            }
            if (isAfterWith && parsedSubstring.startsWith("LicenseRef-")) {
                return null;
            }
            outputExpression.append(parsedSubstring);
            lastEnd = end + 1;
        }
        outputExpression.append(protoExpression, lastEnd, protoExpression.length());
        return outputExpression.toString();
    }

    public String deriveLicenseExpressionFromTmd(TermsMetaData tmd, Set<TermsMetaData> referencedLicenses, Set<String> referencedWithoutTmd) {
        return this.deriveLicenseExpressionFromTmd(tmd, referencedLicenses, referencedWithoutTmd, 0);
    }

    public String getLicenseRefForTmd(TermsMetaData tmd) {
        String spdxIdentifier;
        String representativeName;
        String expressionOrId = null;
        String nullableScancodeId = tmd.getOtherId("scancode");
        if (StringUtils.isNotBlank((CharSequence)nullableScancodeId)) {
            expressionOrId = LicenseStringUtils.createScancodeLicenseRef(nullableScancodeId);
        }
        if (StringUtils.isBlank(expressionOrId) && StringUtils.isNotBlank((CharSequence)(representativeName = LicenseStringConverter.getRepresentativeName(tmd)))) {
            expressionOrId = LicenseStringUtils.createAeLicenseRef(representativeName);
        }
        if (StringUtils.isBlank((CharSequence)expressionOrId) && StringUtils.isNotBlank((CharSequence)(spdxIdentifier = tmd.getSpdxIdentifier()))) {
            expressionOrId = LicenseStringUtils.createSpdxLicenseRef(spdxIdentifier);
        }
        if (StringUtils.isBlank((CharSequence)expressionOrId)) {
            LOG.error("Sanity check failed: will return empty license expression (should never happen).");
        }
        return expressionOrId;
    }

    public String deriveLicenseExpressionFromTmd(TermsMetaData tmd, Set<TermsMetaData> referencedLicenses, Set<String> referencedWithoutTmd, int recursionDepth) {
        Objects.requireNonNull(tmd);
        LOG.trace("deriving spdx expression from tmd [{}] at recursion depth [{}].", (Object)tmd.getCanonicalName(), (Object)recursionDepth);
        String expressionOrId = tmd.getSpdxIdentifier();
        ListedLicenses listedLicenses = ListedLicenses.getListedLicenses();
        if (StringUtils.isNotBlank((CharSequence)expressionOrId) && !listedLicenses.getSpdxListedLicenseIds().contains(expressionOrId) && !listedLicenses.isSpdxListedExceptionId(expressionOrId)) {
            LOG.debug("The spdxIdentifier [{}] listed in tmd does not exist according to the SPDX library. Using other id.", (Object)expressionOrId);
            expressionOrId = null;
        }
        if (StringUtils.isBlank((CharSequence)expressionOrId) && tmd.getSpdxExpression() != null && StringUtils.isNotBlank((CharSequence)(expressionOrId = this.parseProtoExpression(tmd.getSpdxExpression(), tmd.getCanonicalName(), referencedLicenses, referencedWithoutTmd, recursionDepth + 1)))) {
            expressionOrId = "(" + expressionOrId + ")";
        }
        if (StringUtils.isBlank((CharSequence)expressionOrId)) {
            expressionOrId = this.getLicenseRefForTmd(tmd);
            referencedLicenses.add(tmd);
        }
        return expressionOrId;
    }

    public static class ToSpdxResult {
        private final String convertedExpression;
        private final Set<TermsMetaData> referencedLicenses;
        private final Set<String> referencedMissingTmd;

        public ToSpdxResult(String convertedExpression, Set<TermsMetaData> referencedLicenses, Set<String> referencedMissingTmd) {
            this.convertedExpression = convertedExpression;
            this.referencedLicenses = referencedLicenses;
            this.referencedMissingTmd = referencedMissingTmd;
        }

        public String getExpression() {
            return this.convertedExpression;
        }

        public Set<TermsMetaData> getReferencedLicenses() {
            return this.referencedLicenses;
        }

        public Set<String> getReferencedMissingTmd() {
            return this.referencedMissingTmd;
        }
    }
}

