/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx;

import com.metaeffekt.artifact.analysis.bom.spdx.facade.SpdxApiFacade;
import com.metaeffekt.artifact.analysis.bom.spdx.mapper.InventoryModelBaseMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.AssetMetaData;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.RelationshipType;

public class SpdxImporter {
    private final List<Artifact> artifacts = new ArrayList<Artifact>();
    private final List<AssetMetaData> assets = new ArrayList<AssetMetaData>();
    private final Inventory inventory = new Inventory();

    /*
     * Exception decompiling
     */
    public Inventory importFromFile(File file, MultiFormatStore.Format fileFormat) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Inventory importFromDocument(SpdxDocument spdxDocument) {
        List<SpdxPackage> allPackages = SpdxApiFacade.getAllPackages(spdxDocument);
        this.importAssetsAndArtifacts(allPackages);
        this.importHierarchy(spdxDocument, allPackages);
        this.inventory.setArtifacts(this.artifacts);
        this.inventory.setAssetMetaData(this.assets);
        return this.inventory;
    }

    private void importAssetsAndArtifacts(List<SpdxPackage> allPackages) {
        InventoryModelBaseMapper inventoryModelBaseMapper = new InventoryModelBaseMapper();
        for (SpdxPackage spdxPackage : allPackages) {
            AbstractModelBase modelBase = inventoryModelBaseMapper.map(spdxPackage);
            if (modelBase instanceof Artifact) {
                this.artifacts.add((Artifact)modelBase);
                continue;
            }
            this.assets.add((AssetMetaData)modelBase);
        }
    }

    private void importHierarchy(SpdxDocument spdxDocument, List<SpdxPackage> allPackages) {
        try {
            for (SpdxPackage spdxPackage : allPackages) {
                ArrayList relationships = new ArrayList(spdxPackage.getRelationships());
                Optional optionalPackageName = spdxPackage.getName();
                String packageName = optionalPackageName.isPresent() ? optionalPackageName.orElse("") : "";
                for (Relationship relationship : relationships) {
                    String relatedName;
                    Optional relatedElement = relationship.getRelatedSpdxElement();
                    if (relatedElement.isPresent()) {
                        Optional optionalName = ((SpdxElement)relatedElement.get()).getName();
                        relatedName = optionalName.orElse("");
                    } else {
                        relatedName = "";
                    }
                    if (relationship.getRelationshipType().equals((Object)RelationshipType.CONTAINS)) {
                        this.artifacts.stream().filter(artifact -> relatedName.equals(artifact.get(Artifact.Attribute.ID))).findFirst().ifPresent(artifact -> artifact.set(packageName, "c"));
                        continue;
                    }
                    if (!relationship.getRelationshipType().equals((Object)RelationshipType.DESCRIBES)) continue;
                    this.artifacts.stream().filter(artifact -> relatedName.equals(artifact.get(Artifact.Attribute.ID))).findFirst().ifPresent(artifact -> artifact.set(packageName, "x"));
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }
}

