/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.bom.spdx.facade;

import com.metaeffekt.artifact.analysis.bom.BomConstants;
import com.metaeffekt.artifact.analysis.bom.spdx.DocumentSpec;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.jacksonstore.MultiFormatStore;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.Read;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.Relationship;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.SpdxElement;
import org.spdx.library.model.SpdxPackage;
import org.spdx.library.model.enumerations.RelationshipType;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.storage.IModelStore;

public class SpdxApiFacade {
    private static final Logger log = LoggerFactory.getLogger(SpdxApiFacade.class);

    public static void addRelationshipsToDocument(SpdxDocument spdxDocument, String fromNode, List<String> toNodes, RelationshipType relationshipType) {
        for (String toNode : toNodes) {
            try {
                if (fromNode.equals("DOCUMENT")) {
                    spdxDocument.getDocumentDescribes().add(SpdxApiFacade.getPackageByName(toNode, spdxDocument));
                    continue;
                }
                Relationship relationship = spdxDocument.createRelationship((SpdxElement)SpdxApiFacade.getPackageByName(toNode, spdxDocument), relationshipType, null);
                SpdxPackage spdxPackage = SpdxApiFacade.getPackageByName(fromNode, spdxDocument);
                if (spdxPackage == null) continue;
                spdxPackage.addRelationship(relationship);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException("Failed to add Relationship: " + fromNode + " to the document.", e);
            }
        }
    }

    public static SpdxPackage getPackageByName(String name, SpdxDocument spdxDocument) {
        List<SpdxPackage> spdxPackages = SpdxApiFacade.getAllPackages(spdxDocument);
        for (SpdxPackage spdxPackage : spdxPackages) {
            try {
                if (!spdxPackage.getName().orElse("").equals(name)) continue;
                return spdxPackage;
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException("SpdxPackage: " + spdxPackage.getId() + " does not have a name.", e);
            }
        }
        return null;
    }

    public static AnyLicenseInfo parseLicenseString(String licenseString, SpdxDocument spdxDocument) throws InvalidLicenseStringException {
        return LicenseInfoFactory.parseSPDXLicenseString((String)licenseString, (IModelStore)spdxDocument.getModelStore(), (String)spdxDocument.getDocumentUri(), (ModelCopyManager)spdxDocument.getCopyManager());
    }

    public static void createExtractedLicenseInfo(String licenseId, String text, String comment, SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        ExtractedLicenseInfo extractedLicenseInfo = new ExtractedLicenseInfo(spdxDocument.getModelStore(), spdxDocument.getDocumentUri(), licenseId, spdxDocument.getCopyManager(), true);
        if (text != null) {
            extractedLicenseInfo.setExtractedText(text);
        } else {
            extractedLicenseInfo.setExtractedText(SpdxConstants.NOASSERTION_VALUE);
            extractedLicenseInfo.setComment(comment);
        }
        spdxDocument.addExtractedLicenseInfos(extractedLicenseInfo);
    }

    /*
     * Exception decompiling
     */
    public static SpdxDocument generateFromFile(File spdxDocumentFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getFilePathFromProjectLocations(String locations) {
        String rootMarker = "[root]";
        int startIndex = locations.indexOf(rootMarker) + rootMarker.length();
        if (!locations.contains(rootMarker)) {
            return locations;
        }
        int endIndex = locations.indexOf("\\|\n", startIndex);
        if (endIndex == -1) {
            endIndex = locations.length();
            return locations.substring(startIndex, endIndex).trim();
        }
        return "/";
    }

    public static List<SpdxPackage> getAllPackages(SpdxDocument spdxDocument) {
        try {
            return Read.getAllPackages((IModelStore)spdxDocument.getModelStore(), (String)spdxDocument.getDocumentUri()).collect(Collectors.toList());
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Failed to get all packages from document: " + spdxDocument, e);
        }
    }

    public static MultiFormatStore.Format getSpdxFormat(DocumentSpec documentSpec, boolean prettyPrint) {
        MultiFormatStore.Format spdxFormat = null;
        if (documentSpec.getFormat() != null) {
            if (documentSpec.getFormat().equals((Object)BomConstants.Format.JSON)) {
                spdxFormat = prettyPrint ? MultiFormatStore.Format.JSON_PRETTY : MultiFormatStore.Format.JSON;
            } else if (documentSpec.getFormat().equals((Object)BomConstants.Format.XML)) {
                spdxFormat = MultiFormatStore.Format.XML;
            }
        }
        if (spdxFormat == null) {
            spdxFormat = MultiFormatStore.Format.JSON;
        }
        return spdxFormat;
    }
}

