/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.cert;

import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusReviewedEntry;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.AmbDataClass;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeIdentifier;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.query.AdvisorIndexQuery;
import com.metaeffekt.mirror.query.VulnerabilityIndexQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.model.AdvisoryMetaData;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicDataSourcesOperations {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicDataSourcesOperations.class);
    private final List<AdvisorIndexQuery<?>> advisorIndexQueries = new ArrayList();
    private final List<VulnerabilityIndexQuery> vulnerabilityIndexQueries = new ArrayList<VulnerabilityIndexQuery>();

    public void addAdvisorIndexQuery(AdvisorIndexQuery<?> advisorIndexQuery) {
        this.advisorIndexQueries.removeIf(a -> a.getClass().equals(advisorIndexQuery.getClass()));
        this.advisorIndexQueries.add(advisorIndexQuery);
    }

    public void addAdvisorIndexQueriesForContentIdentifiers(File baseMirrorDirectory, Collection<AdvisoryTypeIdentifier<?>> advisoryProviders) {
        advisoryProviders = this.computeEffectiveAdvisoryIdentifiers(advisoryProviders);
        for (AdvisoryTypeIdentifier<?> advisoryProvider : advisoryProviders) {
            Function<File, AdvisorIndexQuery<?>> factory = advisoryProvider.getAdvisorIndexQueryFactory();
            if (factory == null) {
                LOG.warn("No advisor index query factory found for [{}] during registration, skipping", (Object)advisoryProvider.toExtendedString());
                continue;
            }
            AdvisorIndexQuery<?> query = factory.apply(baseMirrorDirectory);
            this.addAdvisorIndexQuery(query);
        }
    }

    private AdvisorIndexQuery<? extends AdvisoryEntry> getAdvisorIndexQuery(AdvisoryTypeIdentifier<?> identifier) {
        if (identifier == null) {
            return null;
        }
        for (AdvisorIndexQuery<?> advisorIndexQuery : this.advisorIndexQueries) {
            if (!advisorIndexQuery.getClass().equals(identifier.getAdvisorIndexQueryClass())) continue;
            return advisorIndexQuery;
        }
        return null;
    }

    public void addVulnerabilityIndexQuery(VulnerabilityIndexQuery vulnerabilityIndexQuery) {
        this.vulnerabilityIndexQueries.removeIf(v -> v.getClass().equals(vulnerabilityIndexQuery.getClass()));
        this.vulnerabilityIndexQueries.add(vulnerabilityIndexQuery);
    }

    public void addVulnerabilityIndexQueriesForContentIdentifiers(File baseMirrorDirectory, Collection<VulnerabilityTypeIdentifier<?>> vulnerabilityProviders) {
        vulnerabilityProviders = this.computeEffectiveVulnerabilityIdentifiers(vulnerabilityProviders);
        for (VulnerabilityTypeIdentifier<?> vulnerabilityProvider : vulnerabilityProviders) {
            Function<File, VulnerabilityIndexQuery> factory = vulnerabilityProvider.getVulnerabilityIndexQueryFactory();
            if (factory == null) {
                LOG.warn("No vulnerability index query factory found for [{}] during registration, skipping", (Object)vulnerabilityProvider.toExtendedString());
                continue;
            }
            VulnerabilityIndexQuery query = factory.apply(baseMirrorDirectory);
            this.addVulnerabilityIndexQuery(query);
        }
    }

    private VulnerabilityIndexQuery getVulnerabilityIndexQuery(VulnerabilityTypeIdentifier<?> identifier) {
        if (identifier == null) {
            return null;
        }
        for (VulnerabilityIndexQuery vulnerabilityIndexQuery : this.vulnerabilityIndexQueries) {
            if (!vulnerabilityIndexQuery.getClass().equals(identifier.getVulnerabilityIndexQueryClass())) continue;
            return vulnerabilityIndexQuery;
        }
        return null;
    }

    public List<AdvisoryEntry> findSecurityAdvisoriesUpdatedOrModifiedSince(QueryTimePeriod queryPeriod, List<AdvisoryTypeIdentifier<?>> advisoryProviders, List<String> includeAdvisoryTypes) {
        advisoryProviders = this.computeEffectiveAdvisoryIdentifiers(advisoryProviders);
        ArrayList<AdvisoryEntry> foundSecurityAdvisories = new ArrayList<AdvisoryEntry>();
        for (AdvisoryTypeIdentifier<?> provider : advisoryProviders) {
            LOG.info("Querying the advisory index for [types={}] [provider={}] [queryPeriod={}]", new Object[]{includeAdvisoryTypes, provider, queryPeriod});
            AdvisorIndexQuery<? extends AdvisoryEntry> index = this.getAdvisorIndexQuery(provider);
            if (index == null) {
                LOG.warn("No advisory index query has been provided for [{}], skipping", (Object)provider.toExtendedString());
                continue;
            }
            List<AdvisoryEntry> advisoriesForProvider = this.findAdvisorsForProvider(index, queryPeriod, includeAdvisoryTypes);
            foundSecurityAdvisories.addAll(advisoriesForProvider);
        }
        LOG.info("Found a total of [{}] advisories", (Object)foundSecurityAdvisories.size());
        return foundSecurityAdvisories;
    }

    private <T extends AdvisoryEntry> List<AdvisoryEntry> findAdvisorsForProvider(AdvisorIndexQuery<? extends T> index, QueryTimePeriod queryPeriod, List<String> includeAdvisoryTypes) {
        List<T> advisors = this.getAdvisoryMetaDataLastModifiedSince(index, queryPeriod, includeAdvisoryTypes);
        if (advisors.isEmpty()) {
            LOG.info("No security advisories found for [{}] in the given time range", (Object)index.getClass().getSimpleName());
        } else {
            LOG.info("Found [{}] security advisories for [{}]", (Object)advisors.size(), (Object)index.getClass().getSimpleName());
        }
        return advisors;
    }

    public <T extends AdvisoryEntry> List<T> getAdvisoryMetaDataLastModifiedSince(AdvisorIndexQuery<? extends T> query, QueryTimePeriod queryPeriod, List<String> includeAdvisoryTypes) {
        List<T> entries = query.findCreatedOrUpdatedInRange(queryPeriod.getStart(), queryPeriod.getEnd());
        return entries.stream().sorted(AdvisoryEntry.UPDATE_CREATE_TIME_COMPARATOR).filter(e -> this.checkForAdvisoryTypeInclude((AdvisoryEntry)e, includeAdvisoryTypes)).collect(Collectors.toList());
    }

    private boolean checkForAdvisoryTypeInclude(AdvisoryEntry advisory, List<String> includeAdvisoryTypes) {
        if (includeAdvisoryTypes == null || includeAdvisoryTypes.isEmpty() || CentralSecurityPolicyConfiguration.containsAny(includeAdvisoryTypes)) {
            return true;
        }
        String type = advisory.getType();
        for (String a : includeAdvisoryTypes) {
            if (!Objects.equals(type, a)) continue;
            return true;
        }
        return false;
    }

    public void removeSecurityAdvisoryIfStatus(VulnerabilityContextInventory vInventory, String status) {
        for (AdvisoryEntry securityAdvisory : vInventory.getShallowCopySecurityAdvisories()) {
            if (!status.equals(securityAdvisory.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS))) continue;
            vInventory.remove(securityAdvisory);
        }
    }

    public void filterVulnerabilitiesByAdvisoryFilter(VulnerabilityContextInventory vInventory, List<AdvisoryTypeIdentifier<?>> advisoryProviders) {
        if (advisoryProviders != null && !advisoryProviders.isEmpty()) {
            Set<Vulnerability> vulnerabilities = vInventory.getShallowCopyVulnerabilities();
            int sizeBefore = vulnerabilities.size();
            for (Vulnerability vulnerability : vulnerabilities) {
                boolean containsAllowedAdvisoryProvider = false;
                for (AdvisoryEntry advisory : vulnerability.getSecurityAdvisories()) {
                    if (advisoryProviders.contains(advisory.getSourceIdentifier())) {
                        containsAllowedAdvisoryProvider = true;
                        break;
                    }
                    if (!advisory.getDataSources().stream().anyMatch(advisoryProviders::contains)) continue;
                    containsAllowedAdvisoryProvider = true;
                    break;
                }
                if (containsAllowedAdvisoryProvider) continue;
                vInventory.remove(vulnerability);
            }
            int diff = sizeBefore - vulnerabilities.size();
            if (diff > 0) {
                LOG.info("Removed [{}] vulnerabilities that do not contain advisories from {}", (Object)diff, advisoryProviders);
            }
        }
    }

    public List<Vulnerability> findVulnerabilitiesUpdatedOrModifiedSince(long lastModified, List<VulnerabilityTypeIdentifier<?>> vulnerabilityProviders) {
        vulnerabilityProviders = this.computeEffectiveVulnerabilityIdentifiers(vulnerabilityProviders);
        ArrayList<Vulnerability> foundVulnerabilities = new ArrayList<Vulnerability>();
        for (VulnerabilityTypeIdentifier<?> provider : vulnerabilityProviders) {
            LOG.info("Querying the advisory index for [provider={}] [changed-since={}]", provider, (Object)lastModified);
            VulnerabilityIndexQuery index = this.getVulnerabilityIndexQuery(provider);
            if (index == null) {
                LOG.warn("No vulnerability index query has been provided for [{}], skipping", (Object)provider.toExtendedString());
                continue;
            }
            List<Vulnerability> vulnerabilitiesForProvider = this.findVulnerabilitiesForProvider(index, lastModified);
            foundVulnerabilities.addAll(vulnerabilitiesForProvider);
        }
        LOG.info("Found a total of [{}] advisories", (Object)foundVulnerabilities.size());
        return foundVulnerabilities;
    }

    private List<Vulnerability> findVulnerabilitiesForProvider(VulnerabilityIndexQuery index, long lastModified) {
        List<Vulnerability> vulnerabilities = this.getVulnerabilityLastModifiedSince(index, lastModified);
        if (vulnerabilities.isEmpty()) {
            LOG.info("No vulnerabilities found for [{}] in the given time range", (Object)index.getClass().getSimpleName());
        } else {
            LOG.info("Found [{}] vulnerabilities for [{}]", (Object)vulnerabilities.size(), (Object)index.getClass().getSimpleName());
        }
        return vulnerabilities;
    }

    public List<Vulnerability> getVulnerabilityLastModifiedSince(VulnerabilityIndexQuery query, long lastModified) {
        List<Vulnerability> entries = query.findCreatedOrUpdatedInRange(lastModified, System.currentTimeMillis() + 86400000L);
        return entries.stream().sorted(Vulnerability.UPDATE_CREATE_TIME_COMPARATOR).collect(Collectors.toList());
    }

    private List<AdvisoryTypeIdentifier<?>> computeEffectiveAdvisoryIdentifiers(Collection<AdvisoryTypeIdentifier<?>> sourceIdentifiers) {
        if (sourceIdentifiers == null) {
            return new ArrayList();
        }
        if (sourceIdentifiers.contains(AdvisoryTypeStore.ANY_ADVISORY_FILTER_WILDCARD)) {
            ArrayList identifiers = new ArrayList(AdvisoryTypeStore.get().values());
            identifiers.remove(AdvisoryTypeStore.ANY_ADVISORY_FILTER_WILDCARD);
            return identifiers;
        }
        return new ArrayList(sourceIdentifiers);
    }

    private List<VulnerabilityTypeIdentifier<?>> computeEffectiveVulnerabilityIdentifiers(Collection<VulnerabilityTypeIdentifier<?>> sourceIdentifiers) {
        if (sourceIdentifiers == null) {
            return new ArrayList();
        }
        if (sourceIdentifiers.contains(VulnerabilityTypeStore.ANY_VULNERABILITY_FILTER_WILDCARD)) {
            ArrayList identifiers = new ArrayList(VulnerabilityTypeStore.get().values());
            identifiers.remove(VulnerabilityTypeStore.ANY_VULNERABILITY_FILTER_WILDCARD);
            return identifiers;
        }
        return new ArrayList(sourceIdentifiers);
    }

    public void setSecurityAdvisoryReviewedStatusFromReferenceInventories(Collection<AdvisoryEntry> checkSecurityAdvisories, Collection<VulnerabilityContextInventory> vReferenceInventories) throws RuntimeException {
        checkSecurityAdvisories.forEach(checkSecurityAdvisory -> checkSecurityAdvisory.setAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS, "unaffected"));
        if (vReferenceInventories == null || vReferenceInventories.isEmpty()) {
            LOG.info("No reference inventories provided, skipping reference inventory processing");
            return;
        }
        LOG.info("Using [{}] reference inventories to calculate the review status", (Object)vReferenceInventories.size());
        for (VulnerabilityContextInventory vReferenceInventory : vReferenceInventories) {
            LOG.info("Processing [{}] vulnerabilities from reference inventory", (Object)vReferenceInventory.getVulnerabilities().size());
            for (Vulnerability referenceVulnerability : vReferenceInventory.getVulnerabilities()) {
                ArrayList<AdvisoryEntry> allAdvisories = new ArrayList<AdvisoryEntry>(referenceVulnerability.getSecurityAdvisories());
                List reviewedAdvisories = referenceVulnerability.getOrCreateNewVulnerabilityStatus().getReviewedAdvisories().stream().map(VulnerabilityStatusReviewedEntry::getId).map(id -> {
                    Optional<AdvisoryEntry> foundAdvisoryEntry = vReferenceInventory.findAdvisoryEntryByName((String)id);
                    if (foundAdvisoryEntry.isPresent()) {
                        return foundAdvisoryEntry.get();
                    }
                    Optional<ContentIdentifierStore.SingleContentIdentifierParseResult<AdvisoryTypeIdentifier<?>>> source = AdvisoryTypeStore.get().fromEntryIdentifier((String)id);
                    if (!source.isPresent()) {
                        throw new RuntimeException("Parsing reviewed advisory entry identifier [" + id + "] from assessment. Check your assessment files for the 'reviewed' > 'id' attributes.");
                    }
                    return (AdvisoryEntry)((AdvisoryEntry)source.get().getIdentifier().getAdvisoryFactory().get()).setId((String)id);
                }).collect(Collectors.toList());
                allAdvisories.removeIf(reviewedAdvisories::contains);
                if (allAdvisories.size() + reviewedAdvisories.size() == 0) continue;
                Set allAdvisoryIds = allAdvisories.stream().map(AmbDataClass::getId).collect(Collectors.toSet());
                Set reviewedAdvisoryIds = reviewedAdvisories.stream().map(AmbDataClass::getId).collect(Collectors.toSet());
                for (AdvisoryEntry checkSecurityAdvisory2 : checkSecurityAdvisories) {
                    if (checkSecurityAdvisory2.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS) == null) {
                        checkSecurityAdvisory2.setAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS, "unaffected");
                    }
                    String currentStatus = checkSecurityAdvisory2.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS);
                    if (reviewedAdvisoryIds.contains(checkSecurityAdvisory2.getId())) {
                        switch (currentStatus) {
                            case "unaffected": {
                                checkSecurityAdvisory2.setAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS, "reviewed");
                                break;
                            }
                            case "new": {
                                checkSecurityAdvisory2.setAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS, "in review");
                            }
                        }
                    } else if (allAdvisoryIds.contains(checkSecurityAdvisory2.getId())) {
                        switch (currentStatus) {
                            case "unaffected": {
                                checkSecurityAdvisory2.setAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS, "new");
                                break;
                            }
                            case "reviewed": {
                                checkSecurityAdvisory2.setAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS, "in review");
                            }
                        }
                    }
                    if (currentStatus.equals(checkSecurityAdvisory2.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS))) continue;
                    LOG.info("  [{}] - [{}] status change [{} --> {}]", new Object[]{referenceVulnerability.getId(), checkSecurityAdvisory2.getId(), currentStatus, checkSecurityAdvisory2.getAdditionalAttribute(AdvisoryMetaData.Attribute.REVIEW_STATUS)});
                }
            }
        }
        LOG.info("Done setting status via reference inventory files");
    }

    public static class QueryTimePeriod {
        private final long start;
        private final long end;

        public String toString() {
            Date startDate = TimeUtils.tryParse(String.valueOf(this.start));
            Date endDate = TimeUtils.tryParse(String.valueOf(this.end));
            long now = System.currentTimeMillis();
            return "[" + TimeUtils.formatNormalizedDate(startDate) + " (" + TimeUtils.formatTimeUntilOrAgoDefault(this.start - now) + ") - " + TimeUtils.formatNormalizedDate(endDate) + " (" + TimeUtils.formatTimeUntilOrAgoDefault(this.end - now) + ")]";
        }

        public QueryTimePeriod(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryTimePeriod)) {
                return false;
            }
            QueryTimePeriod other = (QueryTimePeriod)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getEnd() == other.getEnd();
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueryTimePeriod;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $start = this.getStart();
            result = result * 59 + (int)($start >>> 32 ^ $start);
            long $end = this.getEnd();
            result = result * 59 + (int)($end >>> 32 ^ $end);
            return result;
        }
    }
}

