/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.dashboard;

import com.metaeffekt.artifact.analysis.dashboard.NavigationRow;
import com.metaeffekt.artifact.analysis.dashboard.SheetParagraph;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.SpanTag;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Sheet {
    private String id;
    private SpanTag title = TagCreator.span();
    private final NavigationRow navigationRow = new NavigationRow();
    private final List<SheetParagraph> paragraphs = new ArrayList<SheetParagraph>();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setTitle(String title) {
        this.title = TagCreator.span((String)title);
    }

    public void setTitle(Tag<?> title) {
        this.title = TagCreator.span((DomContent[])new DomContent[]{title});
    }

    public void addTitle(String title) {
        this.title.with((DomContent)TagCreator.text((String)title));
    }

    public void addTitle(Tag<?> title) {
        this.title.with(title);
    }

    public SpanTag getEditableTitle() {
        return this.title;
    }

    public NavigationRow getNavigationRow() {
        return this.navigationRow;
    }

    public void addNavigationEntry(String key, DomContent value) {
        this.navigationRow.addEntry(key, value);
    }

    public void addNavigationEntry(String key, Object value) {
        this.navigationRow.addEntry(key, (DomContent)TagCreator.text((String)String.valueOf(value)));
    }

    public void addNavigationEntry(String key, DomContent value, Object additionalInfo) {
        this.navigationRow.addEntry(key, value, additionalInfo);
    }

    public void addNavigationEntry(String key, Object value, Object additionalInfo) {
        this.navigationRow.addEntry(key, (DomContent)TagCreator.text((String)String.valueOf(value)), additionalInfo);
    }

    public void addParagraph(SheetParagraph paragraph) {
        if (paragraph == null) {
            return;
        }
        this.paragraphs.add(paragraph);
    }

    public List<SheetParagraph> getParagraphs() {
        return this.paragraphs;
    }

    public DivTag getContent() {
        DivTag content = (DivTag)TagCreator.div().withClasses(new String[]{"content-sheet", "card-design", "scrollbox"});
        content.with(new DomContent[]{TagCreator.h1((DomContent[])new DomContent[]{this.title}).withStyle("margin:-8px 0px 0px 0px;"), TagCreator.br()});
        for (SheetParagraph paragraph : this.paragraphs) {
            if (paragraph != this.paragraphs.get(0)) {
                content.with((DomContent)TagCreator.hr().withClass(paragraph.getParagraphClassIdentifier()));
            }
            content.with((DomContent)paragraph.getContent());
        }
        content.with((DomContent)TagCreator.span((String)IntStream.range(0, 450).mapToObj(m -> "-").collect(Collectors.joining()).replaceAll("(.{108})", "$1 ")).withStyle("color:rgba(0,0,0,0);line-height:0px;display:block;"));
        return content;
    }
}

