/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.metascan;

import com.metaeffekt.artifact.analysis.metascan.AbstractScanSupport;
import com.metaeffekt.artifact.analysis.metascan.MergedScanResult;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeParser;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.SegmentationUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.MergedSegmentResult;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import com.metaeffekt.artifact.terms.model.Variables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class CopyrightSegmentationSupport
extends AbstractScanSupport {
    public CopyrightSegmentationSupport(NormalizationMetaData normalizationMetaData, PropertyProvider propertyProvider) {
        super(normalizationMetaData, propertyProvider);
    }

    public boolean runSegmentation(Artifact artifact, File sourceDir) throws IOException, JSONException {
        boolean overwrite;
        File analysisDir = sourceDir.getParentFile();
        String sourceFolderName = sourceDir.getName();
        File targetFolder = new File(analysisDir, sourceFolderName + "-analysis");
        File intermediateFolder = new File(analysisDir, sourceFolderName + "-intermediate");
        String filename = artifact.getId().replace("/", "_");
        File metascanResultFile = new File(targetFolder, filename + "_metascan.json");
        File scancodeResultFile = new File(targetFolder, filename + "_scancode.json");
        File resultLogFile = new File(targetFolder, filename + "_copyright-segmentation.txt");
        boolean enabled = this.getPropertyProvider().isProperty("analyze.scan.copyright.segmentation.enabled", "true", "false");
        if (!enabled) {
            return false;
        }
        long metascanResultJsonTimestamp = metascanResultFile.lastModified();
        long scancodeResultJsonTimestamp = scancodeResultFile.lastModified();
        long resultFileTimestamp = resultLogFile.lastModified();
        boolean outdatedResult = metascanResultJsonTimestamp > resultFileTimestamp || scancodeResultJsonTimestamp > resultFileTimestamp;
        boolean bl = overwrite = outdatedResult || this.getPropertyProvider().isProperty("analyze.scan.copyright.segmentation.overwrite", "true", "false");
        if (!overwrite && resultLogFile.exists()) {
            return false;
        }
        this.init(resultLogFile, "Copyright Segmentation");
        this.log(resultLogFile, "");
        FileUtils.validateExists((File)analysisDir);
        FileUtils.validateExists((File)metascanResultFile);
        FileUtils.validateExists((File)scancodeResultFile);
        String scancodeInput = new JSONObject(FileUtils.readFileToString((File)scancodeResultFile, (Charset)StandardCharsets.UTF_8)).optJSONArray("headers").optJSONObject(0).optJSONObject("options").optJSONArray("input").optString(0);
        ScanCodeParser scanCodeParser = new ScanCodeParser();
        HashMap<String, List<String>> licenseFileMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> copyrightFileMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> authorFileMap = new HashMap<String, List<String>>();
        Map<String, List<String>> metaLicenseFileMap = new SegmentationUtils().getLicenseFileMap(metascanResultFile, false);
        scanCodeParser.parseScanCodeResult(FileUtils.readFileToString((File)scancodeResultFile, (String)"UTF-8"), licenseFileMap, copyrightFileMap, authorFileMap);
        Map<String, List<String>> fileCopyrightMap = this.invertMap(copyrightFileMap);
        for (String license : metaLicenseFileMap.keySet()) {
            List<String> files = metaLicenseFileMap.get(license);
            boolean loggedLicense = false;
            HashSet<String> allCoveredCopyrights = new HashSet<String>();
            for (String file : files) {
                String scancodePath = sourceDir.getName() + "-intermediate" + file + ".txt";
                List<String> copyrights = fileCopyrightMap.get(scancodePath);
                if (copyrights == null) continue;
                allCoveredCopyrights.addAll(copyrights);
            }
            HashMap<String, List> copyrightCondensedCopyrightMap = new HashMap<String, List>();
            Iterator<Object> iterator = allCoveredCopyrights.iterator();
            while (iterator.hasNext()) {
                String copyright;
                String condensed = copyright = (String)iterator.next();
                condensed = condensed.replaceAll("[0-9]*", "");
                condensed = condensed.replaceAll("-", "");
                condensed = condensed.replaceAll(",", "");
                condensed = condensed.replace("Copyrighted ", "");
                condensed = condensed.replace("copyrighted ", "");
                condensed = condensed.replace("Copyright ", "");
                condensed = condensed.replace("copyright ", "");
                condensed = condensed.replace("(c)", "");
                condensed = condensed.replace("(C)", "");
                condensed = condensed.replace("\u00a9", "");
                condensed = condensed.trim();
                copyrightCondensedCopyrightMap.computeIfAbsent(condensed, k -> new ArrayList()).add(copyright);
            }
            for (String copyright : copyrightCondensedCopyrightMap.keySet()) {
                if (!loggedLicense) {
                    this.log(resultLogFile, ">>> " + license + " <<<");
                    loggedLicense = true;
                }
                this.log(resultLogFile, "  >> " + copyright + " <<");
                List condensedList = (List)copyrightCondensedCopyrightMap.get(copyright);
                for (String cr : condensedList) {
                    this.log(resultLogFile, "    > " + cr);
                    List filesCovered = (List)copyrightFileMap.get(cr);
                    for (String file : filesCovered) {
                        String path = FileUtils.asRelativePath((File)intermediateFolder, (File)new File(analysisDir, file));
                        this.log(resultLogFile, "        " + scancodeInput + "/" + path);
                    }
                    this.log(resultLogFile, "");
                }
            }
        }
        this.matchScancodeResultToMetascanResult(artifact, sourceDir, scancodeInput);
        return true;
    }

    private void matchScancodeResultToMetascanResult(Artifact artifact, File sourceDir, String scanCodeInput) throws IOException {
        File targetFolder = new File(sourceDir.getParentFile(), sourceDir.getName() + "-analysis");
        String filename = artifact.getId().replace("/", "_");
        File copyrightLicenseAssignmentFile = new File(targetFolder, filename + "_copyright-license-assignment.txt");
        File variableExtractionFile = new File(targetFolder, filename + "_license-variable-extractions.txt");
        File scancodeMissmatchFolder = new File(targetFolder, filename + "-scancode-missmatch-issues");
        if (scancodeMissmatchFolder.exists()) {
            FileUtils.deleteDir(scancodeMissmatchFolder);
        }
        MergedScanResult mergedResult = new MergedScanResult();
        mergedResult.mergeResults(artifact, sourceDir);
        this.copyrightLicenseAssignmentFile(mergedResult, copyrightLicenseAssignmentFile, scanCodeInput);
        this.variableExtractionFile(mergedResult, variableExtractionFile, scanCodeInput);
        this.metaScanScanCodeMissmatch(mergedResult, scancodeMissmatchFolder);
    }

    private void copyrightLicenseAssignmentFile(MergedScanResult mergedResult, File copyrightLicenseAssignmentFile, String scancodeInput) throws IOException {
        this.init(copyrightLicenseAssignmentFile, "Copyright/License Segmentation");
        this.log(copyrightLicenseAssignmentFile, "");
        HashMap groupedResult = new HashMap();
        List<MergedSegmentResult> mergedScanResult = mergedResult.getMergedScanResult();
        if (mergedScanResult != null) {
            for (MergedSegmentResult mergedSegmentResult : mergedScanResult) {
                String licenseResult = InventoryUtils.joinLicenses(mergedSegmentResult.getResolvedLicenses());
                String scancodeLicensesResult = InventoryUtils.joinLicenses(mergedSegmentResult.getScancodeLicenses());
                String copyrightsResults = InventoryUtils.joinLicenses(mergedSegmentResult.getCopyrights());
                if (licenseResult == null && scancodeLicensesResult == null && copyrightsResults == null) continue;
                JSONObject json = new JSONObject();
                json.put("licenseResult", (Object)StringUtils.notNull(licenseResult));
                json.put("scancodeLicenseResult", (Object)StringUtils.notNull(scancodeLicensesResult));
                json.put("copyrightResult", (Object)StringUtils.notNull(copyrightsResults));
                String key = json.toString();
                if (groupedResult.get(key) != null) {
                    ((List)groupedResult.get(key)).add(scancodeInput + "/" + mergedSegmentResult.getPath());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(scancodeInput + "/" + mergedSegmentResult.getPath());
                groupedResult.put(key, list);
            }
            for (String result : groupedResult.keySet()) {
                JSONObject json = new JSONObject(result);
                this.log(copyrightLicenseAssignmentFile, "-----");
                this.log(copyrightLicenseAssignmentFile, "");
                this.log(copyrightLicenseAssignmentFile, "    resolvedLicenses:   " + json.getString("licenseResult"));
                this.log(copyrightLicenseAssignmentFile, "    scancodeLicenses:   " + json.getString("scancodeLicenseResult"));
                this.log(copyrightLicenseAssignmentFile, "    scancodeCopyrights: " + json.getString("copyrightResult"));
                this.log(copyrightLicenseAssignmentFile, "");
                this.log(copyrightLicenseAssignmentFile, "These results were found in the following files:");
                for (String file : (List)groupedResult.get(result)) {
                    this.log(copyrightLicenseAssignmentFile, "  >" + file + "<");
                }
                this.log(copyrightLicenseAssignmentFile, "");
            }
        }
    }

    private void variableExtractionFile(MergedScanResult mergedResult, File variableExtractionFile, String scancodeInput) throws IOException {
        HashMap variableFiles = new HashMap();
        HashMap variableCopyrights = new HashMap();
        List<MergedSegmentResult> mergedScanResult = mergedResult.getMergedScanResult();
        if (mergedScanResult != null) {
            for (MergedSegmentResult mergedSegmentResult : mergedResult.getMergedScanResult()) {
                List<Variables> variables = mergedSegmentResult.getVariables();
                if (variables == null) continue;
                for (Variables variable : variables) {
                    String filepath = mergedSegmentResult.getPath();
                    if (filepath == null) continue;
                    List<String> copyrights = mergedSegmentResult.getCopyrights();
                    if (variable.listContains(new ArrayList<Variables>(variableFiles.keySet()))) {
                        Variables key = variable.getFromList(new ArrayList<Variables>(variableFiles.keySet()));
                        ((List)variableFiles.get(key)).add(scancodeInput + "/" + filepath);
                        ((List)variableCopyrights.get(key)).addAll(copyrights);
                        continue;
                    }
                    ArrayList<String> fileList = new ArrayList<String>();
                    ArrayList<String> copyrightList = new ArrayList<String>();
                    fileList.add(scancodeInput + "/" + filepath);
                    copyrightList.addAll(copyrights);
                    variableFiles.put(variable, fileList);
                    variableCopyrights.put(variable, copyrightList);
                }
            }
        }
        HashMap licenseVariableList = new HashMap();
        for (Variables variable : variableFiles.keySet()) {
            String license = variable.getLicense();
            if (!licenseVariableList.containsKey(license)) {
                ArrayList<Variables> variablesList = new ArrayList<Variables>();
                variablesList.add(variable);
                licenseVariableList.put(license, variablesList);
                continue;
            }
            ((List)licenseVariableList.get(license)).add(variable);
        }
        this.init(variableExtractionFile, "Variable Extraction File");
        for (String license : licenseVariableList.keySet()) {
            this.log(variableExtractionFile, "-------------------");
            this.log(variableExtractionFile, license + "\n");
            if (((List)licenseVariableList.get(license)).size() > 1) {
                this.log(variableExtractionFile, "The " + license + " has " + ((List)licenseVariableList.get(license)).size() + " different variable sets.\n");
            }
            for (Variables variable : (List)licenseVariableList.get(license)) {
                this.log(variableExtractionFile, "------");
                this.log(variableExtractionFile, "variables:");
                for (String s : variable.getValues().keySet()) {
                    this.log(variableExtractionFile, "  " + s + ": " + variable.getValues().get(s));
                }
                this.log(variableExtractionFile, "\nCopyrights associated with this license and variables:");
                for (String s : (List)variableCopyrights.get(variable)) {
                    this.log(variableExtractionFile, "  - " + s);
                }
                this.log(variableExtractionFile, "\nThose variables were found in the following File/Segments:");
                for (String s : (List)variableFiles.get(variable)) {
                    this.log(variableExtractionFile, "  - " + s);
                }
                this.log(variableExtractionFile, "\n");
            }
        }
    }

    private void metaScanScanCodeMissmatch(MergedScanResult mergedResult, File scancodeMissmatchFolder) throws IOException {
        for (MergedSegmentResult mergedSegmentResult : mergedResult.getMergedScanResult()) {
            List<String> resolvedLicenses = mergedSegmentResult.getResolvedLicenses();
            Map<String, Float> scancodeLicenseKeysValue = mergedSegmentResult.getScancodeLicenseKeys();
            ArrayList<String> scancodeLicenseKeys = new ArrayList<String>(scancodeLicenseKeysValue.keySet());
            if (scancodeLicenseKeys.isEmpty()) continue;
            String filename = mergedSegmentResult.getPath().substring(mergedSegmentResult.getPath().indexOf("/"));
            if (resolvedLicenses.size() == 0) {
                File output = new File(scancodeMissmatchFolder, filename);
                this.init(output, "MetaScan result empty, while ScanCode matches:");
                for (String string : scancodeLicenseKeys) {
                    this.log(output, string);
                }
                continue;
            }
            NormalizationMetaData normalizationMetaData = this.getNormalizationMetaData();
            this.filterScancodeLicenseKeys(scancodeLicenseKeys);
            ArrayList<String> existingKeys = new ArrayList<String>();
            for (String scancodeLicenseKey : scancodeLicenseKeys) {
                String key = "scancode:" + scancodeLicenseKey;
                for (String resolvedLicense : resolvedLicenses) {
                    List<String> otherIdsRepresentedAs;
                    List<String> otherIds;
                    TermsMetaData termsMetaData = normalizationMetaData.getTermsMetaData(resolvedLicense);
                    List<String> list = otherIds = termsMetaData != null ? termsMetaData.getOtherIds() : null;
                    if (otherIds != null) {
                        if (!otherIds.contains(key)) continue;
                        existingKeys.add(scancodeLicenseKey);
                        continue;
                    }
                    if (termsMetaData == null || termsMetaData.getRepresentedAs() == null || (otherIdsRepresentedAs = normalizationMetaData.getTermsMetaData(termsMetaData.getRepresentedAs()).getOtherIds()) == null || !otherIdsRepresentedAs.contains(key)) continue;
                    existingKeys.add(scancodeLicenseKey);
                }
            }
            scancodeLicenseKeys.removeAll(existingKeys);
            existingKeys.clear();
            for (String scancodeLicenseKey : scancodeLicenseKeys) {
                if (!(scancodeLicenseKeysValue.get(scancodeLicenseKey).floatValue() < 90.0f)) continue;
                existingKeys.add(scancodeLicenseKey);
            }
            scancodeLicenseKeys.removeAll(existingKeys);
            if (scancodeLicenseKeys.size() <= 0) continue;
            File file = new File(scancodeMissmatchFolder, filename);
            this.init(file, "Additional ScanCode matches detected:");
            this.log(file, "MetaScan matches:" + org.apache.commons.lang3.StringUtils.join(resolvedLicenses, (String)", "));
            this.log(file, "Additional matches by ScanCode:");
            for (String s3 : scancodeLicenseKeys) {
                this.log(file, s3);
            }
        }
    }

    private List<String> filterScancodeLicenseKeys(List<String> scancodeLicenseKeys) {
        String[] excludes;
        for (String exclude : excludes = new String[]{"other-permissive", "proprietary-license", "public-domain", "unknown-license-reference", "unknown"}) {
            scancodeLicenseKeys.remove(exclude);
        }
        return scancodeLicenseKeys;
    }

    protected Map<String, List<String>> invertMap(Map<String, List<String>> keyListMap) {
        HashMap<String, List<String>> invertedMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : keyListMap.entrySet()) {
            for (String path : entry.getValue()) {
                ArrayList<String> values = (ArrayList<String>)invertedMap.get(path);
                if (values == null) {
                    values = new ArrayList<String>();
                    invertedMap.put(path, values);
                }
                if (values.contains(entry.getKey())) continue;
                values.add(entry.getKey());
            }
        }
        return invertedMap;
    }
}

