/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.metascan;

import com.metaeffekt.artifact.analysis.utils.StringStats;
import com.metaeffekt.artifact.terms.model.ScanResultPart;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.util.ArrayList;
import java.util.List;

public final class ReportController {
    private static final ReportController REPORT_CONTROLLER = new ReportController();
    private List<String> strings = new ArrayList<String>();

    private ReportController() {
    }

    public boolean createReportFor(ScanResultPart normalizedLicensesSRP, StringStats licenseTextStats) {
        boolean toBeExcluded = false;
        for (String s : this.strings) {
            if (!licenseTextStats.getOriginalString().contains(s)) continue;
            toBeExcluded = true;
            break;
        }
        return !toBeExcluded || this.countUnspecificLicense(normalizedLicensesSRP.getMatches()) != 1;
    }

    public static ReportController getInstance() {
        return REPORT_CONTROLLER;
    }

    public void addString(String s) {
        this.strings.add(s);
    }

    public List<String> getStrings() {
        return this.strings;
    }

    private int countUnspecificLicense(List<TermsMetaData> termsMetaData) {
        return (int)termsMetaData.stream().filter(TermsMetaData::isUnspecific).count();
    }
}

