/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.metascan;

import com.metaeffekt.artifact.analysis.metascan.AbstractScanSupport;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.analysis.utils.PropertyUtils;
import com.metaeffekt.artifact.analysis.utils.SegmentationUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.NormalizationMetaData;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class SourceSegmentationSupport
extends AbstractScanSupport {
    public SourceSegmentationSupport(NormalizationMetaData normalizationMetaData, PropertyProvider propertyProvider) {
        super(normalizationMetaData, propertyProvider);
    }

    public boolean runSegmentation(Artifact artifact, File sourceDir) throws IOException {
        boolean overwrite;
        File analysisDir = sourceDir.getParentFile();
        String sourceFolderName = sourceDir.getName();
        File targetFolder = new File(analysisDir, sourceFolderName + "-analysis");
        String filename = artifact.getId().replace("/", "_");
        File metascanResultJson = new File(targetFolder, filename + "_metascan.json");
        File scancodeResultJson = new File(targetFolder, filename + "_scancode.json");
        boolean applySourceSegmentation = this.getPropertyProvider().isProperty("analyze.scan.segmentation.enabled", "true", "false");
        if (!applySourceSegmentation) {
            return false;
        }
        File resultFile = new File(targetFolder, filename + "_license-segmentation.properties");
        File resultLogFile = new File(targetFolder, filename + "_license-segmentation.txt");
        File resultJsonFile = new File(targetFolder, filename + "_license-segmentation.json");
        String[] filterPatterns = this.getPropertyProvider().getPropertyArray("analyze.scan.segmentation.filter.includes", "-none-", ",");
        String[] ignorePatterns = this.getPropertyProvider().getPropertyArray("analyze.scan.segmentation.ignore.includes", "-none-", ",");
        this.validatePatterns(filterPatterns, "analyze.scan.segmentation.filter.includes");
        this.validatePatterns(ignorePatterns, "analyze.scan.segmentation.ignore.includes");
        long metascanResultJsonTimestamp = metascanResultJson.lastModified();
        long scancodeResultJsonTimestamp = scancodeResultJson.lastModified();
        long resultFileTimestamp = resultFile.lastModified();
        boolean outdatedResult = metascanResultJsonTimestamp > resultFileTimestamp || scancodeResultJsonTimestamp > resultFileTimestamp;
        boolean bl = overwrite = outdatedResult || this.getPropertyProvider().isProperty("analyze.scan.segmentation.overwrite", "true", "false");
        if (!overwrite && resultFile.exists()) {
            Properties p = PropertyUtils.loadProperties(resultFile);
            this.applyToArtifact(artifact, p);
            return false;
        }
        if (!metascanResultJson.exists()) {
            return false;
        }
        FileUtils.validateExists((File)analysisDir);
        FileUtils.validateExists((File)metascanResultJson);
        this.init(resultLogFile, "License Segmentation");
        ParseResult parseResult = this.parseMetascanResult(metascanResultJson, scancodeResultJson);
        this.inheritIncompleteMatchMarkerFromMetaScan(analysisDir, sourceFolderName, parseResult);
        Map<String, List<String>> licenseGroups = parseResult.licenseFileGroups;
        Set<String> scancodeLicenseExpressions = parseResult.scancodeExpressionList;
        JSONObject resultJson = new JSONObject();
        this.logGroups(licenseGroups, "License Overview", false, resultLogFile);
        resultJson.put("license.overview", (Object)new JSONObject(licenseGroups));
        this.logGroups(parseResult.markerFileGroups, "Marker Overview", false, resultLogFile);
        resultJson.put("marker.overview", (Object)new JSONObject(parseResult.markerFileGroups));
        ArrayList<String> allLicensesIncludingIgnored = new ArrayList<String>(licenseGroups.keySet());
        this.applyFileFilters(licenseGroups, ignorePatterns);
        ArrayList<String> licenses = new ArrayList<String>(licenseGroups.keySet());
        this.applyFileFilters(licenseGroups, filterPatterns);
        ArrayList<String> filteredLicenses = new ArrayList<String>(licenseGroups.keySet());
        ArrayList<String> removedLicenses = new ArrayList<String>(licenses);
        removedLicenses.removeAll(filteredLicenses);
        ArrayList<String> ignoredLicenses = new ArrayList<String>(allLicensesIncludingIgnored);
        ignoredLicenses.removeAll(licenses);
        InventoryUtils.normalize(licenses);
        InventoryUtils.normalize(removedLicenses);
        Collections.sort(filteredLicenses);
        Collections.sort(removedLicenses);
        this.logLicenses(resultLogFile, "> Licenses <", licenses);
        this.logLicenses(resultLogFile, "> Filtered Licenses <", filteredLicenses);
        this.logLicenses(resultLogFile, "> Removed Licenses <", removedLicenses);
        this.logLicenses(resultLogFile, "> Ignored Licenses <", ignoredLicenses);
        resultJson.put("licenses", (Object)new JSONArray(licenses));
        resultJson.put("licenses.filtered", (Object)new JSONArray(filteredLicenses));
        resultJson.put("licenses.removed", (Object)new JSONArray(removedLicenses));
        resultJson.put("licenses.ignored", (Object)new JSONArray(ignoredLicenses));
        Properties properties = new Properties();
        licenses.sort(String::compareToIgnoreCase);
        filteredLicenses.sort(String::compareToIgnoreCase);
        removedLicenses.sort(String::compareToIgnoreCase);
        properties.setProperty("licenses", InventoryUtils.joinLicenses(licenses));
        properties.setProperty("licenses.filtered", InventoryUtils.joinLicenses(filteredLicenses));
        properties.setProperty("licenses.removed", InventoryUtils.joinLicenses(removedLicenses));
        properties.setProperty("licenses.ignored", InventoryUtils.joinLicenses(ignoredLicenses));
        properties.setProperty("scancode.license.expressions", InventoryUtils.joinLicenses(scancodeLicenseExpressions));
        if ("x".equals(artifact.get("Incomplete Match"))) {
            parseResult.markerList.add("Incomplete Match");
        }
        properties.setProperty("markers", InventoryUtils.joinLicenses(parseResult.markerList));
        properties.setProperty("scan.dir", new File(analysisDir, sourceFolderName).getAbsolutePath());
        this.applyToArtifact(artifact, properties);
        FileUtils.write((File)resultJsonFile, (CharSequence)resultJson.toString(), (Charset)StandardCharsets.UTF_8);
        PropertyUtils.saveProperties(resultFile, properties);
        return true;
    }

    private void validatePatterns(String[] patterns, String property) {
        for (String pattern : patterns) {
            if (StringUtils.isEmpty(pattern)) {
                throw new IllegalStateException("Pattern [" + property + "] may not include empty strings.");
            }
            if (!pattern.contains("//")) continue;
            throw new IllegalStateException("Pattern [" + property + "] may not include '//'.");
        }
    }

    protected void inheritIncompleteMatchMarkerFromMetaScan(File analysisDir, String sourceFolderName, ParseResult parseResult) {
        File metaScanPropertiesFile = new File(analysisDir, sourceFolderName + "_license.properties");
        Properties p = PropertyUtils.loadProperties(metaScanPropertiesFile);
        if (p.getProperty("derived.licenses", "").contains("Incomplete Match")) {
            parseResult.markerList.add("Incomplete Match");
        }
    }

    protected void logLicenses(File resultLogFile, String context, List<String> licenses) throws IOException {
        this.log(resultLogFile, String.format("%n%s", context));
        for (String license : licenses) {
            this.log(resultLogFile, String.format("  %s", license));
        }
    }

    private void applyToArtifact(Artifact artifact, Properties p) {
        artifact.set("Identified Terms", p.getProperty("licenses"));
        artifact.set("Filtered Terms", p.getProperty("licenses.removed"));
        artifact.set("Ignored Terms", p.getProperty("licenses.ignored"));
        artifact.set("Derived Markers", p.getProperty("markers"));
        artifact.set("License Expressions (ScanCode)", p.getProperty("scancode.license.expressions"));
        artifact.set("Derived Licenses", p.getProperty("licenses.filtered"));
        artifact.set("Analysis Path", p.getProperty("scan.dir"));
    }

    protected ParseResult parseMetascanResult(File metascanResultJson, File scancodeResultJson) throws IOException {
        HashSet<String> scancodeLicenseExpressions = new HashSet<String>();
        SegmentationUtils segmentationUtils = new SegmentationUtils();
        Map<String, List<String>> licenseGroups = segmentationUtils.getLicenseFileMap(metascanResultJson, true);
        if (scancodeResultJson.exists()) {
            JSONObject jsonObject = new JSONObject(FileUtils.readFileToString((File)scancodeResultJson, (Charset)StandardCharsets.UTF_8));
            JSONArray scancodeSegments = jsonObject.optJSONArray("files");
            for (int i = 0; i < scancodeSegments.length(); ++i) {
                JSONObject segment = scancodeSegments.optJSONObject(i);
                JSONArray licenseExpressions = segment.optJSONArray("license_expressions");
                if (licenseExpressions != null) {
                    for (int j = 0; j < licenseExpressions.length(); ++j) {
                        scancodeLicenseExpressions.add(licenseExpressions.optString(j));
                    }
                    continue;
                }
                JSONArray licenseDetections = segment.optJSONArray("license_detections");
                if (licenseDetections != null) continue;
                licenseDetections = segment.getJSONArray("license_expressions");
            }
        }
        ArrayList<String> licenseList = new ArrayList<String>(licenseGroups.keySet());
        HashMap<String, List<String>> markerList = new HashMap<String, List<String>>(licenseGroups);
        InventoryUtils.removeMarkers(licenseList, this.getNormalizationMetaData());
        licenseList.forEach(markerList.keySet()::remove);
        markerList.keySet().forEach(licenseGroups::remove);
        return new ParseResult(licenseGroups, markerList, scancodeLicenseExpressions, new HashSet<String>(markerList.keySet()));
    }

    private void logGroups(Map<String, List<String>> licenseGroups, String context, boolean collapse, File resultFile) throws IOException {
        ArrayList<String> licenseList = new ArrayList<String>(licenseGroups.keySet());
        Collections.sort(licenseList);
        this.log(resultFile, String.format("%n>>>> %s <<<<", context));
        for (String license : licenseList) {
            ArrayList<String> filesInGroup;
            this.log(resultFile, String.format("%n  >>> %s <<<", license));
            Collection<String> discriminators = filesInGroup = new ArrayList<String>((Collection)licenseGroups.get(license));
            if (collapse) {
                discriminators = this.collapse(discriminators);
                discriminators = this.collapse(discriminators);
            }
            for (String file : discriminators) {
                this.log(resultFile, String.format("    %s", file));
            }
        }
    }

    private void applyFileFilters(Map<String, List<String>> licenseGroups, String[] filterPatterns) {
        for (List<String> list : licenseGroups.values()) {
            ArrayList<String> toBeDeleted = new ArrayList<String>();
            for (String file : list) {
                for (String pattern : filterPatterns) {
                    if (!file.contains(pattern)) continue;
                    toBeDeleted.add(file);
                }
            }
            list.removeAll(toBeDeleted);
        }
        for (Map.Entry entry : new ArrayList<Map.Entry<String, List<String>>>(licenseGroups.entrySet())) {
            if (!((List)entry.getValue()).isEmpty()) continue;
            licenseGroups.remove(entry.getKey());
        }
    }

    private Set<String> collapse(Collection<String> filesInGroup) {
        if (filesInGroup.isEmpty()) {
            throw new IllegalStateException("Group may not be empty");
        }
        if (filesInGroup.size() == 1) {
            return new HashSet<String>(filesInGroup);
        }
        LinkedHashSet<String> collapsed = new LinkedHashSet<String>();
        for (String file : filesInGroup) {
            collapsed.add(new File(file).getParent());
        }
        return collapsed;
    }

    protected static class ParseResult {
        final Map<String, List<String>> licenseFileGroups;
        final Set<String> markerList;
        final Map<String, List<String>> markerFileGroups;
        final Set<String> scancodeExpressionList;

        public ParseResult(Map<String, List<String>> licenseFileGroups, Map<String, List<String>> markerFileGroups, Set<String> scancodeExpressionList, Set<String> markerList) {
            this.licenseFileGroups = licenseFileGroups;
            this.markerFileGroups = markerFileGroups;
            this.markerList = markerList;
            this.scancodeExpressionList = scancodeExpressionList;
        }
    }
}

