/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.node;

import com.metaeffekt.artifact.analysis.metascan.MetaScanSupport;
import com.metaeffekt.artifact.analysis.model.PropertyProvider;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeScanSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MetaScanSupport.class);
    public static final String KEY_NAME = "name";
    public static final String KEY_VERSION = "version";
    public static final String VALUE_UNDEFINED = "undefined";
    public static final String KEY_HOMEPAGE = "homepage";
    public static final String KEY_LICENSE = "license";
    public static final String KEY_TYPE = "type";
    public static final String KEY_AUTHOR = "author";
    public static final String KEY_AUTHOR_NAME = "name";
    public static final String KEY_AUTHOR_EMAIL = "email";
    private final PropertyProvider propertyProvider;

    public NodeScanSupport(PropertyProvider propertyProvider) {
        this.propertyProvider = propertyProvider;
    }

    public PropertyProvider getPropertyProvider() {
        return this.propertyProvider;
    }

    public void parseJsonPackageMetaData(Artifact artifact, File analysisPath) throws IOException, JSONException {
        StringBuilder sb;
        if (analysisPath == null) {
            return;
        }
        boolean applyNodeJsAnalysis = this.getPropertyProvider().isProperty("analyze.scan.nodejs.enabled", "true", "false");
        if (!applyNodeJsAnalysis) {
            return;
        }
        String[] files = FileUtils.scanDirectoryForFiles((File)analysisPath, (String[])new String[]{"*/package.json"});
        if (files.length == 0) {
            return;
        }
        if (files.length > 1) {
            throw new IllegalStateException(String.format("%s package.json files detected in %s.", files.length, analysisPath));
        }
        File packageJsonFile = new File(analysisPath, files[0]);
        String packageJson = FileUtils.readFileToString((File)packageJsonFile, (String)"UTF-8");
        JSONObject obj = new JSONObject(packageJson);
        String name = this.getString(obj, "name", null);
        if (name == null) {
            artifact.append("Errors", "[Json file detected, but unable to parse]", "\n");
            return;
        }
        String version = this.getString(obj, KEY_VERSION, VALUE_UNDEFINED);
        artifact.set("Package Specified Id", name + "-" + version);
        artifact.set("Package Specified Version", version);
        artifact.set("Package Specified Type", "nodejs-module");
        artifact.set("Package Specified Homepage", this.getString(obj, KEY_HOMEPAGE, null));
        if (obj.has(KEY_LICENSE)) {
            Object licenseObj = obj.get(KEY_LICENSE);
            if (licenseObj instanceof String) {
                artifact.set("Package Specified Licenses", this.getString(obj, KEY_LICENSE, null));
            } else if (obj.get(KEY_LICENSE) instanceof JSONObject) {
                JSONObject licenseObjJson = obj.getJSONObject(KEY_LICENSE);
                sb = new StringBuilder();
                if (licenseObjJson.has(KEY_TYPE)) {
                    sb.append(this.getString(licenseObjJson, KEY_TYPE, null));
                }
                if (sb.length() == 0) {
                    artifact.append("Errors", "[Cannot parse license information from JSON license object " + licenseObj.getClass() + "]", "\n");
                } else {
                    artifact.set("Package Specified Licenses", sb.toString());
                }
            } else {
                artifact.append("Errors", "[Unknown JSON license type " + licenseObj.getClass() + "]", "\n");
            }
        }
        if (obj.has(KEY_AUTHOR)) {
            JSONArray authors;
            Object authorObject = obj.get(KEY_AUTHOR);
            if (authorObject instanceof String) {
                artifact.set("Package Specified Authors", this.getString(obj, KEY_AUTHOR, null));
            } else if (authorObject instanceof JSONArray) {
                authors = obj.getJSONArray(KEY_AUTHOR);
                sb = new StringBuilder();
                for (int i = 0; i < authors.length(); ++i) {
                    if (sb.length() > 0) {
                        sb.append("|\n");
                    }
                    sb.append(authors.get(i));
                }
                artifact.set("Package Specified Authors", sb.toString());
            } else if (authorObject instanceof JSONObject) {
                authors = obj.getJSONObject(KEY_AUTHOR);
                StringBuilder author = new StringBuilder();
                if (authors.has("name")) {
                    author.append(this.getString((JSONObject)authors, "name", null));
                }
                if (authors.has(KEY_AUTHOR_EMAIL)) {
                    if (author.length() > 0) {
                        author.append(" <");
                        author.append(this.getString((JSONObject)authors, KEY_AUTHOR_EMAIL, null));
                        author.append(">");
                    } else {
                        author.append(this.getString((JSONObject)authors, KEY_AUTHOR_EMAIL, null));
                    }
                }
                artifact.set("Package Specified Authors", author.toString());
            } else {
                artifact.append("Errors", "[Unknown JSON author type " + authorObject.getClass() + "]", "\n");
            }
        }
    }

    private String getString(JSONObject obj, String key, String defaultValue) {
        if (obj.has(key)) {
            try {
                return obj.getString(key);
            }
            catch (JSONException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

