/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.scancode;

import com.metaeffekt.artifact.analysis.scancode.ScanCodeLicense;
import com.metaeffekt.artifact.analysis.scancode.ScanCodeRule;
import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.terms.model.TermsMetaData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.yaml.snakeyaml.Yaml;

public class ScanCodeParser {
    public static final Logger LOG = LoggerFactory.getLogger(ScanCodeParser.class);
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    public void scanCodeToLicenseMetaData(File licenseSrcDir, File rulesSrcDir, File targetBaseDir) throws IOException {
        List<String> licenseIds = this.parseLicenseIds(licenseSrcDir);
        String[] ruleYamlFiles = FileUtils.scanDirectoryForFiles((File)rulesSrcDir, (String[])new String[]{"*.RULE"});
        for (String licenseId : licenseIds) {
            File licenseTargetDir = new File(new File(targetBaseDir, licenseId.substring(0, 1)), licenseId);
            TermsMetaData termsMetaData = this.parseTermsMetaData(licenseId, licenseSrcDir, rulesSrcDir);
            File targetFile = new File(licenseTargetDir, "license.meta.yaml");
            termsMetaData.writeToFile(targetFile);
            Yaml yaml = new Yaml();
            for (String ruleFile : ruleYamlFiles) {
                if (!ruleFile.equalsIgnoreCase(licenseId + ".RULE") && !ruleFile.equalsIgnoreCase(licenseId + "_*.RULE")) continue;
                File ruleYamlFile = new File(rulesSrcDir, ruleFile);
                Pair<String, String> content = this.readScanCodeMixedFormat(ruleYamlFile);
                ScanCodeRule scanCodeRule = (ScanCodeRule)yaml.loadAs((String)content.getLeft(), ScanCodeRule.class);
                String rule = (String)content.getRight();
                if (!scanCodeRule.isIs_license_text()) continue;
                File variantDst = new File(licenseTargetDir, "variants/" + ruleFile.replace(".RULE", ".txt"));
                FileUtils.write((File)variantDst, (CharSequence)rule, (String)"UTF-8");
            }
            File licenseFile = new File(licenseSrcDir, licenseId + ".LICENSE");
            File targetLicenseFile = new File(licenseTargetDir, "license/" + licenseId + ".txt");
            if (licenseFile.exists()) {
                Pair<String, String> content = this.readScanCodeMixedFormat(licenseFile);
                FileUtils.writeStringToFile((File)targetLicenseFile, (String)((String)content.getRight()).trim(), (String)"UTF-8");
            }
            LOG.info("Parsing scancode license {} completed.", (Object)licenseId);
        }
    }

    private Pair<String, String> readScanCodeMixedFormat(File file) throws IOException {
        String fileContent = FileUtils.readFileToString((File)file, (String)"UTF-8");
        String intermediate = fileContent.replaceFirst("---\\n", "");
        int index = intermediate.indexOf("\n---");
        String yamlPart = intermediate.substring(0, index);
        String content = intermediate.substring(index + 4).trim();
        return Pair.of((Object)yamlPart, (Object)content);
    }

    public TermsMetaData parseTermsMetaData(String licenseId, File licenseBaseDir, File rulesBaseDir) throws IOException {
        String[] ruleYamlFiles;
        LOG.info("Parsing scancode license {}...", (Object)licenseId);
        TermsMetaData termsMetaData = new TermsMetaData();
        Yaml yaml = new Yaml();
        File licenseYamlFile = new File(licenseBaseDir, licenseId + ".LICENSE");
        if (!licenseYamlFile.exists()) {
            LOG.warn("Inconsistency in scancode versions. The license file [{}] could not be parsed. The file may not exist.", (Object)licenseYamlFile);
            return null;
        }
        Pair<String, String> licenseContent = this.readScanCodeMixedFormat(licenseYamlFile);
        ScanCodeLicense scanCodeLicense = (ScanCodeLicense)yaml.loadAs((String)licenseContent.getLeft(), ScanCodeLicense.class);
        termsMetaData.setCanonicalName(scanCodeLicense.getName());
        termsMetaData.setCategory(scanCodeLicense.getName());
        termsMetaData.setSpdxIdentifier(scanCodeLicense.getSpdx_license_key());
        termsMetaData.addOtherId("scancode", licenseId);
        termsMetaData.setShortName(licenseId);
        termsMetaData.setType(scanCodeLicense.isIs_exception() ? "exception" : null);
        termsMetaData.setUrl(scanCodeLicense.getHomepage_url());
        termsMetaData.setClassification(this.mapCategoryToClassification(scanCodeLicense.getCategory()));
        if (scanCodeLicense.getOsi_license_key() != null) {
            termsMetaData.addOtherId("osi", scanCodeLicense.getOsi_license_key());
        }
        for (String ruleFile : ruleYamlFiles = FileUtils.scanDirectoryForFiles((File)rulesBaseDir, (String[])new String[]{licenseId + ".RUlE", licenseId + "_*.RULE"})) {
            File ruleYamlFile = new File(rulesBaseDir, ruleFile);
            Pair<String, String> ruleContent = this.readScanCodeMixedFormat(ruleYamlFile);
            ScanCodeRule scanCodeRule = (ScanCodeRule)yaml.loadAs((String)ruleContent.getLeft(), ScanCodeRule.class);
            if (scanCodeRule.getIs_license_reference() == null || !scanCodeRule.getIs_license_reference().startsWith("yes")) continue;
            String ref = ((String)ruleContent.getRight()).replace("\n", " ").trim();
            ref = ref.replace("\"", "\\\"");
            termsMetaData.getAlternativeNames().add(ref);
        }
        termsMetaData.consolidateAlternativeNames();
        return termsMetaData;
    }

    private String mapCategoryToClassification(String category) {
        if ("permissive".equalsIgnoreCase(category)) {
            return "permissive";
        }
        if ("copyleft".equalsIgnoreCase(category)) {
            return "copyleft";
        }
        if ("copyleft limited".equalsIgnoreCase(category)) {
            return "limited copyleft";
        }
        if ("Proprietary Free".equalsIgnoreCase(category)) {
            return "proprietary free";
        }
        if ("commercial".equalsIgnoreCase(category)) {
            return "commercial";
        }
        if ("Free Restricted".equalsIgnoreCase(category)) {
            return "restricted free";
        }
        if ("Patent License".equalsIgnoreCase(category)) {
            return "patent license";
        }
        if ("Public Domain".equalsIgnoreCase(category)) {
            return "public domain";
        }
        if ("Source-available".equalsIgnoreCase(category)) {
            return "source-available";
        }
        LOG.warn("Cannot map unknown category: {}", (Object)category);
        return category;
    }

    protected List<String> parseLicenseIds(File licenseSrcDir) {
        String[] licenseYamlFiles;
        ArrayList<String> licenseIds = new ArrayList<String>();
        for (String licenseYamlFile : licenseYamlFiles = FileUtils.scanDirectoryForFiles((File)licenseSrcDir, (String[])new String[]{"**/*.LICENSE"})) {
            licenseIds.add(licenseYamlFile.substring(0, licenseYamlFile.lastIndexOf(".LICENSE")));
        }
        return licenseIds;
    }

    public static void parseScanCodeResult(String result, TreeSet<String> licenseList, TreeSet<String> copyrightList, TreeSet<String> authorList, String[] includes, String[] excludes) throws JSONException {
        JSONObject obj = new JSONObject(result);
        JSONArray files = obj.getJSONArray("files");
        for (int i = 0; i < files.length(); ++i) {
            JSONObject file = files.getJSONObject(i);
            String path = file.getString("path");
            boolean includeMatch = false;
            for (String includePattern : includes) {
                if (includeMatch |= ANT_PATH_MATCHER.match(includePattern, path)) break;
            }
            if (!includeMatch) continue;
            boolean excludeMatch = false;
            for (String excludePattern : excludes) {
                excludeMatch |= ANT_PATH_MATCHER.match(excludePattern, path);
                if (includeMatch) break;
            }
            if (excludeMatch) continue;
            List<String> licenses = ScanCodeParser.parseLicenses(file);
            licenseList.addAll(licenses);
            JSONArray copyrights = file.getJSONArray("copyrights");
            ScanCodeParser.addValuesToList(copyrights, copyrightList, "copyright");
            JSONArray authors = file.getJSONArray("authors");
            ScanCodeParser.addValuesToList(authors, authorList, "author");
        }
    }

    private static List<String> parseLicenses(JSONObject file) {
        ArrayList<String> aggregatedLicenseExpressions = new ArrayList<String>();
        if (file.has("licenses")) {
            JSONArray licenses = file.getJSONArray("licenses");
            for (int i = 0; i < licenses.length(); ++i) {
                JSONObject licensesJSONObject = licenses.getJSONObject(i);
                String license = licensesJSONObject.getString("key");
                String[] split = license.split(" AND ");
                aggregatedLicenseExpressions.addAll(Arrays.asList(split));
            }
        } else {
            JSONArray licenseDetections = file.getJSONArray("license_detections");
            for (int i = 0; i < licenseDetections.length(); ++i) {
                JSONObject licenseExpression = licenseDetections.getJSONObject(i);
                String expressionString = licenseExpression.getString("license_expression");
                String[] split = expressionString.split(" AND ");
                aggregatedLicenseExpressions.addAll(Arrays.asList(split));
            }
        }
        return aggregatedLicenseExpressions;
    }

    private static void addValuesToList(JSONArray copyrights, TreeSet<String> copyrightList, String key) throws JSONException {
        for (int j = 0; j < copyrights.length(); ++j) {
            JSONObject author = copyrights.getJSONObject(j);
            String value = ScanCodeParser.getFieldStringValue(author, key);
            if (StringUtils.isEmpty(value)) continue;
            copyrightList.add(value);
        }
    }

    public void parseScanCodeResult(String result, Map<String, List<String>> licenseFileMap, Map<String, List<String>> copyrightFileMap, Map<String, List<String>> authorFileMap) throws JSONException {
        JSONObject obj = new JSONObject(result);
        JSONArray files = obj.getJSONArray("files");
        for (int i = 0; i < files.length(); ++i) {
            List list;
            JSONObject file = files.getJSONObject(i);
            JSONArray copyrights = file.getJSONArray("copyrights");
            String path = file.getString("path");
            for (int j = 0; j < copyrights.length(); ++j) {
                JSONObject copyright = copyrights.getJSONObject(j);
                String value = ScanCodeParser.getFieldStringValue(copyright, "copyright");
                List<String> list2 = copyrightFileMap.get(value);
                if (list2 == null) {
                    list2 = new ArrayList<String>();
                    copyrightFileMap.put(value, list2);
                }
                if (list2.contains(path)) continue;
                list2.add(path);
            }
            JSONArray authors = file.getJSONArray("authors");
            for (int j = 0; j < authors.length(); ++j) {
                JSONObject author = authors.getJSONObject(j);
                String value = ScanCodeParser.getFieldStringValue(author, "author");
                list = authorFileMap.get(value);
                if (list == null) {
                    list = new ArrayList<String>();
                    authorFileMap.put(value, list);
                }
                if (list.contains(path)) continue;
                list.add(path);
            }
            List<String> licenses = ScanCodeParser.parseLicenses(file);
            for (String license : licenses) {
                list = licenseFileMap.computeIfAbsent(license, k -> new ArrayList());
                if (list.contains(path)) continue;
                list.add(path);
            }
        }
    }

    private static String getFieldStringValue(JSONObject object, String key) throws JSONException {
        if (object.has(key)) {
            return object.getString(key);
        }
        throw new IllegalStateException();
    }
}

