/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitAccess {
    private static final Logger LOG = LoggerFactory.getLogger(GitAccess.class);
    private String proxyScheme;
    private String proxyHost;
    private String proxyUsername;
    private String proxyPassword;
    private Integer proxyPort;
    private GIT_COMMAND_PROXY_SET_TYPE gitCommandProxySetType = GIT_COMMAND_PROXY_SET_TYPE.ENVIRONMENT;

    public GitAccess(String proxyScheme, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword) {
        this.setProxyConfig(proxyScheme, proxyHost, proxyPort, proxyUsername, proxyPassword);
    }

    public GitAccess(String proxyScheme, String proxyHost, Integer proxyPort) {
        this.setProxyConfig(proxyScheme, proxyHost, proxyPort, null, null);
    }

    public GitAccess() {
        this.setProxyConfig(null, null, null, null, null);
    }

    public void setProxyConfig(String proxyScheme, String proxyHost, Integer proxyPort, String proxyUsername, String proxyPassword) {
        this.proxyScheme = proxyScheme;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    public void setGitCommandProxySetType(GIT_COMMAND_PROXY_SET_TYPE gitCommandProxySetType) {
        this.gitCommandProxySetType = gitCommandProxySetType;
    }

    public void cloneRemote(File targetDir, String remote, String branch) throws IOException {
        String[] gitClone = new String[]{"git", "clone", "--depth", "1", remote, targetDir.getAbsolutePath()};
        this.executeCommand(gitClone, null);
        if (branch != null) {
            this.checkout(targetDir, branch);
        }
    }

    public void pull(File targetDir) throws IOException {
        String[] gitPull = new String[]{"git", "pull"};
        this.executeCommand(gitPull, targetDir);
    }

    public void fetch(File targetDir) throws IOException {
        String[] gitFetch = new String[]{"git", "fetch"};
        this.executeCommand(gitFetch, targetDir);
    }

    public void checkout(File targetDir, String branchOrTag) throws IOException {
        String[] gitCheckout = new String[]{"git", "checkout", branchOrTag};
        this.executeCommand(gitCheckout, targetDir);
    }

    public void push(File targetDir) throws IOException {
        String[] gitPush = new String[]{"git", "push"};
        this.executeCommand(gitPush, targetDir);
    }

    public List<String> listBranches(File targetDir) throws IOException {
        String[] gitBranch = new String[]{"git", "branch", "-r"};
        return this.executeCommandAndCollectOutput(gitBranch, targetDir).stream().filter(b -> !b.contains(" -> ")).map(String::trim).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
    }

    public List<String> listTags(File targetDir) throws IOException {
        String[] gitTag = new String[]{"git", "tag"};
        return this.executeCommandAndCollectOutput(gitTag, targetDir).stream().map(String::trim).filter(StringUtils::hasText).distinct().collect(Collectors.toList());
    }

    private ProcessBuilder buildProcess(String[] command, File targetDir) {
        boolean hasAnyProxy;
        ArrayList<String> modifiedCommand = new ArrayList<String>(Arrays.asList(command));
        boolean hasProxy = this.proxyScheme != null && this.proxyHost != null && this.proxyPort != null;
        boolean bl = hasAnyProxy = hasProxy || this.proxyUsername != null && this.proxyPassword != null;
        if (hasAnyProxy != hasProxy) {
            LOG.warn("Incomplete proxy configuration in git command, will still try to execute command");
        }
        ProcessBuilder processBuilder = new ProcessBuilder(modifiedCommand);
        if (targetDir != null) {
            if (targetDir.exists()) {
                processBuilder.directory(targetDir.getAbsoluteFile());
            } else {
                throw new IllegalStateException("Target directory does not exist: " + targetDir.getAbsolutePath());
            }
        }
        if (hasProxy) {
            String proxyCredentials = this.proxyUsername != null && this.proxyPassword != null ? this.proxyUsername + ":" + this.proxyPassword + "@" : "";
            String proxySetting = this.proxyScheme + "://" + proxyCredentials + this.proxyHost + ":" + this.proxyPort;
            LOG.info("Using [GIT_COMMAND_PROXY_SET_TYPE.{}] to configure git proxy", (Object)this.gitCommandProxySetType);
            if (this.gitCommandProxySetType == GIT_COMMAND_PROXY_SET_TYPE.ENVIRONMENT) {
                processBuilder.environment().put("HTTP_PROXY", proxySetting);
                processBuilder.environment().put("http_proxy", proxySetting);
                processBuilder.environment().put("HTTPS_PROXY", proxySetting);
                processBuilder.environment().put("https_proxy", proxySetting);
            } else if (this.gitCommandProxySetType == GIT_COMMAND_PROXY_SET_TYPE.PARAMETERS) {
                int gitIndex = modifiedCommand.indexOf("git");
                if (gitIndex != -1) {
                    modifiedCommand.add(gitIndex + 1, "-c");
                    modifiedCommand.add(gitIndex + 2, "http.proxy=" + proxySetting);
                }
            } else {
                throw new IllegalStateException("Unsupported proxy set type: " + (Object)((Object)this.gitCommandProxySetType));
            }
        }
        if (targetDir != null) {
            LOG.info("git command [{}]: {}", (Object)targetDir.getName(), (Object)String.join((CharSequence)" ", modifiedCommand));
        } else {
            LOG.info("git command: {}", (Object)String.join((CharSequence)" ", modifiedCommand));
        }
        return processBuilder;
    }

    private void executeCommand(String[] command, File targetDir) throws IOException {
        String line;
        ProcessBuilder processBuilder = this.buildProcess(command, targetDir);
        Process p = processBuilder.start();
        StringBuilder outputBuilder = new StringBuilder();
        StringBuilder errorBuilder = new StringBuilder();
        BufferedReader outputReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = outputReader.readLine()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[stdout] {}", (Object)line);
                continue;
            }
            outputBuilder.append(line).append("\n");
        }
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = errorReader.readLine()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[stderr] {}", (Object)line);
                continue;
            }
            errorBuilder.append(line).append("\n");
        }
        this.waitForProcess(p);
        if (p.exitValue() != 0) {
            if (LOG.isDebugEnabled()) {
                throw new IllegalStateException("Command failed. Exit code: " + p.exitValue());
            }
            throw new IllegalStateException("Command failed. Exit code: " + p.exitValue() + "\nOutput:\n" + outputBuilder + "\n\nError:\n" + errorBuilder);
        }
    }

    private List<String> executeCommandAndCollectOutput(String[] command, File targetDir) throws IOException {
        String line2;
        ProcessBuilder processBuilder = this.buildProcess(command, targetDir);
        Process p = processBuilder.start();
        StringBuilder outputBuilder = new StringBuilder();
        StringBuilder errorBuilder = new StringBuilder();
        String[] stringArray = null;
        try (BufferedReader outputReader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            while ((line2 = outputReader.readLine()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[stdout] {}", (Object)line2);
                }
                outputBuilder.append(line2).append("\n");
            }
        }
        catch (Throwable line2) {
            stringArray = line2;
            throw line2;
        }
        stringArray = null;
        try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
            while ((line2 = errorReader.readLine()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[stderr] {}", (Object)line2);
                    continue;
                }
                errorBuilder.append(line2).append("\n");
            }
        }
        catch (Throwable throwable) {
            stringArray = throwable;
            throw throwable;
        }
        this.waitForProcess(p);
        if (p.exitValue() != 0) {
            if (LOG.isDebugEnabled()) {
                throw new IllegalStateException("Command failed. Exit code: " + p.exitValue());
            }
            throw new IllegalStateException("Command failed. Exit code: " + p.exitValue() + "\nOutput:\n" + outputBuilder + "\n\nError:\n" + errorBuilder);
        }
        ArrayList<String> output = new ArrayList<String>();
        for (String s : outputBuilder.toString().split("\n")) {
            output.add(s.trim());
        }
        return output;
    }

    private void waitForProcess(Process p) {
        block4: while (true) {
            try {
                while (p.isAlive()) {
                    p.waitFor(1000L, TimeUnit.MILLISECONDS);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        IOUtils.copy((InputStream)p.getInputStream(), (OutputStream)baos);
                        continue block4;
                    }
                    catch (IOException e) {
                        LOG.error("Unable to copy input stream into output stream.", (Throwable)e);
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public static enum GIT_COMMAND_PROXY_SET_TYPE {
        ENVIRONMENT,
        PARAMETERS;

    }
}

