/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HTTPClientDownloader {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final HttpHost proxy;
    private final CredentialsProvider credentialsProvider;
    public static final int DEFAULT_PORT = 80;
    public static final int FTP_PORT = 20;
    public static final int HTTPS_PORT = 443;
    public static final int HTTP_PORT = 80;

    public HTTPClientDownloader(String scheme, String host, int port, String username, String password) {
        this.proxy = new HttpHost(host, port, scheme);
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public HTTPClientDownloader() {
        this.proxy = null;
        this.credentialsProvider = null;
    }

    private CloseableHttpClient getHttpClient() {
        HttpClientBuilder httpClient = HttpClients.custom();
        httpClient.setDefaultCredentialsProvider(this.credentialsProvider);
        return httpClient.build();
    }

    public void download(URL url, File dstFile, int attempts) {
        attempts = Math.max(1, attempts);
        Throwable caughtException = null;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.download(url, dstFile);
                return;
            }
            catch (RuntimeException e) {
                this.LOG.warn("Attempt {}/{}: Retrying fetching [{}]: {}", new Object[]{i + 1, attempts, url, e.getMessage()});
                caughtException = e;
                continue;
            }
        }
        this.LOG.error("Attempt {}/{}: Unable to fetch [{}]: {}", new Object[]{attempts, attempts, url, caughtException.getMessage()});
        throw caughtException;
    }

    public void download(URL url, File dstFile) {
        try (CloseableHttpClient httpclient = this.getHttpClient();){
            HttpHost target = new HttpHost(url.getHost(), this.protocolToPort(url.getProtocol()), url.getProtocol());
            RequestConfig config = this.proxy != null ? RequestConfig.custom().setProxy(this.proxy).build() : RequestConfig.custom().build();
            HttpGet request = new HttpGet(url.getPath());
            request.setConfig(config);
            if (this.proxy == null) {
                this.LOG.info("Executing request [{}] to [{}]", (Object)request.getRequestLine(), (Object)target);
            } else {
                this.LOG.info("Executing request [{}] to [{}] via proxy [{}]", new Object[]{request.getRequestLine(), target, this.proxy});
            }
            CloseableHttpResponse response = httpclient.execute(target, (HttpRequest)request);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (dstFile == null) {
                    this.LOG.error("Download destination file for request [{}] is [null]", (Object)url);
                    throw new RuntimeException("Unable to download file from [" + url + "] since no local destination file was specified.");
                }
                if (!dstFile.getAbsoluteFile().getParentFile().exists() && !dstFile.getAbsoluteFile().getParentFile().mkdirs()) {
                    this.LOG.error("Unable to create parent directory to file [{}]", (Object)dstFile.getAbsoluteFile());
                    throw new RuntimeException("Unable to download file from [" + url + "] to [" + dstFile.getAbsolutePath() + "] since the parent directory does not exist and could not be created.");
                }
                try (FileOutputStream outstream = new FileOutputStream(dstFile);){
                    entity.writeTo((OutputStream)outstream);
                }
            } else {
                this.LOG.error("Response from [{}] is [null]", (Object)url);
                throw new RuntimeException("Response from [" + url + "] is [null].");
            }
            if (!dstFile.exists()) {
                this.LOG.warn("File was downloaded but destination file [{}] does not exist", (Object)dstFile.getAbsolutePath());
                this.LOG.error("Unable to download file from [{}] to [{}]", (Object)url, (Object)dstFile);
                throw new RuntimeException("Unable to download file from [" + url + "] to [" + dstFile.getAbsolutePath() + "]");
            }
        }
        catch (IOException e) {
            this.LOG.error("An error occurred while getting the response from [{}]: {}", (Object)url, (Object)e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public List<String> getResponseStringFromUrl(URL url, int attempts) {
        attempts = Math.max(1, attempts);
        Throwable caughtException = null;
        for (int i = 0; i < attempts; ++i) {
            try {
                return this.getResponseStringFromUrl(url);
            }
            catch (RuntimeException e) {
                this.LOG.warn("Attempt {}/{}: Retrying fetching [{}]: {}", new Object[]{i + 1, attempts, url, e.getMessage()});
                caughtException = e;
                continue;
            }
        }
        this.LOG.error("Attempt {}/{}: Unable to fetch [{}]: {}", new Object[]{attempts, attempts, url, caughtException.getMessage()});
        throw caughtException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getResponseStringFromUrl(URL url) {
        try (CloseableHttpClient httpclient = this.getHttpClient();){
            String line;
            HttpHost target = new HttpHost(url.getHost(), this.protocolToPort(url.getProtocol()), url.getProtocol());
            RequestConfig config = this.proxy != null ? RequestConfig.custom().setProxy(this.proxy).build() : RequestConfig.custom().build();
            HttpGet request = new HttpGet(url.getPath());
            request.setConfig(config);
            if (this.proxy == null) {
                this.LOG.info("Executing request [{}] to [{}]", (Object)request.getRequestLine(), (Object)target);
            } else {
                this.LOG.info("Executing request [{}] to [{}] via proxy [{}]", new Object[]{request.getRequestLine(), target, this.proxy});
            }
            CloseableHttpResponse response = httpclient.execute(target, (HttpRequest)request);
            HttpEntity entity = response.getEntity();
            InputStream contentInputStream = entity.getContent();
            ArrayList<String> result = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(contentInputStream));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            if (result.stream().anyMatch(res -> res.contains("Access Denied"))) {
                this.LOG.warn("Response from url [{}] contains string 'Access Denied'", (Object)url);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            this.LOG.error("An error occurred while getting the response from [{}]: {}", (Object)url, (Object)e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getFileSizeFromUrl(URL url) {
        try (CloseableHttpClient httpclient = this.getHttpClient();){
            HttpHost target = new HttpHost(url.getHost(), this.protocolToPort(url.getProtocol()), url.getProtocol());
            RequestConfig config = this.proxy != null ? RequestConfig.custom().setProxy(this.proxy).build() : RequestConfig.custom().build();
            HttpGet request = new HttpGet(url.getPath());
            request.setConfig(config);
            if (this.proxy == null) {
                this.LOG.info("Executing request [{}] to [{}]", (Object)request.getRequestLine(), (Object)target);
            } else {
                this.LOG.info("Executing request [{}] to [{}] via proxy [{}]", new Object[]{request.getRequestLine(), target, this.proxy});
            }
            CloseableHttpResponse response = httpclient.execute(target, (HttpRequest)request);
            if (response.getLastHeader("Content-Length") == null) {
                String line;
                this.LOG.warn("Response Header did not contain [Content-Length], getting result content and extracting byte length");
                HttpEntity entity = response.getEntity();
                InputStream contentInputStream = entity.getContent();
                ArrayList<String> result = new ArrayList<String>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(contentInputStream));
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
                if (result.stream().anyMatch(res -> res.contains("Access Denied"))) {
                    this.LOG.warn("Response from url [{}] contains string 'Access Denied'. This might or might not be a bad sign.", (Object)url);
                }
                long l = result.stream().map(String::getBytes).mapToInt(v -> ((byte[])v).length).sum();
                return l;
            }
            String size = response.getLastHeader("Content-Length").getValue();
            long l = Long.parseLong(size);
            return l;
        }
        catch (IOException e) {
            this.LOG.error("An error occurred while getting the response from [{}]: {}", (Object)url, (Object)e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private int protocolToPort(String protocol) {
        switch (protocol.toLowerCase()) {
            case "ftp": {
                return 20;
            }
            case "https": {
                return 443;
            }
            case "http": {
                return 80;
            }
        }
        this.LOG.warn("Unknown protocol [{}], returning default port [{}]", (Object)protocol, (Object)80);
        return 80;
    }
}

