/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

public class Vector
implements Cloneable {
    public double x;
    public double y;

    public Vector() {
        this(0.0, 0.0);
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector set(Vector vector) {
        this.x = vector.x;
        this.y = vector.y;
        return this;
    }

    public Vector add(double x, double y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public Vector add(Vector vector) {
        this.x += vector.x;
        this.y += vector.y;
        return this;
    }

    public Vector subtract(double x, double y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    public Vector subtract(Vector vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        return this;
    }

    public Vector divide(double n) {
        this.x /= n;
        this.y /= n;
        return this;
    }

    public Vector divide(double x, double y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    public Vector divide(Vector vector) {
        this.x /= vector.x;
        this.y /= vector.y;
        return this;
    }

    public Vector multiply(double n) {
        this.x *= n;
        this.y *= n;
        return this;
    }

    public Vector multiply(double x, double y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    public Vector multiply(Vector vector) {
        this.x *= vector.x;
        this.y *= vector.y;
        return this;
    }

    public Vector rotate(double angle) {
        double newX = Math.cos(Math.toRadians(angle)) * this.x - Math.sin(Math.toRadians(angle)) * this.y;
        double newY = Math.sin(Math.toRadians(angle)) * this.x + Math.cos(Math.toRadians(angle)) * this.y;
        this.x = newX;
        this.y = newY;
        return this;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector normalize() {
        double length = this.length();
        if (length != 0.0) {
            this.x /= length;
            this.y /= length;
        }
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            return this.x == v.x && this.y == v.y;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.x * 31.0 + this.y);
    }

    public static Vector calculateInterceptionPoint(Vector s1, Vector s2, Vector d1, Vector d2) {
        double a1 = s2.y - s1.y;
        double b1 = s1.x - s2.x;
        double c1 = a1 * s1.x + b1 * s1.y;
        double a2 = d2.y - d1.y;
        double b2 = d1.x - d2.x;
        double c2 = a2 * d1.x + b2 * d1.y;
        double delta = a1 * b2 - a2 * b1;
        return new Vector((b2 * c1 - b1 * c2) / delta, (a1 * c2 - a2 * c1) / delta);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + "]";
    }

    public Vector clone() {
        return new Vector(this.x, this.y);
    }
}

