/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class WildcardUtilities {
    private static final Pattern REGEX_PATTERN_FLAGS = Pattern.compile("/[gimsuy]{1,3}$");

    public static Pattern convertWildcardStringToPattern(String wildcardString) {
        int flags = WildcardUtilities.extractWildcardFlags(wildcardString);
        wildcardString = wildcardString.replaceAll(REGEX_PATTERN_FLAGS.pattern(), "/");
        boolean endsInSlash = wildcardString.endsWith("/");
        if ((wildcardString = wildcardString.replaceAll("/$", "")).startsWith("/") && endsInSlash) {
            return Pattern.compile(wildcardString.replaceAll("^/", ""), flags);
        }
        return Pattern.compile(wildcardString.replace(".", "\\.").replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("{", "\\{").replace("}", "\\}").replace("+", "\\+").replace("*", ".*").replace("?", "."), flags);
    }

    private static int extractWildcardFlags(String wildcardString) {
        Matcher matcher = REGEX_PATTERN_FLAGS.matcher(wildcardString);
        int flags = 0;
        if (matcher.find()) {
            for (int i = 0; i < matcher.group().length(); ++i) {
                if (matcher.group().charAt(i) == 'g') {
                    flags |= 8;
                    continue;
                }
                if (matcher.group().charAt(i) == 'i') {
                    flags |= 2;
                    continue;
                }
                if (matcher.group().charAt(i) == 'm') {
                    flags |= 8;
                    continue;
                }
                if (matcher.group().charAt(i) == 's') {
                    flags |= 0x20;
                    continue;
                }
                if (matcher.group().charAt(i) == 'u') {
                    flags |= 0x40;
                    continue;
                }
                if (matcher.group().charAt(i) != 'y') continue;
                flags |= 4;
            }
        }
        return flags;
    }

    public static boolean isWildcardPattern(String text) {
        return text.startsWith("/") && text.endsWith("/") || REGEX_PATTERN_FLAGS.matcher(text).find() || text.contains("*") || text.contains("?");
    }
}

