/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.VersionModifier;
import com.metaeffekt.artifact.analysis.version.curation.ConditionalCuratedVersionPartsExtractor;
import com.metaeffekt.artifact.analysis.version.curation.ConditionalCuratedVersionPartsExtractorCollection;
import com.metaeffekt.artifact.analysis.version.curation.ExtractedCuratedVersionParts;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.version.token.VersionToken;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenType;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenizer;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;

public class AllCategorizedPartsVersionImpl
implements Version {
    protected final String rawVersion;
    protected final String rawUpdate;
    protected final VersionToken specVersion;
    protected final VersionToken semVersion;
    protected final VersionToken buildVersion;
    protected final VersionToken otherVersionPart;
    protected final VersionToken versionModifier;
    protected final VersionToken afterAllPart;
    private static final VersionToken DEFAULT_NUMBER_OR_SEMVER = new VersionToken("0", VersionTokenType.NUMBER_OR_SEMVER);
    private static final VersionToken DEFAULT_DATE = new VersionToken("00000000", VersionTokenType.DATE);
    private static final VersionToken DEFAULT_STRING = new VersionToken("\u0000", VersionTokenType.STRING);
    private static final VersionToken DEFAULT_VERSION_MODIFIER = new VersionToken(VersionModifier.NEUTRAL_TOKEN.getValue(), VersionTokenType.VERSION_MODIFIER);

    protected AllCategorizedPartsVersionImpl(String version, String update, VersionContext versionContext) {
        ExtractedCuratedVersionParts effectiveResult;
        boolean curatedResultHasPreprocessedVersion;
        this.rawVersion = version;
        this.rawUpdate = update;
        List<ConditionalCuratedVersionPartsExtractor> matchingExtractors = ConditionalCuratedVersionPartsExtractorCollection.findExtractors(VersionTokenizer.buildEffectiveVersionString(version, update), versionContext);
        Optional<ConditionalCuratedVersionPartsExtractor> firstExtractor = matchingExtractors.stream().findFirst();
        Optional<ExtractedCuratedVersionParts> curatedResult = ConditionalCuratedVersionPartsExtractorCollection.applyFirstStep(firstExtractor, version, versionContext);
        boolean isCuratedResultPresent = curatedResult.isPresent();
        boolean bl = curatedResultHasPreprocessedVersion = isCuratedResultPresent && curatedResult.get().isPreprocessorType();
        if (isCuratedResultPresent && !curatedResultHasPreprocessedVersion) {
            effectiveResult = curatedResult.get();
        } else {
            List<VersionToken> tokens = curatedResultHasPreprocessedVersion ? VersionTokenizer.tokenize(curatedResult.get().getPreprocessedVersionToBeTokenized()) : VersionTokenizer.tokenize(version, update);
            effectiveResult = new ExtractedCuratedVersionParts();
            boolean containsThreeOrMoreStringVersionParts = tokens.stream().filter(t -> t.getType() == VersionTokenType.STRING && t.isComparableByString()).count() >= 3L;
            for (int i = 0; i < tokens.size(); ++i) {
                VersionToken token = tokens.get(i);
                if (i == 0 && token.getType() == VersionTokenType.STRING && token.getValue().length() == 1) continue;
                if (token.getType() == VersionTokenType.VERSION_MODIFIER) {
                    if (effectiveResult.getVersionModifier() != null) continue;
                    effectiveResult.setVersionModifier(token);
                    continue;
                }
                if (!token.isComparableByString() || containsThreeOrMoreStringVersionParts && token.getType() == VersionTokenType.STRING) continue;
                if (effectiveResult.getVersionModifier() != null && effectiveResult.getAfterAllPart() == null) {
                    effectiveResult.setAfterAllPart(token);
                    continue;
                }
                if (effectiveResult.getSpecVersion() == null) {
                    effectiveResult.setSpecVersion(token);
                    continue;
                }
                if (effectiveResult.getSemVersion() == null) {
                    effectiveResult.setSemVersion(token);
                    continue;
                }
                if (effectiveResult.getBuildVersion() == null) {
                    effectiveResult.setBuildVersion(token);
                    continue;
                }
                if (effectiveResult.getOtherVersionPart() != null) continue;
                effectiveResult.setOtherVersionPart(token);
            }
            if (effectiveResult.getOtherVersionPart() == null && effectiveResult.getSpecVersion() != null && (effectiveResult.getSpecVersion().getType() == VersionTokenType.NUMBER_OR_SEMVER || effectiveResult.getSpecVersion().getType() == VersionTokenType.DATE)) {
                effectiveResult.setOtherVersionPart(effectiveResult.getBuildVersion());
                effectiveResult.setBuildVersion(effectiveResult.getSemVersion());
                effectiveResult.setSemVersion(effectiveResult.getSpecVersion());
                effectiveResult.setSpecVersion(null);
            }
            if (effectiveResult.getOtherVersionPart() == null && effectiveResult.getBuildVersion() != null && effectiveResult.getBuildVersion().getValue().length() >= 8 && effectiveResult.getBuildVersion().getType() != VersionTokenType.NUMBER_OR_SEMVER) {
                effectiveResult.setOtherVersionPart(effectiveResult.getBuildVersion());
                effectiveResult.setBuildVersion(null);
            }
            if (effectiveResult.getBuildVersion() == null && effectiveResult.getSemVersion() != null && effectiveResult.getSemVersion().getValue().split("\\.").length == 4) {
                Object[] parts = effectiveResult.getSemVersion().getValue().split("\\.");
                effectiveResult.setBuildVersion(new VersionToken(parts[3], VersionTokenType.NUMBER_OR_SEMVER));
                effectiveResult.setSemVersion(new VersionToken(org.apache.commons.lang3.StringUtils.join((Object[])parts, (String)".", (int)0, (int)3), VersionTokenType.NUMBER_OR_SEMVER));
            }
            if (effectiveResult.getSemVersion() != null && !effectiveResult.getSemVersion().getValue().contains(".")) {
                if (effectiveResult.getBuildVersion() != null && effectiveResult.getBuildVersion().getValue().contains(".")) {
                    effectiveResult.setSemVersion(effectiveResult.getBuildVersion());
                    effectiveResult.setBuildVersion(null);
                } else if (effectiveResult.getOtherVersionPart() != null && effectiveResult.getOtherVersionPart().getValue().contains(".")) {
                    effectiveResult.setSemVersion(effectiveResult.getOtherVersionPart());
                    effectiveResult.setOtherVersionPart(null);
                }
            }
        }
        for (ConditionalCuratedVersionPartsExtractor extractor : matchingExtractors) {
            extractor.applySecondStep(effectiveResult);
        }
        this.specVersion = effectiveResult.getSpecVersion();
        this.semVersion = effectiveResult.getSemVersion();
        this.buildVersion = effectiveResult.getBuildVersion();
        this.versionModifier = effectiveResult.getVersionModifier();
        this.otherVersionPart = effectiveResult.getOtherVersionPart();
        this.afterAllPart = effectiveResult.getAfterAllPart();
    }

    public AllCategorizedPartsVersionImpl(String version, VersionContext versionContext) {
        this(version, null, versionContext);
    }

    @Override
    public int compareTo(Version o) {
        if (!(o instanceof AllCategorizedPartsVersionImpl)) {
            return 1;
        }
        return this.compareTo((AllCategorizedPartsVersionImpl)o);
    }

    @Override
    public int compareTo(AllCategorizedPartsVersionImpl o) {
        if (o == null) {
            return 1;
        }
        int result = this.compareByPart(this.specVersion, o.specVersion);
        if (result == 0) {
            result = this.compareByPart(this.semVersion, o.semVersion);
        }
        if (result == 0) {
            result = this.compareByPart(this.buildVersion, o.buildVersion);
        }
        if (result == 0) {
            result = this.compareByPart(this.otherVersionPart, o.otherVersionPart);
        }
        if (result == 0) {
            result = this.compareByPart(this.versionModifier, o.versionModifier);
        }
        if (result == 0) {
            result = this.compareByPart(this.afterAllPart, o.afterAllPart);
        }
        return result;
    }

    private int compareByPart(VersionToken o1, VersionToken o2) {
        boolean is2VersionModifier;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null || o2 == null) {
            VersionToken defaultValue;
            VersionToken nonNull = (VersionToken)ObjectUtils.firstNonNull((Object[])new VersionToken[]{o1, o2});
            switch (nonNull.getType()) {
                case NUMBER_OR_SEMVER: {
                    defaultValue = DEFAULT_NUMBER_OR_SEMVER;
                    break;
                }
                case DATE: {
                    defaultValue = DEFAULT_DATE;
                    break;
                }
                case STRING: {
                    defaultValue = DEFAULT_STRING;
                    break;
                }
                case VERSION_MODIFIER: {
                    defaultValue = DEFAULT_VERSION_MODIFIER;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown version token type: " + (Object)((Object)nonNull.getType()));
                }
            }
            if (o1 == null) {
                o1 = defaultValue;
            } else {
                o2 = defaultValue;
            }
        }
        boolean is1VersionModifier = o1.getType() == VersionTokenType.VERSION_MODIFIER;
        boolean bl = is2VersionModifier = o2.getType() == VersionTokenType.VERSION_MODIFIER;
        if (is1VersionModifier && is2VersionModifier) {
            return VersionToken.VERSION_MODIFIER_COMPARATOR.compare(o1, o2);
        }
        if (!is1VersionModifier && !is2VersionModifier) {
            if (o1.isLettersOnly() || o2.isLettersOnly()) {
                return o1.getValue().compareTo(o2.getValue());
            }
            return VersionComparator.INSTANCE.compare(o1.getValue(), o2.getValue());
        }
        return is1VersionModifier ? 1 : -1;
    }

    @Override
    public String getVersion() {
        return this.rawVersion;
    }

    @Override
    public String getUpdate() {
        return this.rawUpdate;
    }

    public boolean equals(Object obj) {
        return obj instanceof Version && this.equals((Version)obj);
    }

    public VersionToken getSpecVersion() {
        return this.specVersion;
    }

    public VersionToken getSemVersion() {
        return this.semVersion;
    }

    public VersionToken getBuildVersion() {
        return this.buildVersion;
    }

    public VersionToken getOtherVersionPart() {
        return this.otherVersionPart;
    }

    public VersionToken getVersionModifier() {
        return this.versionModifier;
    }

    public VersionToken getAfterAllPart() {
        return this.afterAllPart;
    }

    public String toStringPreModifierPart() {
        StringBuilder sb = new StringBuilder();
        if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.specVersion)) {
            sb.append(this.specVersion);
        }
        if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.semVersion)) {
            if (sb.length() > 0) {
                sb.append("-");
            }
            sb.append(this.semVersion);
        }
        if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.buildVersion) || AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.otherVersionPart)) {
            sb.append(" [");
            if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.buildVersion)) {
                sb.append(this.buildVersion);
            }
            if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.otherVersionPart)) {
                if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.buildVersion)) {
                    sb.append("-");
                }
                sb.append(this.otherVersionPart);
            }
            sb.append("]");
        }
        return sb.toString().trim();
    }

    public String toStringModifierPart() {
        StringBuilder sb = new StringBuilder();
        if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.versionModifier) && this.versionModifier != VersionModifier.NEUTRAL_TOKEN) {
            sb.append("(").append(this.versionModifier).append(")");
        }
        if (AllCategorizedPartsVersionImpl.nonNullAndNotEmpty(this.afterAllPart)) {
            sb.append(" ").append(this.afterAllPart);
        }
        return sb.toString().trim();
    }

    public String toString() {
        return (this.toStringPreModifierPart() + " " + this.toStringModifierPart()).trim();
    }

    private static boolean nonNullAndNotEmpty(VersionToken t) {
        return t != null && StringUtils.hasText(t.getValue());
    }
}

