/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.version.curation;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.version.curation.ExtractedCuratedVersionParts;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import com.metaeffekt.artifact.analysis.version.curation.VersionContextMatcher;
import com.metaeffekt.artifact.analysis.version.curation.functions.CuratedVersionFunction;
import com.metaeffekt.artifact.analysis.version.token.VersionToken;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenType;
import com.metaeffekt.artifact.analysis.version.token.VersionTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalCuratedVersionPartsExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalCuratedVersionPartsExtractor.class);
    private final VersionContextMatcher matcher;
    private final Pattern pattern;
    private final String specVersion;
    private final String semVersion;
    private final String buildVersion;
    private final String versionModifier;
    private final String otherVersionPart;
    private final String afterAllPart;
    private final String preprocessingPattern;
    private final List<CuratedVersionFunction> postProcessingFunctions;
    private static final Pattern __YEAR__ = Pattern.compile("[0-9]{4}");
    private static final Pattern __SEMVER__ = Pattern.compile("[0-9]+\\.[0-9]+(?:\\.[0-9]+)*?");
    private static final Pattern __NUMBER__ = Pattern.compile("[0-9]+");
    private static final Pattern __LETTER__ = Pattern.compile("[a-zA-Z]+");
    private static final Pattern __SEPARATOR__ = Pattern.compile("[-_ :]");

    public ConditionalCuratedVersionPartsExtractor(VersionContextMatcher matcher, String pattern, int patternFlags, String specVersion, String semVersion, String buildVersion, String versionModifier, String otherVersionPart, String afterAllPart, String preprocessingPattern, List<CuratedVersionFunction> postProcessingFunctions) {
        this.matcher = matcher;
        this.pattern = pattern == null ? null : Pattern.compile(pattern, patternFlags);
        this.specVersion = specVersion;
        this.semVersion = semVersion;
        this.buildVersion = buildVersion;
        this.versionModifier = versionModifier;
        this.otherVersionPart = otherVersionPart;
        this.afterAllPart = afterAllPart;
        this.preprocessingPattern = preprocessingPattern;
        this.postProcessingFunctions = postProcessingFunctions;
    }

    private static int parsePatternFlags(String patternFlagsString) {
        int patternFlags = 0;
        if (patternFlagsString != null) {
            block7: for (char c : patternFlagsString.toCharArray()) {
                switch (c) {
                    case 'i': {
                        patternFlags |= 2;
                        continue block7;
                    }
                    case 'm': {
                        patternFlags |= 8;
                        continue block7;
                    }
                    case 's': {
                        patternFlags |= 0x20;
                        continue block7;
                    }
                    case 'u': {
                        patternFlags |= 0x40;
                        continue block7;
                    }
                    case 'x': {
                        patternFlags |= 4;
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown pattern flag: " + c);
                    }
                }
            }
        }
        return patternFlags;
    }

    public ExtractedCuratedVersionParts applyFirstStep(String version, VersionContext context) {
        if (this.matcher != null && !this.matcher.matches(context)) {
            return null;
        }
        Matcher matcher = this.matcherForExtractorPattern(version);
        if (matcher != null && matcher.matches()) {
            if (this.preprocessingPattern != null) {
                return new ExtractedCuratedVersionParts(this.applyPreprocessingPattern(matcher));
            }
            return new ExtractedCuratedVersionParts(this.applySpecVersion(matcher), this.applySemVersion(matcher), this.applyBuildVersion(matcher), this.applyVersionModifier(matcher), this.applyOtherVersionPart(matcher), this.applyAfterAllPart(matcher));
        }
        return null;
    }

    public void applySecondStep(ExtractedCuratedVersionParts parts) {
        if (parts == null) {
            return;
        }
        for (CuratedVersionFunction function : this.postProcessingFunctions) {
            function.apply(parts);
        }
    }

    public boolean matches(String version, VersionContext context) {
        if (this.matcher != null && !this.matcher.matches(context)) {
            return false;
        }
        if (this.pattern == null) {
            return true;
        }
        Matcher matcher = this.matcherForExtractorPattern(version);
        return matcher != null && matcher.matches();
    }

    private Matcher matcherForExtractorPattern(String version) {
        if (version == null || this.pattern == null) {
            return null;
        }
        return this.pattern.matcher(version);
    }

    private VersionToken applySpecVersion(Matcher matcher) {
        return this.applyTokenization(this.applyPattern(matcher, this.specVersion));
    }

    private VersionToken applySemVersion(Matcher matcher) {
        return this.applyTokenization(this.applyPattern(matcher, this.semVersion));
    }

    private VersionToken applyBuildVersion(Matcher matcher) {
        return this.applyTokenization(this.applyPattern(matcher, this.buildVersion));
    }

    private VersionToken applyVersionModifier(Matcher matcher) {
        return this.applyTokenization(this.applyPattern(matcher, this.versionModifier));
    }

    private VersionToken applyOtherVersionPart(Matcher matcher) {
        return this.applyTokenization(this.applyPattern(matcher, this.otherVersionPart));
    }

    private VersionToken applyAfterAllPart(Matcher matcher) {
        return this.applyTokenization(this.applyPattern(matcher, this.afterAllPart));
    }

    private String applyPreprocessingPattern(Matcher matcher) {
        return this.applyPattern(matcher, this.preprocessingPattern);
    }

    private VersionToken applyTokenization(String str) {
        List<VersionToken> tokenizedVersion = VersionTokenizer.tokenize(str, null);
        if (tokenizedVersion.size() == 1) {
            return tokenizedVersion.get(0);
        }
        if (!tokenizedVersion.isEmpty()) {
            return new VersionToken(str, VersionTokenType.STRING);
        }
        return null;
    }

    private String applyPattern(Matcher matcher, String replacement) {
        if (replacement == null) {
            return null;
        }
        return matcher.replaceAll(replacement);
    }

    public JSONObject toJson() {
        return new JSONObject().put("pattern", this.pattern == null ? null : this.pattern.pattern()).put("pattern-flags", this.pattern == null ? null : Integer.valueOf(this.pattern.flags())).put("segments", (Object)new JSONObject().put("spec", (Object)this.specVersion).put("sem", (Object)this.semVersion).put("build", (Object)this.buildVersion).put("modifier", (Object)this.versionModifier).put("other", (Object)this.otherVersionPart).put("after-all", (Object)this.afterAllPart).put("full", (Object)this.preprocessingPattern)).put("context", this.matcher == null ? null : this.matcher.toJson()).put("second-part-functions", (Collection)this.postProcessingFunctions.stream().map(CuratedVersionFunction::toJson).collect(Collectors.toList()));
    }

    public static ConditionalCuratedVersionPartsExtractor fromYaml(Map<String, Object> yaml) {
        VersionContextMatcher matcher;
        String afterAllPart;
        String otherVersionPart;
        String versionModifier;
        String buildVersion;
        String semVersion;
        String specVersion;
        String pattern = (String)yaml.get("pattern");
        String patternFlagsString = (String)yaml.get("pattern-flags");
        int patternFlags = ConditionalCuratedVersionPartsExtractor.parsePatternFlags(patternFlagsString);
        Map segments = (Map)yaml.get("segments");
        if (segments != null) {
            specVersion = (String)segments.get("spec");
            semVersion = (String)segments.get("sem");
            buildVersion = (String)segments.get("build");
            versionModifier = (String)segments.get("modifier");
            otherVersionPart = (String)segments.get("other");
            afterAllPart = (String)segments.get("after-all");
        } else {
            specVersion = null;
            semVersion = null;
            buildVersion = null;
            versionModifier = null;
            otherVersionPart = null;
            afterAllPart = null;
        }
        String preprocessorPart = (String)yaml.get("preprocessor");
        if (yaml.containsKey("context")) {
            if (yaml.get("context") instanceof LinkedHashMap) {
                matcher = VersionContextMatcher.fromYaml((Map)yaml.get("context"));
            } else {
                LOG.warn("Invalid context definition in extractor: {}", yaml.get("context"));
                matcher = null;
            }
        } else {
            matcher = null;
        }
        String effectivePattern = StringUtils.isEmpty(pattern) ? null : pattern.replace("__YEAR__", __YEAR__.pattern()).replace("__SEMVER__", __SEMVER__.pattern()).replace("__LETTER__", __LETTER__.pattern()).replace("__SEPARATOR__", __SEPARATOR__.pattern()).replace("__NUMBER__", __NUMBER__.pattern());
        ArrayList<CuratedVersionFunction> postProcessingFunctions = new ArrayList<CuratedVersionFunction>();
        if (yaml.containsKey("functions") && yaml.get("functions") instanceof List) {
            for (Object function : (List)yaml.get("functions")) {
                if (!(function instanceof LinkedHashMap)) continue;
                postProcessingFunctions.add(CuratedVersionFunction.fromYaml((LinkedHashMap)function));
            }
        }
        postProcessingFunctions.removeIf(Objects::isNull);
        return new ConditionalCuratedVersionPartsExtractor(matcher, effectivePattern, patternFlags, specVersion, semVersion, buildVersion, versionModifier, otherVersionPart, afterAllPart, preprocessorPart, postProcessingFunctions);
    }
}

