/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparisonFilterAttribute
extends FilterAttribute {
    private static final Logger log = LoggerFactory.getLogger(ComparisonFilterAttribute.class);
    private final String comparisonOperator;
    private final FilterAttribute leftOperand;
    private final FilterAttribute rightOperand;

    public ComparisonFilterAttribute(List<Object> tokens) {
        int operatorIndex = -1;
        for (int i = 0; i < tokens.size(); ++i) {
            if (!(tokens.get(i) instanceof String) || !((String)tokens.get(i)).matches("^(>|>=|<|<=|==|!=|contains|matches)$")) continue;
            operatorIndex = i;
            break;
        }
        if (operatorIndex == -1) {
            throw new IllegalArgumentException("No comparison operator found in " + tokens);
        }
        this.comparisonOperator = (String)tokens.get(operatorIndex);
        this.leftOperand = super.getFilterAttributeOrParse(tokens.subList(0, operatorIndex));
        this.rightOperand = super.getFilterAttributeOrParse(tokens.subList(operatorIndex + 1, tokens.size()));
    }

    @Override
    public Object evaluate(Vulnerability vulnerability) {
        Object leftValue = this.leftOperand.evaluate(vulnerability);
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        Object result = this.evaluate(leftValue, rightValue);
        if (VulnerabilityStatus.LOG_MATCHING_CRITERIA) {
            log.info("ComparisonFilterAttribute.evaluate(Vulnerability) - [{}] - [{}] --> [{}]", new Object[]{vulnerability.getId(), this, result});
        }
        return result;
    }

    @Override
    @Deprecated
    public Object evaluate(VulnerabilityMetaData vulnerability) {
        Object leftValue = this.leftOperand.evaluate(vulnerability);
        Object rightValue = this.rightOperand.evaluate(vulnerability);
        return this.evaluate(leftValue, rightValue);
    }

    private Object evaluate(Object left, Object right) {
        switch (this.comparisonOperator) {
            case ">": {
                return this.parseDouble(left) > this.parseDouble(right);
            }
            case ">=": {
                return this.parseDouble(left) >= this.parseDouble(right);
            }
            case "<": {
                return this.parseDouble(left) < this.parseDouble(right);
            }
            case "<=": {
                return this.parseDouble(left) <= this.parseDouble(right);
            }
            case "==": {
                return left.equals(right);
            }
            case "!=": {
                return !left.equals(right);
            }
            case "contains": {
                return left.toString().contains(right.toString());
            }
            case "matches": {
                return left.toString().matches(right.toString());
            }
        }
        throw new IllegalArgumentException("Unknown comparison operator " + this.comparisonOperator);
    }

    @Override
    public String toString() {
        return "<" + this.leftOperand + " " + this.comparisonOperator + " " + this.rightOperand + ">";
    }
}

