/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus;

import com.metaeffekt.artifact.analysis.utils.CustomCollectors;
import com.metaeffekt.artifact.analysis.utils.JsonSchemaValidator;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.utils.WildcardUtilities;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusReviewedEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation.VulnerabilityStatusValidation;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation.VulnerabilityStatusValidationException;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarnings;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.networknt.schema.SpecVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class VulnerabilityStatus {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityStatus.class);
    public static boolean LOG_MATCHING_CRITERIA = false;
    private VulnerabilityStatusValidation validation;
    private final Set<FilterAttribute> affectedVulnerabilitiesFilters = new HashSet<FilterAttribute>();
    private final Set<String> affectedVulnerabilities = new HashSet<String>();
    private final Set<String> affectedCpe = new HashSet<String>();
    private final Set<String> affectedCwe = new HashSet<String>();
    private Scope scope = Scope.ARTIFACT;
    File originYamlFile;
    private String title;
    private String acceptedBy;
    private String acceptedDate;
    private String reportedBy;
    private String reportedDate;
    private Cvss2 cvss2;
    private Cvss2 cvss2Lower;
    private Cvss2 cvss2Higher;
    private Cvss3P1 cvss3;
    private Cvss3P1 cvss3Lower;
    private Cvss3P1 cvss3Higher;
    private Cvss4P0 cvss4;
    private Cvss4P0 cvss4Lower;
    private Cvss4P0 cvss4Higher;
    private final List<VulnerabilityStatusReviewedEntry> reviewedAdvisories = new ArrayList<VulnerabilityStatusReviewedEntry>();
    private final Set<VulnerabilityStatusHistoryEntry> statusHistory = new TreeSet<VulnerabilityStatusHistoryEntry>();

    public VulnerabilityStatus setCvss2(Cvss2 cvss2) {
        this.cvss2 = cvss2;
        return this;
    }

    public VulnerabilityStatus setCvss3P1(Cvss3P1 cvss3) {
        this.cvss3 = cvss3;
        return this;
    }

    public void setCvss3P1Lower(Cvss3P1 cvss3Lower) {
        this.cvss3Lower = cvss3Lower;
    }

    public void setCvss3P1Higher(Cvss3P1 cvss3Higher) {
        this.cvss3Higher = cvss3Higher;
    }

    public VulnerabilityStatus setCvss4(Cvss4P0 cvss4) {
        this.cvss4 = cvss4;
        return this;
    }

    public VulnerabilityStatus setScope(Scope scope) {
        this.scope = scope;
        this.statusHistory.forEach(e -> e.setScope(this.scope));
        return this;
    }

    public VulnerabilityStatus setScope(String scope) {
        this.scope = Scope.fromString(scope);
        this.statusHistory.forEach(e -> e.setScope(this.scope));
        return this;
    }

    public VulnerabilityStatus setAcceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
        return this;
    }

    public VulnerabilityStatus setAcceptedDate(String acceptedDate) {
        this.acceptedDate = acceptedDate;
        return this;
    }

    public VulnerabilityStatus setReportedBy(String reportedBy) {
        this.reportedBy = reportedBy;
        return this;
    }

    public VulnerabilityStatus setReportedDate(String reportedDate) {
        this.reportedDate = reportedDate;
        return this;
    }

    public VulnerabilityStatus addReviewedAdvisoryEntry(String id, String comment) {
        return this.addReviewedAdvisoryEntry(new VulnerabilityStatusReviewedEntry(id, comment));
    }

    public VulnerabilityStatus addReviewedAdvisoryEntry(String id) {
        return this.addReviewedAdvisoryEntry(new VulnerabilityStatusReviewedEntry(id, null));
    }

    public VulnerabilityStatus addReviewedAdvisoryEntries(Collection<VulnerabilityStatusReviewedEntry> entries) {
        entries.forEach(this::addReviewedAdvisoryEntry);
        return this;
    }

    public VulnerabilityStatus addReviewedAdvisoryEntry(VulnerabilityStatusReviewedEntry entry) {
        Optional<VulnerabilityStatusReviewedEntry> existingEntry = this.reviewedAdvisories.stream().filter(e -> e.getId().equals(entry.getId())).findFirst();
        if (existingEntry.isPresent()) {
            String existingComment = existingEntry.get().getComment();
            if (StringUtils.hasText(existingComment) && StringUtils.hasText(entry.getComment())) {
                existingEntry.get().setComment(existingComment + "; " + entry.getComment());
            } else if (StringUtils.hasText(entry.getComment())) {
                existingEntry.get().setComment(entry.getComment());
            } else {
                existingEntry.get().setComment(existingComment);
            }
        } else {
            this.reviewedAdvisories.add(entry.clone());
        }
        return this;
    }

    public VulnerabilityStatus addAffectedCpe(String cpe) {
        if (!cpe.startsWith("cpe")) {
            LOG.warn("CPE in status file might not be a valid CPE identifier [{}]", this.affectedVulnerabilities);
        }
        this.affectedCpe.add(cpe);
        return this;
    }

    public VulnerabilityStatus addAffectedVulnerability(String vulnerability) {
        this.affectedVulnerabilities.add(vulnerability);
        return this;
    }

    public VulnerabilityStatus addAffectedVulnerabilitiesFilter(FilterAttribute filter) {
        this.affectedVulnerabilitiesFilters.add(filter);
        return this;
    }

    public VulnerabilityStatus addAffectedCwe(String cwe) {
        if (!cwe.startsWith("CWE")) {
            LOG.warn("CWE in status file might not be a valid CWE identifier [{}]", (Object)cwe);
        }
        this.affectedCwe.add(cwe);
        return this;
    }

    public VulnerabilityStatus addHistoryEntry(VulnerabilityStatusHistoryEntry entry) {
        this.statusHistory.add(entry);
        return this;
    }

    public VulnerabilityStatus addHistoryEntries(Collection<VulnerabilityStatusHistoryEntry> entries) {
        entries.forEach(this::addHistoryEntry);
        return this;
    }

    public VulnerabilityStatus removeHistoryEntry(VulnerabilityStatusHistoryEntry entry) {
        this.statusHistory.remove(entry);
        return this;
    }

    public VulnerabilityStatus clearHistoryEntries() {
        this.statusHistory.clear();
        return this;
    }

    public List<VulnerabilityStatusHistoryEntry> getStatusHistory() {
        return Collections.unmodifiableList(new ArrayList<VulnerabilityStatusHistoryEntry>(this.statusHistory));
    }

    public Set<VulnerabilityStatusHistoryEntry> getStatusHistorySet() {
        return this.statusHistory;
    }

    public Set<VulnerabilityStatusHistoryEntry> getStatusHistoryModifiable() {
        return this.statusHistory;
    }

    public VulnerabilityStatusHistoryEntry getLatestActiveStatusHistoryEntry() {
        return this.statusHistory.stream().filter(VulnerabilityStatusHistoryEntry::isActive).findFirst().orElse(null);
    }

    public boolean isLatestStatusHistoryEntryOfType(String type) {
        if (StringUtils.isEmpty(type)) {
            return false;
        }
        VulnerabilityStatusHistoryEntry latestEntry = this.getLatestActiveStatusHistoryEntry();
        if (latestEntry == null) {
            return false;
        }
        return type.equals(latestEntry.getStatus());
    }

    public Set<String> getAffectedVulnerabilitiesWithoutWildcards() {
        return this.affectedVulnerabilities.stream().filter(c -> !WildcardUtilities.isWildcardPattern(c)).collect(Collectors.toSet());
    }

    public List<VulnerabilityStatusReviewedEntry> getReviewedAdvisories(AdvisoryTypeIdentifier<?> type) {
        return this.reviewedAdvisories.stream().filter(a -> a.getAdvisor() == type).sorted(Comparator.comparing(e -> e.getAdvisor().name())).collect(Collectors.toList());
    }

    public Date getAcceptedDateAsDate() {
        return TimeUtils.tryParse(this.acceptedDate);
    }

    public Date getReportedDateAsDate() {
        return TimeUtils.tryParse(this.reportedDate);
    }

    public boolean hasReviewedAdvisories() {
        return !this.reviewedAdvisories.isEmpty();
    }

    public boolean hasReportedBy() {
        return StringUtils.hasText(this.reportedBy) || StringUtils.hasText(this.reportedDate);
    }

    public boolean hasAcceptedBy() {
        return StringUtils.hasText(this.acceptedBy) || StringUtils.hasText(this.acceptedDate);
    }

    public String generateAcceptedByDateString() {
        StringJoiner builder = new StringJoiner(" ");
        if (StringUtils.hasText(this.acceptedBy)) {
            builder.add(this.acceptedBy);
        } else {
            builder.add("no author");
        }
        if (StringUtils.hasText(this.acceptedDate)) {
            builder.add("(" + this.acceptedDate + ")");
        }
        return builder.toString();
    }

    public String generateReportedByDateString() {
        StringJoiner builder = new StringJoiner(" ");
        if (StringUtils.hasText(this.reportedBy)) {
            builder.add(this.reportedBy);
        } else {
            builder.add("no author");
        }
        if (StringUtils.hasText(this.reportedDate)) {
            builder.add("(" + this.reportedDate + ")");
        }
        return builder.toString();
    }

    public boolean hasAcceptedByInformation() {
        return StringUtils.hasText(this.acceptedBy) || StringUtils.hasText(this.acceptedDate);
    }

    public boolean hasReportedByInformation() {
        return StringUtils.hasText(this.reportedBy) || StringUtils.hasText(this.reportedDate);
    }

    public Cvss3P1 getCvss3P1() {
        return this.cvss3;
    }

    public Cvss3P1 getCvss3P1Lower() {
        return this.cvss3Lower;
    }

    public Cvss3P1 getCvss3P1Higher() {
        return this.cvss3Higher;
    }

    public boolean hasCvss2() {
        return this.isCvssDefined((MultiScoreCvssVector)this.cvss2);
    }

    public boolean hasCvss3P1() {
        return this.isCvssDefined((MultiScoreCvssVector)this.cvss3);
    }

    public boolean hasCvss4() {
        return this.isCvssDefined(this.cvss4);
    }

    public boolean hasCvss2Lower() {
        return this.isCvssDefined((MultiScoreCvssVector)this.cvss2Lower);
    }

    public boolean hasCvss2Higher() {
        return this.isCvssDefined((MultiScoreCvssVector)this.cvss2Higher);
    }

    public boolean hasCvss3P1Lower() {
        return this.isCvssDefined((MultiScoreCvssVector)this.cvss3Lower);
    }

    public boolean hasCvss3P1Higher() {
        return this.isCvssDefined((MultiScoreCvssVector)this.cvss3Higher);
    }

    public boolean hasAnyCvss2Information() {
        return this.hasCvss2() || this.hasCvss2Lower() || this.hasCvss2Higher();
    }

    public boolean hasAnyCvss3P1Information() {
        return this.hasCvss3P1() || this.hasCvss3P1Lower() || this.hasCvss3P1Higher();
    }

    public boolean hasAnyCvss4Information() {
        return this.hasCvss4() || this.hasCvss4Lower() || this.hasCvss4Higher();
    }

    public boolean hasCvss4Lower() {
        return this.isCvssDefined(this.cvss4Lower);
    }

    public boolean hasCvss4Higher() {
        return this.isCvssDefined(this.cvss4Higher);
    }

    private boolean isCvssDefined(MultiScoreCvssVector cvss) {
        return cvss != null && (cvss.isAnyBaseDefined() || cvss.isAnyTemporalDefined() || cvss.isAnyEnvironmentalDefined());
    }

    private boolean isCvssDefined(Cvss4P0 cvss) {
        return cvss != null && (cvss.isAnyBaseDefined() || cvss.isAnyThreatDefined() || cvss.isAnyEnvironmentalDefined());
    }

    private boolean isCvssDefined(CvssVector cvss) {
        return cvss != null && cvss.isAnyBaseDefined();
    }

    public void applyCvss2(Cvss2 cvss2) {
        if (cvss2 == null) {
            return;
        }
        cvss2.applyVector((CvssVector)this.cvss2);
        cvss2.applyVectorPartsIfHigher((CvssVector)this.cvss2Higher, CvssVector::getOverallScore);
        cvss2.applyVectorPartsIfLower((CvssVector)this.cvss2Lower, CvssVector::getOverallScore);
    }

    public void applyCvss3P1(Cvss3P1 cvss3) {
        if (cvss3 == null) {
            return;
        }
        cvss3.applyVector((CvssVector)this.cvss3);
        cvss3.applyVectorPartsIfHigher((CvssVector)this.cvss3Higher, CvssVector::getOverallScore);
        cvss3.applyVectorPartsIfLower((CvssVector)this.cvss3Lower, CvssVector::getOverallScore);
    }

    public void applyCvss4(Cvss4P0 cvss4) {
        if (cvss4 == null) {
            return;
        }
        cvss4.applyVector((CvssVector)this.cvss4);
        cvss4.applyVectorPartsIfHigher((CvssVector)this.cvss4Higher, CvssVector::getOverallScore);
        cvss4.applyVectorPartsIfLower((CvssVector)this.cvss4Lower, CvssVector::getOverallScore);
    }

    public boolean isScope(Scope scope) {
        return this.scope == scope;
    }

    public List<VulnerabilityStatusHistoryEntry> getLabelFilteredStatusHistory(Collection<String> activeLabels) {
        return this.statusHistory.stream().map(VulnerabilityStatusHistoryEntry::clone).peek(entry -> entry.setActive(entry.isIncluded(activeLabels))).sorted().collect(Collectors.toList());
    }

    public List<VulnerabilityStatusHistoryEntry> getLabelFilteredStatusHistory(String[] activeLabels) {
        return this.getLabelFilteredStatusHistory(Arrays.asList(activeLabels));
    }

    public MatchType affectsRetainCondition(Vulnerability vulnerability) {
        if (vulnerability == null) {
            throw new IllegalArgumentException("VulnerabilityMetaData must not be null");
        }
        return this.affectsRetainCondition(vulnerability, CommonEnumerationUtil.parseCpes(vulnerability.getAdditionalAttribute(VulnerabilityMetaData.Attribute.PRODUCT_URIS)), vulnerability.getCwes());
    }

    public boolean affects(Vulnerability vulnerability) {
        if (vulnerability == null) {
            throw new IllegalArgumentException("VulnerabilityMetaData must not be null");
        }
        return this.affects(vulnerability, CommonEnumerationUtil.parseCpes(vulnerability.getAdditionalAttribute(VulnerabilityMetaData.Attribute.PRODUCT_URIS)), vulnerability.getCwes());
    }

    public boolean affects(Vulnerability vulnerability, Collection<Cpe> vmdCpe, Collection<String> vmdCwe) {
        return this.affectsRetainCondition(vulnerability, vmdCpe, vmdCwe) != null;
    }

    public MatchType affectsRetainCondition(Vulnerability vulnerability, Collection<Cpe> vmdCpe, Collection<String> vmdCwe) {
        if (this.scope == Scope.INVENTORY) {
            return MatchType.INVENTORY_SCOPE;
        }
        if (vulnerability.getId() != null) {
            if (this.affectsByVulnerability(vulnerability)) {
                return MatchType.VULNERABILITY_NAME;
            }
            if (this.affectsByVulnerabilityFilter(vulnerability)) {
                return MatchType.FILTER_ATTRIBUTE;
            }
        }
        if (vmdCpe != null && this.affectsByCpe(vmdCpe)) {
            return MatchType.CPE;
        }
        if (vmdCwe != null && this.affectsByCwe(vmdCwe)) {
            return MatchType.CWE;
        }
        return null;
    }

    private boolean affectsByCpe(Collection<Cpe> vmdCpe) {
        for (String cpe : this.affectedCpe) {
            Cpe compareCpe = CommonEnumerationUtil.parseCpe(cpe).orElse(null);
            if (compareCpe == null) {
                LOG.warn("CPE [{}] not valid identifier", (Object)cpe);
            }
            for (Cpe vmdCpeEntry : vmdCpe) {
                if (!CommonEnumerationUtil.compareCpeUsingWildcards(vmdCpeEntry, compareCpe)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean affectsByCwe(Collection<String> vmdCwes) {
        for (String cwe : vmdCwes) {
            if (!this.affectedCwe.contains(cwe)) continue;
            return true;
        }
        return false;
    }

    private boolean affectsByVulnerability(Vulnerability vulnerability) {
        if (this.affectedVulnerabilities.contains(vulnerability.getId())) {
            if (this.affectedVulnerabilitiesFilters.isEmpty()) {
                return true;
            }
            return this.affectsByVulnerabilityFilter(vulnerability);
        }
        for (Pattern pattern : this.affectedVulnerabilities.stream().filter(WildcardUtilities::isWildcardPattern).map(WildcardUtilities::convertWildcardStringToPattern).collect(Collectors.toList())) {
            if (!pattern.matcher(vulnerability.getId()).matches()) continue;
            if (this.affectedVulnerabilitiesFilters.isEmpty()) {
                return true;
            }
            return this.affectsByVulnerabilityFilter(vulnerability);
        }
        return false;
    }

    private boolean affectsByVulnerabilityFilter(Vulnerability vulnerability) {
        if (this.affectedVulnerabilitiesFilters.isEmpty()) {
            return false;
        }
        if (LOG_MATCHING_CRITERIA) {
            LOG.info("Checking vulnerability [{}] against filter attributes: {}", (Object)vulnerability.getId(), (Object)this.affectedVulnerabilitiesFilters.stream().map(FilterAttribute::toString).map(fa -> fa.replace("\n", "\\n")).collect(Collectors.joining(", ")));
        }
        for (FilterAttribute filter : this.affectedVulnerabilitiesFilters) {
            if (!filter.matches(vulnerability)) continue;
            if (LOG_MATCHING_CRITERIA) {
                LOG.info("Vulnerability [{}] matches filter attribute: {}", (Object)vulnerability.getId(), (Object)filter);
            }
            return true;
        }
        return false;
    }

    public void reorderChronologically(Vulnerability vulnerability, boolean isInsignificant, double insignificantThreshold) {
        List<VulnerabilityStatusHistoryEntry> reordered = VulnerabilityStatusHistoryEntry.reorderChronologically(this, vulnerability, isInsignificant, insignificantThreshold);
        this.statusHistory.clear();
        this.statusHistory.addAll(reordered);
    }

    public void checkValidation(Inventory inventory, Vulnerability vulnerability, boolean failOnValidationError) {
        if (this.validation != null) {
            if (inventory == null) {
                LOG.warn("Inventory is null, skipping validation on status file {}", (Object)this.originYamlFile);
            }
            try {
                this.validation.validateInventory(inventory, vulnerability.getId());
            }
            catch (VulnerabilityStatusValidationException e) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("Vulnerability status validation failed on vulnerability ").append(vulnerability.getId()).append(": ").append(e.getMessage());
                if (this.originYamlFile != null) {
                    errorMessage.append("\nfrom status file ").append(this.originYamlFile);
                }
                if (failOnValidationError) {
                    throw new RuntimeException(errorMessage.toString(), e);
                }
                LOG.error(errorMessage.toString(), (Throwable)e);
                new InventoryWarnings(inventory).addVulnerabilityWarning(new InventoryWarningEntry<VulnerabilityMetaData>((VulnerabilityMetaData)vulnerability.toBaseModel(), "Vulnerability status validation failed: " + e.getMessage(), this.originYamlFile.getAbsolutePath()));
            }
        }
    }

    public void applyToVulnerability(Vulnerability vulnerability) {
        JSONArray outputReviewedAdvisoriesJson;
        if (vulnerability == null) {
            throw new IllegalArgumentException("Vulnerability must not be null");
        }
        vulnerability.setVulnerabilityStatus(this);
        vulnerability.clearNonTransferableStatusDetails();
        if (!this.reviewedAdvisories.isEmpty() && !(outputReviewedAdvisoriesJson = VulnerabilityStatusReviewedEntry.toJsonArray(this.reviewedAdvisories)).isEmpty()) {
            vulnerability.setAdditionalAttribute(InventoryAttribute.REVIEWED_ADVISORIES, outputReviewedAdvisoriesJson.toString());
        }
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss2.class, this::hasCvss2, this::getCvss2, KnownCvssEntities.ASSESSMENT_ALL);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss2.class, this::hasCvss2Lower, this::getCvss2Lower, KnownCvssEntities.ASSESSMENT_LOWER);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss2.class, this::hasCvss2Higher, this::getCvss2Higher, KnownCvssEntities.ASSESSMENT_HIGHER);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss3P1.class, this::hasCvss3P1, this::getCvss3P1, KnownCvssEntities.ASSESSMENT_ALL);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss3P1.class, this::hasCvss3P1Lower, this::getCvss3P1Lower, KnownCvssEntities.ASSESSMENT_LOWER);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss3P1.class, this::hasCvss3P1Higher, this::getCvss3P1Higher, KnownCvssEntities.ASSESSMENT_HIGHER);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss4P0.class, this::hasCvss4, this::getCvss4, KnownCvssEntities.ASSESSMENT_ALL);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss4P0.class, this::hasCvss4Lower, this::getCvss4Lower, KnownCvssEntities.ASSESSMENT_LOWER);
        VulnerabilityStatus.setCvssVectorIfPresent(vulnerability, Cvss4P0.class, this::hasCvss4Higher, this::getCvss4Higher, KnownCvssEntities.ASSESSMENT_HIGHER);
        List<VulnerabilityStatusHistoryEntry> exportHistory = this.getStatusHistory();
        if (!exportHistory.isEmpty()) {
            JSONArray historyJson = exportHistory.stream().map(VulnerabilityStatusHistoryEntry::toJson).collect(CustomCollectors.toJsonArray());
            vulnerability.setAdditionalAttribute(InventoryAttribute.STATUS_HISTORY.getKey(), historyJson.toString());
        }
        if (this.acceptedBy != null || this.acceptedDate != null) {
            vulnerability.setAdditionalAttribute(InventoryAttribute.STATUS_ACCEPTED.getKey(), this.generateAcceptedByDateString());
        } else {
            vulnerability.setAdditionalAttribute(InventoryAttribute.STATUS_ACCEPTED.getKey(), null);
        }
        if (this.reportedBy != null || this.reportedDate != null) {
            vulnerability.setAdditionalAttribute(InventoryAttribute.STATUS_REPORTED.getKey(), this.generateReportedByDateString());
        } else {
            vulnerability.setAdditionalAttribute(InventoryAttribute.STATUS_REPORTED.getKey(), null);
        }
        if (this.title != null) {
            vulnerability.setAdditionalAttribute(InventoryAttribute.STATUS_TITLE.getKey(), this.title);
        } else {
            vulnerability.setAdditionalAttribute(InventoryAttribute.STATUS_TITLE.getKey(), null);
        }
        VulnerabilityStatusHistoryEntry latestHistoryEntry = this.getLatestActiveStatusHistoryEntry();
        if (latestHistoryEntry != null) {
            vulnerability.setAdditionalAttribute(VulnerabilityMetaData.Attribute.STATUS, latestHistoryEntry.getStatus());
            vulnerability.setAdditionalAttribute(VulnerabilityMetaData.Attribute.RATIONALE, latestHistoryEntry.getRationale());
            vulnerability.setAdditionalAttribute(VulnerabilityMetaData.Attribute.RISK, latestHistoryEntry.getRisk());
            vulnerability.setAdditionalAttribute(InventoryAttribute.MEASURES.getKey(), latestHistoryEntry.getMeasures());
        } else {
            vulnerability.setAdditionalAttribute(VulnerabilityMetaData.Attribute.STATUS, null);
            vulnerability.setAdditionalAttribute(VulnerabilityMetaData.Attribute.RATIONALE, null);
            vulnerability.setAdditionalAttribute(VulnerabilityMetaData.Attribute.RISK, null);
            vulnerability.setAdditionalAttribute(InventoryAttribute.MEASURES.getKey(), null);
        }
    }

    public void appendToVulnerabilityStatus(VulnerabilityStatus appendToStatus, Collection<String> activeLabels) {
        this.appendAllExceptStatusHistoryToVulnerabilityStatus(appendToStatus);
        this.appendStatusHistoryOnlyToVulnerabilityStatus(appendToStatus, activeLabels);
    }

    public void appendAllExceptStatusHistoryToVulnerabilityStatus(VulnerabilityStatus appendToStatus) {
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss2, this::getCvss2, appendToStatus::setCvss2);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss2Lower, this::getCvss2Lower, appendToStatus::setCvss2Lower);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss2Higher, this::getCvss2Higher, appendToStatus::setCvss2Higher);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss3P1, this::getCvss3P1, appendToStatus::setCvss3P1);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss3P1Lower, this::getCvss3P1Lower, appendToStatus::setCvss3P1Lower);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss3P1Higher, this::getCvss3P1Higher, appendToStatus::setCvss3P1Higher);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss4, this::getCvss4, appendToStatus::setCvss4);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss4Lower, this::getCvss4Lower, appendToStatus::setCvss4Lower);
        VulnerabilityStatus.setCvssVectorIfPresent(this::hasCvss4Higher, this::getCvss4Higher, appendToStatus::setCvss4Higher);
        if (this.hasReviewedAdvisories()) {
            appendToStatus.addReviewedAdvisoryEntries(this.reviewedAdvisories);
        }
        if (this.acceptedBy != null) {
            appendToStatus.setAcceptedBy(this.acceptedBy);
        }
        if (this.acceptedDate != null) {
            appendToStatus.setAcceptedDate(this.acceptedDate);
        }
        if (this.reportedBy != null) {
            appendToStatus.setReportedBy(this.reportedBy);
        }
        if (this.reportedDate != null) {
            appendToStatus.setReportedDate(this.reportedDate);
        }
        if (this.title != null) {
            appendToStatus.setTitle(this.title);
        }
        appendToStatus.getAffectedCpe().addAll(this.affectedCpe);
        appendToStatus.getAffectedVulnerabilities().addAll(this.affectedVulnerabilities);
        appendToStatus.getAffectedVulnerabilitiesFilters().addAll(this.affectedVulnerabilitiesFilters);
        appendToStatus.getAffectedCwe().addAll(this.affectedCwe);
    }

    public void appendStatusHistoryOnlyToVulnerabilityStatus(VulnerabilityStatus appendToStatus, Collection<String> activeLabels) {
        List<VulnerabilityStatusHistoryEntry> exportHistory = this.getLabelFilteredStatusHistory(activeLabels);
        appendToStatus.addHistoryEntries(exportHistory);
    }

    private static <T extends CvssVector> void setCvssVectorIfPresent(Supplier<Boolean> hasCvss, Supplier<T> getCvss, Consumer<T> setStatusCvss) {
        if (hasCvss.get().booleanValue()) {
            setStatusCvss.accept(getCvss.get());
        }
    }

    private static <T extends CvssVector> void setCvssVectorIfPresent(Vulnerability vulnerability, Class<T> clazz, Supplier<Boolean> hasCvss, Supplier<T> getCvss, CvssSource.CvssEntity entity) {
        if (hasCvss.get().booleanValue()) {
            CvssVector vector = ((CvssVector)getCvss.get()).deriveAddSource(new CvssSource(KnownCvssEntities.ASSESSMENT, entity, clazz));
            vulnerability.getCvssVectors().addCvssVector(vector);
        }
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put("cvss2", this.cvss2 != null ? String.valueOf(this.cvss2) : null);
        json.put("cvss2Lower", this.cvss2Lower != null ? String.valueOf(this.cvss2Lower) : null);
        json.put("cvss2Higher", this.cvss2Higher != null ? String.valueOf(this.cvss2Higher) : null);
        json.put("cvss3", this.cvss3 != null ? String.valueOf(this.cvss3) : null);
        json.put("cvss3Lower", this.cvss3Lower != null ? String.valueOf(this.cvss3Lower) : null);
        json.put("cvss3Higher", this.cvss3Higher != null ? String.valueOf(this.cvss3Higher) : null);
        json.put("cvss4", this.cvss4 != null ? String.valueOf(this.cvss4) : null);
        json.put("cvss4Lower", this.cvss4Lower != null ? String.valueOf(this.cvss4Lower) : null);
        json.put("cvss4Higher", this.cvss4Higher != null ? String.valueOf(this.cvss4Higher) : null);
        JSONArray reviewed = this.reviewedAdvisories.stream().map(VulnerabilityStatusReviewedEntry::toJson).collect(JSONArray::new, JSONArray::put, JSONArray::putAll);
        json.put("reviewedAdvisories", (Object)reviewed);
        JSONArray history = this.statusHistory.stream().map(VulnerabilityStatusHistoryEntry::toJson).collect(JSONArray::new, JSONArray::put, JSONArray::putAll);
        json.put("statusHistory", (Object)history);
        json.put("acceptedBy", (Object)this.acceptedBy);
        json.put("acceptedDate", (Object)this.acceptedDate);
        json.put("reportedBy", (Object)this.reportedBy);
        json.put("reportedDate", (Object)this.reportedDate);
        json.put("title", (Object)this.title);
        JSONArray affectedVulnerabilities = this.affectedVulnerabilities.stream().collect(JSONArray::new, JSONArray::put, JSONArray::putAll);
        json.put("affectedVulnerabilities", (Object)affectedVulnerabilities);
        JSONArray affectedCpe = this.affectedCpe.stream().collect(JSONArray::new, JSONArray::put, JSONArray::putAll);
        json.put("affectedCpe", (Object)affectedCpe);
        JSONArray affectedCwe = this.affectedCwe.stream().collect(JSONArray::new, JSONArray::put, JSONArray::putAll);
        json.put("affectedCwe", (Object)affectedCwe);
        json.put("scope", (Object)this.scope);
        return json;
    }

    public void appendFromJson(JSONObject json) {
        JSONArray affectedCwe;
        JSONArray affectedCpe;
        JSONArray history;
        this.setCvss2(new Cvss2(json.optString("cvss2", null)));
        this.setCvss2Lower(new Cvss2(json.optString("cvss2Lower", null)));
        this.setCvss2Higher(new Cvss2(json.optString("cvss2Higher", null)));
        this.setCvss3P1(new Cvss3P1(json.optString("cvss3", null)));
        this.setCvss3P1Lower(new Cvss3P1(json.optString("cvss3Lower", null)));
        this.setCvss3P1Higher(new Cvss3P1(json.optString("cvss3Higher", null)));
        this.setCvss4(new Cvss4P0(json.optString("cvss4", null)));
        this.setCvss4Lower(new Cvss4P0(json.optString("cvss4Lower", null)));
        this.setCvss4Higher(new Cvss4P0(json.optString("cvss4Higher", null)));
        JSONArray reviewed = json.optJSONArray("reviewedAdvisories");
        if (reviewed != null) {
            for (int i = 0; i < reviewed.length(); ++i) {
                this.getReviewedAdvisories().add(VulnerabilityStatusReviewedEntry.fromMap(reviewed.getJSONObject(i).toMap()));
            }
        }
        if ((history = json.optJSONArray("statusHistory")) != null) {
            for (int i = 0; i < history.length(); ++i) {
                this.addHistoryEntry(VulnerabilityStatusHistoryEntry.fromMap(history.getJSONObject(i).toMap()));
            }
        }
        this.setAcceptedBy(json.optString("acceptedBy", null));
        this.setAcceptedDate(json.optString("acceptedDate", null));
        this.setReportedBy(json.optString("reportedBy", null));
        this.setReportedDate(json.optString("reportedDate", null));
        this.setTitle(json.optString("title", null));
        JSONArray affectedVulnerabilities = json.optJSONArray("affectedVulnerabilities");
        if (affectedVulnerabilities != null) {
            for (int i = 0; i < affectedVulnerabilities.length(); ++i) {
                this.addAffectedVulnerability(affectedVulnerabilities.getString(i));
            }
        }
        if ((affectedCpe = json.optJSONArray("affectedCpe")) != null) {
            for (int i = 0; i < affectedCpe.length(); ++i) {
                this.addAffectedCpe(affectedCpe.getString(i));
            }
        }
        if ((affectedCwe = json.optJSONArray("affectedCwe")) != null) {
            for (int i = 0; i < affectedCwe.length(); ++i) {
                this.addAffectedCwe(affectedCwe.getString(i));
            }
        }
        this.setScope(Scope.fromString(json.optString("scope", null)));
    }

    public String toString() {
        return "VulnerabilityStatus{statusHistory=" + this.statusHistory + ", validation=" + this.validation + ", affectedVulnerabilities=" + this.affectedVulnerabilities + ", affectedCpe=" + this.affectedCpe + ", affectedCwe=" + this.affectedCwe + ", reviewedAdvisories=" + this.reviewedAdvisories + ", title='" + this.title + '\'' + ", acceptedBy='" + this.acceptedBy + '\'' + ", acceptedDate='" + this.acceptedDate + '\'' + ", reportedBy='" + this.reportedBy + '\'' + ", reportedDate='" + this.reportedDate + '\'' + ", scope=" + (Object)((Object)this.scope) + ", originYamlFile=" + this.originYamlFile + '}';
    }

    public static List<VulnerabilityStatusHistoryEntry> mergeStatusHistoryEntries(Collection<Collection<VulnerabilityStatusHistoryEntry>> entries) {
        return entries.stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public static Set<VulnerabilityStatus> findAffectedEntries(Collection<VulnerabilityStatus> vulnerabilityStatusHistories, Vulnerability vulnerability) {
        return vulnerabilityStatusHistories.stream().filter(Objects::nonNull).filter(vsh -> vsh.affects(vulnerability)).collect(Collectors.toSet());
    }

    public static Map<MatchType, List<VulnerabilityStatus>> findAffectedEntriesRetainMatchingCondition(Collection<VulnerabilityStatus> vulnerabilityStatuses, Vulnerability vulnerability) {
        LinkedHashMap<MatchType, List<VulnerabilityStatus>> result = new LinkedHashMap<MatchType, List<VulnerabilityStatus>>();
        for (VulnerabilityStatus vulnerabilityStatus : vulnerabilityStatuses) {
            MatchType matchType = vulnerabilityStatus.affectsRetainCondition(vulnerability);
            if (matchType == null) continue;
            result.computeIfAbsent(matchType, k -> new ArrayList()).add(vulnerabilityStatus);
            if (!LOG_MATCHING_CRITERIA) continue;
            LOG.info("Vulnerability [{}] uses match type [{}] for status [{}]", new Object[]{vulnerability.getId(), matchType, vulnerabilityStatus.getOriginYamlFile() == null ? "with " + vulnerabilityStatus.statusHistory.size() + " status history entries " : vulnerabilityStatus.getOriginYamlFile().getName()});
        }
        return result;
    }

    public static void assertVulnerabilityStatusFileValid(File file, CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        try {
            JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, "specification/jsonschema/vulnerability-status.json", SpecVersion.VersionFlag.V201909, "Vulnerability Status YAML", jsonSchemaValidationErrorsHandling);
        }
        catch (RuntimeException mapTypeException) {
            JsonSchemaValidator.assertResourceSchemaAppliesToYamlFile(file, "specification/jsonschema/vulnerability-status-array.json", SpecVersion.VersionFlag.V201909, "Vulnerability Status ARRAY YAML", jsonSchemaValidationErrorsHandling);
        }
    }

    public void setValidation(VulnerabilityStatusValidation validation) {
        this.validation = validation;
    }

    public void setOriginYamlFile(File originYamlFile) {
        this.originYamlFile = originYamlFile;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCvss2Lower(Cvss2 cvss2Lower) {
        this.cvss2Lower = cvss2Lower;
    }

    public void setCvss2Higher(Cvss2 cvss2Higher) {
        this.cvss2Higher = cvss2Higher;
    }

    public void setCvss3(Cvss3P1 cvss3) {
        this.cvss3 = cvss3;
    }

    public void setCvss3Lower(Cvss3P1 cvss3Lower) {
        this.cvss3Lower = cvss3Lower;
    }

    public void setCvss3Higher(Cvss3P1 cvss3Higher) {
        this.cvss3Higher = cvss3Higher;
    }

    public void setCvss4Lower(Cvss4P0 cvss4Lower) {
        this.cvss4Lower = cvss4Lower;
    }

    public void setCvss4Higher(Cvss4P0 cvss4Higher) {
        this.cvss4Higher = cvss4Higher;
    }

    public VulnerabilityStatusValidation getValidation() {
        return this.validation;
    }

    public Set<FilterAttribute> getAffectedVulnerabilitiesFilters() {
        return this.affectedVulnerabilitiesFilters;
    }

    public Set<String> getAffectedVulnerabilities() {
        return this.affectedVulnerabilities;
    }

    public Set<String> getAffectedCpe() {
        return this.affectedCpe;
    }

    public Set<String> getAffectedCwe() {
        return this.affectedCwe;
    }

    public Scope getScope() {
        return this.scope;
    }

    public File getOriginYamlFile() {
        return this.originYamlFile;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAcceptedBy() {
        return this.acceptedBy;
    }

    public String getAcceptedDate() {
        return this.acceptedDate;
    }

    public String getReportedBy() {
        return this.reportedBy;
    }

    public String getReportedDate() {
        return this.reportedDate;
    }

    public Cvss2 getCvss2() {
        return this.cvss2;
    }

    public Cvss2 getCvss2Lower() {
        return this.cvss2Lower;
    }

    public Cvss2 getCvss2Higher() {
        return this.cvss2Higher;
    }

    public Cvss3P1 getCvss3() {
        return this.cvss3;
    }

    public Cvss3P1 getCvss3Lower() {
        return this.cvss3Lower;
    }

    public Cvss3P1 getCvss3Higher() {
        return this.cvss3Higher;
    }

    public Cvss4P0 getCvss4() {
        return this.cvss4;
    }

    public Cvss4P0 getCvss4Lower() {
        return this.cvss4Lower;
    }

    public Cvss4P0 getCvss4Higher() {
        return this.cvss4Higher;
    }

    public List<VulnerabilityStatusReviewedEntry> getReviewedAdvisories() {
        return this.reviewedAdvisories;
    }

    public static enum MatchType {
        INVENTORY_SCOPE,
        VULNERABILITY_NAME,
        CPE,
        CWE,
        FILTER_ATTRIBUTE;


        public static <T extends Collection<VulnerabilityStatus>> T findHighestPriority(Map<MatchType, T> affectedEntries) {
            if (affectedEntries.containsKey((Object)INVENTORY_SCOPE)) {
                return (T)((Collection)affectedEntries.get((Object)INVENTORY_SCOPE));
            }
            if (affectedEntries.containsKey((Object)VULNERABILITY_NAME)) {
                return (T)((Collection)affectedEntries.get((Object)VULNERABILITY_NAME));
            }
            if (affectedEntries.containsKey((Object)CPE)) {
                return (T)((Collection)affectedEntries.get((Object)CPE));
            }
            if (affectedEntries.containsKey((Object)CWE)) {
                return (T)((Collection)affectedEntries.get((Object)CWE));
            }
            if (affectedEntries.containsKey((Object)FILTER_ATTRIBUTE)) {
                return (T)((Collection)affectedEntries.get((Object)FILTER_ATTRIBUTE));
            }
            return null;
        }
    }

    public static enum Scope {
        ARTIFACT,
        INVENTORY;


        public static Scope fromString(String scope) {
            if (scope == null) {
                return ARTIFACT;
            }
            switch (scope.trim().toLowerCase()) {
                case "inventory": {
                    return INVENTORY;
                }
            }
            return ARTIFACT;
        }
    }
}

