/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.enrichment.vulnerability.VulnerabilityStatusPostProcessor;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VulnerabilityStatusHistoryEntry
implements Comparable<VulnerabilityStatusHistoryEntry>,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityStatusHistoryEntry.class);
    private String status;
    private String rationale;
    private String risk;
    private String measures;
    private String author;
    private Date date;
    private String[] includes;
    private String[] excludes;
    private Double score;
    private int priority = 0;
    private boolean active = true;
    private VulnerabilityStatus.Scope scope = VulnerabilityStatus.Scope.ARTIFACT;
    public static final VulnerabilityStatusHistoryEntry INSIGNIFICANT = new VulnerabilityStatusHistoryEntry("insignificant", "Vulnerability severity score is below insignificant threshold.", "", "", "", TimeUtils.formatNormalizedDate(new Date(System.currentTimeMillis())), null, null, null);
    public static final VulnerabilityStatusHistoryEntry VOID = new VulnerabilityStatusHistoryEntry("void", "The component affected by this vulnerability is not included in the current asset version.", "", "", "", TimeUtils.formatNormalizedDate(new Date(System.currentTimeMillis())), 0.0, null, null);
    public static final VulnerabilityStatusHistoryEntry IN_REVIEW = new VulnerabilityStatusHistoryEntry("in review", "The vulnerability has automatically been marked as in review.", "", "", "", TimeUtils.formatNormalizedDate(new Date(System.currentTimeMillis())), null, null, null);

    public VulnerabilityStatusHistoryEntry() {
    }

    public VulnerabilityStatusHistoryEntry(String status, String rationale, String risk, String measures, String author, String date, Double score, String[] includes, String[] excludes) {
        this.setStatus(status);
        this.rationale = rationale;
        this.risk = risk;
        this.measures = measures;
        this.author = author;
        this.score = score;
        this.includes = includes;
        this.excludes = excludes;
        this.setDate(date);
    }

    public VulnerabilityStatusHistoryEntry(String status, String rationale, String risk, String measures, String author, String date, double score, String[] includes, String[] excludes, boolean active, VulnerabilityStatus.Scope scope) {
        this(status, rationale, risk, measures, author, date, score, includes, excludes);
        this.active = active;
        this.scope = scope;
    }

    public static VulnerabilityStatusHistoryEntry fromMap(Map<String, Object> values) {
        VulnerabilityStatusHistoryEntry parsedEntry = new VulnerabilityStatusHistoryEntry();
        if (values.containsKey("status")) {
            parsedEntry.setStatus(values.get("status").toString());
        }
        if (values.containsKey("rationale")) {
            parsedEntry.rationale = values.get("rationale").toString();
        }
        if (values.containsKey("risk")) {
            parsedEntry.risk = values.get("risk").toString();
        }
        if (values.containsKey("measures")) {
            parsedEntry.measures = values.get("measures").toString();
        }
        parsedEntry.score = values.containsKey("statusScore") ? Double.valueOf(Double.parseDouble(values.get("statusScore").toString())) : (values.containsKey("score") ? Double.valueOf(Double.parseDouble(values.get("score").toString())) : null);
        if (values.containsKey("author")) {
            parsedEntry.author = values.get("author").toString();
        }
        if (values.containsKey("date")) {
            if (values.get("date") instanceof Date) {
                parsedEntry.date = (Date)values.get("date");
            } else {
                parsedEntry.setDate(values.get("date").toString());
            }
        }
        if (values.containsKey("labels") && values.get("labels") instanceof Map) {
            Map labels = (Map)values.get("labels");
            if (labels.containsKey("includes")) {
                parsedEntry.includes = VulnerabilityStatusHistoryEntry.extractStringArray(labels.get("includes"));
            }
            if (labels.containsKey("excludes")) {
                parsedEntry.excludes = VulnerabilityStatusHistoryEntry.extractStringArray(labels.get("excludes"));
            }
        }
        if (values.containsKey("active")) {
            parsedEntry.active = Boolean.parseBoolean(values.get("active").toString());
        }
        if (values.containsKey("scope")) {
            parsedEntry.scope = VulnerabilityStatus.Scope.valueOf(values.get("scope").toString());
        }
        if (values.containsKey("priority")) {
            parsedEntry.priority = Integer.parseInt(values.get("priority").toString());
        }
        return parsedEntry;
    }

    public static String[] extractStringArray(Object l) {
        if (l instanceof String) {
            if (l.toString().isEmpty()) {
                return null;
            }
            return l.toString().split(", ?");
        }
        if (l instanceof ArrayList) {
            return ((ArrayList)l).toArray(new String[0]);
        }
        return null;
    }

    public VulnerabilityStatusHistoryEntry setStatus(String status) {
        if (status == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        switch (status) {
            default: {
                LOG.warn("Unknown vulnerability assessment status [{}]", (Object)status);
            }
            case "not applicable": 
            case "in review": 
            case "applicable": 
            case "insignificant": 
            case "void": 
            case "none": 
            case "": 
        }
        this.status = status;
        return this;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDate(String date) {
        Date parsedDate;
        if (date == null) {
            this.date = null;
            return;
        }
        if (date.startsWith("${")) {
            String variableToUse;
            Set<String> variables = VulnerabilityStatusPostProcessor.extractVariables(date);
            if (variables.size() > 1) {
                variableToUse = variables.iterator().next();
                LOG.warn("Multiple variables found in date string [{}], only one is supported at the moment. Pick the first: {}", (Object)date, (Object)variableToUse);
            } else if (variables.isEmpty()) {
                variableToUse = null;
                LOG.warn("Invalid date variable found in date string [{}], ignoring", (Object)date);
            } else {
                variableToUse = variables.iterator().next();
            }
            if (variableToUse != null) {
                String variableName = variableToUse.substring(2, variableToUse.length() - 1);
                String[] variableAccessPath = variableName.split("\\.");
                boolean isCurrentDate = VulnerabilityStatusPostProcessor.isVariableAccessPathPrefix(variableAccessPath, 0, "date", "current");
                if (isCurrentDate) {
                    this.date = new Date();
                    return;
                }
                LOG.warn("Invalid date variable found in date string [{}], ignoring", (Object)date);
            }
        }
        if ((parsedDate = TimeUtils.tryParse(date)) == null) {
            if (this.date == null && StringUtils.hasText(date)) {
                this.date = new Date();
                LOG.warn("Invalid date string [{}] on status history entry [{}; {}; {}; {}], setting time to now: [{}]", new Object[]{date, this.status, this.rationale, this.risk, this.measures, this.date});
            } else {
                LOG.warn("Invalid date string [{}] on status history entry [{}; {}; {}; {}]", new Object[]{date, this.status, this.rationale, this.risk, this.measures});
            }
        } else {
            this.date = parsedDate;
        }
    }

    public VulnerabilityStatusHistoryEntry setScope(VulnerabilityStatus.Scope scope) {
        this.scope = scope;
        return this;
    }

    private String notNull(String s) {
        return s == null ? "" : s;
    }

    public String getFormattedDate() {
        if (this.date == null) {
            return null;
        }
        return TimeUtils.formatNormalizedDate(this.date);
    }

    public VulnerabilityStatusHistoryEntry setRationale(String rationale) {
        this.rationale = rationale;
        return this;
    }

    public String[] getIncludeLabels() {
        return this.includes;
    }

    public String[] getExcludeLabels() {
        return this.excludes;
    }

    public JSONObject toJson() {
        JSONObject exportJson = new JSONObject();
        try {
            exportJson.put("status", (Object)this.status);
            exportJson.put("rationale", (Object)this.rationale);
            exportJson.put("risk", (Object)this.risk);
            exportJson.put("measures", (Object)this.measures);
            exportJson.put("author", (Object)this.author);
            exportJson.put("date", (Object)this.getFormattedDate());
            exportJson.put("statusScore", (Object)this.score);
            exportJson.put("priority", this.priority);
            if (!this.active) {
                exportJson.put("active", false);
            }
            exportJson.put("labels", (Object)new JSONObject().put("includes", (Object)this.includes).put("excludes", (Object)this.excludes));
            if (this.scope != VulnerabilityStatus.Scope.ARTIFACT) {
                exportJson.put("scope", (Object)this.scope.name());
            }
        }
        catch (Exception e) {
            LOG.error("Unable to build vulnerability status export JSON object", (Throwable)e);
        }
        return exportJson;
    }

    public boolean isIncluded(String[] features) {
        if (features == null) {
            return true;
        }
        return this.isIncluded(Arrays.asList(features));
    }

    public boolean isIncluded(Collection<String> features) {
        if (features == null) {
            return true;
        }
        if (this.includes != null && this.includes.length > 0) {
            boolean included = false;
            String[] stringArray = this.includes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String include = stringArray[i];
                if (!features.contains(include)) continue;
                included = true;
                break;
            }
            if (!included) {
                return false;
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!features.contains(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    private <T> boolean arrayContains(T[] arr, T value) {
        if (value == null || arr == null) {
            return false;
        }
        return Arrays.asList(arr).contains(value);
    }

    private String getStatusNotNull() {
        return this.notNull(this.getStatus());
    }

    private String getAuthorNotNull() {
        return this.notNull(this.getAuthor());
    }

    @Override
    public int compareTo(VulnerabilityStatusHistoryEntry o) {
        if (this.scope == VulnerabilityStatus.Scope.INVENTORY && o.scope != VulnerabilityStatus.Scope.INVENTORY) {
            return 1;
        }
        if (this.scope != VulnerabilityStatus.Scope.INVENTORY && o.scope == VulnerabilityStatus.Scope.INVENTORY) {
            return -1;
        }
        if (!this.active && o.active) {
            return 1;
        }
        if (this.active && !o.active) {
            return -1;
        }
        if (this.status == null && o.status != null) {
            return 1;
        }
        if (this.status != null && o.status == null) {
            return -1;
        }
        if (this.status == null) {
            return 0;
        }
        if (this.priority != o.priority) {
            return Integer.compare(o.priority, this.priority);
        }
        if (this.date == null && o.date == null) {
            return Comparator.comparing(VulnerabilityStatusHistoryEntry::getStatusNotNull).thenComparing(VulnerabilityStatusHistoryEntry::getAuthorNotNull).compare(this, o);
        }
        if (this.date == null) {
            return 1;
        }
        if (o.date == null) {
            return -1;
        }
        int dateCompareResult = -this.date.compareTo(o.date);
        if (dateCompareResult != 0) {
            return dateCompareResult;
        }
        if (this.author == null && o.author != null) {
            return 1;
        }
        if (this.author != null && o.author == null) {
            return -1;
        }
        if (this.author == null) {
            return 1;
        }
        int authorCompareResult = this.author.compareTo(o.author);
        if (authorCompareResult != 0) {
            return authorCompareResult;
        }
        int statusCompareResult = this.status.compareTo(o.status);
        if (statusCompareResult != 0) {
            return statusCompareResult;
        }
        return 0;
    }

    public String toString() {
        return "VulnerabilityStatusHistoryEntry{status='" + this.status + '\'' + ", rationale='" + this.rationale + '\'' + ", risk='" + this.risk + '\'' + ", measures='" + this.measures + '\'' + ", author='" + this.author + '\'' + ", date='" + this.date + '\'' + ", includes=" + Arrays.toString(this.includes) + ", excludes=" + Arrays.toString(this.excludes) + ", score=" + this.score + ", active=" + this.active + ", scope=" + (Object)((Object)this.scope) + ", priority=" + this.priority + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VulnerabilityStatusHistoryEntry that = (VulnerabilityStatusHistoryEntry)o;
        if (this.score == null && that.score != null || this.score != null && that.score == null) {
            return false;
        }
        if (this.score != null && Double.compare(that.score, this.score) != 0) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.rationale, that.rationale)) {
            return false;
        }
        if (!Objects.equals(this.risk, that.risk)) {
            return false;
        }
        if (!Objects.equals(this.measures, that.measures)) {
            return false;
        }
        if (!Objects.equals(this.author, that.author)) {
            return false;
        }
        if (!Objects.equals(this.date, that.date)) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.includes == null && that.includes != null || this.includes != null && that.includes == null) {
            return false;
        }
        if (this.includes != null && !Arrays.equals(this.includes, that.includes)) {
            return false;
        }
        if (this.excludes == null && that.excludes != null || this.excludes != null && that.excludes == null) {
            return false;
        }
        return this.excludes == null || Arrays.equals(this.excludes, that.excludes);
    }

    public boolean equalsTemplate(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VulnerabilityStatusHistoryEntry that = (VulnerabilityStatusHistoryEntry)o;
        if (this.score == null && that.score != null || this.score != null && that.score == null) {
            return false;
        }
        if (this.score != null && Double.compare(that.score, this.score) != 0) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if ("insignificant".equalsIgnoreCase(this.status) ? (this.rationale == null || !this.rationale.startsWith("Score is below") || that.rationale == null || !that.rationale.startsWith("Score is below")) && !Objects.equals(this.rationale, that.rationale) : !Objects.equals(this.rationale, that.rationale)) {
            return false;
        }
        if (!Objects.equals(this.risk, that.risk)) {
            return false;
        }
        if (!Objects.equals(this.measures, that.measures)) {
            return false;
        }
        if (!Objects.equals(this.author, that.author)) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (this.includes == null && that.includes != null || this.includes != null && that.includes == null) {
            return false;
        }
        if (this.includes != null && !Arrays.equals(this.includes, that.includes)) {
            return false;
        }
        if (this.excludes == null && that.excludes != null || this.excludes != null && that.excludes == null) {
            return false;
        }
        return this.excludes == null || Arrays.equals(this.excludes, that.excludes);
    }

    public int hashCode() {
        int result = Objects.hash(this.status, this.rationale, this.risk, this.measures, this.author, this.date, this.score, this.priority);
        result = 31 * result + Arrays.hashCode(this.includes);
        result = 31 * result + Arrays.hashCode(this.excludes);
        return result;
    }

    public static List<VulnerabilityStatusHistoryEntry> parseEntries(JSONArray json) {
        try {
            ArrayList<VulnerabilityStatusHistoryEntry> parsed = new ArrayList<VulnerabilityStatusHistoryEntry>();
            for (int i = 0; i < json.length(); ++i) {
                VulnerabilityStatusHistoryEntry entry = VulnerabilityStatusHistoryEntry.fromMap(json.getJSONObject(i).toMap());
                parsed.add(entry);
            }
            return parsed;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse Vulnerability Status History Entries from JSON Array: " + json, e);
        }
    }

    public static List<VulnerabilityStatusHistoryEntry> reorderChronologically(VulnerabilityStatus status, Vulnerability vulnerability, boolean isInsignificant, double insignificantThreshold) {
        if (vulnerability == null || status == null) {
            return Collections.emptyList();
        }
        ArrayList<VulnerabilityStatusHistoryEntry> statusHistory = new ArrayList<VulnerabilityStatusHistoryEntry>(status.getStatusHistory());
        statusHistory.sort(VulnerabilityStatusHistoryEntry::compareTo);
        boolean hasNoStatus = statusHistory.stream().noneMatch(s -> StringUtils.hasText(s.getStatus()));
        if (hasNoStatus && isInsignificant) {
            VulnerabilityStatusHistoryEntry insignificantEntry = INSIGNIFICANT.clone();
            if (insignificantEntry.getRationale() != null) {
                insignificantEntry.setRationale(String.format(Locale.GERMANY, insignificantEntry.getRationale(), insignificantThreshold));
            }
            statusHistory.add(0, insignificantEntry);
        }
        return statusHistory;
    }

    public VulnerabilityStatusHistoryEntry clone() {
        try {
            VulnerabilityStatusHistoryEntry clone = (VulnerabilityStatusHistoryEntry)super.clone();
            if (this.excludes != null) {
                clone.excludes = Arrays.copyOf(this.excludes, this.excludes.length);
            }
            if (this.includes != null) {
                clone.includes = Arrays.copyOf(this.includes, this.includes.length);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getRationale() {
        return this.rationale;
    }

    public String getRisk() {
        return this.risk;
    }

    public String getMeasures() {
        return this.measures;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public Double getScore() {
        return this.score;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isActive() {
        return this.active;
    }

    public VulnerabilityStatus.Scope getScope() {
        return this.scope;
    }

    public void setRisk(String risk) {
        this.risk = risk;
    }

    public void setMeasures(String measures) {
        this.measures = measures;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

