/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.validation;

import com.metaeffekt.artifact.analysis.utils.WildcardUtilities;
import com.metaeffekt.artifact.analysis.version.Version;
import com.metaeffekt.artifact.analysis.version.curation.VersionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;

public class VulnerabilityStatusValidationEntry {
    private final String field;
    private final CompareFunction function;
    private final String value;

    public VulnerabilityStatusValidationEntry(String field, CompareFunction function, String value) {
        this.field = field;
        this.function = function;
        this.value = value;
    }

    public boolean validate(AbstractModelBase model) {
        return this.validate(model.get(this.field), model);
    }

    public boolean validate(String fieldValue, AbstractModelBase model) {
        if (fieldValue == null) {
            return false;
        }
        switch (this.function) {
            case EQUALS: {
                return this.value.equals(fieldValue);
            }
            case MATCHES: {
                return this.matches(fieldValue, this.value);
            }
            case VERSION_SMALLER: {
                return this.compareVersion(fieldValue, this.value, model) < 0;
            }
            case VERSION_LARGER: {
                return this.compareVersion(fieldValue, this.value, model) > 0;
            }
            case VERSION_LARGER_OR_EQUAL: {
                return this.compareVersion(fieldValue, this.value, model) >= 0;
            }
            case VERSION_SMALLER_OR_EQUAL: {
                return this.compareVersion(fieldValue, this.value, model) <= 0;
            }
            case NUMERIC_SMALLER: {
                return this.compareNumeric(fieldValue, this.value) < 0;
            }
            case NUMERIC_LARGER: {
                return this.compareNumeric(fieldValue, this.value) > 0;
            }
            case NUMERIC_LARGER_OR_EQUAL: {
                return this.compareNumeric(fieldValue, this.value) >= 0;
            }
            case NUMERIC_SMALLER_OR_EQUAL: {
                return this.compareNumeric(fieldValue, this.value) <= 0;
            }
            case CSV_CONTAINS: {
                return this.containsAllCsvValues(fieldValue, this.value);
            }
            case CSV_NOT_CONTAINS: {
                return !this.containsAllCsvValues(fieldValue, this.value);
            }
        }
        throw new IllegalStateException("Unknown compare function: " + (Object)((Object)this.function));
    }

    private boolean matches(String fieldValue, String compareValue) {
        Pattern pattern = WildcardUtilities.convertWildcardStringToPattern(compareValue);
        return pattern.matcher(fieldValue).matches();
    }

    private int compareNumeric(String fieldValue, String compareValue) {
        if (fieldValue == null || compareValue == null) {
            return 0;
        }
        try {
            return Double.compare(Double.parseDouble(fieldValue), Double.parseDouble(compareValue));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private int compareVersion(String fieldValue, String compareValue, AbstractModelBase model) {
        Version compareVersion;
        Artifact artifact = model instanceof Artifact ? (Artifact)model : null;
        Version fieldVersion = Version.of(fieldValue, VersionContext.fromArtifact(artifact));
        return fieldVersion.after(compareVersion = Version.of(compareValue, VersionContext.fromArtifact(artifact))) ? 1 : (fieldVersion.before(compareVersion) ? -1 : 0);
    }

    private boolean containsAllCsvValues(String fieldValue, String compareValue) {
        String[] compareValues;
        String[] fieldValues = fieldValue.split(", ");
        for (String comp : compareValues = compareValue.split(", ")) {
            boolean found = false;
            for (String field : fieldValues) {
                if (!comp.equals(field)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static List<VulnerabilityStatusValidationEntry> fromYamlList(List<Object> yamlData) {
        ArrayList<VulnerabilityStatusValidationEntry> result = new ArrayList<VulnerabilityStatusValidationEntry>();
        for (Object entry : yamlData) {
            result.addAll(VulnerabilityStatusValidationEntry.fromYamlMap((Map)entry));
        }
        return result;
    }

    public static List<VulnerabilityStatusValidationEntry> fromYamlMap(Map<String, Object> yamlData) {
        if (yamlData.containsKey("field") && yamlData.containsKey("function") && yamlData.containsKey("value")) {
            String field = (String)yamlData.get("field");
            String function = (String)yamlData.get("function");
            String value = String.valueOf(yamlData.get("value"));
            return Arrays.asList(new VulnerabilityStatusValidationEntry(field, CompareFunction.fromLabel(function), value));
        }
        ArrayList<VulnerabilityStatusValidationEntry> result = new ArrayList<VulnerabilityStatusValidationEntry>();
        for (Map.Entry<String, Object> entry : yamlData.entrySet()) {
            String field = entry.getKey();
            String function = "matches";
            String value = String.valueOf(entry.getValue());
            result.add(new VulnerabilityStatusValidationEntry(field, CompareFunction.fromLabel("matches"), value));
        }
        return result;
    }

    public String toString() {
        return "{" + this.field + " : " + this.function.label + " : " + this.value + "}";
    }

    public Map<String, Object> toYamlMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("field", this.field);
        result.put("function", this.function.label);
        result.put("value", this.value);
        return result;
    }

    public static enum CompareFunction {
        EQUALS("equals"),
        MATCHES("matches"),
        VERSION_SMALLER("version <"),
        VERSION_LARGER("version >"),
        VERSION_SMALLER_OR_EQUAL("version <="),
        VERSION_LARGER_OR_EQUAL("version >="),
        NUMERIC_SMALLER("numeric <"),
        NUMERIC_LARGER("numeric >"),
        NUMERIC_SMALLER_OR_EQUAL("numeric <="),
        NUMERIC_LARGER_OR_EQUAL("numeric >="),
        CSV_CONTAINS("csv contains"),
        CSV_NOT_CONTAINS("csv not contains");

        public final String label;

        private CompareFunction(String label) {
            this.label = label;
        }

        public static CompareFunction fromLabel(String label) {
            for (CompareFunction compareFunction : CompareFunction.values()) {
                if (!compareFunction.label.equals(label)) continue;
                return compareFunction;
            }
            throw new IllegalArgumentException("Unknown compare function: " + label);
        }
    }
}

