/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryWarningEntry<T extends AbstractModelBase> {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryWarningEntry.class);
    public T source;
    public String warning;
    public String creator;
    public static final ArtifactFindable ARTIFACT_FINDABLE = new ArtifactFindable();
    public static final VulnerabilityMetaDataFindable VULNERABILITY_META_DATA_FINDABLE = new VulnerabilityMetaDataFindable();

    public InventoryWarningEntry(T source, String warning, String creator) {
        if (source == null) {
            throw new IllegalArgumentException("Source must not be null");
        }
        this.source = source;
        this.warning = warning;
        this.creator = creator;
    }

    public T getSource() {
        return this.source;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getCreator() {
        return this.creator;
    }

    public JSONObject toJson() {
        String sourceName;
        if (this.source instanceof Artifact) {
            sourceName = ((Artifact)this.source).getId();
        } else if (this.source instanceof VulnerabilityMetaData) {
            sourceName = ((VulnerabilityMetaData)this.source).get(VulnerabilityMetaData.Attribute.NAME);
        } else {
            throw new IllegalStateException("Unknown source type: " + this.source.getClass() + ", add handling in " + InventoryWarningEntry.class + ".toJson()");
        }
        return new JSONObject().put("source", (Object)sourceName).put("warning", (Object)this.warning).put("creator", (Object)this.creator);
    }

    public static <E extends AbstractModelBase> Map<E, List<InventoryWarningEntry<E>>> groupBySource(List<InventoryWarningEntry<E>> entries) {
        return entries.stream().collect(Collectors.groupingBy(InventoryWarningEntry::getSource));
    }

    public static <T extends AbstractModelBase> InventoryWarningEntry<T> fromToJson(JSONObject json, Inventory inventory, InventoryFindable<T> finder) {
        AbstractModelBase effectiveInstance;
        String sourceString = json.getString("source");
        AbstractModelBase instance = (AbstractModelBase)finder.find(sourceString, inventory);
        if (instance == null) {
            LOG.warn("Could not find object with id " + sourceString + " when parsing inventory warnings, creating virtual object.");
            effectiveInstance = (AbstractModelBase)finder.create(sourceString);
        } else {
            effectiveInstance = instance;
        }
        return new InventoryWarningEntry<AbstractModelBase>(effectiveInstance, json.getString("warning"), json.getString("creator"));
    }

    public static class VulnerabilityMetaDataFindable
    implements InventoryFindable<VulnerabilityMetaData> {
        @Override
        public VulnerabilityMetaData find(String sourceString, Inventory inventory) {
            return inventory.getVulnerabilityMetaData().stream().filter(v -> Objects.equals(v.get(VulnerabilityMetaData.Attribute.NAME), sourceString)).findFirst().orElse(null);
        }

        @Override
        public VulnerabilityMetaData create(String sourceString) {
            VulnerabilityMetaData virtualVulnerability = new VulnerabilityMetaData();
            virtualVulnerability.set(VulnerabilityMetaData.Attribute.NAME, sourceString);
            virtualVulnerability.set(InventoryAttribute.DESCRIPTION.getKey(), "Virtual vulnerability created by the inventory warnings.");
            return virtualVulnerability;
        }
    }

    public static class ArtifactFindable
    implements InventoryFindable<Artifact> {
        @Override
        public Artifact find(String sourceString, Inventory inventory) {
            return inventory.findArtifact(sourceString);
        }

        @Override
        public Artifact create(String sourceString) {
            Artifact virtualArtifact = new Artifact();
            virtualArtifact.setId(sourceString);
            virtualArtifact.set(InventoryAttribute.DESCRIPTION.getKey(), "Virtual artifact created by the inventory warnings.");
            return virtualArtifact;
        }
    }

    private static interface InventoryFindable<T> {
        public T find(String var1, Inventory var2);

        public T create(String var1);
    }
}

