/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment;

import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.mirror.concurrency.ScheduledDelayedThreadPoolExecutor;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryEnricher.class);
    public static final String INVENTORY_INFO_VULNERABILITY_STATUS_KEY = "vulnerability-status";
    public static final String INVENTORY_INFO_VULNERABILITY_STATUS_INVENTORY_STATUSES_KEY = "Vulnerability Inventory Status";
    protected final ScheduledDelayedThreadPoolExecutor executor = new ScheduledDelayedThreadPoolExecutor(16, 0L);
    protected CentralSecurityPolicyConfiguration securityPolicyConfiguration;

    public void performEnrichmentIfActive(Inventory inventory) {
        LOG.info("");
        LOG.info(InventoryEnricher.formatLogHeader(this.getEnrichmentName()));
        long start = TimeUtils.utcNow();
        if (this.getConfiguration().isActive()) {
            LOG.info("Enriching inventory with [{} artifact{}], [{} vulnerabilit{}] and [{} advisor{}]", new Object[]{inventory.getArtifacts().size(), inventory.getArtifacts().size() == 1 ? "" : "s", inventory.getVulnerabilityMetaData().size(), inventory.getVulnerabilityMetaData().size() == 1 ? "y" : "ies", inventory.getAdvisoryMetaData().size(), inventory.getAdvisoryMetaData().size() == 1 ? "" : "ies"});
            this.getConfiguration().logConfiguration();
            this.performEnrichment(inventory);
        } else {
            LOG.info("Skipping enrichment of inventory with [{} artifact{}], [{} vulnerabilit{}] and [{} advisor{}]", new Object[]{inventory.getArtifacts().size(), inventory.getArtifacts().size() == 1 ? "" : "s", inventory.getVulnerabilityMetaData().size(), inventory.getVulnerabilityMetaData().size() == 1 ? "y" : "ies", inventory.getAdvisoryMetaData().size(), inventory.getAdvisoryMetaData().size() == 1 ? "" : "ies"});
        }
        long duration = TimeUtils.utcNow() - start;
        LOG.info(InventoryEnricher.formatLogHeader("Done: " + this.getEnrichmentName() + " [" + TimeUtils.formatTimeDiff(duration) + "]"));
        LOG.info("");
    }

    protected abstract void performEnrichment(Inventory var1);

    public String getEnrichmentName() {
        return this.getMetadata().name();
    }

    public String getInventoryFileNameSuffix() {
        return this.getMetadata().intermediateFileSuffix();
    }

    public InventoryEnrichmentPhase getPhase() {
        return this.getMetadata().phase();
    }

    public boolean isDeprecated() {
        return this.getMetadata().deprecated();
    }

    public boolean shouldWriteIntermediateInventory() {
        return this.getMetadata().shouldWriteIntermediateInventory();
    }

    public abstract ProcessConfiguration getConfiguration();

    public List<ProcessMisconfiguration> collectMisconfigurations() {
        return this.getConfiguration().collectMisconfigurations();
    }

    public void setSecurityPolicyConfiguration(CentralSecurityPolicyConfiguration securityPolicyConfiguration) {
        this.securityPolicyConfiguration = securityPolicyConfiguration;
    }

    public CentralSecurityPolicyConfiguration getSecurityPolicyConfiguration() {
        if (this.securityPolicyConfiguration == null) {
            this.securityPolicyConfiguration = new CentralSecurityPolicyConfiguration();
        }
        return this.securityPolicyConfiguration;
    }

    public boolean isSecurityPolicyConfigurationDefined() {
        return this.securityPolicyConfiguration != null;
    }

    public EnricherMetadata getMetadata() {
        if (this.getClass().isAnnotationPresent(EnricherMetadata.class)) {
            return this.getClass().getAnnotation(EnricherMetadata.class);
        }
        throw new IllegalStateException("Enricher class " + this.getClass().getName() + " is missing the " + EnricherMetadata.class.getSimpleName() + " annotation.");
    }

    public static Set<String> splitVulnerabilitiesCsv(String vulnerabilities) {
        if (StringUtils.isEmpty(vulnerabilities)) {
            return Collections.emptySet();
        }
        return Arrays.stream(vulnerabilities.split(", ")).map(v -> v.replaceAll(" \\([^)]*\\)$", "")).map(String::trim).filter(StringUtils::hasText).collect(Collectors.toSet());
    }

    protected void moveInventoryData(Inventory source, Inventory destination) {
        destination.setArtifacts(source.getArtifacts());
        for (String context : source.getVulnerabilityMetaDataContexts()) {
            destination.setVulnerabilityMetaData(source.getVulnerabilityMetaData(context), context);
        }
        destination.setAdvisoryMetaData(source.getAdvisoryMetaData());
        destination.setInventoryInfo(source.getInventoryInfo());
        destination.setAssetMetaData(source.getAssetMetaData());
        destination.setComponentNameMap(source.getComponentNameMap());
        destination.setContextMap(source.getContextMap());
        destination.setLicenseNameMap(source.getLicenseNameMap());
        destination.setLicenseMetaData(source.getLicenseMetaData());
        destination.setLicenseData(source.getLicenseData());
        destination.setComponentPatternData(source.getComponentPatternData());
    }

    public static String formatLogHeader(String header) {
        return InventoryEnricher.formatLogHeader(header, 72);
    }

    public static String formatLogHeader(String header, int length) {
        int i;
        if (length < 4) {
            throw new IllegalArgumentException("Length must be at least 4");
        }
        StringBuilder builder = new StringBuilder();
        int headerLength = header.length();
        int headerLengthDiff = length - headerLength - 4;
        int headerLengthDiffHalf = headerLengthDiff / 2;
        for (i = 0; i < headerLengthDiffHalf; ++i) {
            builder.append("-");
        }
        builder.append("< ").append(header).append(" >");
        for (i = 0; i < headerLengthDiffHalf; ++i) {
            builder.append("-");
        }
        while (builder.length() < length) {
            builder.append("-");
        }
        return builder.toString();
    }
}

