/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;

public class ArtifactCorrelationEnrichmentConfiguration
extends ProcessConfiguration {
    private final List<File> yamlFiles = new ArrayList<File>();

    public ArtifactCorrelationEnrichmentConfiguration setYamlFiles(List<File> yamlFiles) {
        this.yamlFiles.clear();
        this.yamlFiles.addAll(yamlFiles);
        return this;
    }

    public ArtifactCorrelationEnrichmentConfiguration addYamlFile(File yamlFile) {
        this.yamlFiles.add(yamlFile);
        return this;
    }

    public ArtifactCorrelationEnrichmentConfiguration addYamlFiles(Collection<File> yamlFiles) {
        this.yamlFiles.addAll(yamlFiles);
        return this;
    }

    public List<File> getYamlFiles() {
        return this.yamlFiles;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("yamlFiles", this.yamlFiles.stream().filter(Objects::nonNull).map(File::getAbsolutePath).collect(Collectors.toList()));
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadListProperty(properties, "yamlFiles", obj -> new File(String.valueOf(obj)), this::setYamlFiles);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.yamlFiles.isEmpty()) {
            misconfigurations.add(new ProcessMisconfiguration("yamlFiles", "No YAML files configured. Set enricher to inactive to avoid this exception."));
        }
        if (this.yamlFiles.stream().anyMatch(Objects::isNull)) {
            misconfigurations.add(new ProcessMisconfiguration("yamlFiles", "Must not contain null values"));
        }
    }
}

