/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.enrichment.configurations.VadDetailLevelConfiguration;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import us.springett.parsers.cpe.Cpe;

public class VadDetailLevelMatcher
extends ProcessConfiguration {
    private static final Set<String> VALID_STATUS_NAMES = new HashSet<String>(){
        {
            this.add("applicable");
            this.add("not applicable");
            this.add("insignificant");
            this.add("in review");
            this.add("void");
        }
    };
    private String status;
    private String allCpe;
    private String anyCpe;
    private String vulnerabilityName;
    private List<Cpe> cachedAllCpes;
    private List<Cpe> cachedAnyCpes;

    public String[] getStatus() {
        return this.status == null ? null : this.status.split(", ");
    }

    public List<Cpe> getAllCpe() {
        if (this.cachedAllCpes == null) {
            this.cachedAllCpes = CommonEnumerationUtil.parseCpes(this.allCpe);
        }
        return this.cachedAllCpes;
    }

    public List<Cpe> getAnyCpe() {
        if (this.cachedAnyCpes == null) {
            this.cachedAnyCpes = CommonEnumerationUtil.parseCpes(this.anyCpe);
        }
        return this.cachedAnyCpes;
    }

    public String[] getVulnerabilityName() {
        return this.vulnerabilityName == null ? null : this.vulnerabilityName.split(", ");
    }

    public VadDetailLevelMatcher setStatus(String status) {
        this.status = status;
        return this;
    }

    public VadDetailLevelMatcher setAllCpe(String allCpe) {
        this.allCpe = allCpe;
        this.cachedAllCpes = null;
        return this;
    }

    public VadDetailLevelMatcher setAnyCpe(String anyCpe) {
        this.anyCpe = anyCpe;
        this.cachedAnyCpes = null;
        return this;
    }

    public VadDetailLevelMatcher setVulnerabilityName(String vulnerabilityName) {
        this.vulnerabilityName = vulnerabilityName;
        return this;
    }

    public VadDetailLevelMatcher setVulnerabilityName(String[] vulnerabilityName) {
        this.vulnerabilityName = vulnerabilityName == null ? null : String.join((CharSequence)", ", vulnerabilityName);
        return this;
    }

    public boolean matches(Vulnerability vulnerability, VulnerabilityStatus status, Set<Artifact> artifacts) {
        String[] vulnerabilityName;
        List<Cpe> anyCpe;
        VulnerabilityStatusHistoryEntry latestActiveEntry = status.getLatestActiveStatusHistoryEntry();
        if (latestActiveEntry != null && !this.isStatusApplicable(latestActiveEntry.getStatus())) {
            return false;
        }
        List<Cpe> allCpe = this.getAllCpe();
        if (allCpe != null && !allCpe.isEmpty()) {
            for (Cpe cpe : allCpe) {
                boolean cpeMatched = false;
                for (Artifact artifact : artifacts) {
                    List<Cpe> effectiveArtifactCpes = CommonEnumerationUtil.parseEffectiveCpe(artifact);
                    for (Cpe effectiveArtifactCpe : effectiveArtifactCpes) {
                        if (!CommonEnumerationUtil.compareCpeUsingWildcardsOneWay(cpe, effectiveArtifactCpe)) continue;
                        cpeMatched = true;
                        break;
                    }
                    if (!cpeMatched) continue;
                    break;
                }
                if (cpeMatched) continue;
                return false;
            }
        }
        if ((anyCpe = this.getAnyCpe()) != null && !anyCpe.isEmpty()) {
            boolean cpeMatched = false;
            for (Artifact artifact : artifacts) {
                List<Cpe> effectiveArtifactCpes = CommonEnumerationUtil.parseEffectiveCpe(artifact);
                for (Cpe effectiveArtifactCpe : effectiveArtifactCpes) {
                    for (Cpe cpe : anyCpe) {
                        if (!CommonEnumerationUtil.compareCpeUsingWildcardsOneWay(cpe, effectiveArtifactCpe)) continue;
                        cpeMatched = true;
                        break;
                    }
                    if (!cpeMatched) continue;
                    break;
                }
                if (!cpeMatched) continue;
                break;
            }
            if (!cpeMatched) {
                return false;
            }
        }
        if ((vulnerabilityName = this.getVulnerabilityName()) != null && vulnerabilityName.length > 0) {
            boolean vulnerabilityNameMatched = false;
            for (String name : vulnerabilityName) {
                if (!vulnerability.getId().contains(name)) continue;
                vulnerabilityNameMatched = true;
                break;
            }
            if (!vulnerabilityNameMatched) {
                return false;
            }
        }
        return true;
    }

    public boolean isStatusApplicable(String checkStatus) {
        String[] statusNames = this.getStatus();
        if (statusNames == null) {
            return true;
        }
        for (String statusName : statusNames) {
            if (!checkStatus.equals(statusName.trim())) continue;
            return true;
        }
        return false;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("status", this.status);
        properties.put("allCpe", this.allCpe);
        properties.put("anyCpe", this.anyCpe);
        properties.put("vulnerabilityName", this.vulnerabilityName);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadStringProperty(properties, "status", this::setStatus);
        super.loadStringProperty(properties, "allCpe", this::setAllCpe);
        super.loadStringProperty(properties, "anyCpe", this::setAnyCpe);
        super.loadStringProperty(properties, "vulnerabilityName", this::setVulnerabilityName);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.status != null) {
            String[] statusNames;
            for (String statusName : statusNames = this.getStatus()) {
                if (VALID_STATUS_NAMES.contains(statusName.trim())) continue;
                misconfigurations.add(new ProcessMisconfiguration("status", "Invalid status name: [" + statusName + "]. Valid names are: " + VALID_STATUS_NAMES));
            }
        }
    }

    public static VadDetailLevelMatcher fromConfigurationString(String configString) {
        if (!configString.startsWith("matcher:")) {
            throw new IllegalArgumentException("Invalid configuration string, expected 'matcher:' but got '" + configString + "'");
        }
        String trimmedConfigString = configString.substring("matcher:".length()).trim();
        Map<String, String> properties = VadDetailLevelConfiguration.extractPropertiesFromConfigLine(trimmedConfigString);
        VadDetailLevelMatcher matcher = new VadDetailLevelMatcher();
        if (properties.containsKey("status")) {
            matcher.setStatus(properties.get("status"));
        }
        if (properties.containsKey("allCpe")) {
            matcher.setAllCpe(properties.get("allCpe"));
        }
        if (properties.containsKey("anyCpe")) {
            matcher.setAnyCpe(properties.get("anyCpe"));
        }
        if (properties.containsKey("vulnerabilityName")) {
            matcher.setVulnerabilityName(properties.get("vulnerabilityName"));
        }
        return matcher;
    }
}

