/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.configurations;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.configuration.ProcessConfiguration;
import org.metaeffekt.core.inventory.processor.configuration.ProcessMisconfiguration;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;

public class VulnerabilityStatusEnrichmentConfiguration
extends ProcessConfiguration {
    private final List<File> statusFiles = new ArrayList<File>();
    private final List<VulnerabilityStatus> additionalStatus = new ArrayList<VulnerabilityStatus>();
    private String[] activeLabels = new String[0];
    private boolean failOnValidationErrors = false;
    private boolean failOnAmbiguousMatchingInformation = false;
    private boolean debugMatchingCriteria = false;

    public VulnerabilityStatusEnrichmentConfiguration setStatusFiles(List<File> statusFiles) {
        this.statusFiles.clear();
        this.statusFiles.addAll(statusFiles);
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration addStatusFile(File statusFile) {
        this.statusFiles.add(statusFile);
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration addStatus(VulnerabilityStatus status) {
        this.additionalStatus.add(status);
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration addStatuses(Collection<VulnerabilityStatus> statuses) {
        this.additionalStatus.addAll(statuses);
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration removeStatus(VulnerabilityStatus status) {
        this.additionalStatus.remove(status);
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration setActiveLabels(String[] activeLabels) {
        this.activeLabels = activeLabels;
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration setActiveLabels(Collection<String> activeLabels) {
        this.activeLabels = activeLabels.toArray(new String[0]);
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration setFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration setFailOnAmbiguousMatchingInformation(boolean failOnAmbiguousMatchingInformation) {
        this.failOnAmbiguousMatchingInformation = failOnAmbiguousMatchingInformation;
        return this;
    }

    public VulnerabilityStatusEnrichmentConfiguration setDebugMatchingCriteria(boolean debugMatchingCriteria) {
        this.debugMatchingCriteria = debugMatchingCriteria;
        return this;
    }

    public Set<VulnerabilityStatus> readVulnerabilityStatusEntries(CentralSecurityPolicyConfiguration.JsonSchemaValidationErrorsHandling jsonSchemaValidationErrorsHandling) {
        LinkedHashSet<VulnerabilityStatus> anyScopeStatus = new LinkedHashSet<VulnerabilityStatus>();
        for (File statusFile : this.statusFiles) {
            anyScopeStatus.addAll(VulnerabilityStatusConverter.fromStatusFileOrDirectory(statusFile, jsonSchemaValidationErrorsHandling));
        }
        anyScopeStatus.addAll(this.additionalStatus);
        return anyScopeStatus;
    }

    public LinkedHashMap<String, Object> getProperties() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put("statusFiles", this.statusFiles);
        properties.put("additionalStatus", this.additionalStatus.stream().filter(Objects::nonNull).map(VulnerabilityStatus::toJson).collect(Collectors.toList()));
        properties.put("activeLabels", Arrays.asList(this.activeLabels));
        properties.put("failOnValidationErrors", this.failOnValidationErrors);
        properties.put("failOnAmbiguousMatchingInformation", this.failOnAmbiguousMatchingInformation);
        properties.put("debugMatchingCriteria", this.debugMatchingCriteria);
        return properties;
    }

    public void setProperties(LinkedHashMap<String, Object> properties) {
        super.loadListProperty(properties, "statusFiles", obj -> new File(String.valueOf(obj)), this::setStatusFiles);
        super.loadListProperty(properties, "additionalStatus", obj -> VulnerabilityStatusConverter.fromJson(new JSONObject(String.valueOf(obj))), list -> list.forEach(this::addStatus));
        super.loadListProperty(properties, "activeLabels", String::valueOf, this::setActiveLabels);
        super.loadBooleanProperty(properties, "failOnValidationErrors", this::setFailOnValidationErrors);
        super.loadBooleanProperty(properties, "failOnAmbiguousMatchingInformation", this::setFailOnAmbiguousMatchingInformation);
        super.loadBooleanProperty(properties, "debugMatchingCriteria", this::setDebugMatchingCriteria);
    }

    protected void collectMisconfigurations(List<ProcessMisconfiguration> misconfigurations) {
        if (this.additionalStatus.stream().anyMatch(Objects::isNull)) {
            misconfigurations.add(new ProcessMisconfiguration("additionalStatus", "contains null values"));
        }
        if (this.statusFiles.isEmpty() && this.additionalStatus.isEmpty()) {
            misconfigurations.add(new ProcessMisconfiguration("statusFiles", "Must not be empty, set enricher to inactive to avoid exception"));
        }
        if (this.statusFiles.stream().anyMatch(Objects::isNull)) {
            misconfigurations.add(new ProcessMisconfiguration("statusFiles", "Must not contain null values"));
        }
    }

    public List<File> getStatusFiles() {
        return this.statusFiles;
    }

    public List<VulnerabilityStatus> getAdditionalStatus() {
        return this.additionalStatus;
    }

    public String[] getActiveLabels() {
        return this.activeLabels;
    }

    public boolean isFailOnValidationErrors() {
        return this.failOnValidationErrors;
    }

    public boolean isFailOnAmbiguousMatchingInformation() {
        return this.failOnAmbiguousMatchingInformation;
    }

    public boolean isDebugMatchingCriteria() {
        return this.debugMatchingCriteria;
    }
}

