/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.details;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.enrichment.configurations.details.DetailsFillingNvdInventoryEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.details.DetailsFillingEnrichment;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.NvdCveIndexQuery;
import java.io.File;
import java.util.Optional;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="NVD Vulnerability Details", phase=InventoryEnrichmentPhase.VULNERABILITY_DETAILS_FILLING, intermediateFileSuffix="details-vulnerability-nvd", mavenPropertyName="nvdCveFillDetailsEnrichment", explicitConfiguration=DetailsFillingNvdInventoryEnrichmentConfiguration.class)
public class DetailsFillingEnrichmentNvd
extends DetailsFillingEnrichment<DetailsFillingNvdInventoryEnrichmentConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(DetailsFillingEnrichmentNvd.class);
    private final LazySupplier<NvdCveIndexQuery> nvdQuery;
    private DetailsFillingNvdInventoryEnrichmentConfiguration configuration = new DetailsFillingNvdInventoryEnrichmentConfiguration();

    public DetailsFillingEnrichmentNvd(File baseMirrorDirectory) {
        this.nvdQuery = new LazySupplier<NvdCveIndexQuery>(() -> new NvdCveIndexQuery(baseMirrorDirectory));
    }

    @Override
    public void setConfiguration(DetailsFillingNvdInventoryEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public DetailsFillingNvdInventoryEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isApplicable(Vulnerability vulnerability) {
        return StringUtils.isEmpty(vulnerability.getDescription()) && VulnerabilityTypeStore.CVE == vulnerability.getSourceIdentifier();
    }

    @Override
    protected boolean isApplicable(AdvisoryEntry advisory) {
        return false;
    }

    @Override
    protected void fillDetailsOnVulnerability(Inventory inventory, VulnerabilityContextInventory vInventory, Vulnerability queryVulnerability) {
        Optional<Vulnerability> potentialDbVulnerability = ((NvdCveIndexQuery)this.nvdQuery.get()).findVulnerabilityByName(queryVulnerability.getId());
        if (!potentialDbVulnerability.isPresent()) {
            LOG.warn("CVE-Vulnerability [{}] not found in NVD", (Object)queryVulnerability.getId());
        } else {
            Vulnerability dbVulnerability = potentialDbVulnerability.get();
            queryVulnerability.appendFromDataClass(dbVulnerability);
        }
    }

    @Override
    protected void fillDetailsOnAdvisory(Inventory inventory, VulnerabilityContextInventory vInventory, AdvisoryEntry queryAdvisory) {
    }
}

