/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.matching;

import com.metaeffekt.artifact.enrichment.configurations.CustomVulnerabilitiesFromCpeEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.matching.VulnerabilitiesFromCpeEnrichment;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.CustomVulnerabilityIndexQuery;
import java.io.File;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Custom Vulnerabilities from CPE", phase=InventoryEnrichmentPhase.VULNERABILITY_MATCHING, intermediateFileSuffix="custom-vulnerabilities-from-cpe", mavenPropertyName="customVulnerabilitiesFromCpeEnrichment")
public class CustomVulnerabilitiesFromCpeEnrichment
extends VulnerabilitiesFromCpeEnrichment {
    private static final Logger LOG = LoggerFactory.getLogger(CustomVulnerabilitiesFromCpeEnrichment.class);
    protected CustomVulnerabilityIndexQuery vulnerabilityQuery;

    public CustomVulnerabilitiesFromCpeEnrichment(File baseMirrorDirectory) {
        super(new CustomVulnerabilitiesFromCpeEnrichmentConfiguration());
    }

    @Override
    public CustomVulnerabilitiesFromCpeEnrichmentConfiguration getConfiguration() {
        return (CustomVulnerabilitiesFromCpeEnrichmentConfiguration)this.configuration;
    }

    @Override
    protected CustomVulnerabilityIndexQuery getVulnerabilityQuery() {
        return this.vulnerabilityQuery;
    }

    @Override
    protected ContentIdentifierStore.ContentIdentifier getVulnerabilitySource() {
        return VulnerabilityTypeStore.get().fromNameAndImplementationWithoutCreation("CUSTOM", "CUSTOM");
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        this.vulnerabilityQuery = new CustomVulnerabilityIndexQuery(this.getConfiguration().getVulnerabilityFiles());
        List artifacts = inventory.getArtifacts();
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        int i = 0;
        int artifactsSize = artifacts.size();
        while (i < artifactsSize) {
            Artifact artifact = (Artifact)artifacts.get(i);
            int finalI = i++;
            this.executor.submit(() -> {
                LOG.info("Collecting vulnerabilities from CPE for artifact [{} / {}] [{}: {} {}]", new Object[]{finalI + 1, inventory.getArtifacts().size(), artifact.getId(), artifact.get(Artifact.Attribute.COMPONENT), artifact.get(Artifact.Attribute.VERSION)});
                super.enrichVulnerabilitiesForCpe(vInventory, artifact);
            });
        }
        this.executor.setSize(16);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for custom vulnerability enrichment to finish.", e);
        }
    }
}

