/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other;

import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.KevEnrichmentConfiguration;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.kev.KevData;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.KevIndexQuery;
import java.io.File;
import java.util.LinkedHashSet;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="KEV Enrichment", phase=InventoryEnrichmentPhase.VULNERABILITY_PRIORITIZATION, intermediateFileSuffix="kev", mavenPropertyName="kevEnrichment")
public class KevEnrichment
extends InventoryEnricher {
    private static final Logger log = LoggerFactory.getLogger(KevEnrichment.class);
    private final LazySupplier<KevIndexQuery> kevIndexQueryLazySupplier;
    private KevEnrichmentConfiguration configuration = new KevEnrichmentConfiguration();

    public KevEnrichment(File baseMirrorDirectory) {
        this.kevIndexQueryLazySupplier = new LazySupplier<KevIndexQuery>(() -> new KevIndexQuery(baseMirrorDirectory));
    }

    @Override
    public KevEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        KevIndexQuery kevIndexQuery = (KevIndexQuery)this.kevIndexQueryLazySupplier.get();
        LinkedHashSet foundKevFromVulnerabilities = new LinkedHashSet();
        for (Vulnerability vulnerability : vInventory.getVulnerabilities()) {
            kevIndexQuery.findKevDataForVulnerability(vulnerability.getId()).ifPresent(kevData -> {
                vulnerability.setKevData((KevData)kevData);
                foundKevFromVulnerabilities.add(vulnerability.getId());
            });
        }
        log.info("Found KEV information for [{}] vulnerabilities", (Object)foundKevFromVulnerabilities.size());
        log.debug("Found KEV information for the following vulnerabilities: {}", foundKevFromVulnerabilities);
        vInventory.writeBack();
    }

    public void setConfiguration(KevEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }
}

