/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other.timeline;

import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimeline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

public class VulnerabilityTimelineGeneratorResult {
    private static final Logger log = LoggerFactory.getLogger(VulnerabilityTimelineGeneratorResult.class);
    private final List<VulnerabilityTimeline> timelines;

    public VulnerabilityTimelineGeneratorResult(List<VulnerabilityTimeline> timelines) {
        if (timelines == null) {
            log.warn("timelines is null in {}. Creating empty list.", (Object)this.getClass().getSimpleName());
            this.timelines = new ArrayList<VulnerabilityTimeline>();
        } else {
            this.timelines = timelines.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    public VulnerabilityTimelineGeneratorResult() {
        this.timelines = new ArrayList<VulnerabilityTimeline>();
    }

    public List<VulnerabilityTimeline> getTimelinesForArtifact(Artifact artifact, String vulnerabilityId) {
        if (vulnerabilityId == null) {
            log.warn("vulnerabilityId is null in {}. Returning empty list for artifact {}", (Object)this.getClass().getSimpleName(), (Object)(artifact != null ? artifact.getId() : null));
            return new ArrayList<VulnerabilityTimeline>();
        }
        List<Cpe> cpeUrisOnArtifact = CommonEnumerationUtil.parseEffectiveCpe(artifact);
        List<Pair<String, String>> vendorProductsOnArtifact = CommonEnumerationUtil.getVendorProducts(cpeUrisOnArtifact);
        ArrayList<VulnerabilityTimeline> result = new ArrayList<VulnerabilityTimeline>();
        for (VulnerabilityTimeline timeline : this.timelines) {
            if (timeline == null || !timeline.containsVulnerability(vulnerabilityId)) continue;
            this.addTimelineToResultWhenMatching(timeline, vendorProductsOnArtifact, result);
        }
        if (result.isEmpty()) {
            for (VulnerabilityTimeline timeline : this.timelines) {
                if (timeline == null) continue;
                this.addTimelineToResultWhenMatching(timeline, vendorProductsOnArtifact, result);
            }
            if (result.size() > 2) {
                result.subList(2, result.size()).clear();
            }
        }
        return result;
    }

    private void addTimelineToResultWhenMatching(VulnerabilityTimeline timeline, List<Pair<String, String>> vendorProductsOnArtifact, List<VulnerabilityTimeline> result) {
        if (timeline == null) {
            return;
        }
        String vendor = timeline.getVendor();
        String product = timeline.getProduct();
        if (vendor != null && product != null) {
            for (Pair<String, String> vp : vendorProductsOnArtifact) {
                if (!vendor.equals(vp.getLeft()) || !product.equals(vp.getRight())) continue;
                result.add(timeline);
                break;
            }
        }
    }

    public List<VulnerabilityTimeline> getTimelinesForArtifacts(Collection<Artifact> artifacts, String vulnerabilityId) {
        ArrayList<VulnerabilityTimeline> result = new ArrayList<VulnerabilityTimeline>();
        for (Artifact artifact : artifacts) {
            result.addAll(this.getTimelinesForArtifact(artifact, vulnerabilityId));
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    public List<VulnerabilityTimeline> getTimelines() {
        return this.timelines;
    }
}

