/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.other.vad;

import com.metaeffekt.artifact.analysis.dashboard.Dashboard;
import com.metaeffekt.artifact.analysis.dashboard.Modal;
import com.metaeffekt.artifact.analysis.dashboard.NavigationCellStyle;
import com.metaeffekt.artifact.analysis.dashboard.NavigationColumnHeaderConfig;
import com.metaeffekt.artifact.analysis.dashboard.Sheet;
import com.metaeffekt.artifact.analysis.dashboard.SheetParagraph;
import com.metaeffekt.artifact.analysis.dashboard.SvgIcon;
import com.metaeffekt.artifact.analysis.dashboard.elements.ContentCard;
import com.metaeffekt.artifact.analysis.dashboard.elements.TableBuilder;
import com.metaeffekt.artifact.analysis.utils.BuildProperties;
import com.metaeffekt.artifact.analysis.utils.JFreeChartUtils;
import com.metaeffekt.artifact.analysis.utils.LazySupplier;
import com.metaeffekt.artifact.analysis.utils.StringUtils;
import com.metaeffekt.artifact.analysis.utils.TimeUtils;
import com.metaeffekt.artifact.analysis.utils.Vector;
import com.metaeffekt.artifact.analysis.vulnerability.CommonEnumerationUtil;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.InventoryAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.VersionComparator;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.filter.FilterAttribute;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.score.VulnerabilityPriorityCalculator;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatus;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusConverter;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusHistoryEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.vulnerabilitystatus.VulnerabilityStatusReviewedEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarnings;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.VadDetailLevelConfiguration;
import com.metaeffekt.artifact.enrichment.configurations.VulnerabilityAssessmentDashboardEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.other.VulnerabilityOverviewChartGenerator;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimeline;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimelineGenerator;
import com.metaeffekt.artifact.enrichment.other.timeline.VulnerabilityTimelineGeneratorResult;
import com.metaeffekt.artifact.enrichment.other.vad.VadPriorityScoreSection;
import com.metaeffekt.mirror.contents.advisory.AdvisoryEntry;
import com.metaeffekt.mirror.contents.advisory.CertEuAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.CertFrAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.CertSeiAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.GhsaAdvisorEntry;
import com.metaeffekt.mirror.contents.advisory.MsrcAdvisorEntry;
import com.metaeffekt.mirror.contents.base.DataSourceIndicator;
import com.metaeffekt.mirror.contents.base.DescriptionParagraph;
import com.metaeffekt.mirror.contents.base.Reference;
import com.metaeffekt.mirror.contents.base.VulnerabilityContextInventory;
import com.metaeffekt.mirror.contents.eol.EolCycle;
import com.metaeffekt.mirror.contents.eol.export.CycleScenarioRating;
import com.metaeffekt.mirror.contents.eol.export.CycleStateScenario;
import com.metaeffekt.mirror.contents.eol.export.ExportedCycleState;
import com.metaeffekt.mirror.contents.kev.KevData;
import com.metaeffekt.mirror.contents.msrcdata.MsThreat;
import com.metaeffekt.mirror.contents.msrcdata.MsrcProduct;
import com.metaeffekt.mirror.contents.msrcdata.MsrcRemediation;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeIdentifier;
import com.metaeffekt.mirror.contents.store.AdvisoryTypeStore;
import com.metaeffekt.mirror.contents.store.ContentIdentifierStore;
import com.metaeffekt.mirror.contents.store.VulnerabilityTypeStore;
import com.metaeffekt.mirror.contents.vulnerability.Vulnerability;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareTreeNode;
import com.metaeffekt.mirror.contents.vulnerability.VulnerableSoftwareVersionRangeCpe;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import com.metaeffekt.mirror.query.MsrcProductIndexQuery;
import com.metaeffekt.mirror.query.NvdCpeApiIndexQuery;
import com.metaeffekt.mirror.query.NvdCveIndexQuery;
import de.yanwittmann.j2chartjs.chart.Chart;
import de.yanwittmann.j2chartjs.chart.LineChart;
import de.yanwittmann.j2chartjs.chart.RadarChart;
import de.yanwittmann.j2chartjs.data.ChartData;
import de.yanwittmann.j2chartjs.data.LineChartData;
import de.yanwittmann.j2chartjs.data.RadarChartData;
import de.yanwittmann.j2chartjs.dataset.ChartDataset;
import de.yanwittmann.j2chartjs.dataset.LineChartDataset;
import de.yanwittmann.j2chartjs.dataset.RadarChartDataset;
import de.yanwittmann.j2chartjs.options.ChartOptions;
import de.yanwittmann.j2chartjs.options.interaction.InteractionOption;
import de.yanwittmann.j2chartjs.options.plugins.title.TitleOption;
import de.yanwittmann.j2chartjs.options.scale.LinearScaleOption;
import de.yanwittmann.j2chartjs.options.scale.RadialScaleOption;
import de.yanwittmann.j2chartjs.options.scale.RadialScaleTicksOption;
import de.yanwittmann.j2chartjs.options.scale.ScaleTitleOption;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.Tag;
import j2html.tags.UnescapedText;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.BTag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.CanvasTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H1Tag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.H4Tag;
import j2html.tags.specialized.InputTag;
import j2html.tags.specialized.LiTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.SelectTag;
import j2html.tags.specialized.SpanTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.TextareaTag;
import j2html.tags.specialized.TrTag;
import j2html.tags.specialized.UlTag;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jfree.chart.ChartColor;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.InventoryInfo;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.metaeffekt.core.inventory.processor.report.configuration.CentralSecurityPolicyConfiguration;
import org.metaeffekt.core.inventory.processor.report.configuration.VulnerabilityPriorityScoreConfiguration;
import org.metaeffekt.core.security.cvss.CvssSeverityRanges;
import org.metaeffekt.core.security.cvss.CvssSource;
import org.metaeffekt.core.security.cvss.CvssVector;
import org.metaeffekt.core.security.cvss.KnownCvssEntities;
import org.metaeffekt.core.security.cvss.MultiScoreCvssVector;
import org.metaeffekt.core.security.cvss.processor.BakedCvssVectorScores;
import org.metaeffekt.core.security.cvss.processor.CvssSelectionResult;
import org.metaeffekt.core.security.cvss.processor.UniversalCvssCalculatorLinkGenerator;
import org.metaeffekt.core.security.cvss.v2.Cvss2;
import org.metaeffekt.core.security.cvss.v3.Cvss3P1;
import org.metaeffekt.core.security.cvss.v4P0.Cvss4P0;
import org.metaeffekt.core.util.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;

@EnricherMetadata(name="Vulnerability Assessment Dashboard", phase=InventoryEnrichmentPhase.REPORTING, intermediateFileSuffix="vulnerability-assessment-dashboard", mavenPropertyName="vulnerabilityAssessmentDashboardEnrichment", shouldWriteIntermediateInventory=false)
public class VulnerabilityAssessmentDashboard
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityAssessmentDashboard.class);
    public static final String VERSION = "v" + BuildProperties.getVulnerabilityAssessmentDashboardVersion();
    public static final String ARTIFACT_ANALYSIS_VERSION = BuildProperties.getProjectVersion();
    public static final List<AdvisoryTypeIdentifier<?>> SECURITY_ADVISORY_DISPLAY_ORDERING = Arrays.asList(AdvisoryTypeStore.MSRC, AdvisoryTypeStore.GHSA, AdvisoryTypeStore.CERT_EU, AdvisoryTypeStore.CERT_SEI, AdvisoryTypeStore.CERT_FR);
    private final LazySupplier<NvdCveIndexQuery> vulnerabilityQuery;
    private final LazySupplier<NvdCpeApiIndexQuery> cpeDictionary;
    private final LazySupplier<MsrcProductIndexQuery> msrcProductIndexQuery;
    private VulnerabilityAssessmentDashboardEnrichmentConfiguration configuration = new VulnerabilityAssessmentDashboardEnrichmentConfiguration();
    private final Random random = new Random();
    private static final Pattern CVE_LINK_PATTERN = Pattern.compile("(?<![/\\[<>\"])(CVE-\\d+-\\d+)(?=[^0-9]|$)(?![/\\]<>\"])");
    private static final Pattern HTTP_URL_REGEX = Pattern.compile("https?:\\/\\/(www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_\\+.~#?&\\/=]*)");
    private final NavigationCellStyle cvssScoringStyle = (cellData, additionalInformation) -> {
        String generalStyling = "text-align:end;";
        try {
            if (additionalInformation instanceof String) {
                if (additionalInformation.equals("override_gray")) {
                    return "text-align:end;color: var(--" + ColorScheme.PASTEL_GRAY.getCssRootName() + ");";
                }
                if (cellData.equals("N/A") || cellData.equals("NaN")) {
                    return "text-align:end;";
                }
            }
            return "text-align:end;color: var(--" + super.getSecurityPolicyConfiguration().getCvssSeverityRanges().getRange(Double.parseDouble(cellData)).getColor().getCssRootName() + ");";
        }
        catch (Exception e) {
            return "text-align:end;";
        }
    };
    private final NavigationCellStyle priorityLabelStyle = (cellData, additionalInformation) -> {
        String generalStyling = "text-align:center;";
        try {
            if (StringUtils.hasText(cellData)) {
                return "text-align:center;color: var(--" + super.getSecurityPolicyConfiguration().getPriorityScoreSeverityRanges().getRangeByName(cellData).getColor().getCssRootName() + ");";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "text-align:center;";
    };
    private final NavigationCellStyle epssScoreStyle = (cellData, additionalInformation) -> {
        String generalStyling = "text-align:end;";
        try {
            if (additionalInformation instanceof String) {
                if (additionalInformation.equals("override_gray")) {
                    return "text-align:end;color: var(--" + ColorScheme.PASTEL_GRAY.getCssRootName() + ");";
                }
                if (cellData.equals("N/A") || cellData.equals("NaN")) {
                    return "text-align:end;";
                }
            }
            return "text-align:end;color: var(--" + this.getEpssScoreColor(Double.parseDouble(cellData)) + ");";
        }
        catch (Exception e) {
            return "text-align:end;";
        }
    };
    private static final String SEARCH_EMOJI = "\ud83d\udd0d";

    public VulnerabilityAssessmentDashboard(File baseMirrorDirectory) {
        this.vulnerabilityQuery = new LazySupplier<NvdCveIndexQuery>(() -> new NvdCveIndexQuery(baseMirrorDirectory));
        this.cpeDictionary = new LazySupplier<NvdCpeApiIndexQuery>(() -> new NvdCpeApiIndexQuery(baseMirrorDirectory));
        this.msrcProductIndexQuery = new LazySupplier<MsrcProductIndexQuery>(() -> new MsrcProductIndexQuery(baseMirrorDirectory));
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        LOG.info("Parsing inventory data");
        VulnerabilityContextInventory vInventory = VulnerabilityContextInventory.fromInventory(inventory);
        LOG.info("Baking effective CVSS vectors");
        vInventory.calculateEffectiveCvssVectorsForVulnerabilities(super.getSecurityPolicyConfiguration());
        LOG.info("Applying effective vulnerability status");
        vInventory.applyEffectiveVulnerabilityStatus(super.getSecurityPolicyConfiguration());
        LOG.info("Using calculated values for potential vulnerability filtering");
        List<Vulnerability> effectiveVulnerabilities = VulnerabilityAssessmentDashboard.getEffectiveVulnerabilitiesAll(vInventory, this.configuration, super.getSecurityPolicyConfiguration());
        LOG.info("Initializing dashboard");
        Dashboard dashboard = this.initializeDashboard(vInventory);
        LOG.info("Starting dashboard generation");
        Map<Artifact, List<Vulnerability>> vulnerabilitiesPerArtifact = Vulnerability.groupVulnerabilitiesByArtifact(effectiveVulnerabilities);
        Map<Vulnerability, VadDetailLevelConfiguration> vulnerabilityDetails = this.determineVulnerabilityDetailLevels(effectiveVulnerabilities);
        this.setFaviconDependingOnVulnerabilityPresence(dashboard, !effectiveVulnerabilities.isEmpty());
        VulnerabilityTimelineGeneratorResult vulnerabilityTimelines = this.generateApplicableVulnerabilityTimelines(effectiveVulnerabilities, vulnerabilityDetails);
        LOG.info("Processing vulnerabilities...");
        Modal inventoryWarningsModal = this.createInventoryWarningsModal(inventory, vulnerabilityDetails.keySet());
        dashboard.addModal(inventoryWarningsModal);
        LOG.info("");
        for (Vulnerability vulnerability2 : effectiveVulnerabilities) {
            VadDetailLevelConfiguration detailLevel = vulnerabilityDetails.get(vulnerability2);
            this.executor.submit(() -> {
                LOG.debug("Processing vulnerability: [{}]", (Object)vulnerability2.getId());
                try {
                    dashboard.addSheet(this.createVulnerabilitySheet(vulnerability2, effectiveVulnerabilities, vulnerabilityTimelines, detailLevel));
                }
                catch (Exception e) {
                    LOG.error("Failed to create vulnerability sheet for vulnerability: {}", (Object)vulnerability2.getId(), (Object)e);
                    throw new RuntimeException("Failed to create vulnerability sheet for vulnerability: " + vulnerability2.getId(), e);
                }
            });
        }
        this.executor.setSize(1);
        this.executor.start();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed to wait for all vulnerability sheets to be created", e);
        }
        dashboard.sortSheets(Comparator.comparing(sheet -> {
            String id = sheet.getId();
            if (id.equalsIgnoreCase("inventory warnings")) {
                return "!!!inventory warnings";
            }
            return id;
        }));
        LOG.info("Generating overview charts");
        VulnerabilityOverviewChartGenerator overviewChartGenerator = new VulnerabilityOverviewChartGenerator(vInventory, super.getSecurityPolicyConfiguration(), effectiveVulnerabilities, vulnerabilitiesPerArtifact);
        List<GeneratedChart> overviewCharts = overviewChartGenerator.generateOverviewCharts();
        for (GeneratedChart overviewChart : overviewCharts) {
            overviewChart.writeSvgTo(this.configuration.getSvgDirectory());
        }
        dashboard.addModal(this.generateOverviewModal(overviewCharts));
        dashboard.addModal(this.generateAssessmentEditorModal());
        dashboard.addBottomLeftBadge(inventory.getArtifacts().size() + " artifact" + this.plural(inventory.getArtifacts().size()));
        dashboard.addBottomLeftBadge(effectiveVulnerabilities.size() + " vulnerabilitie" + this.plural(effectiveVulnerabilities.size()));
        List priorityScores = effectiveVulnerabilities.stream().map(vulnerability -> vulnerability.calculatePriorityScore(this.securityPolicyConfiguration)).collect(Collectors.toList());
        List priorityScoreRanges = priorityScores.stream().filter(VulnerabilityPriorityCalculator.PriorityScoreResult::isElevated).map(score -> this.securityPolicyConfiguration.getPriorityScoreSeverityRanges().getRange(score.getResultingScore())).collect(Collectors.toList());
        CvssSeverityRanges.SeverityRange[] priorityScoreSeverityRanges = this.securityPolicyConfiguration.getPriorityScoreSeverityRanges().getRanges();
        for (int i = 0; i < priorityScoreSeverityRanges.length - 1; ++i) {
            CvssSeverityRanges.SeverityRange severityRange = priorityScoreSeverityRanges[i];
            dashboard.addBottomLeftBadge(TagCreator.span((String)(priorityScoreRanges.stream().filter(range -> range == severityRange).count() + " " + severityRange.getName())), i == 0 ? "danger" : "warning");
        }
        dashboard.addBottomLeftBadge(vInventory.getSecurityAdvisories().size() + " advisorie" + this.plural(vInventory.getSecurityAdvisories().size()));
        int ignoredVulnerabilitiesCount = vInventory.getVulnerabilities().size() - effectiveVulnerabilities.size();
        if (ignoredVulnerabilitiesCount > 0) {
            dashboard.addBottomLeftBadge(ignoredVulnerabilitiesCount + " ignored");
        }
        this.addAdditionalInventoryInformation(inventory, dashboard);
        try {
            dashboard.generateIntoFile(this.configuration.getOutputDashboardFile());
            LOG.info("Wrote dashboard to file: {}", (Object)this.configuration.getOutputDashboardFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write dashboard to file: " + this.configuration.getOutputDashboardFile(), e);
        }
    }

    private VulnerabilityTimelineGeneratorResult generateApplicableVulnerabilityTimelines(List<Vulnerability> effectiveVulnerabilities, Map<Vulnerability, VadDetailLevelConfiguration> vulnerabilityDetails) {
        VulnerabilityTimelineGeneratorResult vulnerabilityTimelines;
        if (this.configuration.isVulnerabilityTimelinesGlobalEnabled()) {
            LOG.info("Building vulnerability timelines...");
            long startTime = System.currentTimeMillis();
            NvdCveIndexQuery vulnerabilityQuery = (NvdCveIndexQuery)this.vulnerabilityQuery.get();
            NvdCpeApiIndexQuery cpeDictionary = (NvdCpeApiIndexQuery)this.cpeDictionary.get();
            VulnerabilityTimelineGenerator vulnerabilityTimelineGenerator = new VulnerabilityTimelineGenerator(vulnerabilityQuery, cpeDictionary, this.configuration, super.getSecurityPolicyConfiguration());
            for (Vulnerability vulnerability : effectiveVulnerabilities) {
                if (!vulnerabilityDetails.get(vulnerability).isTimeline()) continue;
                vulnerabilityTimelineGenerator.addRelevantVulnerability(vulnerability.getId());
                HashSet<Pair<String, String>> allVendorProducts = new HashSet<Pair<String, String>>();
                HashMap<Artifact, List<Pair<String, String>>> vendorProductsPerArtifact = new HashMap<Artifact, List<Pair<String, String>>>();
                List<VulnerableSoftwareVersionRangeCpe> affectedCpes = VulnerableSoftwareTreeNode.getAllCpes(vulnerability.getVulnerableSoftwareConfigurations());
                this.findVendorProductsOnArtifactsForVulnerabilityTimeline(vulnerability.getAffectedArtifactsByDefaultKey(), affectedCpes, allVendorProducts, vendorProductsPerArtifact);
                for (Pair pair : allVendorProducts) {
                    vulnerabilityTimelineGenerator.addVendorProduct((String)pair.getLeft(), (String)pair.getRight());
                }
            }
            vulnerabilityTimelines = vulnerabilityTimelineGenerator.generate(this.executor);
            LOG.info("Generated [{}] timelines in [{}]", (Object)vulnerabilityTimelines.getTimelines().size(), (Object)TimeUtils.formatTimeNoSuffixPrefix(System.currentTimeMillis() - startTime));
        } else {
            vulnerabilityTimelines = new VulnerabilityTimelineGeneratorResult();
        }
        return vulnerabilityTimelines;
    }

    private Modal createInventoryWarningsModal(Inventory inventory, Collection<Vulnerability> vulnerabilities) {
        List warnings;
        InventoryWarnings inventoryWarnings = new InventoryWarnings(inventory);
        Modal modal = new Modal();
        modal.setId("Inventory Warnings");
        modal.setTitle("Inventory Warnings");
        modal.setToggleKey("KeyU");
        modal.setShowInSidebar(inventoryWarnings.hasData());
        modal.setSvgIcon(SvgIcon.EXCLAMATION_TRIANGLE_FILL);
        if (!inventoryWarnings.hasData()) {
            modal.with(new DomContent[]{TagCreator.p((String)"No warnings found.")});
            modal.setSize(Modal.Size.NORMAL);
            return modal;
        }
        modal.setSize(Modal.Size.ADJUST);
        List artifactWarnings = inventoryWarnings.getArtifactWarnings();
        List vulnerabilityWarnings = inventoryWarnings.getVulnerabilityWarnings();
        List<String> sourcelessWarnings = inventoryWarnings.getSourcelessWarnings();
        Map groupedArtifactWarnings = InventoryWarningEntry.groupBySource(artifactWarnings);
        Map groupedVulnerabilityWarnings = InventoryWarningEntry.groupBySource(vulnerabilityWarnings);
        if (!artifactWarnings.isEmpty()) {
            TableTag artifactWarningsTable = (TableTag)TagCreator.table().withClass("basic-table");
            artifactWarningsTable.with((DomContent)TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Id"), TagCreator.th((String)"Component"), TagCreator.th((String)"Version"), TagCreator.th((String)"Messages")})}));
            TbodyTag artifactWarningsTbody = TagCreator.tbody();
            artifactWarningsTable.with((DomContent)artifactWarningsTbody);
            for (Map.Entry entry : groupedArtifactWarnings.entrySet()) {
                Artifact artifact = (Artifact)entry.getKey();
                warnings = (List)entry.getValue();
                artifactWarningsTbody.with((DomContent)((TrTag)((TrTag)((TrTag)TagCreator.tr().with((DomContent)TagCreator.td((String)artifact.getId()))).with((DomContent)TagCreator.td((String)artifact.getComponent()))).with((DomContent)TagCreator.td((String)artifact.getVersion()))).with((DomContent)TagCreator.td((DomContent[])new DomContent[]{this.createInventoryWarningsEntry(warnings, vulnerabilities)})));
            }
            modal.getEditableContent().with(new DomContent[]{TagCreator.h3((String)"Artifact"), artifactWarningsTable, TagCreator.br()});
        }
        if (!vulnerabilityWarnings.isEmpty()) {
            TableTag vulnerabilityWarningsTable = (TableTag)TagCreator.table().withClass("basic-table");
            vulnerabilityWarningsTable.with((DomContent)TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Name"), TagCreator.th((String)"Messages")})}));
            TbodyTag vulnerabilityWarningsTbody = TagCreator.tbody();
            vulnerabilityWarningsTable.with((DomContent)vulnerabilityWarningsTbody);
            for (Map.Entry entry : groupedVulnerabilityWarnings.entrySet()) {
                VulnerabilityMetaData vulnerabilityMetaData = (VulnerabilityMetaData)entry.getKey();
                warnings = (List)entry.getValue();
                String name = vulnerabilityMetaData.get(VulnerabilityMetaData.Attribute.NAME);
                vulnerabilityWarningsTbody.with((DomContent)((TrTag)TagCreator.tr().with((DomContent)((TdTag)TagCreator.td((String)name).attr("onclick", (Object)("showModal('" + name + "')"))).withClass("clickable"))).with((DomContent)TagCreator.td((DomContent[])new DomContent[]{this.createInventoryWarningsEntry(warnings, vulnerabilities)})));
            }
            modal.getEditableContent().with(new DomContent[]{TagCreator.h3((String)"Vulnerability"), vulnerabilityWarningsTable, TagCreator.br()});
        }
        if (!sourcelessWarnings.isEmpty()) {
            TableTag sourcelessWarningsTable = (TableTag)TagCreator.table().withClass("basic-table");
            sourcelessWarningsTable.with((DomContent)TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Messages")})}));
            TbodyTag sourcelessWarningsTbody = TagCreator.tbody();
            sourcelessWarningsTable.with((DomContent)sourcelessWarningsTbody);
            for (String string : sourcelessWarnings) {
                sourcelessWarningsTbody.with((DomContent)TagCreator.tr().with((DomContent)TagCreator.td((String)string)));
            }
            modal.getEditableContent().with(new DomContent[]{TagCreator.h3((String)"Sourceless"), sourcelessWarningsTable});
        }
        return modal;
    }

    private <T extends AbstractModelBase> SpanTag createInventoryWarningsEntry(List<InventoryWarningEntry<T>> warnings, Collection<Vulnerability> vulnerabilities) {
        SpanTag spanTag = TagCreator.span();
        HashSet<String> knownWarnings = new HashSet<String>();
        for (int i = 0; i < warnings.size(); ++i) {
            String croppedStart;
            InventoryWarningEntry<T> warning = warnings.get(i);
            String rawWarningText = warning.getWarning();
            Pattern REFERENCES_PATTERN = Pattern.compile("(.*) \\(references (.*)\\)");
            Matcher matcher = REFERENCES_PATTERN.matcher(rawWarningText);
            ArrayList<String> references = new ArrayList<String>();
            if (matcher.matches()) {
                croppedStart = matcher.group(1);
                references.addAll(Arrays.asList(matcher.group(2).split(", ")));
            } else {
                croppedStart = rawWarningText;
            }
            String warningText = croppedStart + (StringUtils.hasText(warning.getCreator()) ? " (" + warning.getCreator() + ") " : " ");
            if (!knownWarnings.add(warningText)) continue;
            spanTag.with((DomContent)TagCreator.text((String)warningText));
            if (!references.isEmpty()) {
                for (String reference : references) {
                    String badge = this.makeVulnerabilityReferenceBadge(reference, vulnerabilities);
                    spanTag.with((DomContent)TagCreator.rawHtml((String)badge));
                }
            }
            if (i >= warnings.size() - 1) continue;
            spanTag.with((DomContent)TagCreator.br());
        }
        return spanTag;
    }

    private void applyInventoryInfoDashboardCustomization(Dashboard dashboard, VulnerabilityContextInventory vInventory) {
        InventoryInfo vadCustomization = vInventory.getInventory().findInventoryInfo("vad-customization");
        if (vadCustomization != null) {
            if (StringUtils.hasText(vadCustomization.get("Title"))) {
                dashboard.setTitle(vadCustomization.get("Title"));
            }
            if (StringUtils.hasText(vadCustomization.get("Subtitle"))) {
                dashboard.setSubtitle(vadCustomization.get("Subtitle"));
            }
            if (StringUtils.hasText(vadCustomization.get("Footer"))) {
                dashboard.addBottomLeftBadge(vadCustomization.get("Footer"));
            }
        }
    }

    private Dashboard initializeDashboard(VulnerabilityContextInventory vInventory) {
        List<String> onFilterScript;
        Dashboard dashboard = new Dashboard();
        dashboard.setTitle("Vulnerability Assessment Dashboard");
        dashboard.setDescription("An interactive HTML dashboard that allows for the assessment of vulnerability data.");
        dashboard.setAuthor("Powered by {met\u00e6ffekt}");
        dashboard.setAuthorUrl("https://www.metaeffekt.com");
        dashboard.setVersion(ARTIFACT_ANALYSIS_VERSION + " " + VERSION);
        dashboard.setContentSheetEntryNames("Vulnerability", "Vulnerabilities");
        this.applyInventoryInfoDashboardCustomization(dashboard, vInventory);
        dashboard.setChartJsEnabled(true);
        if (vInventory.getInventory().getArtifacts().isEmpty()) {
            dashboard.setEmptyDashboardText("The source inventory does not contain any components.");
            dashboard.setEmptyDashboardTextSize(250);
            dashboard.setEmptyDashboardIcon("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"120\" height=\"120\" fill=\"orange\" class=\"bi bi-patch-check-fill\" viewBox=\"0 0 16 16\" style=\"position: absolute; left: calc(50% - 60px); top: calc(50% - 90px);\">\n  <path d=\"M15 8a6.97 6.97 0 0 0-1.71-4.584l-9.874 9.875A7 7 0 0 0 15 8M2.71 12.584l9.874-9.875a7 7 0 0 0-9.874 9.874ZM16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0\"/></svg>");
        }
        try {
            List<String> nvdLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/nvd.txt");
            dashboard.addLicenseText("NVD", String.join((CharSequence)"\n", nvdLicense), d -> true);
            List<String> msrcLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/msrc.txt");
            dashboard.addLicenseText("MSRC", String.join((CharSequence)"\n", msrcLicense), d -> d.getSheetParagraphTitles().contains("Microsoft Security Upgrade Guide"));
            List<String> ghsaLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/ghsa.txt");
            dashboard.addLicenseText("GitHub Advisory Database", String.join((CharSequence)"\n", ghsaLicense), d -> d.getSheetParagraphTitles().contains("GitHub Security Advisory"));
            List<String> list = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/eol-date.txt");
            dashboard.addLicenseText("EOL", String.join((CharSequence)"\n", list), d -> d.getSheetParagraphTitles().contains("EOL"));
            List<String> certFrLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/cert-fr.txt");
            dashboard.addLicenseText("CERT-FR", String.join((CharSequence)"\n", certFrLicense), d -> d.getSheetParagraphTitles().contains("CERT-FR"));
            List<String> certEuLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/cert-eu.txt");
            dashboard.addLicenseText("CERT-EU", String.join((CharSequence)"\n", certEuLicense), d -> d.getSheetParagraphTitles().contains("CERT-EU"));
            List<String> certSeiLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/cert-sei.txt");
            dashboard.addLicenseText("CERT-SEI", String.join((CharSequence)"\n", certSeiLicense), d -> d.getSheetParagraphTitles().contains("CERT-SEI"));
            List<String> metaeffektLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/metaeffekt.txt");
            dashboard.addLicenseText("{met\u00e6ffekt}", String.join((CharSequence)"\n", metaeffektLicense), d -> true);
            List<String> epssLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/epss.txt");
            dashboard.addLicenseText("EPSS", String.join((CharSequence)"\n", epssLicense), d -> true);
            List<String> kevLicense = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/licenses/kev.txt");
            dashboard.addLicenseText("KEV", String.join((CharSequence)"\n", kevLicense), d -> true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (CvssSeverityRanges.SeverityRange severityRange : super.getSecurityPolicyConfiguration().getCvssSeverityRanges().getRanges()) {
            if (severityRange.getName().equals("None")) continue;
            Dashboard.NavigationFilter lowerBound = Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_CVSS_UNMODIFIED_OVERALL.getTitle().replace("<br>", "")).operation(Dashboard.FilterOperation.LARGER_EQUALS).value(severityRange.getFloor()).build();
            Dashboard.NavigationFilter upperBound = Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_CVSS_UNMODIFIED_OVERALL.getTitle().replace("<br>", "")).operation(Dashboard.FilterOperation.SMALLER_EQUALS).value(severityRange.getCeil()).build();
            dashboard.addNavigationFilterTemplates(severityRange.getName(), lowerBound, upperBound);
        }
        dashboard.addNavigationFilterTemplates("Void", Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_STATUS.getTitle()).operation(Dashboard.FilterOperation.EQUALS).value("void").build());
        dashboard.addNavigationFilterTemplates("Not Void", Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_STATUS.getTitle()).operation(Dashboard.FilterOperation.NOT_EQUALS).value("void").build());
        dashboard.addNavigationFilterTemplates("Not Insignificant", Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_STATUS.getTitle()).operation(Dashboard.FilterOperation.NOT_EQUALS).value("insignificant").build());
        dashboard.addNavigationFilterTemplates("In Review", Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_STATUS.getTitle()).operation(Dashboard.FilterOperation.EQUALS).value("in review").build());
        dashboard.addNavigationFilterTemplates("Not In Review", Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_STATUS.getTitle()).operation(Dashboard.FilterOperation.NOT_EQUALS).value("in review").build());
        dashboard.addNavigationFilterTemplates("Known exploited", Dashboard.navigationFilterBuilder().column(NavigationHeaders.NAVIGATION_KEV_ENTRY.getTitle()).operation(Dashboard.FilterOperation.NOT_EQUALS).value("N/A").build());
        try {
            onFilterScript = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/dashboard-vad-onfilter.js");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load resource [dashboard/dashboard-vad-onfilter.js]", e);
        }
        StringBuilder prependOnFilterApplied = new StringBuilder();
        prependOnFilterApplied.append("let cvssRanges= [");
        StringJoiner rangesArray = new StringJoiner(",");
        for (CvssSeverityRanges.SeverityRange range : super.getSecurityPolicyConfiguration().getCvssSeverityRanges().getRanges()) {
            rangesArray.add("{name:'" + range.getName() + "',color:'" + range.getColor().toHex() + "',floor:" + range.getFloor() + ",ceil:" + range.getCeil() + "}");
        }
        prependOnFilterApplied.append(rangesArray).append("];");
        prependOnFilterApplied.append("let statuses = ").append(CentralSecurityPolicyConfiguration.VULNERABILITY_STATUS_DISPLAY_MAPPER_UNMODIFIED.getStatusNames().stream().collect(Collectors.joining("','", "['", "'];")));
        prependOnFilterApplied.append(CentralSecurityPolicyConfiguration.VULNERABILITY_STATUS_DISPLAY_MAPPER_UNMODIFIED.getJsMappingFunction("reviewStateMappingFunction")).append(";");
        onFilterScript.add(0, prependOnFilterApplied.toString());
        dashboard.addOnFilterApplied(String.join((CharSequence)"", onFilterScript));
        try {
            dashboard.addAdditionalContent((Tag<?>)TagCreator.script((String)String.join((CharSequence)"", Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/dashboard-vad-scripts.js"))));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to load resource [dashboard/dashboard-vad-scripts.js]", iOException);
        }
        try {
            List<String> list = Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/dashboard-vad-onthemechange.js");
            dashboard.addOnThemeChange(String.join((CharSequence)"", list));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load resource [dashboard/dashboard-vad-onthemechange.js]", e);
        }
        try {
            dashboard.addAdditionalContent((Tag<?>)TagCreator.style((String)String.join((CharSequence)"", Dashboard.readResourceAsStringList(Dashboard.class, "dashboard/dashboard-vad-style.css"))));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load resource [dashboard/dashboard-vad-style.css]", e);
        }
        NavigationCellStyle statusStyling = (cellData, additionalInformation) -> {
            String generalStyling = "text-align:center;";
            switch (cellData) {
                case "insignificant": {
                    return "text-align:center;color: var(--pastel-gray);";
                }
                case "applicable": {
                    return "text-align:center;color: var(--strong-dark-blue);";
                }
                case "incomplete": {
                    return "text-align:center;color: var(--strong-red);";
                }
                case "not applicable": {
                    return "text-align:center;color: var(--strong-light-green);";
                }
                case "void": {
                    return "text-align:center;color: var(--strong-gray);";
                }
            }
            return "text-align:center;color: var(--pastel-blue);";
        };
        NavigationCellStyle advisoriesCounterStyling = (cellData, additionalInformation) -> {
            String generalStyling = "text-align:center;";
            String[] split = cellData.replaceAll("[()]", "").split(" ", 2);
            if (split.length == 2 && split[0].equals(split[1]) || split.length == 1 && split[0].equals("0")) {
                return "text-align:center;color: var(--strong-light-green);";
            }
            if (split.length == 2) {
                return "text-align:center;color: var(--strong-yellow);";
            }
            return "text-align:center;color: var(--strong-dark-orange);";
        };
        NavigationCellStyle eolStyling = (cellData, additionalInformation) -> {
            String generalStyling = "text-align:center;";
            switch (cellData) {
                case "supported": {
                    return "text-align:center;color: var(--strong-light-green);";
                }
                case "ending support": {
                    return "text-align:center;color: var(--strong-yellow);";
                }
                case "no support": {
                    return "text-align:center;color: var(--strong-red);";
                }
                case "extended support": {
                    return "text-align:center;color: var(--strong-yellow);";
                }
            }
            return "text-align:center;color: var(--strong-dark-orange);";
        };
        NavigationCellStyle matchedViaStringStyling = (cellData, additionalInformation) -> {
            if (cellData.equals("N/A")) {
                return "color: var(--strong-dark-orange);";
            }
            return null;
        };
        NavigationCellStyle simpleCenteredTextStyling = (cellData, additionalInformation) -> "text-align:center;";
        dashboard.addNavigationColumnHeader("Name", null, NavigationColumnHeaderConfig.Alignment.START);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_CVSS_UNMODIFIED_OVERALL.getTitle(), this.cvssScoringStyle, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_CVSS_MODIFIED_OVERALL.getTitle(), this.cvssScoringStyle, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_CVSS_BASE.getTitle(), this.cvssScoringStyle, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_CVSS_EXPLOITABILITY.getTitle(), this.cvssScoringStyle, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_CVSS_IMPACT.getTitle(), this.cvssScoringStyle, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_EPSS_SCORE.getTitle(), this.epssScoreStyle, NavigationColumnHeaderConfig.Alignment.CENTER, true);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_PRIORITY_SCORE.getTitle(), this.cvssScoringStyle, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_STATUS.getTitle(), statusStyling, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_PRIORITY_SCORE_LABEL.getTitle(), this.priorityLabelStyle, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_AMOUNT_ADVISORIES_REVIEWED.getTitle(), advisoriesCounterStyling, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_KEV_ENTRY.getTitle(), simpleCenteredTextStyling, NavigationColumnHeaderConfig.Alignment.CENTER, true);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_AMOUNT_ARTIFACTS.getTitle(), simpleCenteredTextStyling, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.EOL_STATE.getTitle(), eolStyling, NavigationColumnHeaderConfig.Alignment.CENTER, true);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_VERSION.getTitle(), null, NavigationColumnHeaderConfig.Alignment.START);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_COMPONENTS.getTitle(), null, NavigationColumnHeaderConfig.Alignment.START);
        dashboard.addNavigationColumnHeader(NavigationHeaders.CORRELATION_DISTANCE.getTitle(), simpleCenteredTextStyling, NavigationColumnHeaderConfig.Alignment.CENTER);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_USED_MATCHING_INFORMATION.getTitle(), matchedViaStringStyling, NavigationColumnHeaderConfig.Alignment.START);
        dashboard.addNavigationColumnHeader(NavigationHeaders.NAVIGATION_UNUSED_MATCHING_INFORMATION.getTitle(), matchedViaStringStyling, NavigationColumnHeaderConfig.Alignment.START);
        return dashboard;
    }

    public static List<Vulnerability> getEffectiveVulnerabilitiesAll(VulnerabilityContextInventory vInventory, VulnerabilityAssessmentDashboardEnrichmentConfiguration vadConfig, CentralSecurityPolicyConfiguration securityPolicy) {
        List<Vulnerability> filtered;
        List<Vulnerability> vulnerabilities = vInventory.getSortedVulnerabilities();
        FilterAttribute filterAttribute = vadConfig.getVulnerabilityIncludeFilterAttribute();
        int sizeBefore = vulnerabilities.size();
        if (sizeBefore != (filtered = vulnerabilities.stream().filter(vulnerability -> {
            if (vulnerability.hasTag("marker")) {
                return true;
            }
            if (filterAttribute != null && !filterAttribute.matches((Vulnerability)vulnerability)) {
                return false;
            }
            if (!vInventory.isVulnerabilityIncludedRegardingAdvisoryProviders(securityPolicy, (Vulnerability)vulnerability)) {
                return false;
            }
            if (!vInventory.isVulnerabilityAboveIncludeScoreThreshold(securityPolicy, (Vulnerability)vulnerability)) {
                return false;
            }
            return vInventory.isVulnerabilityIncludedRegardingAdvisoryReviewStatus(securityPolicy, (Vulnerability)vulnerability);
        }).limit(vadConfig.getMaximumVulnerabilitiesPerDashboardCount()).collect(Collectors.toList())).size()) {
            LOG.info("Ignoring [{}] vulnerabilities for dashboard generation based on configured filters", (Object)(sizeBefore - filtered.size()));
        }
        return filtered;
    }

    public static List<Vulnerability> getEffectiveVulnerabilitiesAll(VulnerabilityContextInventory vInventory, CentralSecurityPolicyConfiguration securityPolicy) {
        List<Vulnerability> filtered;
        List<Vulnerability> vulnerabilities = vInventory.getSortedVulnerabilities();
        int sizeBefore = vulnerabilities.size();
        if (sizeBefore != (filtered = vulnerabilities.stream().filter(vulnerability -> {
            if (vulnerability.hasTag("marker")) {
                return true;
            }
            if (!vInventory.isVulnerabilityIncludedRegardingAdvisoryProviders(securityPolicy, (Vulnerability)vulnerability)) {
                return false;
            }
            if (!vInventory.isVulnerabilityAboveIncludeScoreThreshold(securityPolicy, (Vulnerability)vulnerability)) {
                return false;
            }
            return vInventory.isVulnerabilityIncludedRegardingAdvisoryReviewStatus(securityPolicy, (Vulnerability)vulnerability);
        }).collect(Collectors.toList())).size()) {
            LOG.info("Ignoring [{}] vulnerabilities for dashboard generation based on configured filters", (Object)(sizeBefore - filtered.size()));
        }
        return filtered;
    }

    private Map<Vulnerability, VadDetailLevelConfiguration> determineVulnerabilityDetailLevels(List<Vulnerability> vulnerabilities) {
        HashMap<Vulnerability, VadDetailLevelConfiguration> vulnerabilityDetailLevels = new HashMap<Vulnerability, VadDetailLevelConfiguration>();
        for (Vulnerability vulnerability : vulnerabilities) {
            Set<Artifact> vulnerabilityArtifacts = vulnerability.getAffectedArtifactsByDefaultKey();
            List<VadDetailLevelConfiguration> levels = this.configuration.getDetailLevels(vulnerability, vulnerability.getVulnerabilityStatus(), vulnerabilityArtifacts);
            List<VadDetailLevelConfiguration> artifactLevels = VadDetailLevelConfiguration.fromArtifacts(vulnerabilityArtifacts);
            artifactLevels.stream().filter(detailLevel -> detailLevel.getMatcher().matches(vulnerability, vulnerability.getVulnerabilityStatus(), vulnerabilityArtifacts)).forEach(levels::add);
            vulnerabilityDetailLevels.put(vulnerability, VadDetailLevelConfiguration.computeEffective(levels));
        }
        return vulnerabilityDetailLevels;
    }

    private List<Vulnerability> determineEffectiveVulnerabilitiesWithoutIgnored(VulnerabilityContextInventory inventory, Set<Vulnerability> ignoredVulnerabilities) {
        return inventory.getVulnerabilities().stream().filter(v -> !ignoredVulnerabilities.contains(v)).sorted().collect(Collectors.toList());
    }

    private void setFaviconDependingOnVulnerabilityPresence(Dashboard dashboard, boolean containsVulnerabilities) {
        if (containsVulnerabilities) {
            dashboard.setFavicon((LinkTag)((LinkTag)TagCreator.link().withRel("icon")).withHref("data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"red\" class=\"bi bi-bug\" viewBox=\"0 0 16 16\"><path d=\"M4.355.522a.5.5 0 0 1 .623.333l.291.956A4.979 4.979 0 0 1 8 1c1.007 0 1.946.298 2.731.811l.29-.956a.5.5 0 1 1 .957.29l-.41 1.352A4.985 4.985 0 0 1 13 6h.5a.5.5 0 0 0 .5-.5V5a.5.5 0 0 1 1 0v.5A1.5 1.5 0 0 1 13.5 7H13v1h1.5a.5.5 0 0 1 0 1H13v1h.5a1.5 1.5 0 0 1 1.5 1.5v.5a.5.5 0 1 1-1 0v-.5a.5.5 0 0 0-.5-.5H13a5 5 0 0 1-10 0h-.5a.5.5 0 0 0-.5.5v.5a.5.5 0 1 1-1 0v-.5A1.5 1.5 0 0 1 2.5 10H3V9H1.5a.5.5 0 0 1 0-1H3V7h-.5A1.5 1.5 0 0 1 1 5.5V5a.5.5 0 0 1 1 0v.5a.5.5 0 0 0 .5.5H3c0-1.364.547-2.601 1.432-3.503l-.41-1.352a.5.5 0 0 1 .333-.623zM4 7v4a4 4 0 0 0 3.5 3.97V7H4zm4.5 0v7.97A4 4 0 0 0 12 11V7H8.5zM12 6a3.989 3.989 0 0 0-1.334-2.982A3.983 3.983 0 0 0 8 2a3.983 3.983 0 0 0-2.667 1.018A3.989 3.989 0 0 0 4 6h8z\"/></svg>"));
        } else {
            dashboard.setFavicon((LinkTag)((LinkTag)TagCreator.link().withRel("icon")).withHref("data:image/svg+xml,<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"green\" class=\"bi bi-bug\" viewBox=\"0 0 16 16\"><path d=\"M4.355.522a.5.5 0 0 1 .623.333l.291.956A4.979 4.979 0 0 1 8 1c1.007 0 1.946.298 2.731.811l.29-.956a.5.5 0 1 1 .957.29l-.41 1.352A4.985 4.985 0 0 1 13 6h.5a.5.5 0 0 0 .5-.5V5a.5.5 0 0 1 1 0v.5A1.5 1.5 0 0 1 13.5 7H13v1h1.5a.5.5 0 0 1 0 1H13v1h.5a1.5 1.5 0 0 1 1.5 1.5v.5a.5.5 0 1 1-1 0v-.5a.5.5 0 0 0-.5-.5H13a5 5 0 0 1-10 0h-.5a.5.5 0 0 0-.5.5v.5a.5.5 0 1 1-1 0v-.5A1.5 1.5 0 0 1 2.5 10H3V9H1.5a.5.5 0 0 1 0-1H3V7h-.5A1.5 1.5 0 0 1 1 5.5V5a.5.5 0 0 1 1 0v.5a.5.5 0 0 0 .5.5H3c0-1.364.547-2.601 1.432-3.503l-.41-1.352a.5.5 0 0 1 .333-.623zM4 7v4a4 4 0 0 0 3.5 3.97V7H4zm4.5 0v7.97A4 4 0 0 0 12 11V7H8.5zM12 6a3.989 3.989 0 0 0-1.334-2.982A3.983 3.983 0 0 0 8 2a3.983 3.983 0 0 0-2.667 1.018A3.989 3.989 0 0 0 4 6h8z\"/></svg>"));
        }
    }

    private Sheet createVulnerabilitySheet(Vulnerability vulnerability, Collection<Vulnerability> vulnerabilities, VulnerabilityTimelineGeneratorResult vulnerabilityTimelines, VadDetailLevelConfiguration detailLevel) {
        Sheet vulnerabilitySheet = new Sheet();
        Set<Artifact> affectedArtifacts = vulnerability.getAffectedArtifactsByDefaultKey();
        vulnerabilitySheet.setId(vulnerability.getId());
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_VULNERABILITY_NAME.getTitle(), vulnerability.getId());
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_AMOUNT_ARTIFACTS.getTitle(), affectedArtifacts.size());
        List<String> artifactVersions = affectedArtifacts.stream().map(Artifact::getVersion).filter(Objects::nonNull).distinct().sorted(VersionComparator.INSTANCE).collect(Collectors.toList());
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_VERSION.getTitle(), (DomContent)VulnerabilityAssessmentDashboard.croppedNavigationTableContents(artifactVersions, 35));
        List<String> componentNames = affectedArtifacts.stream().map(Artifact::getComponent).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_COMPONENTS.getTitle(), (DomContent)VulnerabilityAssessmentDashboard.croppedNavigationTableContents(componentNames, 35));
        List<AdvisoryEntry> filteredSecurityAdvisories = vulnerability.getSecurityAdvisories().stream().filter(advisor -> super.getSecurityPolicyConfiguration().isSecurityAdvisoryIncludedRegardingEntrySourceType(advisor.getType())).filter(advisor -> super.getSecurityPolicyConfiguration().isSecurityAdvisoryIncludedRegardingEntryProvider(advisor.getSourceIdentifier().name())).filter(advisor -> detailLevel.isAdvisoryTypeEnabled(advisor.getType())).filter(advisor -> detailLevel.isAdvisoryProviderEnabled((AdvisoryTypeIdentifier<?>)advisor.getSourceIdentifier())).sorted(Comparator.comparingInt(advisor -> SECURITY_ADVISORY_DISPLAY_ORDERING.indexOf(advisor.getSourceIdentifier()))).collect(Collectors.toList());
        LinkedHashMap<AdvisoryTypeIdentifier, List> sortedBySourceSecurityAdvisories = new LinkedHashMap<AdvisoryTypeIdentifier, List>();
        HashMap<AdvisoryTypeIdentifier, AtomicInteger> amountReviewedAdvisories = new HashMap<AdvisoryTypeIdentifier, AtomicInteger>();
        for (AdvisoryEntry securityAdvisory : filteredSecurityAdvisories) {
            sortedBySourceSecurityAdvisories.computeIfAbsent((AdvisoryTypeIdentifier)securityAdvisory.getSourceIdentifier(), k -> new ArrayList()).add(securityAdvisory);
            amountReviewedAdvisories.computeIfAbsent((AdvisoryTypeIdentifier)securityAdvisory.getSourceIdentifier(), k -> new AtomicInteger(0));
        }
        boolean hasCustomTitle = vulnerability.getAdditionalAttribute(InventoryAttribute.STATUS_TITLE) != null;
        boolean isCve = vulnerability.getId().startsWith("CVE-");
        boolean isMsrcAdvisor = vulnerability.getId().startsWith("ADV");
        boolean isMarkerVulnerability = vulnerability.hasTag("marker");
        boolean hasMicrosoftAdvisory = sortedBySourceSecurityAdvisories.containsKey(AdvisoryTypeStore.MSRC);
        H1Tag mainSheetHeader = (H1Tag)TagCreator.h1().withStyle("margin: -8px 0px 0px 0px; display: inline;");
        ((H1Tag)((H1Tag)mainSheetHeader.with((DomContent)((SpanTag)TagCreator.span((String)vulnerability.getId()).withClass("copy-to-clipboard-hover")).attr("tooltip", (Object)"Click to copy to clipboard"))).with((DomContent)TagCreator.script((String)"document.querySelectorAll('.copy-to-clipboard-hover').forEach(function(element) { element.addEventListener('click', function() { copyToClipboard(element.innerText); element.classList.add('copied'); setTimeout(function() { element.classList.remove('copied'); }, 1000); }); });"))).with((DomContent)TagCreator.text((String)" "));
        if (isCve) {
            mainSheetHeader.with(new DomContent[]{this.makeHTMLLinkWithStyle("[NVD]", vulnerability.getUrl(), HrefTargets.TARGET_NVD.getTarget(), "font-size: 23px;"), TagCreator.text((String)" "), this.makeHTMLLinkWithStyle("[CVE Details]", "https://www.cvedetails.com/cve/" + vulnerability.getId(), HrefTargets.TARGET_CVEDETAILS.getTarget(), "font-size: 23px;"), TagCreator.text((String)" "), this.makeHTMLLinkWithStyle("[Mitre]", "https://www.cve.org/CVERecord?id=" + vulnerability.getId(), HrefTargets.TARGET_MITRE.getTarget(), "font-size: 23px;"), TagCreator.text((String)" ")});
        } else if (vulnerability.getUrl() != null) {
            String string = vulnerability.getDataSources().stream().map(ContentIdentifierStore.ContentIdentifier::getWellFormedName).collect(Collectors.joining(", ", "(", ")"));
            mainSheetHeader.with(new DomContent[]{this.makeHTMLLink(string.length() >= 3 ? "[URL]" : string, vulnerability.getUrl(), HrefTargets.TARGET_NVD.getTarget()), TagCreator.text((String)" ")});
        }
        if (!isMsrcAdvisor && hasMicrosoftAdvisory) {
            mainSheetHeader.with((DomContent)this.makeHTMLLinkWithStyle("[MSRC]", "https://msrc.microsoft.com/update-guide/en-US/vulnerability/" + vulnerability.getId(), HrefTargets.TARGET_MICROSOFT.getTarget(), "font-size: 23px;"));
        }
        SpanTag spanTag = (SpanTag)TagCreator.span().with((DomContent)mainSheetHeader);
        if (hasCustomTitle) {
            spanTag.with((DomContent)TagCreator.h2((String)vulnerability.getAdditionalAttribute(InventoryAttribute.STATUS_TITLE)));
        }
        vulnerabilitySheet.setTitle((Tag<?>)spanTag);
        vulnerabilitySheet.addParagraph(this.createParagraphDescription(vulnerability));
        if (!isMarkerVulnerability) {
            vulnerabilitySheet.addParagraph(this.createParagraphArtifactsCpe(vulnerability, vulnerabilitySheet));
            if (!vulnerabilityTimelines.getTimelines().isEmpty()) {
                vulnerabilitySheet.addParagraph(this.createParagraphTimelines(vulnerability, vulnerabilityTimelines, detailLevel));
            }
        }
        if (!isMarkerVulnerability) {
            vulnerabilitySheet.addParagraph(this.createParagraphAssessment(vulnerability, vulnerabilitySheet));
        }
        if (!isMarkerVulnerability) {
            vulnerabilitySheet.addParagraph(new VadPriorityScoreSection().createParagraphPriority(this, vulnerability, vulnerabilitySheet));
        }
        if (!isMarkerVulnerability && detailLevel.isEolDate()) {
            this.createParagraphEolDate(affectedArtifacts, vulnerabilitySheet).ifPresent(vulnerabilitySheet::addParagraph);
        }
        if (vulnerability.getCwes() != null && !vulnerability.getCwes().isEmpty()) {
            vulnerabilitySheet.addParagraph(this.createParagraphCwe(vulnerability));
        }
        for (Map.Entry entry : sortedBySourceSecurityAdvisories.entrySet()) {
            AdvisoryTypeIdentifier advisoryType = (AdvisoryTypeIdentifier)entry.getKey();
            List advisories = (List)entry.getValue();
            AtomicInteger amountReviewed = (AtomicInteger)amountReviewedAdvisories.get(advisoryType);
            if (advisoryType == AdvisoryTypeStore.MSRC) {
                vulnerabilitySheet.addParagraph(this.createParagraphMicrosoftVulnerabilityInformation(vulnerability, filteredSecurityAdvisories, amountReviewed, detailLevel));
                continue;
            }
            if (advisoryType == AdvisoryTypeStore.GHSA) {
                vulnerabilitySheet.addParagraph(this.createParagraphGhsa(vulnerability, advisories, vulnerabilities, amountReviewed, detailLevel));
                continue;
            }
            if (advisoryType == AdvisoryTypeStore.CERT_SEI) {
                vulnerabilitySheet.addParagraph(this.createParagraphCertSei(vulnerability, advisories, vulnerabilities, amountReviewed, detailLevel));
                continue;
            }
            if (advisoryType == AdvisoryTypeStore.CERT_FR) {
                vulnerabilitySheet.addParagraph(this.createParagraphCertFr(vulnerability, advisories, vulnerabilities, amountReviewed, detailLevel));
                continue;
            }
            if (advisoryType == AdvisoryTypeStore.CERT_EU) {
                vulnerabilitySheet.addParagraph(this.createParagraphCertEu(vulnerability, advisories, vulnerabilities, amountReviewed, detailLevel));
                continue;
            }
            LOG.warn("No implementation for advisory source [{} / {}] has been found, treating as generic advisory source (has [{}] advisories)", new Object[]{advisoryType, advisoryType.getWellFormedName(), advisories.size()});
            vulnerabilitySheet.addParagraph(this.createParagraphGenericAdvisory(vulnerability, advisories, vulnerabilities, amountReviewed, detailLevel));
        }
        int totalAdvisorEntries = filteredSecurityAdvisories.size();
        int n = amountReviewedAdvisories.values().stream().mapToInt(AtomicInteger::get).sum();
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_AMOUNT_ADVISORIES_REVIEWED.getTitle(), totalAdvisorEntries + (n > 0 ? " (" + n + ")" : ""));
        Set<Reference> references = vulnerability.getReferences();
        if (!references.isEmpty() && detailLevel.isReferences()) {
            vulnerabilitySheet.addParagraph(this.createParagraphReferences(references));
        }
        return vulnerabilitySheet;
    }

    public static SpanTag croppedNavigationTableContents(List<String> items, int maxCharactersOnField) {
        StringBuilder reducedDisplayContent = new StringBuilder();
        int addedComponents = 0;
        for (String item : items) {
            int currentLength = reducedDisplayContent.length();
            if (currentLength != 0 && currentLength + item.length() + 2 > maxCharactersOnField) {
                reducedDisplayContent.append(", +").append(items.size() - items.indexOf(item));
                break;
            }
            if (currentLength > 0) {
                reducedDisplayContent.append(", ");
            }
            ++addedComponents;
            reducedDisplayContent.append(item);
        }
        SpanTag displayContent = TagCreator.span((String)reducedDisplayContent.toString());
        if (addedComponents != items.size()) {
            displayContent.attr("tooltip", (Object)String.join((CharSequence)", ", items));
        }
        return displayContent;
    }

    private SheetParagraph createParagraphDescription(Vulnerability vulnerability) {
        SheetParagraph descriptionParagraph = new SheetParagraph();
        descriptionParagraph.setIdentifier("Description");
        if (vulnerability.getDescription() != null) {
            descriptionParagraph.with(vulnerability.getDescription());
        }
        return descriptionParagraph;
    }

    private SheetParagraph createParagraphArtifactsCpe(Vulnerability vulnerability, Sheet vulnerabilitySheet) {
        SheetParagraph artifactsCpeParagraph = new SheetParagraph();
        artifactsCpeParagraph.setIdentifier("Artifacts & CPE");
        artifactsCpeParagraph.setTitle("Artifacts & CPE");
        Set<Artifact> vulnerabilityAffectedArtifacts = vulnerability.getAffectedArtifactsByDefaultKey();
        HashSet<Triple> coveredCpes = new HashSet<Triple>();
        if (vulnerability.getMatchingSources().isEmpty()) {
            vulnerabilitySheet.addNavigationEntry(NavigationHeaders.CORRELATION_DISTANCE.getTitle(), 0);
        } else {
            TableBuilder matchingSourcesTable = new TableBuilder("basic-table");
            LinkedHashMap<Artifact, List> matchingCriteria = new LinkedHashMap<Artifact, List>();
            Artifact emptyArtifact = new Artifact();
            HashSet<String> allMsProductIds = new HashSet<String>();
            for (DataSourceIndicator matchingSource : vulnerability.getMatchingSources()) {
                Artifact effectiveFoundArtifact;
                DataSourceIndicator.Reason matchReason = matchingSource.getMatchReason();
                if (matchReason instanceof DataSourceIndicator.ArtifactReason) {
                    DataSourceIndicator.ArtifactReason artifactReason = (DataSourceIndicator.ArtifactReason)matchReason;
                    Artifact artifact = artifactReason.findArtifact(vulnerabilityAffectedArtifacts);
                    if (artifact == null) {
                        effectiveFoundArtifact = new Artifact();
                        effectiveFoundArtifact.setId(artifactReason.getArtifactId());
                        effectiveFoundArtifact.setComponent(artifactReason.getArtifactComponent());
                        effectiveFoundArtifact.setVersion(artifactReason.getArtifactVersion());
                    } else {
                        effectiveFoundArtifact = artifact;
                    }
                } else {
                    effectiveFoundArtifact = emptyArtifact;
                }
                matchingCriteria.computeIfAbsent(effectiveFoundArtifact, k -> new ArrayList()).add(matchingSource);
            }
            double correlationDistance = 0.0;
            HashSet<String> navigationTableMatchingSources = new HashSet<String>();
            HashSet<String> allNavigationTableMatchingSources = new HashSet<String>();
            for (Map.Entry entry : matchingCriteria.entrySet()) {
                String dtCveFindings;
                Artifact artifact = (Artifact)entry.getKey();
                List matchingSources = (List)entry.getValue();
                Map<String, DomContent> row = matchingSourcesTable.createRow();
                row.put(Artifact.Attribute.ID.getKey(), this.createArtifactTableEntryForOptionallyEmpty(artifact.getId()));
                row.put(Artifact.Attribute.COMPONENT.getKey(), this.createArtifactTableEntryForOptionallyEmpty(artifact.getComponent()));
                row.put(Artifact.Attribute.VERSION.getKey(), this.createArtifactTableEntryForOptionallyEmpty(artifact.getVersion()));
                if (artifact.get(InventoryAttribute.EOL_ID.getKey()) != null) {
                    row.put("EOL Id", (DomContent)((ATag)TagCreator.a((String)artifact.get(InventoryAttribute.EOL_ID.getKey())).withHref("https://endoflife.date/" + artifact.get(InventoryAttribute.EOL_ID.getKey()))).withTarget(HrefTargets.TARGET_EOL_DATE.getTarget()));
                }
                if (artifact.getUrl() != null) {
                    row.put("URL", (DomContent)((ATag)TagCreator.a((String)artifact.getUrl()).withTarget("_blank")).withHref(artifact.getUrl()));
                }
                if (artifact.get("Organization") != null) {
                    row.put("Organization", (DomContent)TagCreator.text((String)artifact.get("Organization")));
                }
                if ((dtCveFindings = artifact.get(InventoryAttribute.DT_CVE_FINDINGS.getKey())) != null && !dtCveFindings.isEmpty()) {
                    if (Arrays.asList(dtCveFindings.split(", ?")).contains(vulnerability.getId())) {
                        row.put("Is DT Finding", (DomContent)TagCreator.text((String)"Yes"));
                    } else {
                        row.put("Is DT Finding", (DomContent)TagCreator.text((String)"No"));
                    }
                }
                if (artifact.get(InventoryAttribute.MS_PRODUCT_ID.getKey()) != null) {
                    row.put("MS Product ID", (DomContent)TagCreator.text((String)artifact.get(InventoryAttribute.MS_PRODUCT_ID.getKey())));
                    allNavigationTableMatchingSources.add("MS " + artifact.get(InventoryAttribute.MS_PRODUCT_ID.getKey()));
                }
                if (artifact.get(InventoryAttribute.PURL.getKey()) != null) {
                    row.put(Artifact.Attribute.PURL.getKey(), (DomContent)TagCreator.text((String)artifact.get(InventoryAttribute.PURL.getKey())));
                }
                if (!artifact.getProjects().isEmpty()) {
                    row.put("Projects", (DomContent)TagCreator.text((String)String.join((CharSequence)", ", artifact.getProjects())));
                }
                SpanTag matchingCriteriaContainer = TagCreator.span();
                for (DataSourceIndicator matchingSource : matchingSources) {
                    Iterator matchReason = matchingSource.getMatchReason();
                    ContentIdentifierStore.ContentIdentifier provider = matchingSource.getDataSource();
                    DivTag matchingCriteriaEntry = (DivTag)TagCreator.div().withClass("matching-criteria-badge");
                    String overwriteSource = ((DataSourceIndicator.Reason)((Object)matchReason)).overwriteSource();
                    if (overwriteSource == null) {
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)provider.getWellFormedName()));
                    } else {
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)overwriteSource));
                    }
                    if (matchReason instanceof DataSourceIndicator.ArtifactCpeReason) {
                        DataSourceIndicator.ArtifactCpeReason artifactCpeReason = (DataSourceIndicator.ArtifactCpeReason)((Object)matchReason);
                        String affectedConfiguration = artifactCpeReason.getConfiguration();
                        Cpe cpe = CommonEnumerationUtil.parseCpe(artifactCpeReason.getCpe()).orElse(null);
                        if (cpe != null) {
                            matchingCriteriaEntry.with((DomContent)TagCreator.span((String)(StringUtils.hasText(affectedConfiguration) ? affectedConfiguration : CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(cpe))));
                            navigationTableMatchingSources.add(cpe.getVendor() + " / " + cpe.getProduct());
                            coveredCpes.add(Triple.of((Object)cpe.getPart(), (Object)cpe.getVendor(), (Object)cpe.getProduct()));
                        } else {
                            matchingCriteriaEntry.with((DomContent)TagCreator.span((String)("un-parseable CPE: " + artifactCpeReason.getCpe())));
                            navigationTableMatchingSources.add(artifactCpeReason.getCpe());
                        }
                    } else if (matchReason instanceof DataSourceIndicator.MsrcProductReason) {
                        DataSourceIndicator.MsrcProductReason msrcProductReason = (DataSourceIndicator.MsrcProductReason)((Object)matchReason);
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)("product " + msrcProductReason.getMsrcProductId())));
                        navigationTableMatchingSources.add("MS " + msrcProductReason.getMsrcProductId());
                        allMsProductIds.add(msrcProductReason.getMsrcProductId());
                    } else if (matchReason instanceof DataSourceIndicator.AssessmentStatusReason) {
                        DataSourceIndicator.AssessmentStatusReason assessmentStatusReason = (DataSourceIndicator.AssessmentStatusReason)((Object)matchReason);
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)assessmentStatusReason.getOriginFileName()));
                    } else if (matchReason instanceof DataSourceIndicator.ArtifactGhsaReason) {
                        DataSourceIndicator.ArtifactGhsaReason artifactGhsaReason = (DataSourceIndicator.ArtifactGhsaReason)((Object)matchReason);
                        String coordinates = artifactGhsaReason.getCoordinates();
                        if (StringUtils.hasText(coordinates)) {
                            navigationTableMatchingSources.add(coordinates.replaceAll(" [(\\[][^(\\[)\\]]+,[^(\\[)\\]]+[)\\]]$", ""));
                            matchingCriteriaEntry.with((DomContent)TagCreator.span((String)coordinates));
                        }
                    } else if (matchReason instanceof DataSourceIndicator.AnyArtifactOverwriteSourceReason) {
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)artifact.getId()));
                        if (overwriteSource != null) {
                            navigationTableMatchingSources.add(artifact.getId() + " (" + ((DataSourceIndicator.Reason)((Object)matchReason)).overwriteSource() + ")");
                        } else {
                            navigationTableMatchingSources.add(artifact.getId());
                        }
                    } else if (matchReason instanceof DataSourceIndicator.AnyArtifactReason) {
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)artifact.getId()));
                    } else if (matchReason instanceof DataSourceIndicator.AnyReason) {
                        DataSourceIndicator.AnyReason anyReason = (DataSourceIndicator.AnyReason)((Object)matchReason);
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)anyReason.getDescription()));
                    } else {
                        matchingCriteriaEntry.with((DomContent)TagCreator.span((String)((DataSourceIndicator.Reason)((Object)matchReason)).toString()));
                        navigationTableMatchingSources.add(((DataSourceIndicator.Reason)((Object)matchReason)).toString());
                    }
                    matchingCriteriaContainer.with((DomContent)matchingCriteriaEntry);
                }
                HashSet<Cpe> unContainedCpes = new HashSet<Cpe>();
                List<Cpe> allCpesOnArtifact = CommonEnumerationUtil.parseEffectiveCpe(artifact);
                for (Cpe cpe : allCpesOnArtifact) {
                    if (allCpesOnArtifact.size() == 1 || !coveredCpes.stream().noneMatch(vp -> cpe.getPart().equals(vp.getLeft()) && cpe.getVendor().equals(vp.getMiddle()) && cpe.getProduct().equals(vp.getRight()))) continue;
                    unContainedCpes.add(cpe);
                    if (coveredCpes.stream().anyMatch(vp -> cpe.getPart().equals(vp.getLeft()) || cpe.getVendor().equals(vp.getMiddle()) || cpe.getProduct().equals(vp.getRight()) || cpe.getVendor().equals(vp.getRight()) || cpe.getProduct().equals(vp.getMiddle()))) {
                        correlationDistance += 0.5;
                        continue;
                    }
                    correlationDistance += 1.0;
                }
                for (Cpe uncontainedCpe : unContainedCpes.stream().sorted().collect(Collectors.toList())) {
                    DivTag cpeMatchingCriteriaEntry = (DivTag)TagCreator.div().withClasses(new String[]{"matching-criteria-badge", "inapplicable"});
                    cpeMatchingCriteriaEntry.with((DomContent)TagCreator.span((String)"NVD"));
                    cpeMatchingCriteriaEntry.with((DomContent)TagCreator.span((String)CommonEnumerationUtil.toCpe22UriOrFallbackToCpe23FS(uncontainedCpe)));
                    matchingCriteriaContainer.with((DomContent)cpeMatchingCriteriaEntry);
                    allNavigationTableMatchingSources.add(uncontainedCpe.getVendor() + " / " + uncontainedCpe.getProduct());
                }
                if (artifact.get(InventoryAttribute.MS_PRODUCT_ID.getKey()) != null) {
                    String[] msProductIds;
                    for (String msProductId : msProductIds = artifact.get(InventoryAttribute.MS_PRODUCT_ID.getKey()).split(", ")) {
                        if (allMsProductIds.contains(msProductId)) continue;
                        DivTag msProductMatchingCriteriaEntry = (DivTag)TagCreator.div().withClasses(new String[]{"matching-criteria-badge", "inapplicable"});
                        msProductMatchingCriteriaEntry.with((DomContent)TagCreator.span((String)"MSRC"));
                        msProductMatchingCriteriaEntry.with((DomContent)TagCreator.span((String)("product " + msProductId)));
                        matchingCriteriaContainer.with((DomContent)msProductMatchingCriteriaEntry);
                    }
                }
                if (matchingCriteriaContainer.getNumChildren() <= 0) continue;
                row.put("Criteria", (DomContent)matchingCriteriaContainer);
            }
            artifactsCpeParagraph.with(new DomContent[]{matchingSourcesTable.generate(Arrays.asList("Id", "Component", "Version", "URL", "Organization", "Is DT Finding", "EOL Id", "MS Product ID", "PURL", "Criteria", "Projects"))});
            artifactsCpeParagraph.with(new DomContent[]{TagCreator.br()});
            vulnerabilitySheet.addNavigationEntry(NavigationHeaders.CORRELATION_DISTANCE.getTitle(), String.valueOf(correlationDistance).replace(".0", ""));
            SpanTag content = TagCreator.span();
            if (!navigationTableMatchingSources.isEmpty()) {
                navigationTableMatchingSources.stream().sorted().forEach(e -> {
                    SpanTag cfr_ignored_0 = (SpanTag)content.with((DomContent)TagCreator.span((String)e).withClass("badge-navigation"));
                });
                vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_USED_MATCHING_INFORMATION.getTitle(), (DomContent)content);
            }
            allNavigationTableMatchingSources.addAll(navigationTableMatchingSources);
            allNavigationTableMatchingSources.removeAll(navigationTableMatchingSources);
            if (!allNavigationTableMatchingSources.isEmpty()) {
                SpanTag spanTag = TagCreator.span();
                allNavigationTableMatchingSources.stream().sorted().forEach(e -> {
                    SpanTag cfr_ignored_0 = (SpanTag)unusedContent.with((DomContent)TagCreator.span((String)e).withClass("badge-navigation"));
                });
                vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_UNUSED_MATCHING_INFORMATION.getTitle(), (DomContent)spanTag);
            }
        }
        if (vulnerabilityAffectedArtifacts.isEmpty()) {
            String message;
            String color;
            if (vulnerability.hasTag("added by status")) {
                color = "alert-success";
                message = "This vulnerability has been added via a status file and was not matched by the inventory.";
                if (vulnerabilitySheet.getNavigationRow().getEntries().get(NavigationHeaders.NAVIGATION_USED_MATCHING_INFORMATION.getTitle()) == null) {
                    vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_USED_MATCHING_INFORMATION.getTitle(), (DomContent)TagCreator.span((String)"assessment").withClass("badge-navigation"));
                }
            } else {
                color = "alert-danger";
                message = "There are no matching artifacts for this vulnerability.";
                if (vulnerabilitySheet.getNavigationRow().getEntries().get(NavigationHeaders.NAVIGATION_USED_MATCHING_INFORMATION.getTitle()) == null) {
                    vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_USED_MATCHING_INFORMATION.getTitle(), "N/A");
                }
            }
            artifactsCpeParagraph.with(new DomContent[]{((DivTag)((DivTag)TagCreator.div().withClasses(new String[]{"alert", color})).attr("role", (Object)"alert")).with(new DomContent[]{TagCreator.span((DomContent[])new DomContent[]{SvgIcon.ALERT.getTag(20)}).withStyle("margin-right:4px;"), TagCreator.text((String)message)})});
        }
        return artifactsCpeParagraph;
    }

    private SheetParagraph createParagraphTimelines(Vulnerability vulnerability, VulnerabilityTimelineGeneratorResult vulnerabilityTimelines, VadDetailLevelConfiguration detailLevel) {
        SheetParagraph timelinesParagraph = new SheetParagraph();
        timelinesParagraph.setIdentifier("Version Timelines");
        timelinesParagraph.setTitle("Version Timelines");
        Set<Artifact> vulnerabilityAffectedArtifacts = vulnerability.getAffectedArtifactsByDefaultKey();
        if (detailLevel.isTimeline()) {
            List<Object> timelines = vulnerability.optVulnerabilityStatus().map(s -> s.isLatestStatusHistoryEntryOfType("void")).orElse(false) != false ? new ArrayList<VulnerabilityTimeline>() : vulnerabilityTimelines.getTimelinesForArtifacts(vulnerabilityAffectedArtifacts, vulnerability.getId());
            timelines.removeIf(timeline -> timeline.getVersions().size() <= 1);
            if (!timelines.isEmpty() && timelines.get(0) != null && ((VulnerabilityTimeline)timelines.get(0)).getVersions().size() > 1) {
                timelinesParagraph.with(new DomContent[]{TagCreator.b((String)("Related Product Timeline" + this.plural(timelines.size()) + ":"))});
                UlTag timelineList = TagCreator.ul();
                List<VulnerableSoftwareVersionRangeCpe> affectedCpes = VulnerableSoftwareTreeNode.getAllCpes(vulnerability.getVulnerableSoftwareConfigurations());
                HashSet<Pair<String, String>> allVendorProducts = new HashSet<Pair<String, String>>();
                HashMap<Artifact, List<Pair<String, String>>> vendorProductsPerArtifact = new HashMap<Artifact, List<Pair<String, String>>>();
                this.findVendorProductsOnArtifactsForVulnerabilityTimeline(vulnerabilityAffectedArtifacts, affectedCpes, allVendorProducts, vendorProductsPerArtifact);
                for (VulnerabilityTimeline vulnerabilityTimeline : timelines) {
                    ArrayList<Artifact> affectedArtifacts = new ArrayList<Artifact>();
                    for (Map.Entry artifactVendorProducts : vendorProductsPerArtifact.entrySet()) {
                        Artifact artifact = (Artifact)artifactVendorProducts.getKey();
                        List vendorProducts = (List)artifactVendorProducts.getValue();
                        for (Pair vendorProduct : vendorProducts) {
                            if (!((String)vendorProduct.getLeft()).equals(vulnerabilityTimeline.getVendor()) || !((String)vendorProduct.getRight()).equals(vulnerabilityTimeline.getProduct())) continue;
                            affectedArtifacts.add(artifact);
                        }
                    }
                    List<VulnerabilityTimeline.TimelineVersion> customArtifactTimelineVersions = vulnerabilityTimeline.generateCustomVersionsFromArtifacts(vulnerabilityAffectedArtifacts);
                    LiTag timelineElement = (LiTag)TagCreator.li().with(new DomContent[]{TagCreator.b((DomContent[])new DomContent[]{TagCreator.rawHtml((String)(vulnerabilityTimeline.getVendor() + " " + vulnerabilityTimeline.getProduct()))}), TagCreator.br(), (DomContent)TagCreator.iff((!affectedArtifacts.isEmpty() ? 1 : 0) != 0, (Object)TagCreator.join((Object[])new Object[]{"Shown because of the following artifact" + this.plural(affectedArtifacts.size()) + ":", TagCreator.br()}))});
                    for (Artifact artifact : affectedArtifacts) {
                        if (artifact.getUrl() != null) {
                            timelineElement.with((DomContent)this.makeHTMLLink("<span class=\"badge badge-artifact badge-underline clickable\">" + artifact.getId() + "</span>", artifact.getUrl(), HrefTargets.TARGET_ARTIFACT.getTarget()));
                            continue;
                        }
                        timelineElement.with((DomContent)TagCreator.rawHtml((String)("<span class=\"badge badge-artifact\">" + artifact.getId() + "</span>")));
                    }
                    List<VulnerabilityTimeline.TimelineVersion> cpeVersionList = this.configuration.isVulnerabilityTimelineHideIrrelevantVersions() ? vulnerabilityTimeline.getReducedOfficialAndArtifactMergedCpeVersions(vulnerabilityAffectedArtifacts, customArtifactTimelineVersions) : vulnerabilityTimeline.getOfficialAndArtifactMergedVersions(customArtifactTimelineVersions);
                    List<VulnerabilityTimeline.TimelineVersion> currentVersions = vulnerabilityTimeline.createVersionsForArtifactVersion(vulnerabilityAffectedArtifacts, customArtifactTimelineVersions);
                    currentVersions.removeIf(currentVersion -> !cpeVersionList.contains(currentVersion));
                    LineChartDataset timelineChartDatasetTotalVulnerabilities = (LineChartDataset)new LineChartDataset().setLabel("Total").setyAxisID("A").setBorderColor(ColorScheme.STRONG_YELLOW.getColor()).setTension(0.2).addData((Collection)cpeVersionList.stream().map(VulnerabilityTimeline.TimelineVersion::getVulnerabilityCount).collect(Collectors.toList()));
                    LineChartData timelineChartData = (LineChartData)new LineChartData().addDataset(new ChartDataset[]{timelineChartDatasetTotalVulnerabilities});
                    for (VulnerabilityTimeline.TimelineVersion timelineVersion : cpeVersionList) {
                        if (currentVersions.contains(timelineVersion)) {
                            timelineChartDatasetTotalVulnerabilities.addPointBackgroundColor(new Color[]{ColorScheme.STRONG_BLUE.getColor()});
                            timelineChartDatasetTotalVulnerabilities.addPointRadius(new Number[]{4});
                            continue;
                        }
                        if (timelineVersion.containsVulnerability(vulnerability)) {
                            timelineChartDatasetTotalVulnerabilities.addPointBackgroundColor(new Color[]{ColorScheme.STRONG_RED.getColor()});
                            timelineChartDatasetTotalVulnerabilities.addPointRadius(new Number[]{3});
                            continue;
                        }
                        timelineChartDatasetTotalVulnerabilities.addPointBackgroundColor(new Color[]{ColorScheme.STRONG_YELLOW.getColor()});
                        timelineChartDatasetTotalVulnerabilities.addPointRadius(new Number[]{3});
                    }
                    TreeMap<CvssSeverityRanges.SeverityRange, List> versionSeverityCounts = new TreeMap<CvssSeverityRanges.SeverityRange, List>();
                    for (VulnerabilityTimeline.TimelineVersion cpeVersion : cpeVersionList) {
                        Map<CvssSeverityRanges.SeverityRange, Integer> currentVersionSeverityCounts = cpeVersion.getVulnerabilitiesPerSeverity();
                        for (CvssSeverityRanges.SeverityRange category : super.getSecurityPolicyConfiguration().getCvssSeverityRanges().getRanges()) {
                            versionSeverityCounts.computeIfAbsent(category, l -> new ArrayList()).add(currentVersionSeverityCounts.getOrDefault(category, 0));
                        }
                    }
                    for (Map.Entry severityCountsPerVersion : versionSeverityCounts.entrySet()) {
                        if (!((List)severityCountsPerVersion.getValue()).stream().anyMatch(d -> d > 0)) continue;
                        timelineChartData.addDataset(new ChartDataset[]{(ChartDataset)new LineChartDataset().setLabel(((CvssSeverityRanges.SeverityRange)severityCountsPerVersion.getKey()).getName()).setyAxisID("A").setBorderColor(ColorScheme.deriveColor((Color)((CvssSeverityRanges.SeverityRange)severityCountsPerVersion.getKey()).getColor().getColor(), (int)127)).setTension(0.2).setBorderWidth((Number)2).addPointRadius(new Number[]{1.5}).addData((Collection)severityCountsPerVersion.getValue())});
                    }
                    timelineChartData.addLabels((Collection)cpeVersionList.stream().map(VulnerabilityTimeline.TimelineVersion::getVersionUpdate).collect(Collectors.toList()));
                    ChartOptions chartOptions = new ChartOptions().setInteraction(new InteractionOption().setMode("index").setIntersect(Boolean.valueOf(false))).setResponsive(Boolean.valueOf(true)).setMaintainAspectRatio(Boolean.valueOf(false)).addScale("A", new LinearScaleOption().setPosition("left").setBeginAtZero(Boolean.valueOf(true)).setTitle(new ScaleTitleOption().setDisplay(Boolean.valueOf(true)).setText("Vulnerabilities")));
                    LineChart timelineChart = (LineChart)((LineChart)new LineChart().setChartOptions(chartOptions)).setChartData((ChartData)timelineChartData);
                    String timelineChartId = VulnerabilityAssessmentDashboard.makeJsVar(vulnerability.getId(), this.random);
                    timelineElement.with(new DomContent[]{((DivTag)((DivTag)TagCreator.div().attr("height", (Object)"340")).withClass("cpe-timeline-chart-wrapper")).with((DomContent)((CanvasTag)TagCreator.canvas().attr("height", (Object)"340")).withId("timelineChart" + timelineChartId)), TagCreator.script((DomContent[])new DomContent[]{TagCreator.rawHtml((String)("var timelineChart = new Chart(\n  document.getElementById('timelineChart" + timelineChartId + "'),\n  " + timelineChart.build() + "\n);"))})});
                    timelineList.with((DomContent)timelineElement);
                }
                timelinesParagraph.with(new DomContent[]{timelineList});
            }
        }
        return timelinesParagraph;
    }

    private Optional<SheetParagraph> createParagraphEolDate(Set<Artifact> artifacts, Sheet vulnerabilitySheet) {
        Map<String, List<ExportedCycleState>> statesByProducts = ExportedCycleState.parseAndSortByProduct(artifacts);
        if (statesByProducts.isEmpty()) {
            return Optional.empty();
        }
        SheetParagraph paragraph = new SheetParagraph();
        paragraph.setIdentifier("EOL");
        paragraph.setTitle("End of Life");
        int mostSevereRating = 0;
        for (Map.Entry<String, List<ExportedCycleState>> cycleStateEntry : statesByProducts.entrySet()) {
            List<ExportedCycleState> tmp;
            String productName = cycleStateEntry.getKey();
            List<ExportedCycleState> cycleStates = cycleStateEntry.getValue();
            if (cycleStates == null) {
                LOG.warn("No cycle states found for product [{}]", (Object)productName);
                continue;
            }
            try {
                tmp = cycleStates.stream().filter(Objects::nonNull).sorted(Comparator.comparing(ExportedCycleState::getCycle)).collect(Collectors.toList());
            }
            catch (Exception e2) {
                LOG.warn("Failed to sort cycle states for product [{}], using default order", (Object)productName, (Object)e2);
                tmp = cycleStates;
            }
            List<ExportedCycleState> sortedCycleStates = tmp;
            paragraph.with(new DomContent[]{TagCreator.h3((DomContent[])new DomContent[]{TagCreator.text((String)"Product: "), ((ATag)TagCreator.a((String)productName).withHref("https://endoflife.date/" + productName)).withTarget(HrefTargets.TARGET_EOL_DATE.getTarget())})});
            Map<String, List<ExportedCycleState>> artifactVersionCycleStateMap = ExportedCycleState.groupByArtifactVersion(sortedCycleStates);
            TableBuilder table = new TableBuilder();
            for (Map.Entry<String, List<ExportedCycleState>> versionEntry : artifactVersionCycleStateMap.entrySet()) {
                CycleScenarioRating cycleScenarioRating;
                List<ExportedCycleState> versionCycleStates = versionEntry.getValue();
                ExportedCycleState relevantState = versionCycleStates.get(0);
                ArrayList<String> artifactIds = new ArrayList<String>();
                for (ExportedCycleState versionCycleState : versionCycleStates) {
                    if (versionCycleState.getArtifact() == null || !StringUtils.hasText(versionCycleState.getArtifact().getId())) continue;
                    artifactIds.add(versionCycleState.getArtifact().getId());
                }
                Map<String, DomContent> row = table.createRow();
                if (relevantState.getCycleStateScenario() == CycleStateScenario.EXTENDED_SUPPORT_NOT_PRESENT) {
                    cycleScenarioRating = relevantState.getCycleStateExtendedSupportUnavailable().getRating();
                    switch (cycleScenarioRating) {
                        case RATING_4: {
                            mostSevereRating = Math.max(mostSevereRating, 6);
                            break;
                        }
                        default: {
                            mostSevereRating = Math.max(mostSevereRating, cycleScenarioRating.getRating());
                            break;
                        }
                    }
                } else {
                    cycleScenarioRating = relevantState.getCycleStateExtendedSupportAvailable().getRating();
                    mostSevereRating = Math.max(mostSevereRating, cycleScenarioRating.getRating());
                }
                String artifactId = relevantState.getArtifact().getId();
                String artifactVersion = relevantState.getArtifact().getVersion();
                SpanTag artifactCell = (SpanTag)TagCreator.span().withStyle("color: var(--" + cycleScenarioRating.getColor().getCssRootName() + ")");
                for (int i = 0; i < artifactIds.size(); ++i) {
                    artifactCell.with((DomContent)TagCreator.text((String)((String)artifactIds.get(i))));
                    if (i >= artifactIds.size() - 1) continue;
                    artifactCell.with((DomContent)TagCreator.br());
                }
                if (artifactId != null && !artifactId.contains(artifactVersion)) {
                    artifactCell.with((DomContent)TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)" ("), this.createArtifactTableEntryForOptionallyEmpty(relevantState.getArtifact().getVersion()), TagCreator.text((String)")")}));
                }
                row.put("Artifact", (DomContent)artifactCell);
                row.put("Cycle", (DomContent)TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)relevantState.getCycle().getCycle()), (DomContent)TagCreator.iff((boolean)StringUtils.hasText(relevantState.getCycle().getReleaseLabel()), (Object)TagCreator.text((String)(" (" + relevantState.getCycle().getReleaseLabel() + ")"))), (DomContent)TagCreator.iff((boolean)StringUtils.hasText(relevantState.getCycle().getLink()), (Object)((ATag)TagCreator.a((String)" (link)").withHref(relevantState.getCycle().getLink())).withTarget(HrefTargets.TARGET_EOL_DATE.getTarget())), (DomContent)TagCreator.iff((boolean)relevantState.isLts(), (Object)TagCreator.text((String)" (LTS)"))}).withStyle("color: var(--" + cycleScenarioRating.getColor().getCssRootName() + ")"));
                row.put("Support", (DomContent)((SpanTag)TagCreator.span((DomContent[])new DomContent[]{TagCreator.span((DomContent[])new DomContent[]{relevantState.getSupportState().getIcon().getTag(15)}), TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)relevantState.getSupportState().getShortDescription()), TagCreator.br(), TagCreator.text((String)((relevantState.getSupportMillis() < 0L ? "Ended: " : "Ends: ") + EolCycle.formatTimeUntilOrAgo(relevantState.getSupportMillis())))})}).withClass("eol-icon-container")).withStyle("color: var(--" + relevantState.getSupportState().getColor().getCssRootName() + ")"));
                if (relevantState.getCycleStateScenario() == CycleStateScenario.EXTENDED_SUPPORT_INFORMATION_PRESENT) {
                    row.put("Extended Support", (DomContent)((SpanTag)TagCreator.span((DomContent[])new DomContent[]{TagCreator.span((DomContent[])new DomContent[]{relevantState.getExtendedSupportState().getIcon().getTag(15)}), TagCreator.span((DomContent[])new DomContent[]{TagCreator.text((String)relevantState.getExtendedSupportState().getShortDescription()), TagCreator.br(), TagCreator.text((String)((relevantState.getExtendedSupportMillis() < 0L ? "Ended: " : "Ends: ") + EolCycle.formatTimeUntilOrAgo(relevantState.getExtendedSupportMillis())))})}).withClass("eol-icon-container")).withStyle("color: var(--" + relevantState.getExtendedSupportState().getColor().getCssRootName() + ")"));
                }
                TreeMap recommendations = new TreeMap(VersionComparator.INSTANCE.reversed());
                if (!relevantState.isAlreadyLatestVersion() && StringUtils.hasText(relevantState.getLatestLifecycleVersion())) {
                    recommendations.computeIfAbsent(relevantState.getLatestLifecycleVersion(), k -> new StringJoiner(", ")).add("latest");
                }
                if (!relevantState.isAlreadyLatestCycleVersion() && StringUtils.hasText(relevantState.getLatestCycleVersion()) && !relevantState.getLatestCycleVersion().equals(relevantState.getLatestLifecycleVersion())) {
                    recommendations.computeIfAbsent(relevantState.getLatestCycleVersion(), k -> new StringJoiner(", ")).add("latest in cycle");
                }
                if (StringUtils.hasText(relevantState.getNextSupportedVersion())) {
                    recommendations.computeIfAbsent(relevantState.getNextSupportedVersion(), k -> new StringJoiner(", ")).add("next supported");
                }
                if (StringUtils.hasText(relevantState.getNextSupportedExtendedVersion()) && !relevantState.getNextSupportedExtendedVersion().equals(relevantState.getNextSupportedVersion())) {
                    recommendations.computeIfAbsent(relevantState.getNextSupportedExtendedVersion(), k -> new StringJoiner(", ")).add("next supported extended");
                }
                if (StringUtils.hasText(relevantState.getClosestActiveLtsVersion())) {
                    recommendations.computeIfAbsent(relevantState.getClosestActiveLtsVersion(), k -> new StringJoiner(", ")).add("closest supported lts");
                }
                if (StringUtils.hasText(relevantState.getLatestActiveLtsVersion())) {
                    recommendations.computeIfAbsent(relevantState.getLatestActiveLtsVersion(), k -> new StringJoiner(", ")).add("latest lts");
                }
                if (recommendations.isEmpty()) continue;
                Optional<SpanTag> recommendationContents = recommendations.entrySet().stream().map(e -> TagCreator.span((DomContent[])new DomContent[]{TagCreator.rawHtml((String)this.svgArrowUpDown(VersionComparator.INSTANCE.compare((String)e.getKey(), relevantState.getArtifact().getVersion()) > 0)), TagCreator.b((String)(" " + (String)e.getKey())), TagCreator.text((String)" ("), TagCreator.text((String)((StringJoiner)e.getValue()).toString()), TagCreator.text((String)")")})).reduce((a, b) -> TagCreator.span((DomContent[])new DomContent[]{a, TagCreator.br(), b}));
                recommendationContents.ifPresent(span -> {
                    DomContent cfr_ignored_0 = (DomContent)row.put("Recommended Versions", (DomContent)span);
                });
            }
            paragraph.with(new DomContent[]{table.generate().withClass("basic-table")});
        }
        HashMap<Integer, String> ratingToText = new HashMap<Integer, String>(){
            {
                this.put(1, "supported");
                this.put(2, "ending support");
                this.put(3, "extended support");
                this.put(4, "ending support (ext)");
                this.put(5, "no support");
                this.put(6, "ending support (reg)");
            }
        };
        if (mostSevereRating >= 1 && mostSevereRating <= 5) {
            vulnerabilitySheet.addNavigationEntry(NavigationHeaders.EOL_STATE.getTitle(), ratingToText.get(mostSevereRating));
        }
        return Optional.of(paragraph);
    }

    private String svgArrowUpDown(boolean up) {
        if (up) {
            return "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" fill=\"var(--" + ColorScheme.STRONG_LIGHT_GREEN.getCssRootName() + ")\" class=\"bi bi-arrow-up\" viewBox=\"0 0 16 16\" stroke=\"var(--" + ColorScheme.STRONG_LIGHT_GREEN.getCssRootName() + ")\" stroke-width=\"2\"><path fill-rule=\"evenodd\" d=\"M8 15a.5.5 0 0 0 .5-.5V2.707l3.146 3.147a.5.5 0 0 0 .708-.708l-4-4a.5.5 0 0 0-.708 0l-4 4a.5.5 0 1 0 .708.708L7.5 2.707V14.5a.5.5 0 0 0 .5.5z\"/></svg>";
        }
        return "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" fill=\"var(--" + ColorScheme.STRONG_YELLOW.getCssRootName() + ")\" class=\"bi bi-arrow-up\" viewBox=\"0 0 16 16\" stroke=\"var(--" + ColorScheme.STRONG_YELLOW.getCssRootName() + ")\" stroke-width=\"2\"><path fill-rule=\"evenodd\" d=\"M8 1a.5.5 0 0 1 .5.5v11.793l3.146-3.147a.5.5 0 0 1 .708.708l-4 4a.5.5 0 0 1-.708 0l-4-4a.5.5 0 0 1 .708-.708L7.5 13.293V1.5A.5.5 0 0 1 8 1z\"/></svg>";
    }

    private SheetParagraph createParagraphAssessment(Vulnerability vulnerability, Sheet vulnerabilitySheet) {
        GeneratedChart generatedChart;
        boolean overallContextOrInitialCvssHasBaseDefined;
        SheetParagraph assessmentParagraph = new SheetParagraph();
        assessmentParagraph.setIdentifier("Assessment");
        assessmentParagraph.setTitle("Assessment");
        VulnerabilityStatus vulnerabilityStatus = vulnerability.getVulnerabilityStatus();
        List<VulnerabilityStatusHistoryEntry> statusHistory = vulnerabilityStatus.getStatusHistory();
        VulnerabilityStatusHistoryEntry latestStatus = vulnerabilityStatus.getLatestActiveStatusHistoryEntry();
        if (vulnerabilityStatus.hasReportedBy()) {
            assessmentParagraph.with(new DomContent[]{TagCreator.i((String)"Reported by: "), TagCreator.rawHtml((String)vulnerabilityStatus.generateReportedByDateString()), TagCreator.br()});
        }
        if (vulnerabilityStatus.hasAcceptedBy()) {
            assessmentParagraph.with(new DomContent[]{TagCreator.i((String)"Accepted by: "), TagCreator.rawHtml((String)vulnerabilityStatus.generateAcceptedByDateString()), TagCreator.br()});
        }
        if (!statusHistory.isEmpty() && StringUtils.hasText(statusHistory.get(0).getStatus())) {
            vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_STATUS.getTitle(), statusHistory.get(0).getStatus());
        } else {
            vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_STATUS.getTitle(), "in review");
        }
        JSONArray assessmentEditorAssessmentsData = new JSONArray();
        for (VulnerabilityStatusHistoryEntry assessment : vulnerability.getVulnerabilityStatus().getStatusHistory()) {
            if (!assessment.isActive()) continue;
            JSONObject assessmentData = new JSONObject().put("assessmentStatus", (Object)(assessment.getStatus() == null ? "none" : assessment.getStatus())).put("assessmentRationale", (Object)assessment.getRationale()).put("assessmentRisk", (Object)assessment.getRisk()).put("assessmentMeasures", (Object)assessment.getMeasures()).put("assessmentScore", (Object)assessment.getScore()).put("assessmentAuthor", (Object)assessment.getAuthor()).put("assessmentDate", (Object)assessment.getFormattedDate()).put("assessmentLabelsInclude", (Object)assessment.getIncludeLabels()).put("assessmentLabelsExclude", (Object)assessment.getExcludeLabels());
            assessmentEditorAssessmentsData.put((Object)assessmentData);
        }
        JSONObject assessmentEditorData = new JSONObject().put("assessments", (Object)assessmentEditorAssessmentsData).put("vulnerability", (Object)new JSONArray().put((Object)vulnerability.getId())).put("title", (Object)vulnerabilityStatus.getTitle()).put("reportedBy", (Object)vulnerabilityStatus.getReportedBy()).put("reportedDate", (Object)vulnerabilityStatus.getReportedDate()).put("acceptedBy", (Object)vulnerabilityStatus.getAcceptedBy());
        ATag assessmentEditorBadge = (ATag)((ATag)((ATag)((ATag)TagCreator.a((String)"Edit in Assessment Editor").withStyle("color: #fff; margin-bottom: 4px;")).withClasses(new String[]{"badge badge-primary"})).attr("aria-expanded", (Object)"false")).attr("onclick", (Object)("openModal('assessment-editor-modal');assessmentEditorData={...assessmentEditorData, ..." + assessmentEditorData + "};updateAssessmentEditorModalVisuals()"));
        if (!statusHistory.isEmpty()) {
            assessmentParagraph.with(new DomContent[]{this.createVulnerabilityStatusHistoryEntry(statusHistory.get(0), true).withStyle("display:flex;flex-direction:column;width:fit-content;width:-moz-fit-content;margin-top:6px;")});
            if (statusHistory.size() > 1) {
                String randomID = "" + Math.abs(statusHistory.hashCode());
                assessmentParagraph.with(new DomContent[]{((ATag)((ATag)((ATag)TagCreator.a((String)"Show History").withStyle("color: #fff; margin-bottom: 4px;")).withClasses(new String[]{"badge badge-primary"})).attr("aria-expanded", (Object)"false")).attr("onclick", (Object)("if (document.getElementById('statusHistory" + randomID + "').classList.contains('hidden')) document.getElementById('statusHistory" + randomID + "').classList.remove('hidden'); else document.getElementById('statusHistory" + randomID + "').classList.add('hidden');this.text = this.text.indexOf('Show') !== -1 ? 'Hide History' : 'Show History'"))});
                assessmentParagraph.with(new DomContent[]{assessmentEditorBadge});
                DivTag expandableCardBody = (DivTag)TagCreator.div().withClasses(new String[]{"card", "card-body"});
                for (VulnerabilityStatusHistoryEntry entry : statusHistory.stream().skip(1L).collect(Collectors.toList())) {
                    expandableCardBody.with((DomContent)this.createVulnerabilityStatusHistoryEntry(entry, false));
                }
                assessmentParagraph.with(new DomContent[]{((DivTag)((DivTag)TagCreator.div().withClass("hidden")).withId("statusHistory" + randomID)).with((DomContent)expandableCardBody)}).with(new DomContent[]{TagCreator.br()});
            } else {
                assessmentParagraph.with(new DomContent[]{assessmentEditorBadge});
            }
            assessmentParagraph.with(new DomContent[]{TagCreator.br()});
        } else {
            assessmentParagraph.with(new DomContent[]{assessmentEditorBadge});
        }
        CvssSelectionResult selectedCvssVectors = vulnerability.getCvssSelectionResult();
        CvssVector overallInitialCvssVector = selectedCvssVectors.getSelectedInitialCvss();
        CvssVector overallContextCvssVector = selectedCvssVectors.getSelectedContextCvss();
        CvssVector overallContextOrInitialCvss = selectedCvssVectors.getSelectedContextIfAvailableOtherwiseInitial();
        boolean hasAnyCvssVectors = selectedCvssVectors.hasAnyCvss();
        boolean hasBaseCvss = selectedCvssVectors.hasInitialCvss();
        boolean hasEffectiveCvss = selectedCvssVectors.hasContextCvss();
        boolean bl = overallContextOrInitialCvssHasBaseDefined = overallContextOrInitialCvss != null && overallContextOrInitialCvss.isBaseFullyDefined();
        if (hasAnyCvssVectors) {
            assessmentParagraph.withStyle("min-height: 400px;");
        }
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_CVSS_UNMODIFIED_OVERALL.getTitle(), hasBaseCvss ? Double.valueOf(overallInitialCvssVector.getBakedScores().getNormalizedOverallScore()) : "N/A");
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_CVSS_MODIFIED_OVERALL.getTitle(), hasEffectiveCvss ? Double.valueOf(overallContextCvssVector.getOverallScore()) : (hasBaseCvss ? Double.valueOf(overallInitialCvssVector.getBakedScores().getNormalizedOverallScore()) : "N/A"), (Object)(hasEffectiveCvss ? null : "override_gray"));
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_CVSS_BASE.getTitle(), overallContextOrInitialCvssHasBaseDefined && !Double.isNaN(overallContextOrInitialCvss.getBakedScores().getBaseScore()) ? Double.valueOf(overallContextOrInitialCvss.getBaseScore()) : "N/A");
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_CVSS_EXPLOITABILITY.getTitle(), overallContextOrInitialCvssHasBaseDefined && !Double.isNaN(overallContextOrInitialCvss.getBakedScores().getNormalizedExploitabilityScore()) ? Double.valueOf(overallContextOrInitialCvss.getBakedScores().getNormalizedExploitabilityScore()) : "N/A");
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_CVSS_IMPACT.getTitle(), overallContextOrInitialCvssHasBaseDefined && !Double.isNaN(overallContextOrInitialCvss.getBakedScores().getNormalizedImpactScore()) ? Double.valueOf(overallContextOrInitialCvss.getBakedScores().getNormalizedImpactScore()) : "N/A");
        UnescapedText exploitedTag = SvgIcon.EXCLAMATION_DIAMOND_FILL.getTag(22);
        if (vulnerability.getKevData() != null) {
            KevData.RansomwareState ransomwareState = vulnerability.getKevData().getRansomwareState();
            SpanTag stateTag = TagCreator.span();
            stateTag.with((DomContent)TagCreator.span((String)(ransomwareState.ordinal() + 1 + "")).withStyle("display:inline-block;color:transparent;width:0px"));
            stateTag.with((DomContent)TagCreator.span((DomContent[])new DomContent[]{exploitedTag}).withStyle("color: var(--" + ColorScheme.STRONG_RED.getCssRootName() + ");"));
            vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_KEV_ENTRY.getTitle(), (DomContent)stateTag);
        } else {
            vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_KEV_ENTRY.getTitle(), (DomContent)TagCreator.span((String)"0 N/A").withStyle("color:transparent"));
        }
        if (hasAnyCvssVectors) {
            UniversalCvssCalculatorLinkGenerator generator;
            TableTag cvssOverviewTableBase = this.generateCvssDetailsTable(selectedCvssVectors, overallInitialCvssVector, overallContextCvssVector, true, false, true, vulnerability);
            TableTag cvssOverviewTableEffective = this.generateCvssDetailsTable(selectedCvssVectors, overallInitialCvssVector, overallContextCvssVector, false, true, true, vulnerability);
            if (cvssOverviewTableBase != null) {
                assessmentParagraph.with(new DomContent[]{TagCreator.b((String)"Initial CVSS Vectors")});
                generator = new UniversalCvssCalculatorLinkGenerator();
                List vectors = selectedCvssVectors.getAllVectors().getCvssVectors().stream().filter(v -> v.getCvssSource().getHostingEntity() != KnownCvssEntities.ASSESSMENT).collect(Collectors.toList());
                for (CvssVector vector : vectors) {
                    generator.addVectorForVulnerability(vector, vulnerability.getId());
                }
                generator.setSelectedVector(overallInitialCvssVector);
                if (!generator.isEmpty()) {
                    assessmentParagraph.with(new DomContent[]{((ATag)((ATag)((ATag)TagCreator.a((String)"Show [initial] in CVSS Calculator").withHref(this.generateLinkForUniversalCvssCalculator(generator))).withTarget(HrefTargets.TARGET_CVSS_DETAILS.getTarget())).withClasses(new String[]{"badge", "badge-primary", "badge-underline", "clickable"})).withStyle("color:var(--text-color-white);margin-left:0.7rem;")});
                }
                assessmentParagraph.with(new DomContent[]{TagCreator.br()}).with(new DomContent[]{cvssOverviewTableBase}).with(new DomContent[]{TagCreator.br()});
            }
            if (cvssOverviewTableEffective != null) {
                assessmentParagraph.with(new DomContent[]{TagCreator.b((String)"Context CVSS Vectors")});
                generator = new UniversalCvssCalculatorLinkGenerator();
                Stream.of(Pair.of((Object)selectedCvssVectors.getInitialCvss2(), (Object)null), Pair.of((Object)selectedCvssVectors.getContextCvss2(), (Object)selectedCvssVectors.getInitialCvss2()), Pair.of((Object)selectedCvssVectors.getInitialCvss3(), (Object)null), Pair.of((Object)selectedCvssVectors.getContextCvss3(), (Object)selectedCvssVectors.getInitialCvss3()), Pair.of((Object)selectedCvssVectors.getInitialCvss4(), (Object)null), Pair.of((Object)selectedCvssVectors.getContextCvss4(), (Object)selectedCvssVectors.getInitialCvss4())).forEach(cvssVector -> generator.addVectorForVulnerability((CvssVector)cvssVector.getLeft(), vulnerability.getId()).setInitialCvssVectorUnchecked((CvssVector)cvssVector.getRight()));
                generator.setSelectedVector(overallContextCvssVector);
                if (!generator.isEmpty()) {
                    assessmentParagraph.with(new DomContent[]{((ATag)((ATag)((ATag)TagCreator.a((String)"Show [all selected] in CVSS Calculator").withHref(this.generateLinkForUniversalCvssCalculator(generator))).withTarget(HrefTargets.TARGET_CVSS_DETAILS.getTarget())).withClasses(new String[]{"badge", "badge-primary", "badge-underline", "clickable"})).withStyle("color:var(--text-color-white);margin-left:0.7rem;")});
                }
                assessmentParagraph.with(new DomContent[]{TagCreator.br()}).with(new DomContent[]{cvssOverviewTableEffective}).with(new DomContent[]{TagCreator.br()});
            }
        }
        vulnerabilitySheet.addNavigationEntry(NavigationHeaders.NAVIGATION_EPSS_SCORE.getTitle(), vulnerability.getEpssData() != null ? String.format(Locale.ENGLISH, "%f", Float.valueOf(vulnerability.getEpssData().getEpssScore())) : "N/A");
        DivTag cvssChartContainer = (DivTag)TagCreator.div().withClass("cvssChart-container-container");
        if (hasBaseCvss) {
            generatedChart = VulnerabilityAssessmentDashboard.createCombinedCvssChart(selectedCvssVectors.getInitialCvss2(), selectedCvssVectors.getInitialCvss3(), selectedCvssVectors.getInitialCvss4(), false, vulnerability.getId(), this.configuration.getVulnerabilitySvgChartInterpolationMethod());
            generatedChart.writeSvgTo(this.configuration.getSvgDirectory());
            cvssChartContainer.with((DomContent)generatedChart.generateChartJsChart());
        }
        if (hasEffectiveCvss) {
            generatedChart = VulnerabilityAssessmentDashboard.createCombinedCvssChart(selectedCvssVectors.getContextCvss2() != null ? selectedCvssVectors.getContextCvss2() : selectedCvssVectors.getInitialCvss2(), selectedCvssVectors.getContextCvss3() != null ? selectedCvssVectors.getContextCvss3() : selectedCvssVectors.getInitialCvss3(), selectedCvssVectors.getContextCvss4() != null ? selectedCvssVectors.getContextCvss4() : selectedCvssVectors.getInitialCvss4(), true, vulnerability.getId(), this.configuration.getVulnerabilitySvgChartInterpolationMethod());
            generatedChart.writeSvgTo(this.configuration.getSvgDirectory());
            cvssChartContainer.with((DomContent)generatedChart.generateChartJsChart());
        }
        if (cvssChartContainer.getNumChildren() > 0) {
            assessmentParagraph.with(new DomContent[]{cvssChartContainer});
        }
        return assessmentParagraph;
    }

    private SheetParagraph createParagraphCwe(Vulnerability vulnerability) {
        SheetParagraph cweParagraph = new SheetParagraph();
        cweParagraph.setIdentifier("CWE");
        cweParagraph.setTitle("CWE");
        UlTag list = TagCreator.ul();
        for (String cwe : vulnerability.getCwes()) {
            String cweId = cwe.replaceAll("[^-]+-(\\d+)(?: .+)?", "$1");
            String description = cwe.replace("CWE-" + cweId, "").trim();
            list.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{this.makeHTMLLink("<span class=\"badge badge-primary badge-underline clickable\">CWE-" + cweId + "</span>", "https://cwe.mitre.org/data/definitions/" + cweId + ".html", HrefTargets.TARGET_CWE.getTarget()), TagCreator.rawHtml((String)(" " + description.replaceAll("^\\((.+)\\)$", "$1")))}));
        }
        cweParagraph.with(new DomContent[]{list});
        return cweParagraph;
    }

    private SheetParagraph createParagraphMicrosoftVulnerabilityInformation(Vulnerability vulnerability, List<AdvisoryEntry> filteredSecurityAdvisories, AtomicInteger amountReviewedEntries, VadDetailLevelConfiguration detailLevel) {
        SheetParagraph msParagraph = new SheetParagraph();
        msParagraph.setIdentifier("Microsoft Security Upgrade Guide");
        msParagraph.setTitle("Microsoft Security Upgrade Guide");
        try {
            Set<String> artifactProductIds;
            List msrcAdvisories = vulnerability.getRelatedAdvisors(AdvisoryTypeStore.MSRC, MsrcAdvisorEntry.class).stream().filter(filteredSecurityAdvisories::contains).collect(Collectors.toList());
            if (msrcAdvisories.isEmpty()) {
                return null;
            }
            String msFixingIdValue = vulnerability.getAdditionalAttribute(InventoryAttribute.MS_FIXING_KB_IDENTIFIER.getKey());
            JSONObject fixingKbIds = new JSONObject(StringUtils.hasText(msFixingIdValue) ? msFixingIdValue : "{}");
            if (!fixingKbIds.isEmpty()) {
                ContentCard fixingKbIdsCard = new ContentCard().withTitle("Summary of Security Updates").withType(ContentCard.ContentCardType.GREEN);
                UlTag fixingKbIdsList = TagCreator.ul();
                fixingKbIdsCard.with(new DomContent[]{fixingKbIdsList});
                for (Object key : fixingKbIds.keySet()) {
                    List values = fixingKbIds.getJSONArray((String)key).toList().stream().map(Object::toString).collect(Collectors.toList());
                    LiTag fixingList = TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)key), TagCreator.text((String)": ")});
                    fixingKbIdsList.with((DomContent)fixingList);
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        String value = (String)iterator.next();
                        boolean hasNext = iterator.hasNext();
                        ((LiTag)((LiTag)((LiTag)((LiTag)((LiTag)fixingList.with((DomContent)TagCreator.text((String)(value + " (")))).with((DomContent)this.makeHTMLLink("MS Support", "https://support.microsoft.com/en-us/help/" + value, HrefTargets.TARGET_MICROSOFT.getTarget()))).with((DomContent)TagCreator.text((String)", "))).with((DomContent)this.makeHTMLLink("Update Catalog", "https://catalog.update.microsoft.com/Search.aspx?q=KB" + value, HrefTargets.TARGET_MICROSOFT.getTarget()))).with((DomContent)TagCreator.text((String)")"))).with((DomContent)TagCreator.iff((boolean)hasNext, (Object)TagCreator.rawHtml((String)", ")));
                    }
                }
                msParagraph.with(new DomContent[]{fixingKbIdsCard.generate()});
            }
            if (!(artifactProductIds = MsrcAdvisorEntry.getAllMsrcProductIds(vulnerability.getAffectedArtifactsByDefaultKey())).isEmpty()) {
                ContentCard productIdsToNamesCard = new ContentCard().withTitle("Related Product").withType(ContentCard.ContentCardType.DEFAULT);
                UlTag productIdsToNamesList = TagCreator.ul();
                productIdsToNamesCard.with(new DomContent[]{productIdsToNamesList});
                for (String productId : artifactProductIds) {
                    MsrcProduct product = ((MsrcProductIndexQuery)this.msrcProductIndexQuery.get()).findProductById(productId);
                    if (product == null) continue;
                    productIdsToNamesList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)product.getId()), TagCreator.text((String)(": " + product.getName() + " (" + product.getVendor() + ", " + product.getFamily() + ")"))}));
                }
                if (productIdsToNamesList.getNumChildren() > 0) {
                    msParagraph.with(new DomContent[]{productIdsToNamesCard.generate()});
                }
            }
            for (MsrcAdvisorEntry msrcAdvisory : msrcAdvisories) {
                String noteText;
                ATag linkTitle;
                List<DescriptionParagraph> descriptions = msrcAdvisory.getDescription();
                String title = msrcAdvisory.getSummary();
                List msRemediations = msrcAdvisory.getMsRemediations().stream().sorted().collect(Collectors.toList());
                List msThreats = msrcAdvisory.getMsThreats().stream().sorted().collect(Collectors.toList());
                List affectedProducts = msrcAdvisory.getAffectedProducts().stream().sorted().collect(Collectors.toList());
                HashMap<String, String> noteMap = new HashMap<String, String>();
                if (descriptions != null) {
                    for (DescriptionParagraph description : descriptions) {
                        noteMap.put(description.getHeader(), this.findAndMakeCveLinks(description.getContent().replace("<a", "<a target=\"" + HrefTargets.TARGET_MICROSOFT_REFERENCE.getTarget() + "\"")));
                    }
                }
                if (title != null) {
                    linkTitle = this.makeHTMLLink(title, "https://msrc.microsoft.com/update-guide/en-US/vulnerability/" + vulnerability.getId(), HrefTargets.TARGET_MICROSOFT.getTarget());
                    String tagKey = noteMap.keySet().stream().filter(k -> k.startsWith("Tag")).findFirst().orElse(null);
                    msParagraph.with((DomContent)TagCreator.iffElse((tagKey != null ? 1 : 0) != 0, (Object)TagCreator.h4((DomContent[])new DomContent[]{linkTitle, TagCreator.text((String)(" (" + (String)noteMap.get(tagKey) + ")")), TagCreator.text((String)(" (" + msrcAdvisory.getType() + ")"))}), (Object)TagCreator.h4((DomContent[])new DomContent[]{linkTitle, TagCreator.text((String)(" (" + msrcAdvisory.getType() + ")"))})));
                    noteMap.remove(tagKey);
                } else {
                    linkTitle = null;
                    msParagraph.with(new DomContent[]{TagCreator.h4((String)"Untitled vulnerability")});
                }
                CvssSelectionResult effectiveCvssVectors = vulnerability.selectEffectiveCvssVectors(msrcAdvisory.getCvssVectors(), super.getSecurityPolicyConfiguration());
                TableTag baseCvssTable = this.generateCvssDetailsTable(effectiveCvssVectors, null, null, true, true, false, vulnerability);
                if (baseCvssTable != null) {
                    msParagraph.with(new DomContent[]{TagCreator.b((String)"Product CVSS Vectors")}).with(new DomContent[]{TagCreator.br()}).with(new DomContent[]{baseCvssTable}).with(new DomContent[]{TagCreator.br()});
                }
                this.checkIfAdvisorHasBeenReviewedAndAppendCard(msParagraph, msrcAdvisory, vulnerability.getVulnerabilityStatus(), amountReviewedEntries, (ContainerTag<?>)linkTitle);
                List<String> msVulnerabilityNotesOrder = Arrays.asList("Description", "FAQ", "CNA");
                List<String> msVulnerabilityNotesReplacements = Arrays.asList("Description", "Frequently Asked Questions", "Vulnerability Naming Authority");
                for (int i = 0; i < msVulnerabilityNotesOrder.size(); ++i) {
                    String order = msVulnerabilityNotesOrder.get(i);
                    String replacementNoteTitle = msVulnerabilityNotesReplacements.get(i);
                    if (!noteMap.containsKey(order)) continue;
                    noteText = (String)noteMap.get(order);
                    msParagraph.with(new DomContent[]{new ContentCard().withText(noteText).withTitle(replacementNoteTitle).withCharacterCollapseThreshold(1000).generate()});
                    noteMap.remove(order);
                }
                for (Map.Entry note : noteMap.entrySet()) {
                    String noteTitle = (String)note.getKey();
                    noteText = (String)note.getValue();
                    msParagraph.with(new DomContent[]{new ContentCard().withText(noteText).withTitle(noteTitle).withCharacterCollapseThreshold(1000).generate()});
                }
                if (!msRemediations.isEmpty()) {
                    UlTag remediationList = TagCreator.ul();
                    Iterator iterator = msRemediations.iterator();
                    while (iterator.hasNext()) {
                        BTag link;
                        MsrcRemediation remediation = (MsrcRemediation)iterator.next();
                        boolean hasNext = iterator.hasNext();
                        String type = remediation.getType();
                        String description = remediation.getDescription();
                        Reference reference = remediation.getUrl();
                        String supercedence = remediation.getSupercedence();
                        String subType = remediation.getSubType();
                        Set<String> affectedProductIds = remediation.getAffectedProductIds();
                        String productIdList = String.join((CharSequence)", ", affectedProductIds);
                        if (!affectedProductIds.isEmpty()) {
                            if (artifactProductIds.stream().noneMatch(productIdList::contains)) continue;
                        }
                        LiTag remediationEntry = TagCreator.li();
                        remediationList.with((DomContent)remediationEntry);
                        BTag bTag = link = reference != null ? TagCreator.b((DomContent[])new DomContent[]{this.makeHTMLLink(type + ": " + reference.getTitle(), reference.getUrl(), HrefTargets.TARGET_MICROSOFT.getTarget())}) : null;
                        if (link != null) {
                            remediationEntry.with(link);
                        }
                        if (subType != null) {
                            remediationEntry.with(new DomContent[]{TagCreator.text((String)(" (" + subType + ")")), TagCreator.br()});
                        } else if (link != null) {
                            remediationEntry.with((DomContent)TagCreator.br());
                        }
                        boolean descriptionPresent = StringUtils.hasText(description);
                        if (descriptionPresent && description.matches("\\d+")) {
                            remediationEntry.with(new DomContent[]{TagCreator.text((String)"Patch available: "), this.makeHTMLLink(description, "https://www.catalog.update.microsoft.com/Search.aspx?q=KB" + description, HrefTargets.TARGET_MICROSOFT.getTarget()), TagCreator.br()});
                        } else if (descriptionPresent) {
                            remediationEntry.with(new DomContent[]{TagCreator.rawHtml((String)("Description: " + description)), TagCreator.br()});
                        }
                        if (supercedence != null) {
                            remediationEntry.with(new DomContent[]{TagCreator.text((String)("Supercedence: " + supercedence)), TagCreator.br()});
                        }
                        if (StringUtils.hasText(productIdList)) {
                            remediationEntry.with(new DomContent[]{TagCreator.text((String)("Available for products: " + productIdList)), TagCreator.br()});
                        }
                        if (!hasNext) continue;
                        remediationEntry.with((DomContent)TagCreator.br());
                    }
                    if (remediationList.getNumChildren() > 0) {
                        msParagraph.with(new DomContent[]{new ContentCard().with(new DomContent[]{remediationList}).withTitle("Remediation").withCharacterCollapseThreshold(1000).generate()});
                    }
                    if (!msThreats.isEmpty()) {
                        Iterator threat2;
                        ArrayList<String> highlightedProducts = new ArrayList<String>();
                        ArrayList regularProducts = new ArrayList();
                        for (Iterator threat2 : msThreats) {
                            String type = ((MsThreat)((Object)threat2)).getType();
                            String description = ((MsThreat)((Object)threat2)).getDescription() == null ? "" : ((MsThreat)((Object)threat2)).getDescription();
                            String productId = ((MsThreat)((Object)threat2)).getProductId();
                            if (artifactProductIds.contains(productId)) {
                                highlightedProducts.add(productId + ": " + description + " (" + type + ")");
                                continue;
                            }
                            if ("Exploit Status".equals(type)) {
                                highlightedProducts.add(type + ": " + description.replace(";", ", ").replace(":", ": "));
                                continue;
                            }
                            regularProducts.add((StringUtils.hasText(productId) ? productId + " " : "") + description + " (" + type + ")");
                        }
                        UlTag threatsList = TagCreator.ul();
                        for (String highlightedProduct : highlightedProducts) {
                            threatsList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)highlightedProduct)}));
                        }
                        threat2 = regularProducts.iterator();
                        while (threat2.hasNext()) {
                            String regularProduct = (String)threat2.next();
                            threatsList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.text((String)regularProduct)}));
                        }
                        msParagraph.with(new DomContent[]{new ContentCard().withTitle("Threats").with(new DomContent[]{threatsList}).withCharacterCollapseThreshold(250).generate()});
                    }
                }
                if (affectedProducts.isEmpty()) continue;
                ArrayList<String> highlightedProducts = new ArrayList<String>();
                ArrayList<String> regularProducts = new ArrayList<String>();
                for (String affectedProduct : affectedProducts) {
                    MsrcProduct product = ((MsrcProductIndexQuery)this.msrcProductIndexQuery.get()).findProductById(affectedProduct);
                    String content = product != null ? product.getId() + ": " + product.getName() + " (" + product.getFamily() + ")" : affectedProduct;
                    if (artifactProductIds.contains(affectedProduct)) {
                        highlightedProducts.add(content);
                        continue;
                    }
                    regularProducts.add(content);
                }
                UlTag affectedProductsList = TagCreator.ul();
                for (String highlightedProduct : highlightedProducts) {
                    affectedProductsList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.b((String)highlightedProduct)}));
                }
                for (String regularProduct : regularProducts) {
                    affectedProductsList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.text((String)regularProduct)}));
                }
                msParagraph.with(new DomContent[]{new ContentCard().withTitle("Affected Products").with(new DomContent[]{affectedProductsList}).withCharacterCollapseThreshold(250).generate()});
            }
        }
        catch (JSONException e) {
            LOG.error("Unable to read JSON formatted MS Vulnerability data from inventory", (Throwable)e);
        }
        return msParagraph;
    }

    private SheetParagraph createParagraphCertSei(Vulnerability vulnerability, List<AdvisoryEntry> filteredSecurityAdvisories, Collection<Vulnerability> vulnerabilities, AtomicInteger amountReviewedCertSei, VadDetailLevelConfiguration detailLevel) {
        List certSeiAdvisories = vulnerability.getRelatedAdvisors(AdvisoryTypeStore.CERT_SEI, CertSeiAdvisorEntry.class).stream().filter(filteredSecurityAdvisories::contains).collect(Collectors.toList());
        if (certSeiAdvisories.isEmpty()) {
            return null;
        }
        SheetParagraph certSeiParagraph = new SheetParagraph();
        certSeiParagraph.setIdentifier("CERT-SEI");
        certSeiParagraph.setTitle("CERT-SEI Advisor" + this.plural(certSeiAdvisories.size()));
        for (CertSeiAdvisorEntry certSeiAdvisor : certSeiAdvisories) {
            this.appendDefaultAdvisorContentCards(certSeiParagraph, certSeiAdvisor, vulnerability, vulnerability.getVulnerabilityStatus(), vulnerabilities, amountReviewedCertSei, detailLevel);
        }
        return certSeiParagraph;
    }

    private SheetParagraph createParagraphCertFr(Vulnerability vulnerability, List<AdvisoryEntry> filteredSecurityAdvisories, Collection<Vulnerability> vulnerabilities, AtomicInteger amountReviewedCertFr, VadDetailLevelConfiguration detailLevel) {
        List certFrAdvisories = vulnerability.getRelatedAdvisors(AdvisoryTypeStore.CERT_FR, CertFrAdvisorEntry.class).stream().filter(filteredSecurityAdvisories::contains).collect(Collectors.toList());
        if (certFrAdvisories.isEmpty()) {
            return null;
        }
        SheetParagraph certFrParagraph = new SheetParagraph();
        certFrParagraph.setIdentifier("CERT-FR");
        certFrParagraph.setTitle("CERT-FR Advisor" + this.plural(certFrAdvisories.size()));
        for (CertFrAdvisorEntry certFrAdvisor : certFrAdvisories) {
            this.appendDefaultAdvisorContentCards(certFrParagraph, certFrAdvisor, vulnerability, vulnerability.getVulnerabilityStatus(), vulnerabilities, amountReviewedCertFr, detailLevel);
        }
        return certFrParagraph;
    }

    private SheetParagraph createParagraphCertEu(Vulnerability vulnerability, List<AdvisoryEntry> filteredSecurityAdvisories, Collection<Vulnerability> vulnerabilities, AtomicInteger amountReviewedCertEu, VadDetailLevelConfiguration detailLevel) {
        List certEuAdvisories = vulnerability.getRelatedAdvisors(AdvisoryTypeStore.CERT_EU, CertEuAdvisorEntry.class).stream().filter(filteredSecurityAdvisories::contains).collect(Collectors.toList());
        if (certEuAdvisories.isEmpty()) {
            return null;
        }
        SheetParagraph certEuParagraph = new SheetParagraph();
        certEuParagraph.setIdentifier("CERT-EU");
        certEuParagraph.setTitle("CERT-EU Advisor" + this.plural(certEuAdvisories.size()));
        for (CertEuAdvisorEntry certEuAdvisor : certEuAdvisories) {
            List<DescriptionParagraph> description = certEuAdvisor.getDescription();
            for (int i = description.size() - 1; i >= 0; --i) {
                DescriptionParagraph descriptionParagraph = description.get(i);
                if (!Objects.equals(descriptionParagraph.getHeader(), "content_markdown")) continue;
                description.add(descriptionParagraph.deriveWithHeader("Details"));
            }
            certEuAdvisor.getDescription().removeIf(e -> Objects.equals(e.getHeader(), "content_html") || Objects.equals(e.getHeader(), "content_markdown"));
            this.appendDefaultAdvisorContentCards(certEuParagraph, certEuAdvisor, vulnerability, vulnerability.getVulnerabilityStatus(), vulnerabilities, amountReviewedCertEu, detailLevel);
        }
        return certEuParagraph;
    }

    private SheetParagraph createParagraphGhsa(Vulnerability vulnerability, List<AdvisoryEntry> filteredSecurityAdvisories, Collection<Vulnerability> vulnerabilities, AtomicInteger amountReviewedEntries, VadDetailLevelConfiguration detailLevel) {
        List ghsaAdvisories = vulnerability.getRelatedAdvisors(AdvisoryTypeStore.GHSA, GhsaAdvisorEntry.class).stream().filter(filteredSecurityAdvisories::contains).collect(Collectors.toList());
        if (ghsaAdvisories.isEmpty()) {
            return null;
        }
        SheetParagraph ghsaParagraph = new SheetParagraph();
        ghsaParagraph.setIdentifier("GitHub Security Advisory");
        ghsaParagraph.setTitle("GitHub Security Advisory");
        HashSet<String> knownIdentifiers = new HashSet<String>();
        for (GhsaAdvisorEntry entry : ghsaAdvisories) {
            if (!knownIdentifiers.add(entry.getId())) continue;
            this.appendDefaultAdvisorContentCards(ghsaParagraph, entry, vulnerability, vulnerability.getVulnerabilityStatus(), vulnerabilities, amountReviewedEntries, detailLevel);
        }
        return ghsaParagraph;
    }

    private SheetParagraph createParagraphGenericAdvisory(Vulnerability vulnerability, List<AdvisoryEntry> securityAdvisories, Collection<Vulnerability> vulnerabilities, AtomicInteger amountReviewed, VadDetailLevelConfiguration detailLevel) {
        if (securityAdvisories.isEmpty()) {
            return null;
        }
        String advisorySource = securityAdvisories.stream().findFirst().map(a -> a.getSourceIdentifier().getWellFormedName()).orElse("Advisory");
        SheetParagraph paragraph = new SheetParagraph();
        paragraph.setIdentifier(advisorySource);
        paragraph.setTitle(advisorySource + " Advisor" + this.plural(securityAdvisories.size()));
        for (AdvisoryEntry advisoryEntry : securityAdvisories) {
            this.appendDefaultAdvisorContentCards(paragraph, advisoryEntry, vulnerability, vulnerability.getVulnerabilityStatus(), vulnerabilities, amountReviewed, detailLevel);
        }
        return paragraph;
    }

    private void appendDefaultAdvisorContentCards(SheetParagraph paragraph, AdvisoryEntry advisoryEntry, Vulnerability vulnerability, VulnerabilityStatus vulnerabilityStatus, Collection<Vulnerability> vulnerabilities, AtomicInteger amountReviewedEntries, VadDetailLevelConfiguration detailLevel) {
        ContentIdentifierStore.ContentIdentifier advisoryProvider = advisoryEntry.getSourceIdentifier();
        String hrefTarget = advisoryProvider == AdvisoryTypeStore.CERT_FR ? HrefTargets.TARGET_CERT_FR.getTarget() : (advisoryProvider == AdvisoryTypeStore.CERT_EU ? HrefTargets.TARGET_CERT_EU.getTarget() : (advisoryProvider == AdvisoryTypeStore.CERT_SEI ? HrefTargets.TARGET_CERT_SEI.getTarget() : (advisoryProvider == AdvisoryTypeStore.MSRC ? HrefTargets.TARGET_MICROSOFT.getTarget() : (advisoryProvider == AdvisoryTypeStore.GHSA ? HrefTargets.TARGET_GITHUB.getTarget() : HrefTargets.TARGET_BLANK.getTarget()))));
        Object titleTag = StringUtils.hasText(advisoryEntry.getUrl()) ? this.makeHTMLLink(advisoryEntry.getId(), advisoryEntry.getUrl(), hrefTarget) : TagCreator.span((String)advisoryEntry.getId());
        this.checkIfAdvisorHasBeenReviewedAndAppendCard(paragraph, advisoryEntry, vulnerabilityStatus, amountReviewedEntries, (ContainerTag<?>)titleTag);
        paragraph.with(new DomContent[]{((H4Tag)TagCreator.h4().with((DomContent)titleTag)).with((DomContent)TagCreator.text((String)(" (" + advisoryEntry.getType() + ")")))});
        TableTag cvssOverviewTable = this.generateCvssDetailsTable(vulnerability.selectEffectiveCvssVectors(advisoryEntry.getCvssVectors(), super.getSecurityPolicyConfiguration()), null, null, true, true, false, vulnerability);
        if (cvssOverviewTable != null) {
            paragraph.with(new DomContent[]{cvssOverviewTable}).with(new DomContent[]{TagCreator.br()});
        }
        if (StringUtils.hasText(advisoryEntry.getSummary())) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("Summary").withText(advisoryEntry.getSummary()).generate()});
        }
        if (!advisoryEntry.getDescription().isEmpty()) {
            for (DescriptionParagraph descriptionParagraph : advisoryEntry.getDescription()) {
                if (descriptionParagraph.getContent() == null) {
                    LOG.debug("Content of description paragraph is null: {}", (Object)descriptionParagraph);
                    continue;
                }
                SpanTag contentFromMarkdown = Dashboard.markdownToHtml(this.findAndMakeCveMDLinks(Dashboard.attemptEscapeScripts(descriptionParagraph.getContent())).replaceAll("\\n( *\\*(?!\\*))", "$1"), hrefTarget);
                paragraph.with(new DomContent[]{new ContentCard().withTitle(descriptionParagraph.getHeader() == null ? "Description" : org.apache.commons.lang3.StringUtils.capitalize((String)descriptionParagraph.getHeader())).with(new DomContent[]{contentFromMarkdown}).withCharacterCollapseThreshold(2000).generate()});
            }
        }
        if (StringUtils.hasText(advisoryEntry.getThreat())) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("Threat").with(advisoryEntry.getThreat()).generate()});
        }
        if (StringUtils.hasText(advisoryEntry.getRecommendations())) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("Recommendations").with(advisoryEntry.getRecommendations()).generate()});
        }
        if (StringUtils.hasText(advisoryEntry.getWorkarounds())) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("Workarounds").with(advisoryEntry.getWorkarounds()).generate()});
        }
        if (!advisoryEntry.getAcknowledgements().isEmpty()) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("Acknowledgements").with(String.join((CharSequence)" ", advisoryEntry.getAcknowledgements())).generate()});
        }
        if (!advisoryEntry.getReferences().isEmpty() && detailLevel.isAdvisoriesReferences()) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("References").withCharacterCollapseThreshold(2000).with(new DomContent[]{TagCreator.ul((DomContent[])((DomContent[])advisoryEntry.getReferences().stream().map(Reference::toHtmlATag).map(xva$0 -> TagCreator.li((DomContent[])new DomContent[]{xva$0})).toArray(LiTag[]::new)))}).generate()});
        }
        ArrayList<String> badges = new ArrayList<String>();
        for (String cveId : advisoryEntry.getReferencedVulnerabilities(VulnerabilityTypeStore.CVE)) {
            if (cveId.equals(vulnerability.getId())) continue;
            badges.add(this.makeVulnerabilityReferenceBadge(cveId, vulnerabilities));
        }
        if (!badges.isEmpty()) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("References to other CVE").with((DomContent[])badges.stream().sorted().map(TagCreator::rawHtml).toArray(DomContent[]::new)).generate()});
        }
        advisoryEntry.getReferencedSecurityAdvisories().forEach((key, ids) -> {
            ArrayList<SpanTag> badgesOther = new ArrayList<SpanTag>();
            for (String id : ids) {
                badgesOther.add(this.makeBadge(id, "secondary"));
            }
            paragraph.with(new DomContent[]{new ContentCard().withTitle("References to other " + key.getWellFormedName()).with(badgesOther.toArray(new DomContent[0])).generate()});
        });
    }

    private TableTag generateCvssDetailsTable(CvssSelectionResult selectedCvssVectors, CvssVector overallBaseCvss, CvssVector overallEffectiveCvss, boolean initial, boolean context, boolean displayUsage, Vulnerability vulnerability) {
        SpanTag borderWidthTag;
        LinkedHashMap<CvssVector, List<DomContent>> displayVectors = new LinkedHashMap<CvssVector, List<DomContent>>();
        SpanTag chartFillTag = displayUsage ? (SpanTag)TagCreator.span((DomContent[])new DomContent[]{SvgIcon.BAR_CHART_FILL.getTag(15)}).withStyle("margin-right: 8px;") : null;
        SpanTag spanTag = borderWidthTag = displayUsage ? (SpanTag)TagCreator.span((DomContent[])new DomContent[]{SvgIcon.BORDER_WIDTH.getTag(15)}).withStyle("margin-right: 8px;") : null;
        if (context) {
            this.addVectorIfNotPresent((Map<CvssVector, List<DomContent>>)displayVectors, overallEffectiveCvss, (DomContent)borderWidthTag);
            this.addVectorIfNotPresent(displayVectors, (CvssVector)selectedCvssVectors.getContextCvss2(), (DomContent)chartFillTag);
            this.addVectorIfNotPresent(displayVectors, (CvssVector)selectedCvssVectors.getContextCvss3(), (DomContent)chartFillTag);
            this.addVectorIfNotPresent(displayVectors, (CvssVector)selectedCvssVectors.getContextCvss4(), (DomContent)chartFillTag);
        }
        if (initial) {
            this.addVectorIfNotPresent((Map<CvssVector, List<DomContent>>)displayVectors, overallBaseCvss, (DomContent)borderWidthTag);
            this.addVectorIfNotPresent(displayVectors, (CvssVector)selectedCvssVectors.getInitialCvss2(), (DomContent)chartFillTag);
            this.addVectorIfNotPresent(displayVectors, (CvssVector)selectedCvssVectors.getInitialCvss3(), (DomContent)chartFillTag);
            this.addVectorIfNotPresent(displayVectors, (CvssVector)selectedCvssVectors.getInitialCvss4(), (DomContent)chartFillTag);
            List<CvssVector> allVectors = selectedCvssVectors.getAllVectors().getCvssVectors().stream().filter(v -> v.getCvssSource().getHostingEntity() != KnownCvssEntities.ASSESSMENT).collect(Collectors.toList());
            allVectors.forEach(vector -> this.addVectorIfNotPresent((Map<CvssVector, List<DomContent>>)displayVectors, (CvssVector)vector));
        }
        List<String> cvssTableHeaders = this.extractCvssDetailsTableHeaders(displayVectors);
        if (!displayUsage) {
            cvssTableHeaders.remove("Usage");
        }
        TableTag table = (TableTag)((TableTag)TagCreator.table().withClass("basic-table")).with((DomContent)TagCreator.tr().with(TagCreator.each(cvssTableHeaders, header -> TagCreator.th((String)header))));
        for (Map.Entry cvssEntry : displayVectors.entrySet()) {
            CvssVector vector2 = (CvssVector)cvssEntry.getKey();
            List tag = (List)cvssEntry.getValue();
            table.with((DomContent)this.createCvssDetailsTableRowForCvss(vector2, tag, cvssTableHeaders, selectedCvssVectors, vulnerability));
        }
        if (displayVectors.isEmpty()) {
            return null;
        }
        return table;
    }

    private SpanTag createCvssVectorSourceLinks(List<CvssSource> sources) {
        SpanTag span = TagCreator.span();
        boolean hadAssessment = false;
        boolean isFirst = true;
        for (CvssSource source : sources) {
            if (!isFirst) {
                span.withText(" + ");
            } else {
                isFirst = false;
            }
            if (source.getHostingEntity() == KnownCvssEntities.ASSESSMENT) {
                if (hadAssessment) continue;
                hadAssessment = true;
                span.with((DomContent)TagCreator.text((String)"Assessment"));
                continue;
            }
            String hostingEntityUrl = this.getCvssSourceLink(source.getHostingEntity());
            if (hostingEntityUrl != null) {
                span.with((DomContent)this.makeHTMLLink(VulnerabilityAssessmentDashboard.escapeCvssSourceName(source.getHostingEntity().getName()), hostingEntityUrl, HrefTargets.TARGET_BLANK.getTarget()).withClass("preserve-color"));
            } else {
                span.withText(VulnerabilityAssessmentDashboard.escapeCvssSourceName(source.getHostingEntity().getName()));
            }
            if (source.getIssuingEntityRole() != null) {
                span.with((DomContent)TagCreator.text((String)("-" + VulnerabilityAssessmentDashboard.escapeCvssSourceName(source.getIssuingEntityRole().getName()))));
            }
            if (source.getIssuingEntity() == null) continue;
            String issuingEntityUrl = this.getCvssSourceLink(source.getIssuingEntity());
            if (issuingEntityUrl != null) {
                span.with((DomContent)TagCreator.text((String)"-"));
                span.with((DomContent)this.makeHTMLLink(VulnerabilityAssessmentDashboard.escapeCvssSourceName(source.getIssuingEntity().getName()), issuingEntityUrl, HrefTargets.TARGET_BLANK.getTarget()).withClass("preserve-color"));
                continue;
            }
            span.with((DomContent)TagCreator.text((String)("-" + VulnerabilityAssessmentDashboard.escapeCvssSourceName(source.getIssuingEntity().getName()))));
        }
        return span;
    }

    private String getCvssSourceLink(CvssSource.CvssEntity cvssEntity) {
        if (cvssEntity == null) {
            return null;
        }
        if (cvssEntity.getUrl() != null) {
            return cvssEntity.getUrl().toString();
        }
        if (cvssEntity.getEmail() != null) {
            return "mailto:" + cvssEntity.getEmail();
        }
        return null;
    }

    private static String escapeCvssSourceName(String name) {
        return name.replace("_", "\\_").replace("-", "_");
    }

    private void addVectorIfNotPresent(Map<CvssVector, List<DomContent>> vectors, CvssVector vector) {
        this.addVectorIfNotPresent(vectors, vector, null);
    }

    private void addVectorIfNotPresent(Map<CvssVector, List<DomContent>> vectors, CvssVector vector, DomContent tag) {
        if (vector == null) {
            return;
        }
        Optional<CvssVector> found = vectors.keySet().stream().filter(v -> v.equals(vector) && Objects.equals(CvssSource.toCombinedColumnHeaderString((Collection)v.getCvssSources()), CvssSource.toCombinedColumnHeaderString((Collection)vector.getCvssSources()))).findFirst();
        if (found.isPresent()) {
            if (tag != null) {
                vectors.computeIfPresent(found.get(), (v, t) -> {
                    t.add(tag);
                    return t;
                });
            }
            return;
        }
        List created = vectors.computeIfAbsent(vector, v -> new ArrayList());
        if (tag != null) {
            created.add(tag);
        }
    }

    private void checkIfAdvisorHasBeenReviewedAndAppendCard(SheetParagraph paragraph, AdvisoryEntry advisoryEntry, VulnerabilityStatus vulnerabilityStatus, AtomicInteger amountReviewedEntries, ContainerTag<?> linkTag) {
        boolean isAdvisoryReviewed;
        VulnerabilityStatusReviewedEntry reviewedEntry = VulnerabilityStatusReviewedEntry.findReviewedEntry(advisoryEntry.getId(), vulnerabilityStatus.getReviewedAdvisories());
        boolean bl = isAdvisoryReviewed = reviewedEntry != null;
        if (isAdvisoryReviewed) {
            if (linkTag != null) {
                this.markAdvisorTitleAsReviewed(linkTag);
            }
            amountReviewedEntries.getAndIncrement();
        }
        if (isAdvisoryReviewed && StringUtils.hasText(reviewedEntry.getComment())) {
            paragraph.with(new DomContent[]{new ContentCard().withTitle("Review Comment").withText(reviewedEntry.getComment()).withType(ContentCard.ContentCardType.GREEN).generate()});
        }
    }

    private void markAdvisorTitleAsReviewed(ContainerTag<?> title) {
        ((ContainerTag)title.withStyle("color:var(--strong-dark-green);")).with((DomContent)TagCreator.rawHtml((String)"<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"20\" height=\"20\" fill=\"currentColor\" class=\"bi bi-check-lg\" viewBox=\"0 0 16 16\" style=\"margin-right:-3px;margin-left:2px;\">\n  <path d=\"M12.736 3.97a.733.733 0 0 1 1.047 0c.286.289.29.756.01 1.05L7.88 12.01a.733.733 0 0 1-1.065.02L3.217 8.384a.757.757 0 0 1 0-1.06.733.733 0 0 1 1.047 0l3.052 3.093 5.4-6.425a.247.247 0 0 1  .02-.022Z\"/></svg>"));
    }

    private SheetParagraph createParagraphReferences(Collection<Reference> references) {
        SheetParagraph referencesParagraph = new SheetParagraph();
        referencesParagraph.setIdentifier("References");
        referencesParagraph.setTitle("References");
        UlTag referencesList = TagCreator.ul();
        for (Reference reference : references) {
            referencesList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{reference.toHtmlATag().withTarget(HrefTargets.TARGET_REFERENCE.getTarget())}));
        }
        referencesParagraph.with(new DomContent[]{referencesList});
        return referencesParagraph;
    }

    private Modal generateOverviewModal(List<GeneratedChart> charts) {
        DivTag overviewModalChartsRow1 = (DivTag)((DivTag)TagCreator.div().withClass("unselectable")).withStyle("width: 100%; text-align: center;");
        DivTag overviewModalChartsRow2 = (DivTag)((DivTag)TagCreator.div().withClass("unselectable")).withStyle("width: 100%; text-align: center;");
        for (int i = 0; i < charts.size(); ++i) {
            GeneratedChart chart = charts.get(i);
            UnescapedText chartContent = chart.generateChartJsChart();
            if (i < 3) {
                overviewModalChartsRow1.with((DomContent)chartContent);
                continue;
            }
            overviewModalChartsRow2.with((DomContent)chartContent);
        }
        return new Modal().setId("overview-modal").setTitle("Vulnerability Assessment Status").setToggleKey("KeyO").setToggleKeyActive(true).setShowInSidebar(true).setSvgIcon(SvgIcon.PIE_CHART_FILL).with(new DomContent[]{overviewModalChartsRow1, overviewModalChartsRow2, ((SpanTag)((SpanTag)TagCreator.span((String)"Highlighted charts have been updated according to the applied filters").withId("overview-charts-are-filtered-hint")).withStyle("margin-top:10px;")).withClasses(new String[]{"hidden", "badge", "badge-secondary"})});
    }

    private Modal generateAssessmentEditorModal() {
        DivTag assessmentEditorModalContent = (DivTag)TagCreator.div().withId("assessment-editor-modal-content");
        ((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)((DivTag)assessmentEditorModalContent.with((DomContent)TagCreator.h3((String)"Affects"))).with((DomContent)((DivTag)TagCreator.div((String)"Inventory scope assessments do not contain an 'affects' section.").withId("assessment-editor-inventory-scope-selected")).withClass("hidden"))).with((DomContent)((DivTag)TagCreator.div().withId("assessment-editor-affects-add-elements-container")).with(new DomContent[]{((DivTag)TagCreator.div().withClasses(new String[]{"matching-criteria-badge", "inapplicable"})).with(new DomContent[]{TagCreator.span((String)"CPE"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-affects-cpe-input")).withPlaceholder("cpe:/a:")).attr("size", (Object)20)})}), ((DivTag)TagCreator.div().withClasses(new String[]{"matching-criteria-badge", "inapplicable"})).with(new DomContent[]{TagCreator.span((String)"Vulnerability"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-affects-vulnerability-input")).withPlaceholder("CVE-2021-1234")).attr("size", (Object)12)})}), ((DivTag)TagCreator.div().withClasses(new String[]{"matching-criteria-badge", "inapplicable"})).with(new DomContent[]{TagCreator.span((String)"CWE"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-affects-cwe-input")).withPlaceholder("CWE-123")).attr("size", (Object)8)})}), ((DivTag)TagCreator.div().withClasses(new String[]{"matching-criteria-badge", "inapplicable"})).with(new DomContent[]{TagCreator.span((String)"Condition"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-affects-condition-input")).withPlaceholder("")).attr("size", (Object)20)})})}))).with((DomContent)TagCreator.div().withId("assessment-editor-affects-container"))).with((DomContent)TagCreator.h3((String)"General Data"))).with((DomContent)((DivTag)TagCreator.div().withClasses(new String[]{"assessment-editor-data-attribute-container"})).with(new DomContent[]{TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Scope"), TagCreator.span((DomContent[])new DomContent[]{((SelectTag)TagCreator.select().withId("assessment-editor-scope-select")).with(new DomContent[]{TagCreator.option((String)"Artifact").withValue("artifact"), TagCreator.option((String)"Inventory").withValue("inventory")})})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Title"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-title-input")).withPlaceholder("Title")).attr("size", (Object)"50")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Reported"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-reported-by-input")).withStyle("margin-right:3px;")).withPlaceholder("Author")).attr("size", (Object)"25"), ((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-reported-date-input")).withPlaceholder(TimeUtils.formatNormalizedDate(new Date()).replaceAll(" \\d+:\\d+:\\d+", ""))).attr("size", (Object)"22")}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Accepted"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-accepted-by-input")).withStyle("margin-right:3px;")).withPlaceholder("Author")).attr("size", (Object)"25"), ((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-accepted-date-input")).withPlaceholder(TimeUtils.formatNormalizedDate(new Date()))).attr("size", (Object)"22")})})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"CVSS 2.0"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-2.0-all-input")).withPlaceholder("all")).withStyle("margin-right:3px;")).attr("size", (Object)"15"), ((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-2.0-lower-input")).withPlaceholder("lower")).withStyle("margin-right:3px;")).attr("size", (Object)"14"), ((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-2.0-higher-input")).withPlaceholder("higher")).attr("size", (Object)"15")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"CVSS 3.1"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-3.1-all-input")).withPlaceholder("all")).withStyle("margin-right:3px;")).attr("size", (Object)"15"), ((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-3.1-lower-input")).withPlaceholder("lower")).withStyle("margin-right:3px;")).attr("size", (Object)"14"), ((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-3.1-higher-input")).withPlaceholder("higher")).attr("size", (Object)"15")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"CVSS 4.0"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-4.0-all-input")).withPlaceholder("all")).withStyle("margin-right:3px;")).attr("size", (Object)"15"), ((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-4.0-lower-input")).withPlaceholder("lower")).withStyle("margin-right:3px;")).attr("size", (Object)"14"), ((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-cvss-vector-4.0-higher-input")).withPlaceholder("higher")).attr("size", (Object)"15")})})}))).with((DomContent)TagCreator.h3((String)"Assessment").withStyle("margin-top:15px;"))).with((DomContent)((DivTag)TagCreator.div().withId("assessment-editor-assessments-container")).with((DomContent)TagCreator.span().with(new DomContent[]{((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button((String)"New").withId("assessment-editor-assessment-add-new-button")).withClasses(new String[]{"btn", "btn-primary", "btn-sm"})).attr("type", (Object)"button")).withStyle("margin-right:15px;"), ((SpanTag)TagCreator.span().withId("assessment-editor-assessment-add-button-container")).with(new DomContent[0])})))).with((DomContent)((DivTag)((DivTag)TagCreator.div().withId("assessment-editor-assessment-add-elements-container")).withClasses(new String[]{"assessment-editor-data-attribute-container", "hidden"})).with(new DomContent[]{TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Status"), TagCreator.span((DomContent[])new DomContent[]{((SelectTag)TagCreator.select().withId("assessment-editor-assessment-status-select")).with(new DomContent[]{TagCreator.option((String)"Applicable").withValue("applicable"), TagCreator.option((String)"Not Applicable").withValue("not applicable"), TagCreator.option((String)"Insignificant").withValue("insignificant"), TagCreator.option((String)"Void").withValue("void"), TagCreator.option((String)"None (No status)").withValue("none")})})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Rationale"), TagCreator.span((DomContent[])new DomContent[]{((TextareaTag)((TextareaTag)((TextareaTag)TagCreator.textarea().withId("assessment-editor-assessment-rationale-input")).withPlaceholder("Rationale")).attr("rows", (Object)"1")).attr("cols", (Object)"50")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Risk"), TagCreator.span((DomContent[])new DomContent[]{((TextareaTag)((TextareaTag)((TextareaTag)TagCreator.textarea().withId("assessment-editor-assessment-risk-input")).withPlaceholder("Risk")).attr("rows", (Object)"1")).attr("cols", (Object)"50")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Measures"), TagCreator.span((DomContent[])new DomContent[]{((TextareaTag)((TextareaTag)((TextareaTag)TagCreator.textarea().withId("assessment-editor-assessment-measures-input")).withPlaceholder("Measures")).attr("rows", (Object)"1")).attr("cols", (Object)"50")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Score"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-assessment-score-input")).withPlaceholder("Score")).attr("size", (Object)"50")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Created"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-assessment-author-input")).withStyle("margin-right:3px;")).withPlaceholder("Author")).attr("size", (Object)"25"), ((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-assessment-date-input")).withPlaceholder(TimeUtils.formatNormalizedDate(new Date()))).attr("size", (Object)"22")})}), TagCreator.div().with(new DomContent[]{TagCreator.span((String)"Labels"), TagCreator.span((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-assessment-labels-include-input")).withStyle("margin-right:3px;")).withPlaceholder("include, label")).attr("size", (Object)"25"), ((InputTag)((InputTag)TagCreator.input().withId("assessment-editor-assessment-labels-exclude-input")).withPlaceholder("exclude, label")).attr("size", (Object)"22")})}), TagCreator.div().with((DomContent)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button((String)"Remove").withId("assessment-editor-assessment-remove-button")).withClasses(new String[]{"btn", "btn-danger", "btn-sm"})).attr("type", (Object)"button")).withStyle("margin-top:15px;"))}))).with((DomContent)((H3Tag)TagCreator.h3().withStyle("margin-top:35px;")).with(new DomContent[]{TagCreator.text((String)"Generated Assessment File "), ((SpanTag)((SpanTag)((SpanTag)TagCreator.span().withId("assessment-editor-yaml-output-copy")).withClasses(new String[]{"badge", "badge-secondary", "hidden"})).withStyle("margin-left:5px;")).with((DomContent)TagCreator.text((String)"Copied!"))}))).with((DomContent)((TextareaTag)TagCreator.textarea().withId("assessment-editor-yaml-output")).withClasses(new String[]{"yaml-output"}))).with((DomContent)TagCreator.script((String)"document.getElementById('assessment-editor-yaml-output').addEventListener('focus', function() { copyToClipboard(document.getElementById('assessment-editor-yaml-output').value);document.getElementById('assessment-editor-yaml-output-copy').classList.remove('hidden');setTimeout(function() { document.getElementById('assessment-editor-yaml-output-copy').classList.add('hidden'); }, 1500); });"));
        return new Modal().setId("assessment-editor-modal").setTitle("Assessment Editor (beta)").setToggleKeyActive(false).setShowInSidebar(false).setSvgIcon(SvgIcon.PENCIL_FILL).withOnOpenScript("clearAssessmentEditorModal();").with(new DomContent[]{assessmentEditorModalContent});
    }

    private void addAdditionalInventoryInformation(Inventory inventory, Dashboard dashboard) {
        this.contributeInventoryAssessmentAdditionalInformation(inventory, dashboard);
        this.contributeSecurityPolicyAdditionalInformation(dashboard);
    }

    private void contributeSecurityPolicyAdditionalInformation(Dashboard dashboard) {
        CvssSeverityRanges.SeverityRange[] versionSelector2;
        CentralSecurityPolicyConfiguration securityPolicy = super.getSecurityPolicyConfiguration();
        SpanTag securityPolicyExplanation = TagCreator.span();
        String providedVectorsSelectorExplanation = securityPolicy.getInitialCvssSelector().explain("Initial Vectors");
        String effectiveVectorsSelectorExplanation = securityPolicy.getContextCvssSelector().explain("Context Vectors");
        SpanTag providedVectorsSelectorExplanationHtml = this.convertCvssSelectorExplanationToHtml(providedVectorsSelectorExplanation);
        SpanTag effectiveVectorsSelectorExplanationHtml = this.convertCvssSelectorExplanationToHtml(effectiveVectorsSelectorExplanation);
        dashboard.addAdditionalInformationModalContent(new DomContent[]{TagCreator.h2((String)"Security Policy"), securityPolicyExplanation});
        securityPolicyExplanation.with(new DomContent[]{TagCreator.text((String)"The security policy used to generate the Vulnerability Assessment Dashboard has been configured as shown below."), TagCreator.br(), TagCreator.br()});
        securityPolicyExplanation.with(new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"CVSS Selector for Provided Vectors"), TagCreator.text((String)"The following CVSS selector is evaluated to find one representative CVSS vector from the unmodified vectors provided from the data sources per CVSS version."), TagCreator.br(), providedVectorsSelectorExplanationHtml}).withClass("left-bracket-container"), TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"CVSS Selector for Effective Vectors"), TagCreator.text((String)"The following CVSS selector is evaluated to find one representative CVSS vector from the effective vectors provided from the data sources per CVSS version."), TagCreator.br(), effectiveVectorsSelectorExplanationHtml}).withClass("left-bracket-container")});
        UlTag filterList = TagCreator.ul();
        securityPolicyExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"CVSS Version Selection Policy"), TagCreator.text((String)"The versioned vectors selected by the CVSS selectors above are then further reduced to a single vector per selector using the first filter that applies from these."), filterList}).withClass("left-bracket-container"));
        for (CvssSeverityRanges.SeverityRange[] versionSelector2 : securityPolicy.getCvssVersionSelectionPolicy()) {
            String explanation;
            switch (2.$SwitchMap$org$metaeffekt$core$security$cvss$processor$CvssSelectionResult$CvssScoreVersionSelectionPolicy[versionSelector2.ordinal()]) {
                case 1: {
                    explanation = "A vector with the version " + Cvss2.getVersionName();
                    break;
                }
                case 2: {
                    explanation = "A vector with the version " + Cvss3P1.getVersionName();
                    break;
                }
                case 3: {
                    explanation = "A vector with the version " + Cvss4P0.getVersionName();
                    break;
                }
                case 4: {
                    explanation = "The vector with the highest version number";
                    break;
                }
                case 5: {
                    explanation = "The vector with the lowest version number";
                    break;
                }
                case 6: {
                    explanation = "The vector with the highest overall score";
                    break;
                }
                case 7: {
                    explanation = "The vector with the lowest overall score";
                    break;
                }
                default: {
                    explanation = "Unspecified version selection policy";
                }
            }
            filterList.with((DomContent)TagCreator.li((String)explanation));
        }
        CvssSeverityRanges ranges = securityPolicy.getCvssSeverityRanges();
        UlTag severityRangesList = TagCreator.ul();
        securityPolicyExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Severity Ranges"), TagCreator.text((String)"The following severity ranges are used to categorize the CVSS vectors into severity levels."), TagCreator.br(), severityRangesList}).withClass("left-bracket-container"));
        versionSelector2 = ranges.getRanges();
        int explanation = versionSelector2.length;
        for (int i = 0; i < explanation; ++i) {
            CvssSeverityRanges.SeverityRange range = versionSelector2[i];
            severityRangesList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{this.cvssSeverityColorBadge(range)}));
        }
        double vulnerabilityInsignificantStatusThreshold = securityPolicy.getInsignificantThreshold();
        CvssSeverityRanges.SeverityRange insignificantRangeBelow = securityPolicy.getCvssSeverityRanges().getRange(vulnerabilityInsignificantStatusThreshold - 0.1);
        double vulnerabilityIncludeScoreThreshold = securityPolicy.getIncludeScoreThreshold();
        List includeVulnerabilitiesWithAdvisoryProviders = AdvisoryTypeStore.get().fromJsonNamesAndImplementations(securityPolicy.getIncludeVulnerabilitiesWithAdvisoryProviders());
        List includeVulnerabilitiesWithAdvisoryReviewStatus = securityPolicy.getIncludeVulnerabilitiesWithAdvisoryReviewStatus();
        DivTag vulnerabilityConfigExplanation = TagCreator.div();
        if (vulnerabilityInsignificantStatusThreshold > 0.0) {
            vulnerabilityConfigExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.text((String)"A vulnerability is mapped to the insignificant status if it is \"in review\" and has a CVSS overall score "), this.cvssSeverityColorBadge("below " + vulnerabilityInsignificantStatusThreshold, insignificantRangeBelow), TagCreator.text((String)".")}));
        }
        if (vulnerabilityIncludeScoreThreshold > 0.0) {
            CvssSeverityRanges.SeverityRange includeRangeEqual = securityPolicy.getCvssSeverityRanges().getRange(vulnerabilityIncludeScoreThreshold);
            vulnerabilityConfigExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.text((String)"A vulnerability is excluded if it has a CVSS overall score "), this.cvssSeverityColorBadge("below " + vulnerabilityIncludeScoreThreshold, includeRangeEqual), TagCreator.text((String)".")}));
        }
        if (!includeVulnerabilitiesWithAdvisoryProviders.isEmpty() && includeVulnerabilitiesWithAdvisoryProviders.stream().noneMatch(source -> source == AdvisoryTypeStore.ANY_ADVISORY_FILTER_WILDCARD)) {
            vulnerabilityConfigExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.text((String)"A vulnerability is excluded if it does not contain a security advisory from the following providers: "), TagCreator.text((String)includeVulnerabilitiesWithAdvisoryProviders.stream().map(ContentIdentifierStore.ContentIdentifier::getWellFormedName).collect(Collectors.joining(", ")))}));
        }
        if (!(includeVulnerabilitiesWithAdvisoryReviewStatus.isEmpty() || includeVulnerabilitiesWithAdvisoryReviewStatus.contains("ALL") || includeVulnerabilitiesWithAdvisoryReviewStatus.contains("all") || includeVulnerabilitiesWithAdvisoryReviewStatus.contains("ANY") || includeVulnerabilitiesWithAdvisoryReviewStatus.contains("any"))) {
            vulnerabilityConfigExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.text((String)"A vulnerability is excluded if it does not reference a security advisory that has a review status of: "), TagCreator.text((String)String.join((CharSequence)", ", includeVulnerabilitiesWithAdvisoryReviewStatus))}));
        }
        if (vulnerabilityConfigExplanation.getNumChildren() > 0) {
            securityPolicyExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Vulnerabilities"), vulnerabilityConfigExplanation}).withClass("left-bracket-container"));
        }
        List includeAdvisoryTypes = securityPolicy.getIncludeAdvisoryTypes();
        DivTag advisoryConfigExplanation = TagCreator.div();
        if (!(includeAdvisoryTypes.isEmpty() || includeAdvisoryTypes.contains("ALL") || includeAdvisoryTypes.contains("all") || includeAdvisoryTypes.contains("ANY") || includeAdvisoryTypes.contains("any"))) {
            advisoryConfigExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.text((String)"Security advisories are excluded if they are not of one of the following types: "), TagCreator.text((String)String.join((CharSequence)", ", includeAdvisoryTypes))}));
        }
        if (advisoryConfigExplanation.getNumChildren() > 0) {
            securityPolicyExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Security Advisories"), advisoryConfigExplanation}).withClass("left-bracket-container"));
        }
        VulnerabilityPriorityScoreConfiguration pConf = super.getSecurityPolicyConfiguration().getPriorityScoreConfiguration();
        VulnerabilityPriorityScoreConfiguration.EolConfiguration.NoExtendedSupportConfiguration eolNoExtended = pConf.getEol().getNoExtendedSupport();
        VulnerabilityPriorityScoreConfiguration.EolConfiguration.ExtendedSupportConfiguration eolExtended = pConf.getEol().getExtendedSupport();
        securityPolicyExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Priority Score"), TagCreator.text((String)"The priority score of a vulnerability is determined by calculating the sum of the following metrics:"), TagCreator.ul((DomContent[])new DomContent[]{TagCreator.li((String)"CVSS Overall: Either the Context CVSS, or as a fallback the Initial CVSS vector is used to calculate the base priority score the other metrics are added to."), TagCreator.li((String)"Keywords: The sum of all matched keyword set scores."), TagCreator.li((DomContent[])new DomContent[]{TagCreator.text((String)"EPSS: The exploit probability "), TagCreator.code((String)"p"), TagCreator.text((String)" of the vulnerability and the parameters "), TagCreator.code((String)("min=" + pConf.getEpss().getMin())), TagCreator.text((String)", "), TagCreator.code((String)("f=" + pConf.getEpss().getf())), TagCreator.text((String)" and "), TagCreator.code((String)("F=" + pConf.getEpss().getF())), TagCreator.text((String)" are used in the following formula only if "), TagCreator.code((String)"p>=min"), TagCreator.text((String)", otherwise 0 is used: "), TagCreator.code((String)VulnerabilityPriorityCalculator.PriorityScoreResult.getEpssFormula()), TagCreator.br(), TagCreator.text((String)"This formula represents a truncated linear function between "), TagCreator.code((String)"(min, f)"), TagCreator.text((String)" and "), TagCreator.code((String)"(1, F)"), TagCreator.text((String)" with a minimum value of "), TagCreator.code((String)"f"), TagCreator.text((String)" and a maximum value of "), TagCreator.code((String)"F"), TagCreator.text((String)".")}), TagCreator.li((DomContent[])new DomContent[]{TagCreator.text((String)"KEV: If an exploit is known on a vulnerability, "), TagCreator.code((String)("exploit=" + pConf.getKev().getExploit())), TagCreator.text((String)" is added to the priority score. If additionally a use in a ransomware campaign is known, "), TagCreator.code((String)("ransomware=" + pConf.getKev().getRansomware())), TagCreator.text((String)" is added.")}), TagCreator.li((DomContent[])new DomContent[]{TagCreator.text((String)"EOL: The end-of-life state of the affected product is evaluated. The priority score is increased by the value of the worst-case state, for all affected components."), TagCreator.br(), TagCreator.text((String)"If the product does not provide extended support, the following values are used: "), TagCreator.code((String)("supportValid=" + eolNoExtended.getSupportValid())), TagCreator.text((String)", "), TagCreator.code((String)("supportEndingSoon=" + eolNoExtended.getSupportEndingSoon())), TagCreator.text((String)", "), TagCreator.code((String)("supportExpired=" + eolNoExtended.getSupportExpired())), TagCreator.br(), TagCreator.text((String)"If the product provides extended support, the following values are used: "), TagCreator.code((String)("supportValid=" + eolExtended.getSupportValid())), TagCreator.text((String)", "), TagCreator.code((String)("supportEndingSoon=" + eolExtended.getSupportEndingSoon())), TagCreator.text((String)", "), TagCreator.code((String)("extendedSupportValid=" + eolExtended.getExtendedSupportValid())), TagCreator.text((String)", "), TagCreator.code((String)("extendedSupportEndingSoon=" + eolExtended.getExtendedSupportEndingSoon())), TagCreator.text((String)", "), TagCreator.code((String)("extendedSupportExpired=" + eolExtended.getExtendedSupportExpired()))})})}).withClass("left-bracket-container"));
        CvssSeverityRanges priorityScoreSeverityRanges = super.getSecurityPolicyConfiguration().getPriorityScoreSeverityRanges();
        UlTag priorityScoreSeverityRangesList = TagCreator.ul();
        securityPolicyExplanation.with((DomContent)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)"Priority Score Severity Ranges"), TagCreator.text((String)"The following severity ranges are used to categorize the priority score into severity levels, only if there is an elevation from the base cvss overall score through any of the other metrics."), TagCreator.br(), priorityScoreSeverityRangesList}).withClass("left-bracket-container"));
        for (CvssSeverityRanges.SeverityRange range : priorityScoreSeverityRanges.getRanges()) {
            priorityScoreSeverityRangesList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{this.cvssSeverityColorBadge(range)}));
        }
    }

    private SpanTag cvssSeverityColorBadge(String text, CvssSeverityRanges.SeverityRange range) {
        return (SpanTag)((SpanTag)TagCreator.span((String)text).withClass("badge")).withStyle("background-color:" + range.getColor().toHex() + ";color: " + range.getColor().getHexTextColor());
    }

    private SpanTag cvssSeverityColorBadge(CvssSeverityRanges.SeverityRange range) {
        String name = range.getName();
        String floor = range.getFloor() < -5000.0 ? "-\u221e" : String.valueOf(range.getFloor());
        String ceil = range.getCeil() > 5000.0 ? "\u221e" : String.valueOf(range.getCeil());
        return this.cvssSeverityColorBadge(name + " (" + floor + " - " + ceil + ")", range);
    }

    private SpanTag convertCvssSelectorExplanationToHtml(String explanation) {
        String[] lines = explanation.split("\n");
        SpanTag span = TagCreator.span();
        UlTag currentList = null;
        LiTag currentListItem = null;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.startsWith("- ") && currentList == null) {
                currentList = TagCreator.ul();
                span.with((DomContent)currentList);
                currentListItem = TagCreator.li();
                currentList.with((DomContent)currentListItem);
                currentListItem.with((DomContent)this.formatCvssSelectorExplanationLineContentToHtml(line.substring(2)));
                continue;
            }
            if (line.startsWith("- ") && currentList != null) {
                currentListItem = TagCreator.li();
                currentList.with((DomContent)currentListItem);
                currentListItem.with((DomContent)this.formatCvssSelectorExplanationLineContentToHtml(line.substring(2)));
                continue;
            }
            if (line.startsWith("  ") && currentList != null) {
                if (currentListItem.getNumChildren() > 0) {
                    currentListItem.with((DomContent)TagCreator.br());
                }
                currentListItem.with((DomContent)this.formatCvssSelectorExplanationLineContentToHtml(line.substring(2)));
                continue;
            }
            if (line.startsWith("  ")) continue;
            boolean previousWasList = currentList != null;
            currentList = null;
            currentListItem = null;
            if (!line.isEmpty()) {
                span.with((DomContent)this.formatCvssSelectorExplanationLineContentToHtml(line));
            }
            if (previousWasList || i >= lines.length - 1) continue;
            span.with((DomContent)TagCreator.br());
        }
        return span;
    }

    private SpanTag formatCvssSelectorExplanationLineContentToHtml(String lineContent) {
        SpanTag span = TagCreator.span();
        StringBuilder currentSegment = new StringBuilder();
        boolean isInsideTag = false;
        for (int i = 0; i < lineContent.length(); ++i) {
            char c = lineContent.charAt(i);
            if (c == '[' && !isInsideTag) {
                isInsideTag = true;
                if (currentSegment.length() <= 0) continue;
                span.with((DomContent)TagCreator.text((String)currentSegment.toString()));
                currentSegment.setLength(0);
                continue;
            }
            if (c == ']' && isInsideTag) {
                isInsideTag = false;
                String tagContent = currentSegment.toString();
                span.with((DomContent)TagCreator.b((String)("[" + tagContent + "]")).withClass("monospace"));
                currentSegment.setLength(0);
                continue;
            }
            currentSegment.append(c);
        }
        if (currentSegment.length() > 0) {
            span.with((DomContent)TagCreator.text((String)currentSegment.toString()));
        }
        return span;
    }

    private void contributeInventoryAssessmentAdditionalInformation(Inventory inventory, Dashboard dashboard) {
        JSONArray vulnerabilityStatusJson;
        List<VulnerabilityStatus> statuses;
        InventoryInfo statusInformation = inventory.findInventoryInfo("vulnerability-status");
        if (statusInformation != null && !(statuses = VulnerabilityStatusConverter.fromJson(vulnerabilityStatusJson = new JSONArray(statusInformation.get("Vulnerability Inventory Status")))).isEmpty()) {
            dashboard.addAdditionalInformationModalContent(new DomContent[]{TagCreator.h3((String)"Inventory Vulnerability Status"), TagCreator.text((String)"This status information is applied to all vulnerabilities in the inventory.")});
            for (VulnerabilityStatus status : statuses) {
                DivTag statusCard = new DivTag();
                if (!status.getStatusHistory().isEmpty()) {
                    statusCard.with((DomContent)this.createVulnerabilityStatusHistoryEntry(status.getStatusHistory().get(0), true));
                    for (int i = 1; i < status.getStatusHistory().size(); ++i) {
                        statusCard.with((DomContent)this.createVulnerabilityStatusHistoryEntry(status.getStatusHistory().get(i), true));
                    }
                }
                if (status.getTitle() != null) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("Title: "), TagCreator.text((String)status.getTitle()), TagCreator.br()});
                }
                if (status.hasCvss2()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 2.0: "), TagCreator.text((String)status.getCvss2().toString()), TagCreator.br()});
                }
                if (status.hasCvss2Lower()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 2.0 (lower): "), TagCreator.text((String)status.getCvss2Lower().toString()), TagCreator.br()});
                }
                if (status.hasCvss2Higher()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 2.0 (higher): "), TagCreator.text((String)status.getCvss2Higher().toString()), TagCreator.br()});
                }
                if (status.hasCvss3P1()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 3.1: "), TagCreator.text((String)status.getCvss3P1().toString()), TagCreator.br()});
                }
                if (status.hasCvss3P1Lower()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 3.1 (lower): "), TagCreator.text((String)status.getCvss3P1Lower().toString()), TagCreator.br()});
                }
                if (status.hasCvss3P1Higher()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 3.1 (higher): "), TagCreator.text((String)status.getCvss3P1Higher().toString()), TagCreator.br()});
                }
                if (status.hasCvss4()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 4.0: "), TagCreator.text((String)status.getCvss4().toString()), TagCreator.br()});
                }
                if (status.hasCvss4Lower()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 4.0 (lower): "), TagCreator.text((String)status.getCvss4Lower().toString()), TagCreator.br()});
                }
                if (status.hasCvss4Higher()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("CVSS 4.0 (higher): "), TagCreator.text((String)status.getCvss4Higher().toString()), TagCreator.br()});
                }
                if (status.hasReportedByInformation()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("Reported by: "), TagCreator.text((String)status.generateReportedByDateString()), TagCreator.br()});
                }
                if (status.hasAcceptedByInformation()) {
                    statusCard.with(new DomContent[]{this.createSlightHighlightText("Accepted by: "), TagCreator.text((String)status.generateAcceptedByDateString()), TagCreator.br()});
                }
                if (status.getReviewedAdvisories() != null && !status.getReviewedAdvisories().isEmpty()) {
                    statusCard.with((DomContent)this.createSlightHighlightText("Reviewed advisories: "));
                    for (VulnerabilityStatusReviewedEntry advisory : status.getReviewedAdvisories()) {
                        statusCard.with((DomContent)this.makeBadge(advisory.getAdvisor() + ": " + advisory.getId(), "primary"));
                    }
                    statusCard.with((DomContent)TagCreator.br());
                }
                statusCard.withClass("left-bracket-container");
                dashboard.addAdditionalInformationModalContent(new DomContent[]{statusCard});
            }
        }
    }

    private DomContent createArtifactTableEntryForOptionallyEmpty(String value) {
        if (!(value == null || value.equals("*") || value.equals("-") || value.equals("unspecific") || value.equals(""))) {
            return TagCreator.text((String)value);
        }
        return TagCreator.span((String)"n.a.").withClass("cpe-missing-data");
    }

    private String plural(int size) {
        return size == 1 ? "" : "s";
    }

    private static String makeJsVar(String text, Random random) {
        return (text + random.nextDouble()).replace("-", "_").replace(".", "_").replaceAll("[^A-Za-z0-9]", "");
    }

    private void findVendorProductsOnArtifactsForVulnerabilityTimeline(Set<Artifact> artifacts, List<VulnerableSoftwareVersionRangeCpe> affectedCpes, Set<Pair<String, String>> allVendorProducts, Map<Artifact, List<Pair<String, String>>> vendorProductsPerArtifact) {
        for (Artifact artifact : artifacts) {
            List<Cpe> cpeUrisOnArtifact = CommonEnumerationUtil.parseEffectiveCpe(artifact);
            List<Pair<String, String>> vendorProductsOnArtifact = CommonEnumerationUtil.getVendorProducts(cpeUrisOnArtifact);
            Set relevantVendorProductsOnArtifact = vendorProductsOnArtifact.stream().filter(o -> affectedCpes.stream().anyMatch(cpe -> ((String)o.getLeft()).equals(cpe.getCpe().getVendor()) && ((String)o.getRight()).equals(cpe.getCpe().getProduct()))).sorted(Comparator.comparing(Pair::getLeft)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (relevantVendorProductsOnArtifact.size() == 0) {
                relevantVendorProductsOnArtifact.addAll(vendorProductsOnArtifact);
            }
            relevantVendorProductsOnArtifact.removeIf(o -> allVendorProducts.stream().anyMatch(e -> ((String)e.getLeft()).equals(o.getLeft()) && ((String)e.getRight()).equals(o.getRight())));
            allVendorProducts.addAll(relevantVendorProductsOnArtifact);
            vendorProductsPerArtifact.put(artifact, vendorProductsOnArtifact);
            boolean hasTooManyCPEs = this.configuration.getMaximumCpeForTimelinesPerVulnerability() != -1 && allVendorProducts.size() > this.configuration.getMaximumCpeForTimelinesPerVulnerability();
            if (!hasTooManyCPEs) continue;
            AtomicInteger limitCount = new AtomicInteger();
            allVendorProducts.removeIf(o -> limitCount.incrementAndGet() > this.configuration.getMaximumCpeForTimelinesPerVulnerability());
            LOG.warn("Stopped generation of vulnerability timelines, configured limit of [{}] CPEs per vulnerability reached. Consider providing initial CPE URIs.", (Object)this.configuration.getMaximumCpeForTimelinesPerVulnerability());
            break;
        }
    }

    public static GeneratedChart createCombinedCvssChart(Cvss2 cvss2, Cvss3P1 cvss3, Cvss4P0 cvss4, boolean isModified, String vulnerabilityName, VulnerabilityAssessmentDashboardEnrichmentConfiguration.VulnerabilityCvssSvgChartInterpolationMethod interpolationMethod) {
        RadarChartData cvssChartData = new RadarChartData();
        cvssChartData.addLabels(new String[]{"Base", "Adj. Impact", "Impact", "Temporal", "Exploitability", "Environmental"});
        if (cvss4 != null) {
            RadarChartDataset cvssChartCvss4Dataset = VulnerabilityAssessmentDashboard.createCvssRadarChartDataset((CvssVector)cvss4, ColorScheme.CVSS_4.getColor(), "v4.0", true, interpolationMethod);
            cvssChartData.addDataset(new ChartDataset[]{cvssChartCvss4Dataset});
        }
        if (cvss3 != null) {
            RadarChartDataset cvssChartCvss3P1Dataset = VulnerabilityAssessmentDashboard.createCvssRadarChartDataset((CvssVector)cvss3, ColorScheme.CVSS_3.getColor(), "v3.1", true, interpolationMethod);
            cvssChartData.addDataset(new ChartDataset[]{cvssChartCvss3P1Dataset});
        }
        if (cvss2 != null) {
            RadarChartDataset cvssChartCvss2Dataset = VulnerabilityAssessmentDashboard.createCvssRadarChartDataset((CvssVector)cvss2, ColorScheme.CVSS_2.getColor(), "v2.0", true, interpolationMethod);
            cvssChartData.addDataset(new ChartDataset[]{cvssChartCvss2Dataset});
        }
        ChartOptions cvssChartOptions = new ChartOptions().setInteraction(new InteractionOption().setMode("index")).setResponsive(Boolean.valueOf(true)).setMaintainAspectRatio(Boolean.valueOf(false)).addScale("r", new RadialScaleOption().setBeginAtZero(Boolean.valueOf(true)).setMax(Integer.valueOf(10)).setTicks(new RadialScaleTicksOption().setStepSize((Number)2))).setTitle(new TitleOption().setText((isModified ? "Context" : "Initial") + " CVSS Scores").setDisplay(Boolean.valueOf(true)));
        RadarChart cvssChart = (RadarChart)((RadarChart)new RadarChart().setChartData((ChartData)cvssChartData)).setChartOptions(cvssChartOptions);
        DefaultCategoryDataset cvssDataset = new DefaultCategoryDataset();
        HashMap<String, Color> versionToColorMap = new HashMap<String, Color>();
        for (int i = cvssChartData.getDatasets().size() - 1; i >= 0; --i) {
            String rowLabel;
            RadarChartDataset currentDataset = (RadarChartDataset)cvssChartData.getDatasets().get(i);
            if (StringUtils.hasText(currentDataset.getLabel())) {
                rowLabel = currentDataset.getLabel();
                if (rowLabel.contains("v2")) {
                    versionToColorMap.put(rowLabel, ColorScheme.CVSS_2.getColor());
                } else if (rowLabel.contains("v3")) {
                    versionToColorMap.put(rowLabel, ColorScheme.CVSS_3.getColor());
                } else if (rowLabel.contains("v4")) {
                    versionToColorMap.put(rowLabel, ColorScheme.CVSS_4.getColor());
                } else {
                    versionToColorMap.put(rowLabel, ColorScheme.CVSS_2.getColor());
                }
            } else if (cvss4 != null && i == 2) {
                rowLabel = Cvss4P0.getVersionName();
                versionToColorMap.put(rowLabel, ColorScheme.CVSS_4.getColor());
            } else if (cvss3 != null && i == 1) {
                rowLabel = Cvss3P1.getVersionName();
                versionToColorMap.put(rowLabel, ColorScheme.CVSS_3.getColor());
            } else if (cvss2 != null && i == 0) {
                rowLabel = Cvss2.getVersionName();
                versionToColorMap.put(rowLabel, ColorScheme.CVSS_2.getColor());
            } else {
                rowLabel = "Unknown";
            }
            for (int j = 0; j < currentDataset.getData().size(); ++j) {
                String currentLabel = (String)cvssChartData.getLabels().get(j);
                cvssDataset.addValue((Number)currentDataset.getData().get(j), (Comparable)((Object)rowLabel), (Comparable)((Object)currentLabel));
            }
        }
        SpiderWebPlot plotModified = new SpiderWebPlot((CategoryDataset)cvssDataset);
        for (String version : versionToColorMap.keySet()) {
            plotModified.setSeriesPaint(cvssDataset.getRowIndex((Comparable)((Object)version)), (Paint)versionToColorMap.get(version));
        }
        plotModified.setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        plotModified.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        plotModified.setMaxValue(10.0);
        plotModified.setNoDataMessage("No Cvss Data available");
        JFreeChart svgChart = new JFreeChart("", (Plot)plotModified);
        svgChart.setBackgroundPaint((Paint)new ChartColor(255, 255, 255));
        svgChart.setPadding(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        return new GeneratedChartBuilder().setjFreeChart(svgChart).setjFreeChartName(isModified ? "cvss_modified_" + vulnerabilityName : "cvss_unmodified_" + vulnerabilityName).setChartJsChart((Chart<?, ?, ?, ?>)cvssChart).setChartJsChartId("cvssChart" + VulnerabilityAssessmentDashboard.makeJsVar(vulnerabilityName, new Random())).setCanvasOrParentTag((ContainerTag)TagCreator.div().withClasses(new String[]{"cvssChart-container", isModified ? "modified" : "unmodified"})).setCharJsChartJsVarName("cvssChart").createGeneratedChart();
    }

    private static RadarChartDataset createCvssRadarChartDataset(CvssVector cvss, Color color, String label, boolean includeModified, VulnerabilityAssessmentDashboardEnrichmentConfiguration.VulnerabilityCvssSvgChartInterpolationMethod interpolationMethod) {
        RadarChartDataset cvssChartDataset = new RadarChartDataset().setLabel(label).setBackgroundColor(ColorScheme.setOpacity((Color)color, (float)0.2f)).setBorderColor(color).addPointBackgroundColor(new Color[]{color}).addPointBorderColor(new Color[]{Color.WHITE});
        BakedCvssVectorScores bakedScores = cvss.getBakedScores();
        if (includeModified) {
            double baseScore = bakedScores.getNormalizedBaseScore();
            double impactScore = VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedImpactScore(), cvss.getBaseScore());
            double exploitabilityScore = VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedExploitabilityScore(), cvss.getBaseScore());
            double adjustedImpactScore = VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedAdjustedImpactScore(), Double.NaN);
            double temporalScore = VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedTemporalScore(), Double.NaN);
            double environmentalScore = VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedEnvironmentalScore(), Double.NaN);
            if (interpolationMethod == VulnerabilityAssessmentDashboardEnrichmentConfiguration.VulnerabilityCvssSvgChartInterpolationMethod.BASE_METRICS) {
                cvssChartDataset.addPointRadius(new Number[]{3});
                if (Double.isNaN(adjustedImpactScore) && !Double.isNaN(impactScore)) {
                    adjustedImpactScore = impactScore;
                    cvssChartDataset.addPointRadius(new Number[]{0});
                } else {
                    cvssChartDataset.addPointRadius(new Number[]{3});
                }
                cvssChartDataset.addPointRadius(new Number[]{3});
                if (Double.isNaN(temporalScore) && !Double.isNaN(baseScore)) {
                    temporalScore = baseScore;
                    cvssChartDataset.addPointRadius(new Number[]{0});
                } else {
                    cvssChartDataset.addPointRadius(new Number[]{3});
                }
                cvssChartDataset.addPointRadius(new Number[]{3});
                if (Double.isNaN(environmentalScore) && !Double.isNaN(baseScore)) {
                    environmentalScore = baseScore;
                    cvssChartDataset.addPointRadius(new Number[]{0});
                } else {
                    cvssChartDataset.addPointRadius(new Number[]{3});
                }
            } else {
                double angleStep = 60.0;
                cvssChartDataset.addPointRadius(new Number[]{3});
                if (Double.isNaN(adjustedImpactScore)) {
                    adjustedImpactScore = VulnerabilityAssessmentDashboard.cvssRadarChartInterpolate(baseScore, impactScore, 60.0, 90.0);
                    cvssChartDataset.addPointRadius(new Number[]{0});
                } else {
                    cvssChartDataset.addPointRadius(new Number[]{3});
                }
                cvssChartDataset.addPointRadius(new Number[]{3});
                if (Double.isNaN(temporalScore)) {
                    temporalScore = VulnerabilityAssessmentDashboard.cvssRadarChartInterpolate(impactScore, exploitabilityScore, 60.0, -30.0);
                    cvssChartDataset.addPointRadius(new Number[]{0});
                } else {
                    cvssChartDataset.addPointRadius(new Number[]{3});
                }
                cvssChartDataset.addPointRadius(new Number[]{3});
                if (Double.isNaN(environmentalScore)) {
                    environmentalScore = VulnerabilityAssessmentDashboard.cvssRadarChartInterpolate(exploitabilityScore, baseScore, 60.0, -150.0);
                    cvssChartDataset.addPointRadius(new Number[]{0});
                } else {
                    cvssChartDataset.addPointRadius(new Number[]{3});
                }
            }
            cvssChartDataset.addData((Object[])new Number[]{baseScore, adjustedImpactScore, impactScore, temporalScore, exploitabilityScore, environmentalScore});
        } else {
            cvssChartDataset.addData((Object[])new Number[]{VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedBaseScore(), cvss.getBaseScore()), VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedImpactScore(), cvss.getBaseScore()), VulnerabilityAssessmentDashboard.getEffectiveCvss4ScoreForUnknownScore(cvss, bakedScores.getNormalizedExploitabilityScore(), cvss.getBaseScore())});
        }
        return cvssChartDataset;
    }

    private static double getEffectiveCvss4ScoreForUnknownScore(CvssVector result, double score, double v4Score) {
        if (result instanceof Cvss4P0 && Double.isNaN(score)) {
            return v4Score;
        }
        return score;
    }

    public static double cvssRadarChartInterpolate(double value1, double value2, double angleStep, double baseAngle) {
        Vector vector1 = new Vector(value1, 0.0).rotate(baseAngle);
        Vector vector2 = new Vector(value2, 0.0).rotate(baseAngle - 2.0 * angleStep);
        Vector averageLine = new Vector(10.0, 0.0).rotate(baseAngle - angleStep);
        Vector averagePosition = Vector.calculateInterceptionPoint(vector1, vector2, new Vector(0.0, 0.0), averageLine);
        return averagePosition.length();
    }

    private List<String> extractCvssDetailsTableHeaders(Map<CvssVector, List<DomContent>> cvssVectorsMap) {
        ArrayList<String> cvssTableHeaders = new ArrayList<String>();
        Set<CvssVector> cvssVectors = cvssVectorsMap.keySet();
        boolean anyHasTagString = cvssVectorsMap.values().stream().anyMatch(element -> element != null && !element.isEmpty());
        List nonNullVectors = cvssVectors.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (anyHasTagString) {
            cvssTableHeaders.add("Usage");
        }
        cvssTableHeaders.add("Version");
        cvssTableHeaders.add("Source");
        cvssTableHeaders.add("Overall score");
        cvssTableHeaders.add("Base score");
        for (CvssVector cvss : nonNullVectors) {
            if (!(cvss instanceof MultiScoreCvssVector) || cvssTableHeaders.contains("Impact")) continue;
            cvssTableHeaders.add("Impact");
        }
        for (CvssVector cvss : nonNullVectors) {
            if (!(cvss instanceof MultiScoreCvssVector) || cvssTableHeaders.contains("Exploitability")) continue;
            cvssTableHeaders.add("Exploitability");
        }
        for (CvssVector cvss : nonNullVectors) {
            if (!(cvss instanceof MultiScoreCvssVector) || cvssTableHeaders.contains("Temporal") || !((MultiScoreCvssVector)cvss).isAnyTemporalDefined()) continue;
            cvssTableHeaders.add("Temporal");
        }
        for (CvssVector cvss : nonNullVectors) {
            if (!(cvss instanceof MultiScoreCvssVector) || cvssTableHeaders.contains("Environmental") || !((MultiScoreCvssVector)cvss).isAnyEnvironmentalDefined()) continue;
            cvssTableHeaders.add("Environmental");
        }
        for (CvssVector cvss : nonNullVectors) {
            if (!(cvss instanceof MultiScoreCvssVector) || cvssTableHeaders.contains("Adjusted impact") || Double.isNaN(cvss.getBakedScores().getAdjustedImpactScore())) continue;
            cvssTableHeaders.add("Adjusted impact");
        }
        cvssTableHeaders.add("Vector");
        return cvssTableHeaders;
    }

    private <T extends CvssVector> TrTag createCvssDetailsTableRowForCvss(CvssVector cvss, List<DomContent> tag, List<String> headers, CvssSelectionResult selectedCvssVectors, Vulnerability vulnerability) {
        CvssVector initialCvss;
        SpanTag vectorSources;
        TrTag row = TagCreator.tr();
        String cssClass = cvss instanceof Cvss2 ? "cvss2-text" : (cvss instanceof Cvss3P1 ? "cvss3-text" : "cvss4-text");
        String vectorVersion = cvss.getName();
        SpanTag spanTag = vectorSources = cvss.getLatestSource() == null ? TagCreator.span((String)"Unknown") : this.createCvssVectorSourceLinks(cvss.getCvssSources());
        if (headers.contains("Usage")) {
            if (tag == null || tag.isEmpty()) {
                row.with((DomContent)TagCreator.td());
            } else {
                tag.sort(Comparator.comparing(c -> c.render()).reversed());
                row.with((DomContent)TagCreator.td((DomContent[])new DomContent[]{TagCreator.span().with(tag)}));
            }
        }
        BakedCvssVectorScores bakedScores = cvss.getBakedScores();
        DomContent[] domContentArray = new DomContent[4];
        domContentArray[0] = TagCreator.td((DomContent[])new DomContent[]{TagCreator.span().with((DomContent)TagCreator.b((String)vectorVersion).withClass(cssClass))});
        domContentArray[1] = TagCreator.td((DomContent[])new DomContent[]{((SpanTag)TagCreator.span().with((DomContent)vectorSources)).withClass(cssClass)});
        domContentArray[2] = this.createCvssDetailsTableStyledCell(cvss.getOverallScore(), bakedScores.getNormalizedOverallScore(), bakedScores.getUnNormalizedOverallScoreMax(), () -> ((BakedCvssVectorScores)bakedScores).hasNormalizedOverallScore());
        domContentArray[3] = this.createCvssDetailsTableStyledCell(bakedScores.getBaseScore(), bakedScores.getNormalizedBaseScore(), bakedScores.getUnNormalizedBaseScoreMax(), () -> ((BakedCvssVectorScores)bakedScores).hasNormalizedBaseScore());
        row.with(domContentArray);
        if (cvss instanceof Cvss2 || cvss instanceof Cvss3P1) {
            DomContent[] domContentArray2 = new DomContent[2];
            domContentArray2[0] = this.createCvssDetailsTableStyledCell(bakedScores.getImpactScore(), bakedScores.getNormalizedImpactScore(), bakedScores.getUnNormalizedImpactScoreMax(), () -> ((BakedCvssVectorScores)bakedScores).hasNormalizedImpactScore());
            domContentArray2[1] = this.createCvssDetailsTableStyledCell(bakedScores.getExploitabilityScore(), bakedScores.getNormalizedExploitabilityScore(), bakedScores.getUnNormalizedExploitabilityScoreMax(), () -> ((BakedCvssVectorScores)bakedScores).hasNormalizedExploitabilityScore());
            row.with(domContentArray2);
        } else {
            if (headers.contains("Impact")) {
                row.with((DomContent)TagCreator.td());
            }
            if (headers.contains("Exploitability")) {
                row.with((DomContent)TagCreator.td());
            }
        }
        if (bakedScores.isTemporalScoreAvailable()) {
            row.with((DomContent)this.createCvssDetailsTableStyledCell(bakedScores.getTemporalScore(), bakedScores.getNormalizedTemporalScore(), bakedScores.getUnNormalizedTemporalScoreMax(), () -> ((BakedCvssVectorScores)bakedScores).hasNormalizedTemporalScore()));
        } else if (headers.contains("Temporal")) {
            row.with((DomContent)TagCreator.td());
        }
        if (bakedScores.isEnvironmentalScoreAvailable()) {
            row.with((DomContent)this.createCvssDetailsTableStyledCell(bakedScores.getEnvironmentalScore(), bakedScores.getNormalizedEnvironmentalScore(), bakedScores.getUnNormalizedEnvironmentalScoreMax(), () -> ((BakedCvssVectorScores)bakedScores).hasNormalizedEnvironmentalScore()));
        } else if (headers.contains("Environmental")) {
            row.with((DomContent)TagCreator.td());
        }
        if (bakedScores.getAdjustedImpactScore() > 0.0) {
            row.with((DomContent)this.createCvssDetailsTableStyledCell(bakedScores.getAdjustedImpactScore(), bakedScores.getNormalizedAdjustedImpactScore(), bakedScores.getUnNormalizedAdjustedImpactScoreMax(), () -> ((BakedCvssVectorScores)bakedScores).hasNormalizedAdjustedImpactScore()));
        } else if (headers.contains("Adjusted impact")) {
            row.with((DomContent)TagCreator.td());
        }
        UniversalCvssCalculatorLinkGenerator aeUniversalWebEditorLink = new UniversalCvssCalculatorLinkGenerator();
        UniversalCvssCalculatorLinkGenerator.UniversalCvssCalculatorEntry linkCvssVectorEntry = aeUniversalWebEditorLink.addVectorForVulnerability(cvss, vulnerability.getId());
        if (selectedCvssVectors.isContext(cvss) && (initialCvss = selectedCvssVectors.findWithSourceInInitial(cvss)) != null) {
            linkCvssVectorEntry.setInitialCvssVectorUnchecked(initialCvss);
            aeUniversalWebEditorLink.addVectorForVulnerability(initialCvss, vulnerability.getId());
        }
        aeUniversalWebEditorLink.setSelectedVector(cvss);
        row.with((DomContent)TagCreator.td((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)cvss.toString()).withHref(this.generateLinkForUniversalCvssCalculator(aeUniversalWebEditorLink))).withTarget(HrefTargets.TARGET_CVSS_DETAILS.getTarget())}));
        return row;
    }

    private TdTag createCvssDetailsTableStyledCell(double score, double normalizedScore, double maxUnNormalizedScore, Supplier<Boolean> hasNormalizedScore) {
        TdTag tag = (TdTag)TagCreator.td((String)String.valueOf(score)).withStyle(this.cvssScoringStyle.style(String.valueOf(normalizedScore), null));
        if (hasNormalizedScore.get().booleanValue()) {
            tag.withText(String.format("/%s \u2192 %s", maxUnNormalizedScore, normalizedScore));
        }
        return tag;
    }

    private DivTag createVulnerabilityStatusHistoryEntry(VulnerabilityStatusHistoryEntry entry, boolean isFirst) {
        boolean hasModifiedPriority;
        SpanTag contentFromMarkdown;
        boolean hasDate;
        ContentCard statusCard = new ContentCard();
        String titleSuffix = (entry.isActive() ? "" : " (assessment inactive)") + (entry.getScope() != VulnerabilityStatus.Scope.INVENTORY ? "" : " (inventory scope)");
        if (entry.getStatus() == null) {
            statusCard.withTitle("No status set" + titleSuffix);
        } else {
            switch (entry.getStatus()) {
                case "applicable": {
                    statusCard.withTitle("applicable" + titleSuffix).withType(ContentCard.ContentCardType.RED);
                    break;
                }
                case "not applicable": {
                    statusCard.withTitle("not applicable" + titleSuffix).withType(ContentCard.ContentCardType.GREEN);
                    break;
                }
                case "insignificant": {
                    statusCard.withTitle("insignificant" + titleSuffix).withType(ContentCard.ContentCardType.GRAY);
                    break;
                }
                case "void": {
                    statusCard.withTitle("void" + titleSuffix).withType(ContentCard.ContentCardType.LIGHT_GRAY);
                    break;
                }
                case "in review": {
                    statusCard.withTitle("in review" + titleSuffix).withType(ContentCard.ContentCardType.PASTEL_BLUE);
                    break;
                }
                default: {
                    statusCard.withTitle("Unknown Status");
                }
            }
        }
        if (!entry.isActive() || entry.getScope() == VulnerabilityStatus.Scope.INVENTORY && !isFirst) {
            statusCard.withType(ContentCard.ContentCardType.LIGHT_GRAY);
        }
        if (entry.getIncludeLabels() != null && entry.getIncludeLabels().length > 0) {
            statusCard.with(new DomContent[]{TagCreator.span((String)"Include feature labels: ").withClass("slight-text-highlight")});
            for (String label : entry.getIncludeLabels()) {
                statusCard.with(new DomContent[]{this.makeBadge(label, "primary")});
            }
            statusCard.with(new DomContent[]{TagCreator.br()});
        }
        if (entry.getExcludeLabels() != null && entry.getExcludeLabels().length > 0) {
            statusCard.with(new DomContent[]{TagCreator.span((String)"Exclude feature labels: ").withClass("slight-text-highlight")});
            for (String label : entry.getExcludeLabels()) {
                statusCard.with(new DomContent[]{this.makeBadge(label, "primary")});
            }
            statusCard.with(new DomContent[]{TagCreator.br()});
        }
        boolean hasAuthor = entry.getAuthor() != null && !entry.getAuthor().isEmpty();
        boolean bl = hasDate = entry.getDate() != null;
        if (hasAuthor && hasDate) {
            statusCard.with(new DomContent[]{TagCreator.span((String)"Author: ").withClass("slight-text-highlight"), TagCreator.text((String)(entry.getAuthor() + " (" + entry.getFormattedDate() + ")"))});
        } else if (hasAuthor) {
            statusCard.with(new DomContent[]{TagCreator.span((String)"Author: ").withClass("slight-text-highlight"), TagCreator.text((String)entry.getAuthor())});
        } else if (hasDate) {
            statusCard.with(new DomContent[]{TagCreator.span((String)"Date: ").withClass("slight-text-highlight"), TagCreator.text((String)entry.getFormattedDate())});
        }
        boolean lastEntryHadParagraph = false;
        if (entry.getRationale() != null && !entry.getRationale().isEmpty()) {
            if (statusCard.getNumChildren() > 0) {
                statusCard.with(new DomContent[]{TagCreator.br()});
            }
            String rationale = entry.getRationale();
            if (entry == VulnerabilityStatusHistoryEntry.INSIGNIFICANT) {
                rationale = String.format(Locale.ENGLISH, rationale, this.securityPolicyConfiguration.getInsignificantThreshold());
            }
            SpanTag contentFromMarkdown2 = Dashboard.markdownToHtml(this.findAndMakeCveMDLinks(Dashboard.attemptEscapeScripts(rationale)), HrefTargets.TARGET_ARTIFACT.getTarget());
            statusCard.with(new DomContent[]{TagCreator.span((String)"Rationale: ").withClass("slight-text-highlight"), contentFromMarkdown2});
            lastEntryHadParagraph = rationale.contains("<p>");
        }
        if (entry.getRisk() != null && !entry.getRisk().isEmpty()) {
            if (statusCard.getNumChildren() > 0 && !lastEntryHadParagraph) {
                statusCard.with(new DomContent[]{TagCreator.br()});
            }
            contentFromMarkdown = Dashboard.markdownToHtml(this.findAndMakeCveMDLinks(Dashboard.attemptEscapeScripts(entry.getRisk())), HrefTargets.TARGET_ARTIFACT.getTarget());
            statusCard.with(new DomContent[]{TagCreator.span((String)"Risk: ").withClass("slight-text-highlight"), contentFromMarkdown});
            lastEntryHadParagraph = entry.getRisk().contains("<p>");
        }
        if (entry.getMeasures() != null && !entry.getMeasures().isEmpty()) {
            if (statusCard.getNumChildren() > 0 && !lastEntryHadParagraph) {
                statusCard.with(new DomContent[]{TagCreator.br()});
            }
            contentFromMarkdown = Dashboard.markdownToHtml(this.findAndMakeCveMDLinks(Dashboard.attemptEscapeScripts(entry.getMeasures())), HrefTargets.TARGET_ARTIFACT.getTarget());
            statusCard.with(new DomContent[]{TagCreator.span((String)"Measures: ").withClass("slight-text-highlight"), contentFromMarkdown});
        }
        boolean bl2 = hasModifiedPriority = entry.getPriority() != 0;
        if (hasModifiedPriority) {
            if (statusCard.getNumChildren() > 0) {
                statusCard.with(new DomContent[]{TagCreator.br()});
            }
            statusCard.with(new DomContent[]{TagCreator.span((String)"Display Priority: ").withClass("slight-text-highlight"), TagCreator.text((String)String.valueOf(entry.getPriority()))});
            if (entry.getPriority() < 0) {
                statusCard.with(new DomContent[]{TagCreator.span((String)" (appears lower than other status entries)")});
            } else if (entry.getPriority() > 0) {
                statusCard.with(new DomContent[]{TagCreator.span((String)" (appears higher than other status entries)")});
            }
        }
        return statusCard.generate();
    }

    private UnescapedText richTextField(String text) {
        return TagCreator.rawHtml((String)text.replaceAll("\\*\\*([^*]+)\\*\\*", "<b>$1</b>").replaceAll("\\*([^*]+)\\*", "<i>$1</i>").replaceAll("`([^`]+)`", "<code>$1</code>"));
    }

    protected SpanTag makeBadge(Object text, String type) {
        return (SpanTag)TagCreator.span((String)String.valueOf(text)).withClasses(new String[]{"badge", "badge-" + type});
    }

    private String makeVulnerabilityReferenceBadge(String vulnerability, Collection<Vulnerability> allVulnerabilities) {
        if (allVulnerabilities.stream().anyMatch(v -> v.getId().equals(vulnerability))) {
            return "<a onclick=\"showSheet('" + vulnerability + "')\"><span class=\"badge badge-primary badge-underline clickable\">" + vulnerability + "</span></a>";
        }
        return this.makeHTMLLink("<span class=\"badge badge-secondary badge-underline clickable\">" + vulnerability + "</span>", "https://nvd.nist.gov/vuln/detail/" + vulnerability, HrefTargets.TARGET_NVD.getTarget()).render();
    }

    protected ATag makeHTMLLink(String text, String url, String target) {
        return (ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.rawHtml((String)text)}).withTarget(target)).withHref(String.valueOf(url).replace(" ", "%20"));
    }

    private ATag makeHTMLLinkWithStyle(String text, String url, String target, String style) {
        return (ATag)((ATag)((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.rawHtml((String)text)}).withTarget(target)).withHref(String.valueOf(url).replace(" ", "%20"))).withStyle(style);
    }

    private String findAndMakeCveLinks(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll(CVE_LINK_PATTERN.pattern(), "<a href=\"https://nvd.nist.gov/vuln/detail/$1\" target=\"" + HrefTargets.TARGET_NVD.getTarget() + "\" class=\"black-underline\">$1</a>");
    }

    private String findAndMakeCveMDLinks(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll(CVE_LINK_PATTERN.pattern(), "[$1](https://nvd.nist.gov/vuln/detail/$1)");
    }

    private SpanTag createSlightHighlightText(String text) {
        return (SpanTag)TagCreator.span((String)text).withClass("slight-text-highlight");
    }

    protected SpanTag generateATagsForHyperlinks(String text, String target) {
        Matcher matcher = HTTP_URL_REGEX.matcher(text);
        SpanTag container = TagCreator.span();
        int previousUrlEndIndex = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (previousUrlEndIndex != startIndex) {
                String previousSegment = text.substring(previousUrlEndIndex, startIndex);
                container.with((DomContent)TagCreator.text((String)previousSegment));
            }
            String url = text.substring(startIndex, endIndex);
            container.with((DomContent)((ATag)TagCreator.a((String)url).withHref(url)).withTarget(target));
            previousUrlEndIndex = endIndex;
        }
        if (previousUrlEndIndex != text.length()) {
            String previousSegment = text.substring(previousUrlEndIndex);
            container.with((DomContent)TagCreator.text((String)previousSegment));
        }
        return container;
    }

    public static double roundOneDecimal(double value) {
        return VulnerabilityAssessmentDashboard.round(value, 1);
    }

    private static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    protected String getEpssScoreColor(double score) {
        if (score <= 0.01) {
            return ColorScheme.PASTEL_GRAY.getCssRootName();
        }
        if (score <= 0.1) {
            return ColorScheme.STRONG_YELLOW.getCssRootName();
        }
        if (score <= 0.8) {
            return ColorScheme.STRONG_LIGHT_ORANGE.getCssRootName();
        }
        return ColorScheme.STRONG_RED.getCssRootName();
    }

    private String generateLinkForUniversalCvssCalculator(UniversalCvssCalculatorLinkGenerator generator) {
        return generator.addOpenSection("base").addOpenSection("environmental").addOpenSection("environmental-base").generateOptimizedLink();
    }

    @Override
    public VulnerabilityAssessmentDashboardEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VulnerabilityAssessmentDashboardEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }

    public static class GeneratedChartBuilder {
        private JFreeChart jFreeChart;
        private String jFreeChartName;
        private Chart<?, ?, ?, ?> chartJsChart;
        private String chartJsChartId;
        private ContainerTag<?> canvasOrParentTag;
        private String charJsChartJsVarName;

        public GeneratedChartBuilder setjFreeChart(JFreeChart jFreeChart) {
            this.jFreeChart = jFreeChart;
            return this;
        }

        public GeneratedChartBuilder setjFreeChartName(String jFreeChartName) {
            this.jFreeChartName = jFreeChartName;
            return this;
        }

        public GeneratedChartBuilder setChartJsChart(Chart<?, ?, ?, ?> chartJsChart) {
            this.chartJsChart = chartJsChart;
            return this;
        }

        public GeneratedChartBuilder setChartJsChartId(String chartJsChartId) {
            this.chartJsChartId = chartJsChartId;
            return this;
        }

        public GeneratedChartBuilder setCanvasOrParentTag(ContainerTag<?> canvasOrParentTag) {
            this.canvasOrParentTag = canvasOrParentTag;
            return this;
        }

        public GeneratedChartBuilder setCharJsChartJsVarName(String charJsChartJsVarName) {
            this.charJsChartJsVarName = charJsChartJsVarName;
            return this;
        }

        public GeneratedChart createGeneratedChart() {
            int jFreeChartAttributes = 0;
            if (this.jFreeChart != null) {
                ++jFreeChartAttributes;
            }
            if (this.jFreeChartName != null) {
                ++jFreeChartAttributes;
            }
            if (jFreeChartAttributes != 0 && jFreeChartAttributes != 2) {
                throw new IllegalStateException("jFreeChart and jFreeChartName must either both be null or both be set");
            }
            int chartJsChartAttributes = 0;
            if (this.chartJsChart != null) {
                ++chartJsChartAttributes;
            }
            if (this.chartJsChartId != null) {
                ++chartJsChartAttributes;
            }
            if (this.canvasOrParentTag != null) {
                ++chartJsChartAttributes;
            }
            if (this.charJsChartJsVarName != null) {
                ++chartJsChartAttributes;
            }
            if (chartJsChartAttributes != 0 && chartJsChartAttributes != 4) {
                throw new IllegalStateException("chartJsChart, chartJsChartId, canvasOrParentTag and charJsChartJsVarName must either all be null or all be set");
            }
            return new GeneratedChart(this.jFreeChart, this.jFreeChartName, this.chartJsChart, this.chartJsChartId, this.canvasOrParentTag, this.charJsChartJsVarName);
        }
    }

    public static class GeneratedChart {
        private final String chartJsChartId;
        private final Chart<?, ?, ?, ?> chartJsChart;
        private final String jFreeChartName;
        private final JFreeChart jFreeChart;
        private final DomContent canvasTag;
        private final String charJsChartJsVarName;

        private GeneratedChart(JFreeChart jFreeChart, String jFreeChartName, Chart<?, ?, ?, ?> chartJsChart, String chartJsChartId, ContainerTag<?> canvasOrParentTag, String charJsChartJsVarName) {
            this.jFreeChartName = jFreeChartName;
            this.jFreeChart = jFreeChart;
            this.chartJsChartId = chartJsChartId;
            this.chartJsChart = chartJsChart;
            this.canvasTag = canvasOrParentTag instanceof CanvasTag ? canvasOrParentTag.withId(chartJsChartId) : (canvasOrParentTag.render().contains("<canvas") ? TagCreator.rawHtml((String)canvasOrParentTag.render().replace("<canvas", "<canvas id=\"" + chartJsChartId + "\"")) : canvasOrParentTag.with((DomContent)TagCreator.canvas().withId(chartJsChartId)));
            this.charJsChartJsVarName = charJsChartJsVarName;
        }

        public UnescapedText generateChartJsChart() {
            if (this.canvasTag == null || this.chartJsChartId == null || this.chartJsChart == null || this.charJsChartJsVarName == null) {
                return TagCreator.rawHtml((String)"");
            }
            return TagCreator.join((Object[])new Object[]{this.canvasTag, TagCreator.script((DomContent[])new DomContent[]{TagCreator.rawHtml((String)("var " + this.charJsChartJsVarName + " = new Chart(\n  document.getElementById('" + this.chartJsChartId + "'),\n  " + this.chartJsChart.build() + "\n);"))})});
        }

        public void writeSvgTo(File dir) {
            int height;
            int width;
            if (dir == null) {
                return;
            }
            if (!(dir.exists() || dir.mkdirs() || dir.exists())) {
                throw new IllegalStateException("Could not create directory " + dir.getAbsolutePath());
            }
            if (this.jFreeChart == null || this.jFreeChartName == null) {
                return;
            }
            JFreeChartUtils.setFont(this.jFreeChart, new Font("Helvetica", 0, 14));
            JFreeChartUtils.setTransparentBackground(this.jFreeChart);
            JFreeChartUtils.removeChartOutline(this.jFreeChart);
            JFreeChartUtils.setPieChartLabelGenerator(this.jFreeChart, true, true, true, new Color(242, 242, 242), new Color(45, 45, 45));
            if (this.jFreeChartName.startsWith("timeline_")) {
                int width2 = 1600;
                int height2 = 300;
                return;
            }
            if (this.jFreeChartName.startsWith("cvss_") || this.jFreeChartName.startsWith("overview_") || this.jFreeChartName.startsWith("vulnerability-overview-")) {
                width = 430;
                height = 320;
            } else {
                width = 640;
                height = 460;
            }
            File targetFile = new File(dir, this.jFreeChartName + ".svg");
            try {
                JFreeChartUtils.writeGraphToFile(this.jFreeChart, targetFile, width, height);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to write SVG chart [" + this.jFreeChartName + "] to file " + targetFile.getAbsolutePath(), e);
            }
        }

        public String getChartJsChartId() {
            return this.chartJsChartId;
        }

        public Chart<?, ?, ?, ?> getChartJsChart() {
            return this.chartJsChart;
        }

        public String getJFreeChartName() {
            return this.jFreeChartName;
        }

        public JFreeChart getJFreeChart() {
            return this.jFreeChart;
        }

        public DomContent getCanvasTag() {
            return this.canvasTag;
        }

        public String getCharJsChartJsVarName() {
            return this.charJsChartJsVarName;
        }
    }

    protected static enum HrefTargets {
        TARGET_NVD("nvd"),
        TARGET_CVSS_DETAILS("cvss_details"),
        TARGET_CVEDETAILS("cvedetails"),
        TARGET_MITRE("mitre"),
        TARGET_NVD_CPE_SEARCH("cpesearch"),
        TARGET_CERT_FR("certfr"),
        TARGET_CERT_EU("certeu"),
        TARGET_CERT_SEI("certsei"),
        TARGET_CERT_SEI_REFERENCE("certseiref"),
        TARGET_MICROSOFT("microsoft"),
        TARGET_GITHUB("ghsa"),
        TARGET_MICROSOFT_REFERENCE("microsoft_reference"),
        TARGET_CWE("cwe"),
        TARGET_REFERENCE("reference"),
        TARGET_ARTIFACT("artifact"),
        TARGET_EOL_DATE("eol_data"),
        TARGET_KEV("kev"),
        TARGET_BLANK("_blank");

        private final String target;

        public String getTarget() {
            return this.target;
        }

        private HrefTargets(String target) {
            this.target = target;
        }
    }

    protected static enum NavigationHeaders {
        NAVIGATION_VULNERABILITY_NAME("Name"),
        NAVIGATION_PRIORITY_SCORE("Priority <br>Score"),
        NAVIGATION_PRIORITY_SCORE_LABEL("Priority <br>Label"),
        NAVIGATION_CVSS_MODIFIED_OVERALL("Context <br>Overall"),
        NAVIGATION_CVSS_UNMODIFIED_OVERALL("Initial <br>Overall"),
        NAVIGATION_CVSS_BASE("Base"),
        NAVIGATION_CVSS_EXPLOITABILITY("Exploit-<br>ability"),
        NAVIGATION_CVSS_IMPACT("Impact"),
        NAVIGATION_EPSS_SCORE("EPSS<br>Score"),
        NAVIGATION_AMOUNT_ARTIFACTS("Arti-<br>facts"),
        NAVIGATION_AMOUNT_ADVISORIES_REVIEWED("Security<br>Advisories"),
        NAVIGATION_KEV_ENTRY("KEV"),
        NAVIGATION_STATUS("Status"),
        NAVIGATION_USED_MATCHING_INFORMATION("Matched configurations"),
        NAVIGATION_UNUSED_MATCHING_INFORMATION("Unused configurations"),
        NAVIGATION_VERSION("Versions"),
        NAVIGATION_COMPONENTS("Components"),
        CORRELATION_DISTANCE("\u0394<sub>Corr"),
        EOL_STATE("EOL");

        private final String title;

        public String getTitle() {
            return this.title;
        }

        private NavigationHeaders(String title) {
            this.title = title;
        }
    }
}

