/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation;

import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarningEntry;
import com.metaeffekt.artifact.analysis.vulnerability.enrichment.warnings.InventoryWarnings;
import com.metaeffekt.artifact.enrichment.InventoryEnricher;
import com.metaeffekt.artifact.enrichment.configurations.InventoryValidationEnrichmentConfiguration;
import com.metaeffekt.artifact.enrichment.validation.InventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.reason.InventoryValidationReason;
import com.metaeffekt.artifact.enrichment.validation.reason.ReasonIdentifier;
import com.metaeffekt.mirror.download.documentation.EnricherMetadata;
import com.metaeffekt.mirror.download.documentation.InventoryEnrichmentPhase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.metaeffekt.core.inventory.processor.model.AbstractModelBase;
import org.metaeffekt.core.inventory.processor.model.Artifact;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnricherMetadata(name="Inventory Validation", phase=InventoryEnrichmentPhase.INVENTORY_POST_PROCESSING, intermediateFileSuffix="inventory-validation", mavenPropertyName="inventoryValidationEnrichment", shouldWriteIntermediateInventory=false)
public class InventoryValidationEnrichment
extends InventoryEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryValidationEnrichment.class);
    private InventoryValidationEnrichmentConfiguration configuration = new InventoryValidationEnrichmentConfiguration();
    private final Map<Inventory, List<InventoryValidationReason>> cachedValidationFailReasons = new HashMap<Inventory, List<InventoryValidationReason>>();
    private final File baseMirrorDirectory;

    public InventoryValidationEnrichment(File baseMirrorDirectory) {
        this.baseMirrorDirectory = baseMirrorDirectory;
    }

    @Override
    public InventoryValidationEnrichmentConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<InventoryValidationReason> getValidationFailReasons(Inventory inventory) {
        return this.cachedValidationFailReasons.get(inventory);
    }

    @Override
    protected void performEnrichment(Inventory inventory) {
        List<InventoryValidator> validators = this.configuration.buildValidators();
        LinkedHashMap<InventoryValidator, List<InventoryValidationReason>> validationErrorReasons = new LinkedHashMap<InventoryValidator, List<InventoryValidationReason>>();
        for (InventoryValidator validator : validators) {
            validator.beforeValidation(this.baseMirrorDirectory);
            LOG.info("Validating inventory with validator: [{}]", (Object)validator.getValidatorName());
            try {
                List<InventoryValidationReason> reasons = validator.validate(inventory);
                for (InventoryValidationReason reason : reasons) {
                    validationErrorReasons.computeIfAbsent(validator, k -> new ArrayList()).add(reason);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Performing the validation failed for validator " + validator.getValidatorName() + ": " + e.getMessage(), e);
            }
            if (validationErrorReasons.getOrDefault(validator, Collections.emptyList()).isEmpty()) {
                LOG.info("No validation failures found");
                continue;
            }
            LOG.warn("Found [{}] validation failures", (Object)validationErrorReasons.values().stream().mapToInt(List::size).sum());
        }
        this.cachedValidationFailReasons.computeIfAbsent(inventory, k -> new ArrayList()).addAll(validationErrorReasons.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        if (!validationErrorReasons.isEmpty()) {
            int count = validationErrorReasons.values().stream().mapToInt(List::size).sum();
            String longDescriptions = this.buildValidationLongDescriptions(Collections.singletonList(validationErrorReasons));
            String logMessage = "Inventory Validation failures in " + count + " instance" + (count == 1 ? "" : "s") + ":\n" + this.buildValidationFailReasonsReport(validationErrorReasons) + "\n" + longDescriptions + "\n";
            if (this.configuration.isFailOnValidationErrors()) {
                throw new IllegalStateException(logMessage);
            }
            if (this.configuration.isAddAsCorrelationWarnings()) {
                this.addInventoryWarningsToInventory(inventory, this.cachedValidationFailReasons.get(inventory));
            }
            LOG.error(logMessage);
        } else {
            LOG.info("Inventory Validation successful.");
        }
    }

    private String buildValidationLongDescriptions(List<Map<InventoryValidator, List<InventoryValidationReason>>> validationFailReasons) {
        HashSet<ReasonIdentifier> reasonIdentifiers = new HashSet<ReasonIdentifier>();
        for (Map<InventoryValidator, List<InventoryValidationReason>> validationFailReason : validationFailReasons) {
            for (List<InventoryValidationReason> reasons : validationFailReason.values()) {
                for (InventoryValidationReason reason : reasons) {
                    if (reason.getReason().getLongDescription() == null) continue;
                    reasonIdentifiers.add(reason.getReason());
                }
            }
        }
        if (reasonIdentifiers.isEmpty()) {
            return "";
        }
        StringBuilder joiner = new StringBuilder();
        joiner.append("More information about the errors and possible solutions below:\n");
        for (ReasonIdentifier reasonIdentifier : reasonIdentifiers.stream().sorted(Comparator.comparingInt(Enum::ordinal)).collect(Collectors.toList())) {
            joiner.append(this.makeIndentedListEntry(reasonIdentifier.getLongDescription(), "[" + reasonIdentifier.ordinal() + "] ", 1));
        }
        return joiner.toString();
    }

    private String buildValidationFailReasonsReport(Map<InventoryValidator, List<InventoryValidationReason>> validationFailReasons) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<InventoryValidator, List<InventoryValidationReason>> entry : validationFailReasons.entrySet()) {
            InventoryValidator validator = entry.getKey();
            List<InventoryValidationReason> reasons = entry.getValue();
            sb.append("\n").append(InventoryValidationEnrichment.formatLogHeader(validator.getValidatorName())).append("\n");
            for (InventoryValidationReason reason : reasons) {
                sb.append(this.makeIndentedListEntry(reason.toString(), "- ", 2));
            }
        }
        return sb.toString();
    }

    private void addInventoryWarningsToInventory(Inventory inventory, List<InventoryValidationReason> validationFailReasons) {
        InventoryWarnings inventoryWarnings = new InventoryWarnings(inventory);
        for (InventoryValidationReason validationFailReason : validationFailReasons) {
            AbstractModelBase source = validationFailReason.getSource();
            String warningText = validationFailReason.getReason().getShortDescription() + ": " + validationFailReason.getText();
            if (source instanceof Artifact) {
                inventoryWarnings.addArtifactWarning(new InventoryWarningEntry<Artifact>((Artifact)source, warningText, "Validation"));
                continue;
            }
            if (source instanceof VulnerabilityMetaData) {
                inventoryWarnings.addVulnerabilityWarning(new InventoryWarningEntry<VulnerabilityMetaData>((VulnerabilityMetaData)source, warningText, "Validation"));
                continue;
            }
            if (source == null) {
                inventoryWarnings.addSourcelessWarning(warningText);
                continue;
            }
            LOG.warn("Cannot add correlation warning for source of type [{}]: {}", (Object)source, (Object)warningText);
        }
    }

    private String makeIndentedListEntry(String text, String indentationSymbol, int indent) {
        String[] lines = text.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) {
                sb.append(this.repeat(" ", indent)).append(indentationSymbol).append(lines[i]).append("\n");
                continue;
            }
            sb.append(this.repeat(" ", indent + indentationSymbol.length())).append(lines[i]).append("\n");
        }
        return sb.toString();
    }

    private String repeat(String text, int count) {
        return IntStream.range(0, count).mapToObj(i -> text).collect(Collectors.joining());
    }

    public void setConfiguration(InventoryValidationEnrichmentConfiguration configuration) {
        this.configuration = configuration;
    }
}

