/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.enrichment.validation;

import com.metaeffekt.artifact.enrichment.validation.InventoryValidator;
import com.metaeffekt.artifact.enrichment.validation.reason.InventoryValidationReason;
import java.util.ArrayList;
import java.util.List;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.model.VulnerabilityMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VulnerabilityInventoryValidator
extends InventoryValidator {
    private static final Logger LOG = LoggerFactory.getLogger(VulnerabilityInventoryValidator.class);
    private static final int MAX_WAIT_TIME_BEFORE_LOGGING = 15000;

    public abstract List<InventoryValidationReason> validate(Inventory var1, VulnerabilityMetaData var2);

    @Override
    public List<InventoryValidationReason> validate(Inventory inventory) {
        ArrayList<InventoryValidationReason> validationFailReasons = new ArrayList<InventoryValidationReason>();
        int i = 0;
        long startTime = System.currentTimeMillis();
        boolean logProgressEnabled = false;
        for (VulnerabilityMetaData vmd : inventory.getVulnerabilityMetaData()) {
            if (!logProgressEnabled) {
                boolean isLongerThanMaxWaitTime;
                boolean bl = isLongerThanMaxWaitTime = System.currentTimeMillis() - startTime > 15000L;
                if (isLongerThanMaxWaitTime) {
                    logProgressEnabled = true;
                    LOG.info("[{}] Validating vulnerability [{} / {}]", new Object[]{this.getValidatorName(), i, inventory.getVulnerabilityMetaData().size()});
                }
            }
            if (logProgressEnabled && i % 100 == 0) {
                LOG.info("[{}] Validating vulnerability [{} / {}]", new Object[]{this.getValidatorName(), i, inventory.getVulnerabilityMetaData().size()});
            }
            ++i;
            validationFailReasons.addAll(this.validate(inventory, vmd));
        }
        return validationFailReasons;
    }
}

