/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.extractors.configuration;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.extractors.configuration.AbstractExtractorConfiguration;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.metaeffekt.core.inventory.processor.configuration.DirectoryScanAggregatorConfiguration;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.metaeffekt.core.inventory.processor.reader.InventoryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryScanExtractorConfiguration
extends AbstractExtractorConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryScanExtractorConfiguration.class);
    private final File scanBaseDir;
    private final File referenceInventoryFile;
    private final Inventory referenceInventory;

    public DirectoryScanExtractorConfiguration(String id, File referenceInventoryFile, File scanResultInventoryFile, File scanBaseDir) {
        super(id, scanResultInventoryFile);
        this.scanBaseDir = scanBaseDir;
        this.referenceInventoryFile = referenceInventoryFile;
        this.referenceInventory = null;
    }

    public DirectoryScanExtractorConfiguration(String id, Inventory referenceInventory, File scanResultInventoryFile, File scanBaseDir) {
        super(id, scanResultInventoryFile);
        this.scanBaseDir = scanBaseDir;
        this.referenceInventory = referenceInventory;
        this.referenceInventoryFile = null;
    }

    @Override
    public void contribute(File targetDir, Inventory aggregatedInventory) throws IOException {
        Inventory referenceInventory = this.loadReferenceInventory();
        Inventory resultInventory = this.loadResultInventory();
        DirectoryScanAggregatorConfiguration directoryScanAggregatorConfiguration = new DirectoryScanAggregatorConfiguration(referenceInventory, resultInventory, this.scanBaseDir);
        directoryScanAggregatorConfiguration.contribute(targetDir, aggregatedInventory);
    }

    private Inventory loadResultInventory() throws IOException {
        File scanResultInventoryFile = this.getResultInventoryFile();
        FileUtils.validateExists((File)scanResultInventoryFile);
        return new InventoryReader().readInventory(scanResultInventoryFile);
    }

    private Inventory loadReferenceInventory() throws IOException {
        Inventory referenceInventory;
        if (this.referenceInventoryFile != null) {
            FileUtils.validateExists((File)this.referenceInventoryFile);
            referenceInventory = this.referenceInventoryFile.isDirectory() ? InventoryUtils.readInventory((File)this.referenceInventoryFile, (String)"*.xls, *.xlsx") : new InventoryReader().readInventory(this.referenceInventoryFile);
        } else {
            Validate.notNull((Object)this.referenceInventory);
            referenceInventory = this.referenceInventory;
        }
        return referenceInventory;
    }
}

