/*
 * Decompiled with CFR 0.152.
 */
package com.metaeffekt.artifact.extractors.configuration;

import com.metaeffekt.artifact.analysis.utils.FileUtils;
import com.metaeffekt.artifact.analysis.utils.InventoryUtils;
import com.metaeffekt.artifact.extractors.configuration.AbstractExtractorConfiguration;
import java.io.File;
import java.io.IOException;
import org.metaeffekt.core.inventory.processor.adapter.LicenseSummaryAdapter;
import org.metaeffekt.core.inventory.processor.model.Inventory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseSummaryExtractorConfiguration
extends AbstractExtractorConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseSummaryExtractorConfiguration.class);
    private final File analysisDir;
    private final File downloadDir;

    public LicenseSummaryExtractorConfiguration(String id, File analysisDir, File downloadDir) {
        super(id, null);
        this.analysisDir = analysisDir;
        this.downloadDir = downloadDir;
    }

    @Override
    public void contribute(File targetDir, Inventory aggregatedInventory) throws IOException {
        String[] files = FileUtils.scanDirectoryForFiles((File)targetDir, (String[])new String[]{"**/licenses.json"});
        if (files != null) {
            for (String file : files) {
                File licenseSummaryFile = new File(targetDir, file);
                try {
                    Inventory inventoryFromLicenseSummary = new LicenseSummaryAdapter().createInventoryFromLicenseSummary(licenseSummaryFile, file);
                    InventoryUtils.addToInventory(inventoryFromLicenseSummary, aggregatedInventory, true);
                }
                catch (Exception e) {
                    LOG.warn("Cannot parse " + licenseSummaryFile + ".", (Throwable)e);
                }
            }
        }
    }
}

